// Watcom tech support,
//
// This program is an example of some code that breaks Greenleaf
// ArchiveLib when used with Watcom C++ 10.0 or 10.5.  In this
// program, function bar() has a reference argument that has a
// default value.  If you call bar() with no args, it gets a
// reference to a temporary object, as defined in the function
// signature.
//
// The problem with this is that the temporary passed to bar()
// is destroyed before the function is entered!  This means
// that bar is working with a copy of an object that no longer
// exists.  Running the program with Watcom 10.5 always prints
// the "Invalid destroyed foo" status.  With 10.0, the 16 bit
// compiler prints garbage instead.  Either way, it is symptomatic
// of the same problem.
//
// I don't have a copy of the draft C++ standard with me at work,
// so I don't know if this limited lifetime of a temporary is
// in fact legitimate.  However, I do know that Borland, Microsoft,
// and Symantec all wait until bar() exits before destroying
// the temporary.
//
// If your compiler is going to work this way, I think that you
// should issue a warning when you encounter this code.  Since my
// reference argument in var is a const reference to a temporary,
// you let it through without any warnings.
//
// Mark Nelson
// Greenleaf Software
// 73650,312
//

#include <iostream.h>

struct foo {
    char *status;
    foo(){ status = "Valid new foo"; }
    foo( const foo& ){ status = "Valid copy foo"; }
    void operator=(const foo& ){ status = "Valid assigned foo"; }
    ~foo(){ status = "Invalid destroyed foo"; };
};

void bar( const foo & t = foo() )
{
    cout << "Status: " << t.status << endl;
}

main()
{
    bar();
    return 1;
}
