/**********************************************************
Author:     Dale Roberts
Date:       11/19/95
Program:    DMAREAD.EXE
Compile:    cl dmaread.c

Purpose:

  Demonstrate use of USERDMA device driver.  Simple
example to continuously read a single sample and
display the first eight channels on the console.
The device driver does 'autoinitialize' type DMA
to a one sample buffer, which is mapped into the
user address space.  This gives us a "live" buffer
and requires no interaction with the device driver
to update the buffer.
**********************************************************/
#define WIN32

#include <stdio.h>
#include <windows.h>
#include <winioctl.h>
#include <string.h>
#include "userdma.h"

/**********************************************************
  This is so simple that we just put everything in main().
Get a handle to the USERDMA driver, used DeviceIoControl()
to start/stop the DMA, loop and print sample values.
**********************************************************/
main(int argc, char *argv[])
{
    HANDLE hUserDMA;
    USERDMA_INFO dmainfo;
    int i, nchar;

    // Get handle to the USERDMA device driver.
    hUserDMA = CreateFile("\\\\.\\userdma",
                    GENERIC_READ, 0, NULL, OPEN_EXISTING,
                    FILE_ATTRIBUTE_NORMAL, NULL);

    if(hUserDMA == INVALID_HANDLE_VALUE) {
        printf("Couldn't access USERDMA device\n");
        return -1;
    }

    memset(&dmainfo, 0, sizeof(dmainfo));
    dmainfo.NumSamps = 1;

    // Start up the DMA.
    if(!DeviceIoControl(hUserDMA,
                            IOCTL_USERDMA_START,
                            &dmainfo, sizeof(dmainfo),
                            &dmainfo, sizeof(dmainfo),
                            &nchar, 0)) {
        printf("Error doing IOCTL\n");
        goto endit;
    }

    while(!kbhit()) {
        for(i=0; i < min(dmainfo.NumChans, 8); ++i)
            printf("%7d ",
                dmainfo.buf[dmainfo.CurDMAWord+i]);
        printf("\r");       // carriage return, no linefeed
        Sleep(20);          // don't be a processor hog
    }
    getch();
    printf("\n");

endit:
    // Stop DMA.
    DeviceIoControl(hUserDMA,
                    IOCTL_USERDMA_STOP,
                    &dmainfo, sizeof(dmainfo),
                    &dmainfo, sizeof(dmainfo),
                    &nchar, 0);

    // Release the device driver.
    CloseHandle(hUserDMA);
    return 0;
}
