/**********************************************************
  Structures and constants used by the USERDMA driver.
**********************************************************/

// Calls to control A/D board.
void StartAD(void), StopAD(void);

#define USERDMA_NUM_AD_CHANS    16
#define USERDMA_CHANNEL         6
#define USERDMA_RATE            100

/**********************************************************
   IOCTL codes for USERDMA device driver.
**********************************************************/

#define FILE_DEVICE_USERDMA 0x8001

#define USERDMA_CODE(c)     CTL_CODE(FILE_DEVICE_USERDMA, \
                                    0x800 | (c), \
                                    METHOD_BUFFERED, \
                                    FILE_ANY_ACCESS)

#define IOCTL_USERDMA_START             USERDMA_CODE(1)
#define IOCTL_USERDMA_STOP              USERDMA_CODE(2)
#define IOCTL_USERDMA_CUR_OFFSET        USERDMA_CODE(3)

/**********************************************************
  Structure used by the IOCTL calls.
**********************************************************/
typedef struct {
    short   *buf;           // pointer to the DMA buffer
    int     NumChans;       // number of channels
    int     NumSamps;       // length of buffer in samples
    int     CurDMAWord;     // offset into dmabuf of most
                            //   recent *complete* sample
                            //   (i.e. all channels read)
} USERDMA_INFO;
