/*
 *	FXDDESPY.C: Fix DDESPY's ASCII output format
 */

#include <stdio.h>

#define LF  0x0a
#define NUL 0x00

main ()
{
   int state = 0;
   int c;

   while ((c = getchar ()) != EOF) {
      if (state == 0) {
         if (c == LF)
            state = 1;
         else
            putchar (c);
      }
      else {
         putchar (LF);
         if (c != NUL)
            putchar (c);

         state = 0;
      }
   }

   return 1;
}
