// prg_path.cpp: Implementation of TExeDir class

#include "prg_path.h"

#include <dir.h>
#include <dos.h>

#ifdef _Windows
#include <windows.h>
#endif

string TExeDir::Program_Path;
string TExeDir::Program_Name;
TExeDir ExeDir;

TExeDir::TExeDir () : After_Init (false)
{
}

void
TExeDir::Init ()
{
    if (After_Init)
       return;

    After_Init  = true;

    char *drive = new char[MAXDRIVE];
    char *dir   = new char[MAXDIR];
    char *name  = new char[MAXFILE];
    char *ext   = new char[MAXEXT];

#ifdef _Windows
    char *path  = new char[MAXPATH];
# ifdef __WIN32__
    ::GetModuleFileName (NULL, path, MAXPATH);
    fnsplit (path, drive, dir, name, ext);
# else
    ::GetModuleFileName ((HINSTANCE)_DS, path, MAXPATH);
    fnsplit (path, drive, dir, name, ext);
# endif
    delete path;
#else
    fnsplit (_argv[0], drive, dir, name, ext);
#endif

    Program_Path = drive;
    Program_Path += dir;
    Program_Name = name;

    delete drive;
    delete dir;
    delete name;
    delete ext;
}

