//
// BUG0396.CPP
//
// This program demonstrates a bug in Visual C++ 2.2.  When using
// the stack variable i as an index, and when building with optimization
// turned off, VC++ generates code that inadvertently loads 32 bits
// from the stack instead of just 16.  This means that the upper 16 bits
// of i are totally random stack values.
//
// This will usually cause a GPF.  If you are lucky enough that the stack
// was initially set to all 0s, you can force an error by storing some bad
// values in the 16 bits before i on your own, by defining the FORCE
// macro.
//
// In either case, the generated code can be seen with the /FC option, and
// it clearly shows that eax is loaded with a DWORD from the stack, but
// the upper 16 bits are never cleared.
//
// Build using:
//
//  cl /Zi /Od /Fc bug0396.cpp
//
//  -or-
//
//  cl /Zi /Od /Fc /DFORCE bug0396.cpp
//

main()
{
    unsigned short i;
    unsigned short bug[ 1 ];

#if defined( FORCE )
    long *p = (long*) &i;
    *p = 0xffffeeee;
#endif


    i = 0;
    int j = ( bug[ i ] & 0xff00 ) | ( ( bug[ i ] >> 8 ) & 0xff );
    return 0;
}

