    PAGE ,132
;**********************************************************;
;							   ;
;   File name:	    cvxdctrl.asm			   ;
;							   ;
;   Description:    ControlDispatch for IrqMon.vxd	   ;
;							   ;
;   History:						   ;
;    1995/06/09 JFL Adapted from Windows 95 DDK CVXDSAMP.C ;
;							   ;
;**********************************************************;

.386p

;**********************************************************;
;		      I N C L U D E S			   ;
;**********************************************************;

WIN31COMPAT	equ	1

.xlist
include vmm.inc     ; Virtual Machine Manager defs
.list

include irqmon.inc  ; Converted from irqmon.h
option casemap:notpublic ; broken by H2INC

; General capabilities

IRQMON_DYNAMIC EQU 1	; Make the VXD dynamically loadable.

IRQMON_DEVICE_ID EQU UNDEFINED_DEVICE_ID   ; No Device ID

VXD_PM_API EQU 0	; No PM API
IRQMON_PM_PTR equ 0

VXD_VM_API EQU 0	; No VM API
IRQMON_VM_PTR equ 0

;==========================================================;
;   V I R T U A L   D E V I C E   D E C L A R A T I O N    ;
;==========================================================;

DECLARE_VIRTUAL_DEVICE IRQMON, \
		       HIGH(IRQMON_VERSION), \
		       LOW(IRQMON_VERSION), \
		       IRQMON_Control, \
		       IRQMON_DEVICE_ID, \
		       UNDEFINED_INIT_ORDER, \
		       IRQMON_VM_PTR, IRQMON_PM_PTR


VxD_LOCKED_CODE_SEG

;----------------------------------------------------------;
;							   ;
;   Function:	    IRQMON_Control			   ;
;							   ;
;   Description:    VxD control procedure for IRQMON.	   ;
;							   ;
;   Parameters:     EAX = Control message number	   ;
;							   ;
;   Returns:	    Carry clear if OK, set if failed	   ;
;							   ;
;   Regs altered:   All general registers		   ;
;							   ;
;----------------------------------------------------------;

BeginProc IRQMON_Control

    Control_Dispatch DEVICE_INIT, \
		     IRQMON_Dynamic_Init, sCall
    Control_Dispatch SYS_DYNAMIC_DEVICE_INIT, \
		     IRQMON_Dynamic_Init, sCall
    Control_Dispatch SYS_DYNAMIC_DEVICE_EXIT, \
		     IRQMON_Dynamic_Exit, sCall
    Control_Dispatch BEGIN_PM_APP, \
		     IRQMON_Begin_PM_App, sCall, <EDI, EDX>
    Control_Dispatch END_PM_APP, \
		     IRQMON_End_PM_App, sCall, <EDI>

    clc     ; Default: Success for unsupported messages
    ret

EndProc IRQMON_Control

VxD_LOCKED_CODE_ENDS

END
