	page	,132
;**********************************************************;
;							   ;
;   File Name:	    HookIRQ.asm 			   ;
;							   ;
;   Description:    Hook Windows VMM IRQs		   ;
;		    Output routines to a serial terminal   ;
;							   ;
;**********************************************************;

.386p

WIN31COMPAT	equ	1

.xlist
include vmm.inc     ; Virtual Machine Manager defs
include vpicd.inc   ; Virtual Interrupt Controllers defs
.list

include irqmon.inc  ; Converted from IRQMON.H
option casemap:notpublic ; Broken by H2INC

N_HANDLERS	equ	NIDT * 16   ; Number of IRQ handlers

;==========================================================;
;		       Data segment			   ;
;==========================================================;

VxD_LOCKED_DATA_SEG

	public	dwIrqMask
dwIrqMask dd	0FFFFH	    ; Bit n = 1 ==> Intercept IRQ n

next_vpicd_callback dd ?    ; Next VPICD Hw_Int callback

current_idt label fword     ; Temp storage for current IDT
current_idt_limit dw ?
current_idt_base dd ?

	align	4
	public	Old_IDT_IRQs	    ; Old IRQ vectors for
Old_IDT_IRQs dd N_HANDLERS dup (?)  ;  all IDTs

VxD_LOCKED_DATA_ENDS

;==========================================================;
;		       Code segment			   ;
;==========================================================;

VxD_LOCKED_CODE_SEG

;----------------------------------------------------------;
;							   ;
;   Function:	    My_IRQ_Handler			   ;
;							   ;
;   Description:    Intercepts all IRQs from all IDTs	   ;
;							   ;
;   Parameters:     None				   ;
;							   ;
;   Returns:	    None				   ;
;							   ;
;   Regs altered:   None				   ;
;							   ;
;   Notes:	    Sends one character on a COM port,	   ;
;		     identifying which IRQ occured.	   ;
;							   ;
;----------------------------------------------------------;

My_IRQ_Handler	proc	C public

INDEX	=	0
	REPEAT	N_HANDLERS	; One entry point per IRQ
	push	eax
	mov	eax, INDEX	; Identifies the IDT and IRQ
	jmp	near ptr @F
INDEX	=	INDEX+1
	ENDM

.ERRNZ	($-My_IRQ_Handler) - (N_HANDLERS * HANDLER_SIZE)

@@:
	call	SendNibble	; Display the IRQ number

	mov	eax, ss:Old_IDT_IRQs[eax*4] ; Prev. hdlr adr
	xchg	eax, ss:[esp]	; Restore the initial EAX
	ret			; Chain to the prev. handler

My_IRQ_Handler	endp

;----------------------------------------------------------;
;							   ;
;   Function:	    vpicd_callback			   ;
;							   ;
;   Description:    Called by VPICD after every IRQ	   ;
;							   ;
;   Parameters:     None (unfortunately)		   ;
;							   ;
;   Returns:	    N/A 				   ;
;							   ;
;   Regs altered:   None				   ;
;							   ;
;   Notes:						   ;
;							   ;
;----------------------------------------------------------;

vpicd_callback	proc

	pushad	    ; Save whatever the C code may trash

	sidt	current_idt ; Get the current IDT location
	cCall	Add_IDT, <current_idt_base> ; Analyse it

	popad

	jmp	next_vpicd_callback

vpicd_callback	endp

;----------------------------------------------------------;
;							   ;
;   Function:	    VPICD_Hook_IRQs			   ;
;							   ;
;   Description:    Hook VMM IRQs using the standard method;
;							   ;
;   Parameters:     None				   ;
;							   ;
;   Returns:	    None				   ;
;							   ;
;   Regs altered:   EAX, EBX, EDX			   ;
;							   ;
;   Notes:						   ;
;							   ;
;----------------------------------------------------------;

VPICD_Hook_IRQs proc	C public uses ESI

	pushfd
	cli		; Begin critical section

	mov	esi, OFFSET32 vpicd_callback
	VxDCall VPICD_Call_When_Hw_Int
	mov	next_vpicd_callback, esi

	popfd		; End critical section
	ret

VPICD_Hook_IRQs endp

;----------------------------------------------------------;
;							   ;
;   Function:	    VPICD_Unhook_IRQs			   ;
;							   ;
;   Description:    Unhook VMM IRQs using the standard mthd;
;							   ;
;   Parameters:     None				   ;
;							   ;
;   Returns:	    None				   ;
;							   ;
;   Regs altered:   EAX, EBX, EDX			   ;
;							   ;
;   Notes:	    Restores the initial IRQ hook handler. ;
;		    Will crash eventually if someone else  ;
;		     has hooked them after us.		   ;
;							   ;
;----------------------------------------------------------;

VPICD_Unhook_IRQs proc	  C public uses ESI

	pushfd
	cli		; Begin critical section

	mov	esi, next_vpicd_callback
	VxDCall VPICD_Call_When_Hw_Int

	popfd		; End critical section
	ret

VPICD_Unhook_IRQs endp

;----------------------------------------------------------;
;							   ;
;   Function:	    GetIdtBase				   ;
;							   ;
;   Description:    Get the base of the current IDT	   ;
;							   ;
;   Parameters:     None				   ;
;							   ;
;   Returns:	    The 32-bits linear address of the IDT  ;
;							   ;
;   Regs altered:   None				   ;
;							   ;
;----------------------------------------------------------;

GetIdtBase	proc	C public

	sidt	current_idt
	mov	eax, current_idt_base
	ret

GetIdtBase	endp

VxD_LOCKED_CODE_ENDS

END
