/***********************************************************
*							   *
*   File name:	    IrqMon.h				   *
*							   *
*   Description:    Global definitions for IrqMon.VxD	   *
*							   *
***********************************************************/

#define IRQMON_VERSION 0x100	    // Version 1.00

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

#pragma pack(1)

typedef struct
    {
    WORD Offset_0_15;	// Entry point's offset, lower 16
    WORD Selector;	// Entry point's selector
    BYTE DWord_Count;	// (D)Word parameter count
    BYTE Access_Rights; // Present, dpl, system, type
    WORD Offset_16_31;	// Entry point's offset, upper 16
    } CALLGATEDESCRIPTOR,* PCALLGATEDESCRIPTOR;

#pragma pack()

/* Prototypes */

// In IrqMon.c

extern void Add_IDT(PCALLGATEDESCRIPTOR);
extern void Remove_IDT(PCALLGATEDESCRIPTOR);
extern DWORD _stdcall IRQMON_Dynamic_Init(void);
extern DWORD _stdcall IRQMON_Dynamic_Exit(void);
extern DWORD _stdcall IRQMON_Begin_PM_App(
		      struct pmcb_s *pPMCB, DWORD dwFlags);
extern DWORD _stdcall IRQMON_End_PM_App(
		      struct pmcb_s *pPMCB);

// In HookIrq.asm

#define NIDT 5		    // Number of IDTs supported
extern DWORD Old_IDT_IRQs[NIDT][16];	// Previous handlers

#define HANDLER_SIZE 11     // Offset between IRQ handlers

extern DWORD dwIrqMask;     // Bit n = 1 ==> Intercept IRQ n

extern void My_IRQ_Handler(void);
extern int _cdecl VPICD_Hook_IRQs(void);
extern int _cdecl VPICD_Unhook_IRQs(void);
extern PCALLGATEDESCRIPTOR GetIdtBase(void);

// In ComPort.asm

extern DWORD dwPort;	    // Serial port base I/O port

extern int _cdecl Init_UART(void);
extern int _cdecl Reset_UART(void);

extern void _cdecl SendChar(void);
#define SENDCHAR(c) \
	{ {_asm mov al, c}; SendChar(); }
extern void _cdecl SendNibble(void);
#define SENDNIBBLE(x) \
	{ {_asm mov al, BYTE ptr x}; SendNibble(); }
extern void _cdecl SendAL(void);
#define SENDAL(x) \
	{ {_asm mov al, BYTE ptr x}; SendAL(); }
extern void _cdecl SendAX(void);
#define SENDAX(x) \
	{ {_asm mov ax, WORD ptr x}; SendAX(); }
extern void _cdecl SendEAX(void);
#define SENDEAX(x) \
	{ {_asm mov eax, DWORD ptr x}; SendEAX(); }
