###############################################################################
#									      #
#   File name:	    IrqMon.mak						      #
#									      #
#   Description:    Make file for building IrqMon.vxd			      #
#									      #
#   Notes:	    The following macros / environment variables must	      #
#		    be predefined:					      #
#									      #
#		    o AS	    Assembler pathname			      #
#		    o CC32	    32-bits C compiler pathname 	      #
#		    o INC32	    32-bits include files path		      #
#		    o LIB32	    16-bits libraries path		      #
#		    o LINK32	    32-bits Linker pathname		      #
#		    o MAPSYM	    32-bits Map Symbols extraction tool       #
#									      #
#		    To prevent confusions, do NOT predefine INCLUDE and LIB.  #
#									      #
###############################################################################

O=OBJ				# Where to store object files
L=LIST				# Where to store listing files
B=BIN				# Where to store binary files

# DEBUGFLAGS = -DDEBLEVEL=1 -DDEBUG
DEBUGFLAGS =

CFLAGS	   = -Fo$(O)\ -I$(INC32:;= -I) $(DEBUGFLAGS) -Gs
CFLAGS32   = $(CFLAGS) -DWIN32 -DCON -Di386 -D_X86_ -D_NTWIN -Fc$(L)\ -W3 -Zi
CVXDFLAGS  = $(CFLAGS) -DIS_32 -Fc$(L)\ -Zdp -Zl
H2INCFLAGS = $(CFLAGS) -DIS_32		-Zdp -Zl
LFLAGS	   = -machine:i386 -debug:notmapped,full -debugtype:cv \
	     -subsystem:console kernel32.lib

AFLAGS	   = -coff -DBLD_COFF -DIS_32 -Fl$(L)\ -Fo$(O)\ -I$(INC32:;= -I) \
	     -Sg -Sn -W2 -Zd -Cx -DMASM6 $(DEBUGFLAGS)

MODELE	   = S
CFLAGS16   = /A$(MODELE) $(DEBUGFLAGS) /Fo$(O)\ /G2 /I$(INC16) /Oaes /W3 /Zpi

!IFDEF _DEBUG
DD=/D_DEBUG
!ELSE
DD=
!ENDIF

# Create subdirectories if they don't exist

!IF !EXIST($(O))
!MESSAGE Creating directory $(O)
!IF [md $(O)]
!ENDIF
!ENDIF

!IF !EXIST($(L))
!MESSAGE Creating directory $(L)
!IF [md $(L)]
!ENDIF
!ENDIF

!IF !EXIST($(B))
!MESSAGE Creating directory $(B)
!IF [md $(B)]
!ENDIF
!ENDIF

# Default goal
goal: $(B)\IrqMon.vxd

$(O)\IrqMon.obj: IrqMon.c IrqMon.h
    echo >con Compiling %s ...
    $(CC32) $(CVXDFLAGS) /c %s
    echo >con ... Done.

IrqMon.inc: IrqMon.h
    echo >con Converting %s ...
    $(AS:ML=H2INC) $(H2INCFLAGS) /c %s
    echo >con ... done.

$(O)\ComPort.obj: ComPort.asm IrqMon.inc comports.inc
    echo >con Assembling %s ...
    $(AS) $(AFLAGS) -c %s
    echo >con ... Done.

$(O)\CVxdCtrl.obj: CVxdCtrl.asm IrqMon.inc
    echo >con Assembling %s ...
    $(AS) $(AFLAGS) -c %s
    echo >con ... Done.

$(O)\HookIRQ.obj: HookIRQ.asm IrqMon.inc
    echo >con Assembling %s ...
    $(AS) $(AFLAGS) -c %s
    echo >con ... Done.

# List of object files that will be part of the IrqMon.vxd VxD
VxdObj = $(O)\IrqMon.obj $(O)\CVxdCtrl.obj $(O)\HookIRQ.obj $(O)\ComPort.obj

$(B)\IrqMon.vxd: IrqMon.def $(VxdObj)
    echo >con Linking $(@F) ...
    set LIB=$(LIB32)
    $(LINK32) @<<IrqMon.lnk
-MACHINE:i386 -DEBUG:NONE -PDB:NONE
-DEF:$(@B).def -OUT:$@ -MAP:$(@R).map
-VXD vxdwraps.clb $(VxdObj)
<<
    echo >con ... Done.
#    echo >con Creating symbol file $(@B).sym ...
#    cd bin
#    $(MAPSYM) IrqMon
#    cd ..
#    echo >con ... Done.
