/*----------------------------------------------------------------------------
PROJECT	config.exe
FILE	parser.h
HISTORY
	Tilakraj Roy Choudhury 941103 Created
ABOUT
	Contains the constants required for parsing the plug and play configuraion
	file.
----------------------------------------------------------------------------*/

// lookup table for the table driven parser.
typedef struct  _PARSERTABLE
{
	char 			*szResourceName; 	// IO, DMA , IRQ, MEM
	unsigned short	wResourceCount; 	// 8, 2, 2, 4
	unsigned short	wResourceType; 		// Hex , Dec , Dec , Hex
	unsigned short	wResourceID;		// 1, 2, 3, 4
} PARSERTABLE, *PPARSERTABLE;

// values for the wResourceType Field
#define TYPE_HEX	1	// resource is always expressed as hexadecimal
#define TYPE_DEC	2	// resource is always expressed as decimal

// values for the wResourceID field
#define ID_IO		1	// I/O Port type resource
#define ID_DMA		2	// DMA channel type resource
#define ID_IRQ		3	// IRQ channel type resource
#define ID_MEM		4	// Board Memory type resource


#define MAX_RESOURCE_TYPE	4	// a PC has mainly 4 resources

extern	unsigned long dwLogicalDevice;
extern	PARSERTABLE	ParserTable[];

