#include <windows.h>
#include <stddef.h>
#include <string.h>

#include <dos.h>
#ifdef  _MSC_VER
#   define  segread _segread
#   define  int86x  _int86x
#   define  SREGS   _SREGS
#   define  REGS    _REGS
#endif

#define ZERO(p)    memset(p, 0, sizeof(*p))

typedef struct NETWARE_TIME
    {
    BYTE    Year, Month, Day, Hour,
            Minute, Second, DayOfWeek;
    }          NETWARE_TIME;

typedef struct  NETWARE_REPLY
    {
    WORD            Length;
    DWORD           ObjectId;
    WORD            ObjectType;
    BYTE            ObjectName[48];
    NETWARE_TIME    Time;
    BYTE            Reserved;
    }           NETWARE_REPLY;

typedef struct  NETWARE_REQUEST
    {
    WORD            Length;
    BYTE            Function;
    BYTE            Connection;
    }           NETWARE_REQUEST;

typedef struct  NETWARE_BLOCK
    {
    NETWARE_REQUEST Request;
    NETWARE_REPLY   Reply;
    }           NETWARE_BLOCK;

/* DPMI structure for real-mode registers */
typedef struct  REGS16
    {
    DWORD   di, si, bp, reserved, bx, dx, cx, ax;
    WORD    f, es, ds, fs, gs, ip, cs, sp, ss;
    }           REGS16;

/* Simulate a real-mode interrupt, given the interrupt
 * number and a structure containing space for the
 * values of the real-mode registers.
 */
static BYTE SimulateRealModeInt(int IntNum, REGS16 *RealModeRegs)
    {
    union   REGS   InRegs, OutRegs;
    struct  SREGS  SegRegs;

    ZERO(&InRegs);
    segread(&SegRegs);

    InRegs.x.ax     = 0x0300;   /* simulate real mode int */
    InRegs.x.bx     = IntNum;   /* which interrupt?       */
    InRegs.x.cx     = 0;        /* no copying of stack    */
    SegRegs.es      = HIWORD(RealModeRegs);
    InRegs.x.di     = LOWORD(RealModeRegs);

    int86x(0x31, &InRegs, &OutRegs, &SegRegs);
    
    if(OutRegs.x.cflag != 0)  /* if error returned       */
        return OutRegs.x.ax;
    else                    /* 0 means no error occurred */
        return 0;
    }


/* return logical connection #, or else 0 */
int GetNetWareConnection(void)
    {
    REGS16  Regs16;
    WORD    al;

    ZERO(&Regs16);
    Regs16.ax     = 0xDC00;       /* get connection # */
    Regs16.cx     = 0xFFFF;
    /* if error in performing interrupt */
    if(SimulateRealModeInt(0x0021, &Regs16))
        return 0;

    al  = (BYTE)(Regs16.ax & 0x00FF);
    if(al < 1 || al > 250)
        return 0;
    else
        return al;
    }

int CALLBACK __export GetNetWareLoginName(char *Buffer)
    {
    BYTE    Connection;
    int     Result  = 0;    /* assume failure */

    Connection  = GetNetWareConnection();

    if(Connection)
        {
        DWORD           ParaSel;

        /* returns paragraph in upper, selector in lower */
        ParaSel = GlobalDosAlloc(sizeof(NETWARE_BLOCK));

        if(ParaSel != 0)
            {
            REGS16          Regs;
            WORD            Para    = HIWORD(ParaSel);
            WORD            Sel     = LOWORD(ParaSel);
            NETWARE_BLOCK*  RealMem = MAKELP(Sel, 0);

            ZERO(RealMem);  ZERO(&Regs);
            RealMem->Request.Length      = 2;
            RealMem->Request.Function    = 0x16;
            RealMem->Request.Connection  = Connection;
            RealMem->Reply.Length        = 0x3E;
            RealMem->Reply.ObjectType    = 0xFFFF;

            Regs.ax = 0xE300;
            /* ds:si = request buffer */
            Regs.ds = Para;            Regs.si = 0;

            /* es:di = reply buffer   */
            Regs.es = Para;
            Regs.di = offsetof(NETWARE_BLOCK, Reply);

            if(!SimulateRealModeInt(0x21, &Regs))
                {
                strcpy(Buffer, RealMem->Reply.ObjectName);
                Result  = 1;
                }
            GlobalDosFree(Sel);
            }
        }
    return Result;
    }
