/*
 *  Listing 3
 *  examp.cpp
 */

#include <iostream.h>
#include "intr.h"

int get_drive_info( IntDos &Dos )
{   Dos <= Clear;
    Dos[ah] = 0x36;   //DOS get disk free space
    Dos[dl] = 0;      //current drive
    Dos <= Exec;
    return (Dos[ax] == 0xffff) ? -1 : 0;  //0 == OK
}

void * get_current_path( char *buf )
{   IntDos Dos;
    Dos[ah] = 0x47;
    Dos[ds] = FP_SEG( buf );
    Dos[si] = FP_OFF( buf );
    Dos[dl] = 0;    /* use default drive */
    return Dos;    /* Execute, return S/F flag */
}

int main(void)
{   IntDos Dos;
    char path[100];

    get_drive_info( Dos);

    cout << "Allocation Info for current drive ...\n"
         << "Sectors per cluster ...... " <<
                                  Dos[ax] << endl
         << "Number of free clusters .. " <<
                                  Dos[bx] << endl
         << "Bytes per sector ......... " <<
                                  Dos[cx] << endl
         << "Total clusters ........... " <<
                                  Dos[dx] << endl;

    if( get_current_path(path) )
        cout << endl << "Current path is: "
                     << path << endl;

    Dos.SegRead();
    cout << hex << endl
         << "Segment registers ...." << endl
         << "ES = " << Dos[es] << endl
         << "DS = " << Dos[ds] << endl
         << "SS = " << Dos[ss] << endl
         << "CS = " << Dos[cs] << endl << dec;

    Intr vid(0x10);
    vid[ah] = 0x0f;
    if( !vid )  //Demo only, can't actually fail ...
        cout << "Can't get video mode..." << endl;
    else
        cout << hex << endl
             << "Current video mode = "
             << (vid[al] & 0x7f) << endl;

    return 0;
}
/* ----- EOF --------------------------------------- */
