/*
 *  Listing 2
 *  intr.cpp
 */

#include <mem.h>    /* memset() */
#include "intr.h"

Intr & Intr::operator <= (Intr& (*_manipf)(Intr&))
    {   return (*_manipf)(*this);   }

Intr::operator void *()     //0 on Exec() failure
    {   Exec();
        return (void *)(ExecFail() ? 0 : this);
    }

int  Intr::operator !()    //!0 on Exec() failure
    {   Exec();
        return ExecFail();
    }

void Intr::Clear()
    {   _errn = 0;
        memset( reinterpret_cast<void *>(&_regs),
                              '\0', sizeof(XREGS) );
    }

void Intr::Exec()
    {   intr( _intn,
          reinterpret_cast<REGPACK *> (&_regs) );
    }

int Intr::ExecFail()
    {   return 0;   //return !0 on failure
    }

void Intr::SegRead()
    {   SREGS sregs;
        segread( &sregs );
        es( sregs.es );
        ds( sregs.ds );
        ss( sregs.ss );
        cs( sregs.cs );
    }

int IntDos::ExecFail()
    {   _errn = 0;      //assume OK

        if( cflag() )
        {   ah( 0x59 );     //DOS Get Extended Error
            Exec();
            _doserr.de_exterror = ax();
            _doserr.de_class    = bh();
            _doserr.de_action   = bl();
            _doserr.de_locus    = ch();
            _errn = ax();
        }

        return _errn;   //return !0 on failure
    }

/* Manipulators ........ */
Intr& Clear( Intr& obj ) /* Clear all Intr data */
    {   obj.Clear();
        return obj;
    }
Intr& Exec( Intr& obj )  /* Execute */
    {   obj.Exec();
        return obj;
    }

/* ----- EOF --------------------------------------- */
