// assumes large model and -DSTRICT
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>
#include <windows.h>
#include <commdlg.h>
#include <ver.h>
#include <dlgs.h>

#if defined(__BORLANDC__) || defined(__WATCOMC__)
    #define STRLWR  strlwr
    #define GETCWD  getcwd
#else
    #define STRLWR  _strlwr
    #define GETCWD  _getcwd
#endif

#define NE_MAGIC        0x454E
#define DISP_UNREF      1
#define DISP_REF        2

static HINSTANCE _hInst;
static int       _nDispType = DISP_UNREF;
static WNDPROC   _lpfnOrgFileProc = NULL;
static char      _pResData[1024];

//---- Local prototypes ------------------------------------
UINT CALLBACK _export OpenHook(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK _export FileNameProc(
    HWND, UINT, WPARAM, LPARAM);
int IsFileNE(LPSTR, LPSTR);


#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInstance,
    HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    OPENFILENAME ofn;

    _hInst          = hInstance;
    memset(&ofn, 0, sizeof(OPENFILENAME));
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner   = (HWND)NULL;
    ofn.hInstance   = hInstance;
    ofn.lpstrFilter = "DLL's (*.dll)\0*.dll\0"
                    "Font files (*.fo?)\0*.fot;*.fon\0"
                    "Driver files (*.drv)\0*.drv\0"
                    "VB extensions (*.vbx)\0*.vbx\0"
                    "CPL's (*.cpl)\0*.cpl\0"
                    "All NE lib files (*.*)\0*.*\0";
    ofn.nFilterIndex    = 1;
    ofn.lpstrFile       = NULL;
    ofn.nMaxFile        = 0;
    ofn.lpstrFileTitle  = NULL;
    ofn.nMaxFileTitle   = 0;
    ofn.lpstrInitialDir = ".";
    ofn.lpstrTitle      = "DLL Load Watcher";
    ofn.lpTemplateName  = MAKEINTRESOURCE(FILEOPENORD);
    ofn.lpfnHook        = OpenHook;
    ofn.Flags           = OFN_PATHMUSTEXIST |
        OFN_HIDEREADONLY | OFN_FILEMUSTEXIST |
        OFN_ENABLEHOOK | OFN_ENABLETEMPLATE;

    GetOpenFileName(&ofn); // Display the Open File box

    return 0;
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
UINT CALLBACK _export OpenHook(HWND hDlg,
            UINT message, WPARAM wParam, LPARAM lParam)
{
    int nTabs[] = { 56, 108 };
    static HWND hLB;

    if (message == WM_INITDIALOG) {
        // Disable unwanted controls.
        ShowWindow(GetDlgItem(hDlg, IDOK), SW_HIDE);
        EnableWindow(GetDlgItem(hDlg, IDOK), FALSE);
        ShowWindow(GetDlgItem(hDlg, edt1), SW_HIDE);
        EnableWindow(GetDlgItem(hDlg, edt1), FALSE);

        hLB = GetDlgItem(hDlg, lst1);
        SendMessage(hLB, LB_SETTABSTOPS, sizeof(nTabs) /
            sizeof(nTabs[0]), (DWORD)(LPINT)nTabs);
        SendMessage(hLB, LB_SETHORIZONTALEXTENT, 490, 0L);
        CheckRadioButton(hDlg, rad1, rad2, rad1);
        _lpfnOrgFileProc = (WNDPROC)SetWindowLong(hLB,
                GWL_WNDPROC, (DWORD)FileNameProc);
    }
    else if (message == WM_COMMAND) {
        if (wParam == lst1) {
            return 1; // Don't let CommonDlg proc handle this
        }
        else if (wParam == rad1) {
            // Show unreferenced files
            _nDispType = DISP_UNREF;
            SendMessage(hDlg, WM_COMMAND, lst2, MAKELONG(
                GetDlgItem(hDlg, lst2), LBN_DBLCLK));
            ShowScrollBar(GetDlgItem(hDlg, lst1),
                SB_HORZ, TRUE);
        }
        else if (wParam == rad2) {
            // Show referenced files
            _nDispType = DISP_REF;
            SendMessage(hDlg, WM_COMMAND, lst2, MAKELONG(
                GetDlgItem(hDlg, lst2), LBN_DBLCLK));
            ShowScrollBar(GetDlgItem(hDlg, lst1),
                SB_HORZ, FALSE);
        }
        else if (wParam == IDCANCEL) {
            SetWindowLong(hLB, GWL_WNDPROC,
                (DWORD)_lpfnOrgFileProc);
        }
    }

    return 0; // Continue processing the message
}
 
LRESULT CALLBACK _export FileNameProc(HWND hWnd,
        UINT wMsg, WPARAM wParam, LPARAM lParam)
{
    // This is the filename listbox window. It is subclassed
    char szDir[128], szBuf[128], szString[128];
    LPSTR   lpStr;
    LPWORD  lpWord;
    UINT    wSize;

    switch (wMsg) {
    case LB_ADDSTRING:
        GETCWD(szDir, sizeof(szDir));
        // Only add filename if it's New Executable file.
        if (IsFileNE(szDir, (LPSTR)lParam) <= 0) 
            break; // Not an executable file, skip it.

        if (GetPrivateProfileString(szDir, (LPSTR)lParam, "",
           szString, sizeof(szString), "LoadDLL.ini") != 0) {
            // File was found so it has been referenced.
            if (_nDispType == DISP_UNREF)
                break; // Do not display.
            // Add reference info. String is
            // <count>,<Module Name>
            if ((lpStr = _fstrchr(szString, ',')) != NULL)
                *lpStr = '\t';
            // Remove path name from calling module name
            if (((lpStr = _fstrrchr(szString, '\\')) == NULL)
            && ((lpStr = _fstrrchr(szString, '/')) == NULL)) 
                lpStr = szString;
            else
                lpStr++;
            wsprintf(szBuf, "%s\t%s", (LPSTR)lParam, lpStr);
            lParam = (DWORD)(LPSTR)STRLWR(szBuf);
        }
        else {
            DWORD handle;
            if (_nDispType == DISP_REF)
                break;
            // Unreferenced exe. Look up the resource info.
            wsprintf(szBuf, "%s\\%s", szDir, (LPSTR)lParam);
            if (GetFileVersionInfoSize(szBuf, &handle) == 0)
                STRLWR((LPSTR)lParam);
            else {
                GetFileVersionInfo(szBuf, 0L,
                    sizeof(_pResData), _pResData);
                if (VerQueryValue((void *)_pResData,
                    "\\VarFileInfo\\Translation",
                    (void **)&lpWord, &wSize) != 0) {
                    wsprintf(szBuf,
                        "\\StringFileInfo\\%04X%04X"
                        "\\FileDescription", *lpWord,
                        *(lpWord + 1));
                }
                if (VerQueryValue(_pResData, szBuf,
                    (void **)&lpWord, &wSize)) {
                    wsprintf(szBuf, "%s\t%s", (LPSTR)lParam,
                        (LPSTR)lpWord); 
                    lParam = (DWORD)(LPSTR)STRLWR(szBuf);
                }
                else {
                    STRLWR((LPSTR)lParam);
                }
            }
        }
        // Fall through
    default:
        return CallWindowProc(_lpfnOrgFileProc, hWnd,
            wMsg, wParam, lParam);
    }
    return 0L;
}


int IsFileNE(LPSTR szDir, LPSTR szFile)
{    
    // Return 0 if the specified is a valid New
    // Executable file, 1 if the file is also a DLL.
    // Return < 0 otherwise.
    char szBuf[256], Header[64];
    DWORD dwNeStart;
    WORD wMagic, wFlags;
    FILE *fpNE;
    
    _fstrcpy(szBuf, szDir);
    _fstrcat(szBuf, "\\");
    _fstrcat(szBuf, szFile);

    if ((fpNE = fopen(szBuf, "rb")) == NULL)
        return -1;

    // Read and check the old-style exe header
    fread(Header, 1, sizeof(Header), fpNE);
    if (Header[0x18] != 0x40) { // Is NE exe
        fclose(fpNE);
        return -2;
    }
    // Read the NE header
    dwNeStart = *(DWORD *)(Header + 0x3C);
    fseek(fpNE, dwNeStart, SEEK_SET);
    fread(&wMagic, 1, sizeof(wMagic), fpNE);
    if (wMagic != NE_MAGIC) {
        fclose(fpNE);
        return -3;
    }
    fseek(fpNE, dwNeStart + 0x0C, SEEK_SET);
    fread(&wFlags, 1, sizeof(wFlags), fpNE);
    fclose(fpNE);

    return (wFlags & 0x8000) ? 1 : 0;
}
