// assumes large model and -DSTRICT
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <windows.h>
#include <toolhelp.h>

#define  WM_STARTTASK (WM_USER+0x0820)
#define  WM_STARTDLL  (WM_USER+0x0821)

HINSTANCE _hInst;
HWND      _hPostWnd;
LPSTR     _pClassName = "LoadDllClass";
char      _szString[128];

//----------------------------------------------------------
BOOL __export WINAPI NotifyCallBack(WORD wID, DWORD dwData);
int UpdateModuleEntry(LPSTR szDLL, LPSTR szCaller);
HMODULE SearchModuleHandle(WORD wSel);
int InitLoadDLL(void);
int EndLoadDLL(void);
int InitModules(void);

#ifdef __BORLANDC__
    #pragma argsused
#endif
int CALLBACK LibMain(HINSTANCE hInstance, WORD wDataSeg,
            WORD wHeapSize, LPSTR lpszCmdLine)
{
    if (wHeapSize > 0)
        UnlockData(0);      // Unlock the ds locked by LocalInit
    _hInst = hInstance;

    return 1;
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
int CALLBACK WEP(int wParam)
{
    return 1;
}

LRESULT CALLBACK __export DriverProc(DWORD dwDriverIdentifier,
    HDRVR hDriver, UINT wMessage, LPARAM lParam1,
    LPARAM lParam2)
{
    DWORD dwRes = 1L;

    switch (wMessage) {
        case DRV_LOAD:
        // Sent when driver is loaded; always the first
        // message received by the driver.
            dwRes = (InitLoadDLL() == 0) ? 1L : 0L;
            break;
        case DRV_FREE:
            break;
        case DRV_QUERYCONFIGURE:
        // Sent to determine if driver can be configured
            dwRes = 0L;
            break;
        default:
            return DefDriverProc(dwDriverIdentifier, hDriver,
                                wMessage, lParam1, lParam2);
    }

    return dwRes;
}


LRESULT CALLBACK __export LoadWndProc(HWND hWnd, UINT wMsg,
    WPARAM wParam, LPARAM lParam)
{
    char szBuf[256], szCaller[128];
    int nCount;
    int Status;

    if(wMsg == WM_STARTTASK || wMsg == WM_STARTDLL)
        Status = GetModuleFileName((HMODULE)wParam, szBuf,
            sizeof(szBuf));

    switch(wMsg){
    case WM_STARTTASK:
        // A task is started. Get module name,
        // adjust .ini value.
        if (Status) {
            if (GetPrivateProfileString("Tasks", szBuf, "",
            _szString,sizeof(_szString),"LoadDLL.ini")==0)
                nCount = 1;
            else
                nCount = atoi(_szString) + 1;
            wsprintf(_szString, "%d", nCount);
            WritePrivateProfileString("Tasks", szBuf,
                    _szString, "LoadDLL.ini");
        }
        break;

    case WM_STARTDLL:
        if (Status != 0) {
            szCaller[0] = '\0';
            GetModuleFileName((HMODULE)HIWORD(lParam),
                        szCaller, sizeof(szCaller));
            UpdateModuleEntry(szBuf, szCaller);
        }
        break;

    case WM_QUERYENDSESSION:
        return 1;
    case WM_ENDSESSION:
        if (wParam == TRUE) {
            EndLoadDLL();
            return 0;
        }
        return 1;
    default:
        return DefWindowProc(hWnd, wMsg, wParam, lParam);
    }

    return 0L;
}


int UpdateModuleEntry(LPSTR szDLL, LPSTR szCaller)
{
    int nCount = 1;
    char *pCount;
    LPSTR lpStr;

    if (((lpStr = _fstrrchr(szDLL, '\\')) == NULL) &&
        ((lpStr = _fstrrchr(szDLL, '/')) == NULL))
        lpStr = szDLL;
    else
        *lpStr++ = '\0';

    if (GetPrivateProfileString(szDLL, lpStr, "",
            _szString, sizeof(_szString), "LoadDLL.ini") != 0) {
        if ((pCount = strchr(_szString, ',')) != NULL)
            nCount = atoi(pCount + 1) + 1;
    }
    if ((szCaller == NULL) || (szCaller[0] == '\0'))
        wsprintf(_szString, "Unknown,%d", nCount);
    else
        wsprintf(_szString, "%s,%d", (LPSTR)szCaller, nCount);
    WritePrivateProfileString(szDLL, lpStr, _szString, "LoadDLL.ini");

    return 0;
}

BOOL __export WINAPI NotifyCallBack(WORD wID, DWORD dwData)
{
    // Only use PostMessage and ToolHelp functions 
    WORD wSS;
    HMODULE hMod;
    NFYSTARTDLL _far *lpInfo;

    switch (wID) {

    case NFY_STARTTASK: // dwData has CS:IP of the starting address
        if ((hMod = SearchModuleHandle(HIWORD(dwData))) != NULL)
            PostMessage(_hPostWnd, WM_STARTTASK, (WORD)hMod, 0L);
        break;

    case NFY_STARTDLL:
        lpInfo = (NFYSTARTDLL _far *)dwData;
        _asm    mov    wSS, ss
        PostMessage(_hPostWnd, WM_STARTDLL, 
                (WORD)lpInfo->hModule, MAKELONG(0, wSS));
        break;

    default:
        break;
    }

    return 0;
}


HMODULE SearchModuleHandle(WORD wSel)
{
    MODULEENTRY ModuleEntry;
    GLOBALENTRY GlobalEntry;
    BOOL bRc;

    ModuleEntry.dwSize = sizeof(ModuleEntry);
    GlobalEntry.dwSize = sizeof(GlobalEntry);

    bRc = GlobalFirst(&GlobalEntry, GLOBAL_ALL);
    while (bRc) {
            
        if ((GlobalEntry.wType == GT_CODE) &&
                (((WORD)GlobalEntry.hBlock & 0xFFFC) == (wSel & 0xFFFC))) {
            if (ModuleFindHandle(&ModuleEntry, GlobalEntry.hOwner) != NULL) {
                return ModuleEntry.hModule;
            }
            else {
                return (HINSTANCE)NULL;
            }
        }
        bRc = GlobalNext(&GlobalEntry, GLOBAL_ALL);
    }

    return (HINSTANCE)NULL;
}

int InitLoadDLL()
{
    WNDCLASS WndClass;
    int nQ = 80;

    // Increase message queue size
    while (SetMessageQueue(nQ--) == 0)
        ;

    // Register our class and create the window
    memset(&WndClass, 0, sizeof(WndClass));
    WndClass.style         = CS_HREDRAW | CS_VREDRAW;
    WndClass.lpfnWndProc   = LoadWndProc;
    WndClass.hInstance     = _hInst;
    WndClass.hbrBackground = GetStockObject(WHITE_BRUSH);
    WndClass.lpszClassName = (LPSTR)_pClassName;
    if (RegisterClass((LPWNDCLASS)&WndClass) == 0)
        return -1;

    _hPostWnd = CreateWindow(_pClassName, "LoadDLL",
        WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, CW_USEDEFAULT, 0, 0, _hInst, 0);
    if (_hPostWnd == 0)
        return -1;

    if (NotifyRegister((HTASK)NULL, NotifyCallBack, NF_NORMAL) == 0)
        return -1; // Couldn't install callback

    InitModules();

    return 0;
}

int InitModules()
{
    // Scan all DLL's that have already been loaded before us. Add them
    // to the .ini file with a task name of "Startup".
    MODULEENTRY ModuleEntry;
    GLOBALENTRY GlobalEntry;
    char szBuf[128];
    BOOL bRc;

    ModuleEntry.dwSize = sizeof(ModuleEntry);
    GlobalEntry.dwSize = sizeof(GlobalEntry);

    bRc = GlobalFirst(&GlobalEntry, GLOBAL_ALL);
    while (bRc) {
            
        if (ModuleFindHandle(&ModuleEntry, GlobalEntry.hOwner) != NULL) {
            GetModuleFileName(ModuleEntry.hModule, szBuf, sizeof(szBuf));
            UpdateModuleEntry(szBuf, "STARTUP");
        }
        bRc = GlobalNext(&GlobalEntry, GLOBAL_ALL);
    }

    return 0;
}

int EndLoadDLL()
{
    NotifyUnRegister((HTASK)NULL);

    DestroyWindow(_hPostWnd);

    UnregisterClass(_pClassName, _hInst);

    return 0;
}
