//
//  This short program demonstrates a problem
//  found when calling a static member function.
//  For some reason, both VC 1.x and Borland 4.5
//  call the destructor for a temporary object that
//  was never constructed properly.  This error only
//  shows up in Test_3(), where a temporary object
//  is used to call a static member function.
//

#include <iostream.h>

class foo {
    public:
        foo() { cout << "ctor "; }
        foo( const &foo ) { cout << "copy "; }
        ~foo() { cout << "dtor "; }
        static void bar() { cout << "bar "; }
};

//
// Test 1 performs properly.  It doesn't construct
// or destroy any foo() objects.
//
void Test_1() {
    foo::bar();
}

//
// Test 2 works properly as well.  It constructs a
// single object, then destroys it when the function exits.
//
void Test_2() {
    foo f;
    f.bar();
}

//
// Test 3 has a problem.  It doesn't create the temporary
// object used here, but it destroys it!
//

void Test_3() {
    foo().bar();
}

void main()
{
    for ( int i = 1 ; i <= 3 ; i++ ) {
        cout << "Test " << i << ": ";
        switch ( i ) {
            case 1 : Test_1(); break;
            case 2 : Test_2(); break;
            case 3 : Test_3(); break;
        }
        cout << endl;
    }
}

