/*
 * Visual C++ v1.5:
 *   rc -r getdcex.rc
 *   cl /c /DSTRICT /W3 /Zp /GA /AL getdcex.c
 *   link /noi /NOD:LLIBCE getdcex.obj,,,
 *             llibcew libw,getdcex.def
 *   rc getdcex.res getdcex.exe
 * Borland C++ v4.5:
 *   brc -r getdcex.rc
 *   bcc -c -DSTRICT -ml -WSE getdcex.c
 *   tlink /A=16 /c /C /l /s /Twe c0wl+getdcex,,,
 *              cwl+import,getdcex,getdcex
 */
#include <windows.h>
#include <windowsx.h>

/* name of main dialog resource */
#define MAIN_DLG   "MainDialog"

/* global instance handle for this program */
HINSTANCE CurrentInstance;

int nGetDCCount;

static void OnTimer(HWND hWnd, UINT Id) 
    {
    int         nLine;
    const char* Error   = 0;
    HDC         hDC;
    POINT       ptOrigin;
    RECT        rectItem;

    ptOrigin.x = ptOrigin.y = 0;
    ClientToScreen(hWnd, &ptOrigin);
    GetClientRect(hWnd, &rectItem);
    
    for(nLine = 0; nLine < 40 && Error == 0; nLine++)
        {
        /* need temp region, as GetDCEx() deletes it */
        HRGN     rgnClipTo;

        if((rgnClipTo = CreateRectRgnIndirect(&rectItem)) == FALSE)
            Error   = "CreateRectRgnIndirect failed";
        // offset the region to screen coords
        else if (OffsetRgn(rgnClipTo, ptOrigin.x, ptOrigin.y) == ERROR)  
            Error   = "OffsetRgn failed";
        else
            {
            hDC = GetDCEx(hWnd, rgnClipTo, DCX_CACHE
                | DCX_INTERSECTRGN | DCX_CLIPSIBLINGS
                | DCX_CLIPCHILDREN);    
            if (hDC == NULL) /* if failed to get DC */
                Error   = "GetDCEx failed";
            else
                {
                SetDlgItemInt(hWnd, 100, nGetDCCount++, FALSE);
                ReleaseDC(hWnd, hDC);
#if defined(__WIN32__)
                if(GetRegionData(rgnClipTo, 256, NULL) != 0)
                    {
                    MessageBeep(0xFFFFFFFF);
                    DeleteObject(rgnClipTo);
                    }
#endif
                }
            }
        }
    if(Error != 0)
        {
        KillTimer(hWnd, Id);
        MessageBox(hWnd, Error, "GetDCEx Test", MB_OK);
        }
   }

BOOL CALLBACK MainDialog(HWND Dialog, UINT Message,
                         WPARAM wParam, LPARAM lParam)
    {
    switch(Message)
        {
        case    WM_INITDIALOG   :
            SetTimer(Dialog, 1, 100, NULL);
            return TRUE; /* FALSE if you called SetFocus() */
        case    WM_COMMAND  :
            EndDialog(Dialog, 0);
            break;
        HANDLE_MSG(Dialog, WM_TIMER, OnTimer);
        }
    return FALSE; /* FALSE == we did not process msg */
    }

#ifdef __BORLANDC__
    #pragma argsused
#endif
int WINAPI WinMain(HINSTANCE Instance, HINSTANCE Previous,
        LPSTR CommandLine, int ShowCommand)
    {
    CurrentInstance    = Instance;
    DialogBox(CurrentInstance, MAIN_DLG, NULL, MainDialog);
    return 0;
    }

