#include <windows.h>
#include <shellapi.h> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>

#ifdef __BORLANDC__
#include <dir.h>
#else
#define MAXPATH _MAX_PATH
#include <direct.h>
#endif
/* define Windows platform for NWCALLS headers and
 * then define unneeded headers                     */
#define NWWIN
#define NOAFP_INC
#define NODEL_INC
#define NODENTRY_INC
#define NODPATH_INC
#define NOEA_INC
#define NOERROR_INC
#define NOFILES_INC
#define NOMESSAGES_INC
#define NONAMSPC_INC
#define NONTTS_INC
#define NOPRINT_INC
#define NOSERVER_INC
#define NOSYNC_INC
#define NOVOL_INC
#define NOFSE_INC
#define NOMIGRATE_INC
#include <nwcalls.h>
#include "q.h"
 
static HANDLE        hParentInstance;
static HWND          hParent;
static char          errMsg[200];
static char          szQueueDir[118];
static DWORD         qID;
static int           function;
static unsigned int  nwConn;
static unsigned int  nwConnNum;
static NWOBJ_ID      queObjectID;

/* szQueueName and szServerName will need to be changed
 * for your particular network                          */
static char         *szQueueName = "TEST_QUEUE";
static char         *szServerName = "CHER";

BOOL CALLBACK _export MainDlgProc(HWND hwnd,
        UINT message,WPARAM wParam, LPARAM lParam);

int PASCAL WinMain(HINSTANCE hInstance,
    HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
    WNDCLASS    wc;

    hPrevInstance   = hPrevInstance;
    lpszCmdLine     = lpszCmdLine;
    nCmdShow        = nCmdShow;

    if (InitNetWareInfo(szServerName, szQueueName))
        return 0;

    wc.style = CS_DBLCLKS | CS_SAVEBITS | CS_BYTEALIGNWINDOW;
    wc.lpfnWndProc = DefDlgProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = DLGWINDOWEXTRA;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, "QMSIcon");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)COLOR_WINDOW + 1;
    wc.lpszMenuName = NULL;
    wc.lpszClassName = "QMSDlgClass";
    RegisterClass(&wc);

    hParentInstance = hInstance;
    return DialogBox(hInstance, "MainDialog", 0,
            (DLGPROC)MainDlgProc);
}

BOOL FAR PASCAL _export CreateDestroyDlgProc(HWND hDlg,
        WORD message, WORD wParam, LONG lParam)
{
    NWCCODE rc;
    NWDIR_HANDLE newDirHandle;

    lParam = lParam;
    switch (message)
    {
    case  WM_INITDIALOG:
        EnableWindow(GetDlgItem(hDlg, IDE_QCDIR)
            ,function == CREATE ? TRUE : FALSE);
        return (TRUE);
    case WM_COMMAND:
        switch (wParam)
        {
        case IDOK:
        /* Retrieve queue name information from edit box */
            GetDlgItemText(hDlg,IDE_QCNAME,szQueueName,48);
            switch (function)
            {
            case CREATE:
                rc = NWAllocTemporaryDirectoryHandle(nwConn,
                    0, "SYS:SYSTEM", &newDirHandle, 0);
                ErrMessage("NWAllocTemporaryDirectoryHandle",
                    rc);
                GetDlgItemText(hDlg, IDE_QCDIR,
                    szQueueDir, 118);
             /*  Create the queue and add EVERYONE to the
                 queue's Q_SERVERS property.  Any object
                 can attach itself to the queue and service
                 the queue, not very secure, but done for
                 example purposes.                         */
                rc = NWCreateQueue(nwConn, szQueueName,
                OT_PRINT_QUEUE,newDirHandle,szQueueDir,&qID);
                ErrMessage("NWCreateQueue", rc);
                rc = NWAddObjectToSet(nwConn, szQueueName,
                    OT_PRINT_QUEUE, "Q_SERVERS", "EVERYONE",
                    OT_USER_GROUP);
                ErrMessage("NWAddObjectToSet", rc);
                rc = NWAddObjectToSet(nwConn, szQueueName,
                    OT_PRINT_QUEUE, "Q_USERS", "EVERYONE",
                    OT_USER_GROUP);
                ErrMessage("NWAddObjectToSet", rc);
                rc = NWDeallocateDirectoryHandle(
                    nwConn, newDirHandle);
                ErrMessage("NWDeallocateDirectoryHandle", rc);
                EndDialog (hDlg, TRUE);
                break;
            case DESTROY:
                rc = NWGetObjectID(nwConn, szQueueName,
                    OT_PRINT_QUEUE , &qID);
                ErrMessage("NWGetObjectID", rc);
                rc = NWDestroyQueue(nwConn, qID);
                ErrMessage("NWDestroyQueue", rc);
                EndDialog (hDlg, TRUE);
                break;
            }
        return (TRUE);
        case IDCANCEL:
            EndDialog (hDlg, FALSE) ;
            return TRUE ;
        }
        break ;
    }
    return FALSE ;
}

BOOL _export CALLBACK MainDlgProc(HWND hDlg, UINT message,
        WPARAM wParam, LPARAM lParam )
{
    BOOL rc = FALSE;
    lParam = lParam;

    switch (message)
    {
    case WM_TIMER:
    case SERVICE_JOB_MSG:
    /* When the timer message arrives or a SERVICE_JOB_MSG
       is posted, try to service the queue */

        rc = PServer();
        ErrMessage("PServer", rc);
        rc = TRUE;
        break;
    case WM_INITDIALOG:
        hParent = hDlg;
        SetDlgItemText(hDlg,IDM_SERVERSTATUS,
            (LPCSTR)"Stopped");
        SetDlgItemText(hDlg,IDM_SERVERNAME,
            (LPCSTR)szServerName);
        SetDlgItemText(hDlg,IDM_QUEUENAME,
            (LPCSTR)szQueueName);
        rc = TRUE;
        break;
    case WM_CLOSE:
        EndDialog(hDlg, TRUE);
        rc = TRUE;
        break;
    case WM_COMMAND:
        switch (wParam)
        {
        case IDM_QUEUEBEGINSERVICE:
        /* begin servicing, first attach to the queue as
           a server, start a timer, and set status to
           running */

            rc = NWAttachQueueServerToQueue( nwConn,
                queObjectID);
            ErrMessage("NWAttachQueueServerToQueue", rc);
            SetTimer (hDlg, SERVICE_JOB_TIMER,
                TWO_SECONDS, NULL);
            PostMessage (hDlg, SERVICE_JOB_MSG, NULL,
                (DWORD) NULL);
            SetDlgItemText(hDlg,IDM_SERVERSTATUS,"Running");
            rc = TRUE;
            break;
        case IDM_QUEUEENDSERVICING:
        /* finish, first detach from the queue, kill the
           timer, and set the status to stopped */
            rc = NWDetachQueueServerFromQueue( nwConn,
                queObjectID);
            ErrMessage("NWDetachQueueServerFromQueue", rc);
            KillTimer(hDlg, SERVICE_JOB_TIMER);
            SetDlgItemText(hDlg,IDM_SERVERSTATUS,"Stopped");
            rc = TRUE; 
            break; 
        case IDM_CREATE:
            function = CREATE;
            DialogBox (hParentInstance, "CreateDestroyBox",
                hDlg, (DLGPROC)CreateDestroyDlgProc);
            rc = TRUE;
            break;
        case IDM_DESTROY:
            function = DESTROY;
            DialogBox (hParentInstance, "CreateDestroyBox",
                hDlg, (DLGPROC)CreateDestroyDlgProc);
            rc = TRUE;
            break;
        case IDM_QUEUEEXIT:
            EndDialog(hDlg, TRUE);
            rc = TRUE;
            return (0) ;
        }

    }
    return (rc);
}


int InitNetWareInfo(char * server, char * queue)
{
    /* Initialize NWCALLS.DLL, and get your connection
       handle and number, and get the object id for the
       queue name */
    NWCCODE              rc;

    rc = NWCallsInit(NULL,NULL);
    if (rc)
        return rc;

    rc = NWGetConnectionHandle((BYTE *)server, 0, &nwConn,
        NULL);
    if(rc)
        return rc;
    rc = NWGetConnectionNumber(nwConn,&nwConnNum);
    if(rc)
       return rc;
    rc = NWGetObjectID(nwConn, queue, OT_PRINT_QUEUE,
        &queObjectID);
    return rc;
}

/* Service the queue, removing files until done */
int PServer()
{
    QueueJobListReply       job;
    NWNUM                   startPosition = 0;
    NWQueueJobStruct        queueJob;
    NWFILE_HANDLE           nwfHandle;
    NWSIZE                  fileSize;
    NWCCODE                 ccode;
    FILE                   *hout; 
    unsigned char          *buf;
    unsigned long          processed = 0L;
    int                    cnt;
    struct pconsoleclientRecord *cliRec;
    char                    printFileName[MAXPATH];
    char                    displayFileName[MAXPATH];
    int                     err;
    char                    cwd[MAXPATH];
    HINSTANCE               exeInst;

    ccode = NWGetQueueJobList2(nwConn, queObjectID,
        startPosition, &job);
    CheckErr(ccode,1);
    CheckErr(!job.totalQueueJobs,0);
    ccode = NWReadQueueJobEntry2(nwConn, queObjectID,
        job.jobNumberList[0], &queueJob);
    CheckErr(ccode, 1);
    while(job.totalQueueJobs--)
    {
        /* check to see if there are any jobs in queue */
        ccode = NWServiceQueueJob2(nwConn, queObjectID,
            0, &queueJob, &nwfHandle);
        BreakCheckErr(ccode,1);
        cliRec = (struct pconsoleclientRecord *)
            queueJob.clientRecordArea; 
        ccode = NWGetQueueJobFileSize2(nwConn, queObjectID,
            queueJob.jobNumber, &fileSize);
        if(ccode)
        {
            ccode = NWAbortServicingQueueJob2(nwConn,
                queObjectID, queueJob.jobNumber, nwfHandle);
            err = 1;
            break;
        }
        if (cliRec->fileName[0]) 
        {
            strcpy(printFileName,".\\");
            strcat(printFileName,cliRec->fileName);
            strcpy(displayFileName,cliRec->fileName);
        }
        else
        {
            strcpy(printFileName,"LPT");
            strcpy(displayFileName,"LPT");
        }
        hout = fopen( printFileName, "wb");
        BreakCheckErr(!hout, 1);
        buf = malloc(BUF_SIZE);
        processed = 0;

        while(1)
        {
            cnt = read(nwfHandle, buf, BUF_SIZE);
            if (cnt == -1 || cnt == 0)
                break;
            fwrite (buf,cnt, 1, hout);
            processed +=cnt;
        }
        fclose(hout);
        free(buf);
        if (processed < fileSize)
        {
            ccode = NWAbortServicingQueueJob2(nwConn,
                queObjectID, queueJob.jobNumber, nwfHandle);
            break;
        } 
        ccode = NWFinishServicingQueueJob2(nwConn,
            queObjectID, queueJob.jobNumber, nwfHandle);
        /* Insert filename in the list box */
        SendMessage(GetDlgItem(hParent,IDM_SERVEDLIST),
          LB_INSERTSTRING,0,(LPARAM)(LPSTR)displayFileName);
        getcwd(cwd,sizeof(cwd));
        /* See if we can execute the association */
        exeInst = ShellExecute(hParent, NULL,
            displayFileName,NULL, cwd,SW_SHOW);
        if (exeInst <= (HINSTANCE)32)
        { 
            wsprintf(errMsg,"Unable to execute %s", displayFileName);
            MessageBox(NULL,errMsg,"Error", MB_OK);
        }
    }
 
End:
    return err;
}
