// UNI.C

#include <windows.h>
#include <stdio.h>
#include "convert.h"


PSTR UnicodeToMB(PCWSTR pStringW)
{
   PSTR  pStringA, p;
   ULONG Length = lstrlenW(pStringW) + 1;
   ULONG Bytes = Length * sizeof(WCHAR);

   if ((pStringA = (PSTR)LocalAlloc(LPTR, Bytes)) 
         == NULL) return NULL; 

   if ((Bytes = WideCharToMultiByte(CP_ACP, 0, 
         pStringW, Length, pStringA, Bytes, NULL, 
         NULL)) == 0) {
      LocalFree(pStringA);
      return NULL;
   }

   if (p = (PSTR)LocalReAlloc(pStringA, Bytes, 
         LMEM_ZEROINIT))
		pStringA = p;

   return pStringA;
}


PWSTR MBToUnicode(PCSTR pStringA)
{
   PWSTR pStringW, p;
   ULONG Length = lstrlenA(pStringA) + 1;
   ULONG Bytes = Length * sizeof(WCHAR);

   if ((pStringW = (PWSTR)LocalAlloc(LPTR, Bytes)) 
         == NULL) return NULL;

   if ((Length = MultiByteToWideChar(CP_ACP, 
         MB_PRECOMPOSED, pStringA, Length, 
         pStringW, Length)) == 0) {		                            
      LocalFree(pStringW);
      return NULL;
   }

   if (p = (PWSTR)LocalReAlloc(pStringW, 
         Length * sizeof(WCHAR),	LMEM_ZEROINIT))
      pStringW = p;

   return pStringW;
}


BOOL APIENTRY LibraryRoutineW(LPWSTR lpString)
{
   CharUpperW(lpString);  // do the real work here
   return TRUE;
}

BOOL APIENTRY LibraryRoutineA(LPSTR lpString)
{
   BOOL   Status;
   LPWSTR lpStringW;
   LPSTR  lpStringA;

   lpStringW = MBToUnicode(lpString);
   Status = LibraryRoutineW(lpStringW);
   lpStringA = UnicodeToMB(lpStringW);
   lstrcpy(lpString, lpStringA);
   LocalFree(lpStringW);
   LocalFree(lpStringA);
	
   return Status;
}
