/*

   MGRMAP.H

   Oliver Kraus
   kraus@lrs.e-technik.uni-erlangen.de

*/

#ifndef _MGR_MAP_H
#define _MGR_MAP_H

#include "mgr.h"
#include "map.h"

struct _mgrmap_struct
{
   map_type map;
   mgr_type mgr;
   long dpi;
   long dest_width;
   long dest_height;
   long curr_width;
   long curr_height;
   long x_offset;
   long x_skip;
   long y_offset;
   long ratio_num;
   long ratio_den;

   long tf_height;
   long lf_height;
   long idf_height;

   long upper_skip;
   long lower_skip;
   long legend_cols;
   long legend_rows;
   long legend_cnt;
   long legend_f1_size;
   long legend_f2_size;
   long legend_f3_size;

   int  is_monster;
   int  is_card;
};
typedef struct _mgrmap_struct mgrmap_struct;
typedef struct _mgrmap_struct *mgrmap_type;


#define mgrmap_SetMonster(mm) ((mm)->is_monster = 1, map_SetMonster(mm->map))
#define mgrmap_ClrMonster(mm) ((mm)->is_monster = 0, map_ClrMonster(mm->map))
#define mgrmap_SetCard(mm) ((mm)->is_card = 1, map_SetCard(mm->map))
#define mgrmap_ClrCard(mm) ((mm)->is_card = 0, map_ClrCard(mm->map))

mgrmap_type mgrmap_Open(char *fname, FILE *fp);
void mgrmap_Close(mgrmap_type mm);
void mgrmap_SetDestSize(mgrmap_type mm, long dest_width, long dest_height);
void mgrmap_SetFontHeight(mgrmap_type mm, long idf_height, long tf_height, long lf_height);
#define mgrmap_SetDPI(mm,_dpi) ((mm)->dpi=(_dpi))
int mgrmap_AllocMGR(mgrmap_type mm);
void mgrmap_DrawTitle(mgrmap_type mm, char *title);
void mgrmap_DrawLegend(mgrmap_type mm);
void mgrmap_DrawLines(mgrmap_type mm);
void mgrmap_DrawSprites(mgrmap_type mm);

#endif
