#include "mdl.h"
#include "3ds.h"

word frame_info ( frame *frame_ptr, mdl_header *head ) {
dword index;
   
   printf("name: %s\n",frame_ptr->name);
   printf("min: x:%8.2f y:%8.2f z:%8.2f\n",
      frame_ptr->min.x * head->scale.x + head->origin.x + head->eye_pos.x,
      frame_ptr->min.y * head->scale.y + head->origin.y + head->eye_pos.y,
      frame_ptr->min.z * head->scale.z + head->origin.z + head->eye_pos.z );
   printf("min: x:%8.2f y:%8.2f z:%8.2f\n",
      frame_ptr->max.x * head->scale.x + head->origin.x + head->eye_pos.x,
      frame_ptr->max.y * head->scale.y + head->origin.y + head->eye_pos.y,
      frame_ptr->max.z * head->scale.z + head->origin.z + head->eye_pos.z );
   for ( index=0; index < head->vert_num; index++ ) {

   printf("vert %lu: x:%8.2f y:%8.2f z:%8.2f light: %u\n", index,
      frame_ptr->vert_ptr[index].x * head->scale.x + head->origin.x + head->eye_pos.x,
      frame_ptr->vert_ptr[index].y * head->scale.y + head->origin.y + head->eye_pos.y,
      frame_ptr->vert_ptr[index].z * head->scale.z + head->origin.z + head->eye_pos.z,
      frame_ptr->vert_ptr[index].normal );
   }

return 0; }





word load_mdl ( byte *filename, mdl_object *obj ) {
FILE *fp;
dword c0; // general counter

fp = fopen ( filename, "rb" );
if ( !fp ) {
   printf("unable to open mdl \"%s\"\n",filename);
   exit(1);
}
fread(&obj->head,sizeof(mdl_header),1,fp);

if ( obj->head.id != IDPO ) {
   printf("this is not a quake .mdl\n");
   exit(1);
}

/*
printf("id: %c%c%c%c\n",
          ((byte *)&obj->head.id)[0],
          ((byte *)&obj->head.id)[1],
          ((byte *)&obj->head.id)[2],
          ((byte *)&obj->head.id)[3] );
printf("version: %lu\n",obj->head.version);
printf("scale: x:%8.2f y:%8.2f z:%8.2f\n",
                    obj->head.scale.x,obj->head.scale.y,obj->head.scale.z );
printf("origin: x:%8.2f y:%8.2f z:%8.2f\n",
                    obj->head.origin.x,obj->head.origin.y,obj->head.origin.z );
printf("radius: %8.2f\n",obj->head.radius);
printf("eye pos: %8.2f %8.2f %8.2f\n",
                    obj->head.eye_pos.x,obj->head.eye_pos.y,obj->head.eye_pos.z );
printf("number of skins: %lu\n",obj->head.skin_num );
printf("skin width:  %lu\n",obj->head.skin_width );
printf("skin height: %lu\n",obj->head.skin_height );

printf("number of verts: %lu\n",obj->head.vert_num );
printf("number of triangles: %lu\n",obj->head.tri_num );
printf("number of frames: %lu\n",obj->head.frame_num );
printf("synctype: %lu\n",obj->head.sync_type);
printf("flags: %lu\n",obj->head.flags);
printf("size: %8.2f\n",obj->head.size);
*/

obj->rimg = ( raw_image * ) malloc ( obj->head.skin_num * sizeof(raw_image) );
 if ( !obj->rimg ) {
    printf("could not allocate skin ptrs\n");
    exit(1);
 }

for ( c0=0; c0< obj->head.skin_num; c0++ ) {
  fread(&obj->rimg[c0].unknown,4,1,fp);
 // printf("texture unknown: %lu\n",obj->rimg[c0].unknown);
  obj->rimg[c0].width  = obj->head.skin_width;
  obj->rimg[c0].height = obj->head.skin_height;
  obj->rimg[c0].data = ( byte * ) malloc ( obj->rimg[c0].width*obj->rimg[c0].height );
  if ( !obj->rimg[c0].data ) {
       printf("could not allocate mem for skin %lu bitmap\n",c0);
       exit(1);
  } // end if
  fread ( obj->rimg[c0].data, 1, obj->rimg[c0].width*obj->rimg[c0].height, fp );
} // end c0

obj->tvert_ptr = ( tvert * ) malloc ( obj->head.vert_num * sizeof(tvert) );
if ( !obj->tvert_ptr ) {
   printf("could not allocate mem for texture verts\n");
   exit(1);
}
fread( obj->tvert_ptr, sizeof(tvert), obj->head.vert_num, fp );
/*
for ( c0=0; c0< obj->head.vert_num; c0++ ) {
  printf("tvert %lu: \n",c0);
  printf("  onseam: %lu\n",obj->tvert_ptr[c0].onseam);
  printf("  s: %lu \n",obj->tvert_ptr[c0].s);
  printf("  t: %lu \n",obj->tvert_ptr[c0].t);
} // end f0
*/

obj->tri_ptr = ( tri * ) malloc ( obj->head.tri_num * sizeof(tri) );
if ( !obj->tri_ptr ) {
   printf("unable to allocate triangle mem\n");
   exit(1);
}

fread( obj->tri_ptr, sizeof(tri), obj->head.tri_num, fp );
/*
for ( c0=0; c0< obj->head.tri_num; c0++ ) {
  printf("triangle %lu:\n",c0);
  printf("   front: %lu\n",obj->tri_ptr[c0].front);
  printf("   verts: %lu %lu %lu\n",
                     obj->tri_ptr[c0].vert[0],
                     obj->tri_ptr[c0].vert[1],
                     obj->tri_ptr[c0].vert[2] );
} // end c0
*/

obj->frame_ptr = ( frame * ) malloc ( obj->head.frame_num*sizeof(frame) );
if ( !obj->frame_ptr ) {
   printf("could not allocate mem for frame pointers\n");
   exit(1);
}

c0 = 0;
for ( c0=0; c0< obj->head.frame_num; c0++ ) {
   fread(&obj->frame_ptr[c0].unknown,4,1,fp);
   fread(&obj->frame_ptr[c0].min,sizeof(vert),1,fp);
   fread(&obj->frame_ptr[c0].max,sizeof(vert),1,fp);
   fread(&obj->frame_ptr[c0].name,1,16,fp);

   obj->frame_ptr[c0].vert_ptr = (vert *) malloc ( obj->head.vert_num * sizeof(vert));
   if ( !obj->frame_ptr[c0].vert_ptr ) {
      printf("unable to allocate vert mem for frame %lu\n",c0);
      exit(1);
   }
   fread( obj->frame_ptr[c0].vert_ptr, sizeof(vert), obj->head.vert_num, fp );

} // end c0

fclose(fp);
return 0; }




word free_mdl ( mdl_object *obj ) {
dword c0;
  for ( c0=0; c0< obj->head.skin_num; c0++ )
    free( obj->rimg[c0].data );
  free(obj->tvert_ptr);
  free(obj->tri_ptr);
  for ( c0=0; c0< obj->head.frame_num; c0++ )
    free ( obj->frame_ptr[c0].vert_ptr );
  free(obj->frame_ptr);
return 0; }




word main ( word argc, byte **argv ) {
mdl_object trimesh;

if ( argc < 3 ) {
   printf("usage: mdl <mdlfile> <3dsfile> \n");
   return 1;
}
load_mdl ( argv[1], &trimesh );
//frame_info ( &trimesh.frame_ptr[0], &trimesh.head );
write_3ds ( &trimesh, argv[2] );
free_mdl ( &trimesh );
return 0; }
