

   rar(C)                       9 February 1996                       rar(C)

 Name

    rar - file archiver

 Syntax

    rar <command> [ -<switches> ] <archive> <@listfiles...> [ <files...> ]

 Description

    The rar archiver adds and extracts files to and from an archive. The
    archive is usually a regular file, which name has ".rar" suffix in its
    end. Archive could be a media like a floppy diskette, tape or any other
    storage device.

    Command line options (commands and switches) provides control of creating
    and managing archives with rar. The command is a string (or a single
    letter) which says rar to perform corresponding action. Switches are
    designed to modify the way rar performs the action. Other parameters are
    archive name and files to be archived into or extracted from the archive.

    Command could be one of the list:

    a       Add files to archive.

    c       Add archive comment. Comments are displayed while the archive is
            being processed.

    cf      Add files comment. Comments are displayed when the 'v' command
            is given. Comment length is limited to 16384 bytes.

    cw      Write archive comment to specified file.

    d       Delete files from archive. Note, if the processing of this
            command resulted in removing all the files from the archive, the
            empty archive would removed.

    e       Extract files to current directory.

    f       Freshen files in archive. Updates those files changed since they
            were packed to the archive. This command will not add new files
            to the archive.

    k       Lock archive. Any command which intend to change the archive
            will be ignored.

    l[t]    List contents of archive [technical]. Files are listed as with
            the 'v' command with the exception of the file path. i.e. only
            the file name is displayed. Optional technical information is
            displayed when 't' modifier is used.

    m[f]    Move to archive [files only]. Moving files and directories
            results in the files and directories being erased upon
            successful completion of the packing operation. Directories will
            not be removed if 'f' modifier is used and/or '-ed' switch is
            applied.

    p       Print file to stdout.

    r       Repair archive. Archive repairing is performed in two stages.
            First, damaged archive is searched for recovery record (see 'rr'
            command). If the archive contains recovery record and if portion
            of the damaged data is continuous and less than N*512 bytes,
            where N is number of recovery sectors placed into the archive,
            the chance of successful archive reconstruction is very high.
            When this stage has completed, a new archive will be created,
            called _RECOVER.RAR.

            If broken archive does not contain recovery record or if archive
            is not completely recovered due to major damages, second stage
            is being performed. During this stage only archive structure is
            reconstructed and it is impossible to recover files which fail
            the CRC validation, but still is possible to recover undamaged
            files which inaccessible due to broken archive structure. Mostly
            it is useful for non-solid archives. In damaged solid archives
            usually only the first file can be really recovered during
            second stage.

            When the second stage is completed, reconstructed archive will
            be saved as _RECONST.RAR.

            While the recovery is in progress, RAR may prompt the user for
            assistance when suspicious file is detected.

                      Suspicious entry

              Name:  <possibly filename>
              Size:  <size>    Packed: <compressed size>

                      Add it: Yes/No/All

            Answer 'y' to add this entry to the file _RECOVER.RAR.

    rr[N]
            Add data recovery record. Optionally, redundant information
            (recovery record) may be added to archive. It causes small
            increasing of the archive size and helps to recover archived
            files in case of floppy disk failure or data losses of any other
            kind. Recovery record contains up to 8 recovery sectors. Number
            of sectors may be specified directly in the 'rr' command (N = 1,
            2 .. 8) or if it is not specified by user it will be selected
            automatically corresponding to the archive size:

                   Archive size       Number of sectors
                     < 50Kb                   2
                     50Kb-500Kb               4
                     > 500Kb                  8

            If data are damaged continuously then each rr-sector helps to
            recover 512 bytes of damaged information. This value may lower
            in case of multiple damages.

            Size of recovery record may be rawly determined with the formula
            <archive size>/256 + <number of recovery sectors>*512 bytes.

    s       Convert archive to SFX. The archive is merged with SFX-module
            (file sfx.cod by default). This is reserved for future use.

    t       Test archive files. This command performs a dummy file
            extraction, writing nothing to the output stream, in order to
            validate the specified file(s).

    u       Update files in archive. Adds files not already in the archive
            and updates those files changed since they were packed to the
            archive.

    v[t]    Verbosely list contents of archive [technical].
            Files are listed using the format: full pathname, file comment,
            original and compressed size, compression ratio, last update
            date and time, attributes, CRC, compression method and minimum
            RAR version required to extract. Optional technical information
            is displayed when 't' modifier is used.

            To list the contents of all archive volumes, use an asterisk
            ('*') in place of the archive file extension or use the '-v'
            switch.

    x       Extract files with full path.


    Switches (used in accordance with a command):

    -?      Display help on commands and switches. The same as when none
            or an illegal command line option is entered.

    -av     Put authenticity verification (registered versions only).
            RAR will put, in every new and updated archive, information
            concerning the creator, last update time and archive name.

            If an archive, containing authenticity verification, is being
            modified and this switch is not specified, the authenticity
            verification information will be removed.

            When extracting, testing, listing or updating and archive with
            the '-av' switch, RAR will perform integrity validation and
            display the message:

              Verifying authenticity information ...

            In the case of successful authenticity verification, the message
            'Ok', creator name and last update information will be
            displayed. In the case of authenticity verification failure, the
            message 'FAILED' will be displayed.

            The Authenticity Verification feature, '-av,' is recommended for
            use with archives in a software distribution environment.

            In order to enable the Authenticity verification feature, the
            program MUST be registered. Please contact your local
            distribution site or the world-wide distribution center.

    -av-    Disable AV checking or adding.

    -cfg-   Disable read configuration and environment.

    -cl     Convert file names to lower case.

    -cu     Convert file names to upper case.

    -c-     Disable comments show.

    -ds     Do not sort files while adding to a solid archive.

    -ed     Do not add empty directories. This switch indicates that empty
            directories are not to be stored in the created archive.

    -ep     Exclude paths from names. This switch enables files to be added
            to an archive without including the path information. This
            could, of course, result in multiple files existing in the
            archive with the same name.

    -ep1    Exclude base dir from names. Do not store the path entered in
            the command line.

    -e<atr> Specifies file exclude attributes mask. <atr> is a number in the
            decimal, octal (with leading '0') or hex (with leading '0x')
            format. If result of bitwise AND between <mask> and file
            attributes is nonzero, then file would not be added to archive.

    -f      Freshen files. May be used with archive extraction or creation.
            The command string "a -f" is equivalent to the command 'f', you
            could also use the switch '-f' with the commands 'm' or 'mf'. If
            the switch '-f' is used with the commands 'x' or 'e', then only
            old files would be replaced with new versions extracted from the
            archive.

    -ilog   Log errors to file.

    -isnd   Enable sound.

    -m<n>   Set compression method:

       -m0   store     do not compress file when adding to archive
       -m1   fastest   use fastest method (less compressive)
       -m2   fast      use fast compression method
       -m3   normal    use normal (default) compression method
       -m4   good      use good compression method (more
                       compressive, but slower)
       -m5   best      use best compression method (sightly more
                       compressive, but slowest)

            By default RAR uses -m3 method (Normal compression).


    -md<n>  Select dictionary size <n> in Kb. Must be 64,128,256,512 or 1024.

            Sliding dictionary is a special memory area used by the
            compression algorithm. If size of file to archive (or the size of
            all files to pack when creating solid archive) more than
            dictionary size then greater dictionary size usually will
            increase compression ratio significantly. Though it will lower
            packing speed and cause higher memory requirements.

            Default sliding dictionary size in Unix version of RAR is 256
            Kb. In versions of RAR for Unix, OS/2 and some other platforms
            it is possible to select five different sizes: 64, 128, 256, 512
            or 1024 Kb. Besides, speed of extraction in these versions does
            not depend upon dictionary size. In version of RAR for DOS the
            sliding dictionary size is fixed and equal to 64 Kb. Though RAR
            for DOS provides extracting files from large dictionary
            archives.

            Amount of memory to create large dictionary archives determined
            as 5*<dictionary size>+150Kb. About 1 Mb required for extraction
            and 5*<dictionary size>+1150Kb to update solid archives.

    -mm[f]  Multimedia compression [force]. Enables special multimedia
            compression algorithm. It is intended to compress digital audio
            data containing up to four 8-bit or two 16-bit channels. It
            works good with a true color (24-bit) bitmaps as well.
            Improvement in the compression ratio up to 30% over the normal
            compression may be achieved.

            When archiving file in the multimedia mode rar performs
            intelligent data analysis and may use for different file parts
            general or multimedia compression depending on which suits
            better. Such analysis allows to reach optimum performance when
            different data types are merged in the file. The 'f' modifier
            forces the multimedia compression to be used for whole file; it
            may help when certain multimedia files are to be compressed,
            but in most cases it only increase archive size.

            Both the -m<N> "Set compression method" and -s "Create solid
            archive" switches could be applied with multimedia compression,
            but they are in effect for those file parts where general
            algorithm works.

            If -mm is used with non-multimedia data, compression ratio
            usually is not changed in comparison with general method or
            changed not significantly but due to multimedia analysis
            overhead the packing speed is always slower. Then the usage of
            -mm is not recommended with common data files.

    -ol     Save symbolic links as the link instead of the file.

    -ow     Save file owner and group information.

    -o+     Overwrite existing files.

    -o-     Do not overwrite existing files.

    -p<p>   Crypt files with the string <p> as password while archiving.
            The password is case-sensitive. If you omit the password on the
            command line, you will be prompted with message "Enter password".

    -r      Recurse subdirectories. May be used with commands:
            a,u,f,m,x,e,t,p,v,l,c,cf,s.

            When used with the commands 'a', 'u', 'f', 'm' will process
            files in all sub-directories as well as the current working
            directory.

            When used with the commands x,e,t,p,v,l,c,cf,s will process all
            archives in sub-directories as well as the current working
            directory.

    -rr[N]  Add data recovery record. This switch is used when creating or
            modifying archive to add data recovery record to the archive.
            See the 'rr[N]' command description for details.

    -s      Create solid archive. Solid is a special archive type. Please
            refer to the appendix "Glossary" for further information.

    -sfx    Create SFX archives. If this switch is used when creating a new
            archive, a Self-Extracting archive (using a module in file
            sfx.cod) would be created. Reserved for future use.

    -tk     Keep original archive date. Prevents RAR from modifying the
            archive date when changing an archive.

    -tl     Set archive time to newest file. Forces RAR to set the date of a
            changed archive to the date of the newest file in the archive.

    -u      Update files. May be used with archive extraction or creation.
            The command string "a -u" is equivalent to the command 'u', you
            could also use the switch '-u' with the commands 'm' or 'mf'. If
            the switch '-u' is used with the commands 'x' or 'e', then files
            not present on the disk and files newer than their copies on the
            disk would extracted from the archive.

    -v<n>[k|b]  Create volumes with size=<size>*1000 [*1024 | *1].
            By default this switch uses <size> as thousands (1000) of bytes
            (not 1024 x bytes). You may also enter the size in kilobytes
            using the symbol 'k' or in bytes using the symbol 'b' following
            the numerical value. If the size is omitted, autodetection will
            be used.

            If volumes are created on the same drive as the temporary files
            (current drive by default, but may be changed with the switch
            '-w'), the autodetected size becomes meaningless. In this case
            the volume size must be explicitly defined.

            If volumes are created on a drive OTHER than the drive
            containing the temporary files, then after the first volume has
            been created, the user will be prompted with:

              Create next volume: Yes/No/All/Quit

            At this moment in time, you should change the disks. Answering
            'A' will cause all volumes to be created without a pause.

            The first volume file in a multi-volume set has the extension
            .RAR, following volumes are numbered from .R00 to .R99.

            When extracting or testing a multi-volume archive you must use
            only the first volume name (*.RAR). If there is no next volume
            on the drive (and volumes are not placed in the same directory
            as the temporary files), the user will be prompted with:

             Insert disk with <next volume name>

            Insert the disk with the correct volume and press any key.

            If while extracting, the next volume is not found and volumes
            are placed in the same directory as the temporary files, RAR
            will abort with the error message:

             Cannot find <volume name>
             Cannot change disk with temporary files

            Archive volumes may not be modified. The commands 'd', 'f', 'u',
            's' can not be used with Multi-volume sets. The command 'a' may
            be used only for the creation of a new multi-volume sequence.

            It is possible, although unlikely, that the file size, of a file
            in a multi-volume set, could be greater than it's uncompressed
            size. This is due to the fact that 'storing' (no compression if
            size increases) cannot be enabled for multi-volume sets.

            Archive volumes may be Self-Extracting (SFX). Such an archive
            should be created using both the '-v' and '-sfx' switches.

    -w<p>   Assign work directory as <p>. This switch may be used to assign
            the directory for temporary files.


    -x<f>   Exclude specified file<f>, wildcards may be used. You may
            specify the switch '-x' several times:


    -x@<lf> Exclude files using specified list file.

    -y      Assume Yes on all queries.


    -z<f>   Read archive comment from file<f>.


 Examples

    1. Create or update existant archive, adding all files in current
    directory:

       rar a myarch

    Note: the archive will have name myarch.rar.

    2. Create solid archive sources.rar with 512 Kb dictionary, recursing all
    directories, starting with the current directory. Add only .asm files:

       rar a -s -md512 sources.rar *.asm -r

    You need to quote wildcards in case they should be processed with rar
    itself. This will delete *.asm files from rar archives in current path:

       rar d '*.rar' '*.asm'

    3. Extract specified file to current path. AV check and comment show
    are disabled:

       rar x -av- -c- dime 10cents.txt

    4. Use the tightest compression method, solid archiving and multimedia
    compression with smart analysis, which method should be applied for
    particular data:

       rar a -m5 -s -mm All_My_Songs.rar /usr/smith/wavs/*.wav

       The directories will be stored to the archive as well.

    5. Encrypt files *.txt with password "myhoney".

       rar a -pmyhoney /usr/smith/secure/secret1 /tmp/*.txt

    If the password not indicated in command line, the user would be prompted
    with the message "Enter password:"

    6. Create archive in volumes of fixed size:

       rar a -s -v1440 floparch.rar *.*

    Will create solid volumes of size 1440000 bytes.

    7. Create SelF-eXtracting (SFX) archive using specified SFX-module and
    special installation script:

       rar a -sfxidos.sfx -zscript.s myinst

    See the SFX documentation, SFX.DOC for details.

    8. All files and directories from the directory tmp will be added to the
    archive 'pasta', but the path will not include 'tmp/':

       rar a -ep1 -r pasta 'tmp/*'

    This is equivalent to the commands:

         cd tmp
         rar a -ep1 -r pasta
         cd ..

    9. Do not add (eXclude) some files when creating archive:

       rar a -x*.bak purearch.rar

    You may specify the switch '-x' several times:

       rar a -r -x*.arj -x*.rar rawfiles

    A list file could be used to exclude files:

       rar a -x@exlist.txt arch *.exe

    10. Enter archive comment:

       rar c distrib.rar

    The user may add it from file:

       rar c -zinfo.txt dummy

    ..or add file comments:

       rar cf bigarch *.txt

    11. Save archive comment to specified text file:

       rar cw oldarch comment.txt

    12. Lock to prevent archive modification later:

       rar k final.rar

    13. Repair archive (recovery record will be used if present):

       rar r buggy.rar

    14. Direct archive content list (technical) to a file:

       rar vt bambam >bambam.lst

    15. Test archives in current directory:

       rar t '*'

    The user may test archives in all sub-directories, starting with
    the current path:

       rar t '*' -r
 
 Environment variable

    Default parameters may be added to the RAR command line by establishing
    an environment variable "RAR".

    For instance, following lines may be added to your profile:

      RAR='-s -md1024'
      export RAR

    RAR will use this string as default parameters in the command line and
    will create "solid" archives with 1024 Kb sliding dictionary size.

    RAR handles options with priority as following:

       command line switches              highest priority
       switches in the RAR variable       lower priority
       switches saved in .rarrc           lowest priority

 Limitations

    Pathname is limited to 259 symbols.

    Maximum comment length is 16384 bytes.

    Command limitations:

    The commands 'd','u','f' will not operate with archive volumes.

    The command 'a' cannot be used to update an archive volume, only to
    create one.

    The commands 'c' and 'cf' will not operate with archive volumes, but
    will work with solid archives.

 Exit values

    rar exits with a zero code (0) in case of successful operation. The exit
    code of non-zero means the operation is canceled due to error:

     255   USER BREAK       User stopped the process

       8   MEMORY ERROR     Not enough memory for operation

       7   USER ERROR       Command line option error

       6   OPEN ERROR       Open file error

       5   WRITE ERROR      Write to disk error

       4   LOCKED ARCHIVE   Attempt to modify an archive previously locked
                            by the 'k' command

       3   CRC ERROR        A CRC error occurred when unpacking

       2   FATAL ERROR      A fatal error occurred

       1   WARNING          Non fatal error(s) occurred

       0   SUCCESS          Successful operation (User exit)

 Glossary

    Archive      Special file containing one or more files optionally
                 encoded and/or compressed.

    Compression  A method of encoding data to reduce it's size.

    CRC          Cyclic Redundancy Check. Mathematical method calculating
                 special checking information for data validity.

    SFX          Archive module used to extract files from when executed.
                 (SelF-eXtracting module), usually in the form of a .EXE
                 file.

    Solid        An archive packed using a special compression method which
                 sees all files as one continuous data stream. Particularly
                 advantageous when packing a large number of small files.

    Volume       Part of a split archive. Splitting an archive to volumes
                 allows storing them on diskettes. Volumes must be extracted
                 starting from first in sequence.

 Files

    $HOME/.rarrc  File in the user's home directory (stored in HOME
                  environment variable with default switches and
                  registration info. It may contains following strings:
                  switches=<any rar switches>
                  regname=<your registration name>
                  regcode=<your code as stated in registration>

    $HOME/.rarlog Log file where rar writes messages about errors 
                  encountered while processing archives.

 Version 

    RAR for Unix 2.00 beta

 Copyrights

    (c) 1993-96 Eugene Roshal

