{ Purpose: This program will play Tic Tac Toe against another person.
  Input  : Two integers per player.
  Output : A diagram of the board showing the ending positions and total wins.
  Author : Johnny Duraccio
  Date   : 15 February 1996
  Project: #3
-----------------------------------------------------------------------------}
PROGRAM Tic_Tac_Toe;

USES Crt;

TYPE
   TicTacToe = Array [1..3,1..3] OF Char;    { Declare An Array Variable With    }
                                             { 3 Rows And 3 Columns To Type Char }
VAR
   TTT:                                      { Define An Array Variable TTT To   }
      TicTacToe;                             { Be Of Type TicTacToe              }
   Row,                                      { Define The Variable Row           }
   Col:                                      { And The Variable Column           }
      Integer;                               { To Be Of Type Integer             }
   Win:                                      { Define The Variable Win           }
      Boolean;                               { To Be Of Type Boolean             }

{ This Procedure Display The Tic Tac Toe Board }

PROCEDURE Display;

BEGIN { Display }
   WriteLn;
   WriteLn ('Tic Tac Toe     by Johnny Duraccio':56);
   WriteLn ('':56);
   WriteLn;
   WriteLn ('ͻ':63);
   WriteLn ('':63);
   WriteLn ('':63);
   WriteLn ('':63);
   WriteLn (' ':63);
   WriteLn ('       [1,1]  [1,2]  [1,3]':63);
   WriteLn (' ':63);
   WriteLn ('':63);
   WriteLn (' ':63);
   WriteLn ('       [2,1]  [2,2]  [2,3]':63);
   WriteLn (' ':63);
   WriteLn ('':63);
   WriteLn ('':63);
   WriteLn ('':63);
   WriteLn ('       [3,1]  [3,2]  [3,3]':63);
   WriteLn ('':63);
   WriteLn ('ͼ':63);
END;  {Display}

{ This Procedure Will Clear The Array }

PROCEDURE ClearArray;

BEGIN { ClearArray }
   FOR Row := 1 TO 3 DO             { Loop From Row 1 To 3     }
      FOR Col := 1 TO 3 DO          { Loop From Column 1 To 3  }
         TTT [Row,Col] :=' ';       { And Assign A Blank Space }
END; { ClearArray }

{ This Procedure Puts The Characters On The Tic Tac Toe Board }

PROCEDURE ShowChars;

BEGIN { ShowChars }
   CASE Col OF
      1: CASE Row OF                { If Column 1 Is Chosen And }
            1: GotoXY(28,8);        { If Row 1 Is Chosen, Put Symbol At This Coordinate }
            2: GotoXY(28,12);       { If Row 2 Is Chosen, Put Symbol At This Coordinate }
            3: GotoXY(28,17);       { If Row 3 Is Chosen, Put Symbol At This Coordinate }
         END; { Case }
      2: CASE Row OF                { If Column 2 Is Chosen And }
            1: GotoXY(40,8);        { If Row 1 Is Chosen, Put Symbol At This Coordinate }
            2: GotoXY(40,12);       { If Row 2 Is Chosen, Put Symbol At This Coordinate }
            3: GotoXY(40,17);       { If Row 3 Is Chosen, Put Symbol At This Coordinate }
         END; { Case }
      3: CASE Row OF                { If Column 3 Is Chosen And }
            1: GotoXY(51,8);        { If Row 1 Is Chosen, Put Symbol At This Coordinate }
            2: GotoXY(51,12);       { If Row 2 Is Chosen, Put Symbol At This Coordinate }
            3: GotoXY(51,17);       { If Row 3 Is Chosen, Put Symbol At This Coordinate }
         END; { Case }
   END; { Case }
     Write (TTT [Row,Col]);         { Write The Symbol At This Two Dimensionl Array Coordinate }
END;

{ This Procedure Checks To See If There Are Any Winners }

PROCEDURE CheckWin;

BEGIN { CheckWin }
   IF (TTT [1,1] = TTT [1,2]) AND (TTT [1,1] = TTT [1,3]) THEN Win := True; { Row 1 Across  }
   IF (TTT [2,1] = TTT [2,2]) AND (TTT [2,1] = TTT [2,3]) THEN Win := True; { Row 2 Across  }
   IF (TTT [3,1] = TTT [3,2]) AND (TTT [3,1] = TTT [3,3]) THEN Win := True; { Row 3 Across  }
   IF (TTT [1,1] = TTT [2,1]) AND (TTT [1,1] = TTT [3,1]) THEN Win := True; { Column 1 Down }
   IF (TTT [1,2] = TTT [2,2]) AND (TTT [1,2] = TTT [3,2]) THEN Win := True; { Column 2 Down }
   IF (TTT [1,3] = TTT [2,3]) AND (TTT [1,3] = TTT [3,3]) THEN Win := True; { Column 3 Down }
   IF (TTT [1,1] = TTT [2,2]) AND (TTT [1,1] = TTT [3,3]) THEN Win := True; { Diagonal From Top Left To Bottom Right }
   IF (TTT [1,3] = TTT [2,2]) AND (TTT [1,3] = TTT [3,1]) THEN Win := True; { Diagonal From Top Right To Bottom Left }
END; { CheckWin }
                                                                                
{ This Procedure Gets The Symbols And Coordinates From The Players }

PROCEDURE GetSymbolsAndCoords;

VAR
   Symbol1,            { Define The Variable Symbol1 }
   Symbol2:            { And The Variable Symbol2    }
      Char;            { To Be Of Type Char          }
   Player:             { Define The Variable Player  }
      Integer;         { To Be Of Type Integer       }

BEGIN
   Player := 1;        { Set Player Variable Equal To Player 1 }
   Win := False;       { Set Win Variable To False - No Wins   }
   REPEAT              { Repeat This Loop Until A Valid Character Is Entered }
      Write ('Enter The Symbol For Player #1 [O Or X]: ':61);
      ReadLn (Symbol1);                                           { Get Symbol For Player 1 }
      IF NOT (Symbol1 IN ['O','o','X','x'])                       { Check For Valid Symbol  }
         THEN
            BEGIN
               Write ('Invalid Symbol. Try Again: ');             { Show Error Message      }
               ReadLn (Symbol1);                                  { Get Symbol Again        }
            END;
   UNTIL (Symbol1 = 'O') OR (Symbol1 = 'o') OR (Symbol1 = 'X') OR (Symbol1 = 'x');
   REPEAT
      Write ('Enter The Symbol For Player #2 [O Or X]: ':61);     { Get Symbol For Player 2 }
      ReadLn (Symbol2);
      IF NOT (Symbol2 IN ['O','o','X','x'])                       { Check For Valid Symbol  }
         THEN
            BEGIN
               Write ('Invalid Symbol. Try Again: ');             { Show Error Message      }
               ReadLn (Symbol2);                                  { Get Symbol Again        }
            END;
   UNTIL (Symbol2 = 'O') OR (Symbol2 = 'o') OR (Symbol2 = 'X') OR (Symbol2 = 'x');
   REPEAT
      Window (15,22,70,25);         { Set The Text Display Window To This Size And Location }
      Clrscr;                       { Clear The Text Display Window }
      Window (1,1,80,25);           { Reset The Window Display To Maximum Opening }
      Write ('Player #',Player);    { Display Which Player Takes A Turn In Upper Left Corner Of Screen }
      GotoXY (30,22);                        { Go To Screen Coordinates }
      Write ('Enter The Row [1/2/3]: ');     { Display Prompt           }
      ReadLn (Row);                          { And Get Row Number       }
      GotoXY (27,23);                        { Go To Screen Coordinates }
      Write ('Enter The Column [1/2/3]: ');  { Display Prompt           }
      ReadLn (Col);                          { And Get Column Number    }
      IF Player = 1
         THEN
            TTT [Row,Col] := Symbol1         { Place Symbol1 In Array   }
         ELSE
            TTT [Row,Col] := Symbol2;        { Place Symbol2 In Array   }
      IF Player = 1
         THEN
            Player := Succ(Player)           { Increment Player1 To Player 2 }
         ELSE
            Player := 1;
      ShowChars;                             { Call To ShowChars Procedure }
      CheckWin;                              { Call To CheckWin Procedure  }
      IF Win = True
         THEN
            BEGIN
               GotoXY (20,25);
               Write ('Winner !!');
            END;
   UNTIL Player = 3;
END;

{ Main Body Of Program }

BEGIN
   ClrScr;                   { Clear The Screen                 }
   ClearArray;               { Call To the ClearArray Procedure }
   Display;                  { Call To the Display Procedure    }
   GetSymbolsAndCoords;      { Call To GetSymbols Procedure     }
END.
