/* Combine.c */
/* copyright (c) 1995 by Tom Proudfoot */
/*
 *
 *  This program combines two nethack score files.
 *  One file must be called 'RECORD' (the default name),
 *  and the other must be called 'RECORD.2'.
 *  Both must be in the current directory. The results are
 *  written to a file called 'RECORD.ALL'.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void combine_files();
void sort_file();
void delete_duplicates();
void error(const char *error_message);


char read_string[200][256];

main()
{
  combine_files();
  sort_file();
  delete_duplicates();
  return 0;
}


void combine_files()
{
   FILE *fp_1;
   FILE *fp_2;
   FILE *fp_all;
   char buffer_1[256];
   char buffer_2[256];
   char buffer_all[256];
   char s[129];
   fp_1 = fopen("record", "r");
   if (!fp_1) error("Reading RECORD file.");
   fp_2 = fopen("record.2", "r");
   if (!fp_2) error("Reading RECORD.2 file.");
   fp_all = fopen("record.$$$", "w");
   if (!fp_all) error("Creating RECORD.$$$ file.");
   while ((fgets(buffer_1, 255, fp_1) != NULL) && (fgets(buffer_2, 255, fp_2) != NULL))
   {
	fputs(buffer_1, fp_all);
	fputs(buffer_2, fp_all);
   }
   fclose(fp_1);
   fclose(fp_2);
   fclose(fp_all);
}

int score(const char *score_line)
{
   int space_count;
   int num_length;
   int score_spot;
   char score_char;
   char num_string[12];
   int score_int;

   space_count = 0;
   score_spot = 0;
   while (space_count < 7)
   {
     score_char = score_line[score_spot];
     score_spot++;
     if (score_char == ' ') space_count++;
   }
   while (space_count == 7);
   {
     score_char = score_line[score_spot];
     sprintf(num_string, '%s',score_char);
     score_spot++;
     if (score_char == ' ') space_count++;
   }
   strtol(num_string, score_int);
   return score_int;
}

void sort_file()
{
   int read_loop;
   FILE *fp_all;
/* score is after 7 spaces */
   for (read_loop = 0; read_loop < 200; read_loop++)
      fgets(read_string, 255, fp_all);

}

void delete_duplicates()
{
}

void error(const char *error_message)
{
   printf("\n\nError -- %s", error_message);
   exit(1);
}