/*      SCCS Id: @(#)monst.c    3.1     93/05/26                  */
/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1985. */
/* NetHack may be freely redistributed.  See license for details. */

#include "config.h"
#include "permonst.h"
#include "monsym.h"
#include "eshk.h"
#include "vault.h"
#include "epri.h"

#ifdef MUSE
#define MARM(x,y) x /* x is usually 10 */
#else
#define MARM(x,y) y
#endif

#define NO_ATTK         { 0, 0, 0, 0 }

#define WT_ELF          800
#define WT_DRAGON       4500

#ifdef C
#undef C
#endif
#ifdef TEXTCOLOR
#include "color.h"
#define C(color)        color
#define HI_DOMESTIC     WHITE           /* use for player + friendlies */
#define HI_LORD         MAGENTA
#else
#define C(color)
#endif

void NDECL(monst_init);
/*
 *      Entry Format:           (from permonst.h)
 *
 *      name, symbol (S_* defines),
 *      difficulty level, move rate, armor class, magic resistance,
 *      alignment, creation/geno flags (G_* defines),
 *      6 * attack structs ( type , damage-type, # dice, # sides ),
 *      weight (WT_* defines), nutritional value, extension length,
 *      sounds made (MS_* defines), physical size (MZ_* defines),
 *      resistances, resistances conferred (both MR_* defines),
 *      3 * flag bitmaps (M1_*, M2_*, and M3_* defines respectively)
 *      symbol color (C(x) macro)
 */

#ifndef SPLITMON_2
NEARDATA struct permonst playermon = {          /* used by weapons bonus code */
	"player", S_HUMAN, 1, 10, 10, 0, 0, G_GENO | G_NOGEN,
	{ { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	  NO_ATTK, NO_ATTK, NO_ATTK },
	WT_HUMAN, 400, PL_NSIZ, MS_HUMANOID, MZ_HUMAN, 0, 0,
	M1_NEEDPICK | M1_HUMANOID | M1_OMNIVORE,
	M2_HUMAN | M2_STRONG | M2_COLLECT, 0, C(HI_DOMESTIC)
},      *uasmon = &playermon;
#endif /* SPLITMON_2 */

/*
 *      Rule #1:        monsters of a given class are contiguous in the
 *                      mons[] array.
 *
 *      Rule #2:        monsters of a given class are presented in ascending
 *                      order of strength.
 *
 *      Rule #3:        monster frequency is included in the geno mask;
 *                      the frequency can be from 0 to 7.  0's will also
 *                      be skipped during generation.
 *
 *      Rule #4:        monster subclasses (e.g. giants) should be kept
 *                      together, unless it violates Rule 2.  NOGEN monsters
 *                      won't violate Rule 2.
 *
 * Guidelines for color assignment:
 *
 *      * Use the same color for all `growth stages' of a monster (ex.
 *        little dog/big dog, baby naga/full-grown naga.
 *
 *      * Use colors given in names wherever possible. If the class has `real'
 *        members with strong color associations, use those.
 *
 *      * Favor `cool' colors for cold-resistent monsters, `warm' ones for
 *        fire-resistent ones.
 *
 *      * Try to reserve purple (magenta) for powerful `ruler' monsters (queen
 *        bee, kobold lord, &c.).
 *
 *      * Subject to all these constraints, try to use color to make as many
 *        distinctions as the / command (that is, within a monster letter
 *        distinct names should map to distinct colors).
 *
 * The aim in assigning colors is to be consistent enough so a player can
 * become `intuitive' about them, deducing some or all of these rules
 * unconsciously. Use your common sense.
 */

/* [Tom] I increased frequencies of all the "old" monsters, so the new ones
 *  are all that much more rare and special */

/* [Tom] I made many monsters NOHELL -- mostly natural animals and stuff */

#ifndef SPLITMON_2
NEARDATA struct permonst mons[] = {
/*      ants    */
	{ "giant ant",  S_ANT, 2, 18, 3, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 4),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_TINY, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "killer bee", S_ANT, 1, 18, -1, 0, 0, (G_NOHELL | G_GENO | G_LGROUP | 3),
	  { { AT_STNG, AD_DRST, 1, 3 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 5, 0, MS_BUZZ, MZ_TINY, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_FLY | M1_NOHANDS | M1_POIS, M2_HOSTILE | M2_FEMALE,
	  0, C(YELLOW) },
	{ "soldier ant", S_ANT, 3, 18, 3, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 3),
	  { { AT_BITE, AD_PHYS, 2, 4 }, { AT_STNG, AD_DRST, 3, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 5, 0, MS_SILENT, MZ_TINY, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_POIS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BLUE) },
	{ "fire ant", S_ANT, 3, 18, 3, 10, 0, (G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 2, 4 }, { AT_BITE, AD_FIRE, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 10, 0, MS_SILENT, MZ_TINY, MR_FIRE, MR_FIRE,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(RED) },
	{ "snow ant", S_ANT, 3, 18, 3, 10, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 2, 4 }, { AT_BITE, AD_COLD, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 10, 0, MS_SILENT, MZ_TINY, MR_COLD, MR_COLD,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(CYAN) },
	{ "giant beetle", S_ANT, 5, 6, 4, 0, 0, (G_NOHELL | G_GENO | 4),
	  { { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_POIS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BLACK) },
	{ "yellow jacket", S_ANT, 5, 15, 2, 0, 0, (G_NOHELL | G_GENO | G_LGROUP | 1),
	  { { AT_STNG, AD_DRST, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 10, 0, MS_BUZZ, MZ_SMALL, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_FLY | M1_NOHANDS | M1_POIS, M2_HOSTILE | M2_FEMALE,
	  0, C(YELLOW) },
	{ "tsetse fly", S_ANT, 1, 15, 0, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_STNG, AD_SLEE, 1, 3 }, { AT_STNG, AD_PHYS, 1, 3 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 5, 0, MS_BUZZ, MZ_TINY, MR_POISON | MR_SLEEP, MR_POISON | MR_SLEEP,
	  M1_ANIMAL | M1_FLY | M1_NOHANDS | M1_POIS, M2_HOSTILE,
	  0, C(GREEN) },
	{ "queen bee", S_ANT, 9, 24, -4, 0, 0, (G_NOHELL | G_GENO | G_NOGEN),
	  { { AT_STNG, AD_DRST, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 5, 0, MS_BUZZ, MZ_TINY, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_FLY | M1_NOHANDS | M1_POIS,
	  M2_HOSTILE | M2_FEMALE | M2_PRINCE, 0, C(HI_LORD) },
	{ "giant wasp", S_ANT, 9, 15, 2, 0, 0, (G_NOHELL | G_GENO | G_LGROUP | 1),
	  { { AT_STNG, AD_DRST, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 100, 0, MS_BUZZ, MZ_MEDIUM, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_FLY | M1_NOHANDS | M1_POIS, M2_HOSTILE | M2_FEMALE,
	  0, C(YELLOW) },
	{ "black wasp", S_ANT, 12, 15, 2, 0, 0, (G_NOHELL | G_GENO | G_LGROUP | 1),
	  { { AT_STNG, AD_DRST, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 100, 0, MS_BUZZ, MZ_MEDIUM, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_FLY | M1_NOHANDS | M1_POIS, M2_HOSTILE | M2_FEMALE,
	  0, C(BLACK) },
	{ "army ant", S_ANT, 6, 18, 3, 10, 0, (G_NOHELL | G_GENO | G_LGROUP | 1),
	  { { AT_BITE, AD_DRST, 2, 4 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 10, 0, MS_SILENT, MZ_TINY, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(RED) },
	{ "spitting beetle", S_ANT, 14, 6, -4, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 4, 6 }, { AT_SPIT, AD_ACID, 2, 6 },
	      NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_SILENT, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_POIS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "assassin bug", S_ANT, 6, 24, 4, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_DRST, 4, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_SILENT, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_POIS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BLACK) },
	{ "killer beetle", S_ANT, 19, 6, -4, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 6, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_SILENT, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_POIS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(ORANGE_COLORED) },
/*      blobs   */
	{ "acid blob", S_BLOB, 1, 3, 8, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_NONE, AD_ACID, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 10, 0, MS_SILENT, MZ_TINY,
	  MR_SLEEP | MR_POISON | MR_ACID | MR_STONE, MR_SLEEP | MR_STONE,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_ACID, M2_WANDER | M2_NEUTER, 0, C(GREEN) },
	{ "quivering blob", S_BLOB, 5, 1, 8, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_TUCH, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 100, 0, MS_SILENT, MZ_SMALL,
	  MR_SLEEP | MR_POISON, MR_POISON,
	  M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_WANDER | M2_HOSTILE | M2_NEUTER, 0, C(WHITE) },
	{ "gelatinous cube", S_BLOB, 6, 6, 8, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_TUCH, AD_PLYS, 2, 4 }, { AT_NONE, AD_PLYS, 1, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 150, 0, MS_SILENT, MZ_LARGE,
	  MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_ACID |
	  MR_STONE | MR_HITASONE, MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP,
	  M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS | M1_OMNIVORE |
	  M1_ACID, M2_WANDER | M2_HOSTILE | M2_NEUTER,
	  0, C(CYAN) },
	{ "jiggling blob", S_BLOB, 10, 6, 8, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_TUCH, AD_PHYS, 2, 8 }, { AT_NONE, AD_ACID, 2, 4 },
	      NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 100, 0, MS_SILENT, MZ_LARGE,
	  MR_SLEEP | MR_POISON, MR_POISON,
	  M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_WANDER | M2_HOSTILE | M2_NEUTER, 0, C(MAGENTA) },
	{ "lava blob", S_BLOB, 10, 6, 8, 0, 0, (G_GENO | 1),
	  { { AT_TUCH, AD_FIRE, 4, 4 }, { AT_NONE, AD_FIRE, 2, 6 },
	      NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 100, 0, MS_SILENT, MZ_LARGE,
	  MR_SLEEP | MR_FIRE, MR_FIRE,
	  M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_WANDER | M2_HOSTILE | M2_NEUTER, 0, C(RED) },
	{ "crackling blob", S_BLOB, 12, 6, 8, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_TUCH, AD_ELEC, 3, 8 }, { AT_NONE, AD_ELEC, 3, 4 },
	      NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 100, 0, MS_SILENT, MZ_LARGE,
	  MR_SLEEP | MR_POISON | MR_ELEC, MR_POISON | MR_ELEC,
	  M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_WANDER | M2_HOSTILE | M2_NEUTER, 0, C(HI_ZAP) },
	{ "burbling blob", S_BLOB, 14, 6, 8, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_TUCH, AD_PHYS, 2, 8 }, { AT_NONE, AD_ACID, 5, 4 },
	      NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 100, 0, MS_SILENT, MZ_LARGE,
	  MR_SLEEP | MR_POISON, MR_POISON,
	  M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_WANDER | M2_HOSTILE | M2_NEUTER, 0, C(BLACK) },
/*      cockatrice      */
	{ "cockatrice", S_COCKATRICE, 5, 6, 6, 30, 0, (G_GENO | 6),
	  { { AT_BITE, AD_PHYS, 1, 3 }, { AT_TUCH, AD_STON, 0, 0 },
	    { AT_NONE, AD_STON, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_HISS, MZ_SMALL,
	  MR_POISON | MR_STONE | MR_HITASTWO, MR_POISON | MR_STONE,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS, M2_HOSTILE, 0, C(YELLOW) },
	{ "chickatrice", S_COCKATRICE, 3, 6, 6, 30, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 3 }, { AT_TUCH, AD_STON, 0, 0 },
	    { AT_NONE, AD_STON, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_HISS, MZ_TINY,
	  MR_POISON | MR_STONE, MR_POISON | MR_STONE,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS, M2_HOSTILE, 0, C(BROWN) },
	{ "pyrolisk", S_COCKATRICE, 6, 6, 6, 30, 0, (G_GENO | 1),
	  { { AT_GAZE, AD_FIRE, 2, 6 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK }, 30, 30, 0,
	  MS_HISS, MZ_SMALL,
	  MR_POISON | MR_FIRE | MR_HITASTWO, MR_POISON | MR_FIRE,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS, M2_HOSTILE, 0, C(RED) },
/*      dogs and other canines  */
	{ "jackal", S_DOG, 0, 12, 7, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 4),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 250, 0, MS_BARK, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(BROWN) },
	{ "dingo", S_DOG, 0, 12, 7, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 250, 0, MS_BARK, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(YELLOW) },
	{ "fox", S_DOG, 0, 15, 7, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 250, 0, MS_BARK, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(RED) },
	{ "coyote", S_DOG, 1, 12, 7, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 250, 0, MS_BARK, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(BROWN) },
	{ "werejackal", S_DOG, 2, 12, 7, 10, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 250, 0, MS_BARK, MZ_SMALL, MR_POISON | MR_HITASONE, 0,
	  M1_NOHANDS | M1_POIS | M1_REGEN | M1_CARNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE, 0, C(BROWN) },
	{ "little dog", S_DOG, 2, 18, 6, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  150, 150, 0, MS_BARK, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_DOMESTIC, 0, C(HI_DOMESTIC) },
	{ "dog", S_DOG, 4, 16, 5, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1 ,6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 200, 0, MS_BARK, MZ_MEDIUM, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_DOMESTIC, 0, C(HI_DOMESTIC) },
	{ "large dog", S_DOG, 6, 15, 4, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  800, 250, 0, MS_BARK, MZ_MEDIUM, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_STRONG | M2_DOMESTIC,
	  0, C(HI_DOMESTIC) },
	{ "pit bull", S_DOG, 11, 15, 4, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 4, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  800, 250, 0, MS_BARK, MZ_MEDIUM, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_STRONG | M2_DOMESTIC,
	  0, C(HI_DOMESTIC) },
	{ "wolf", S_DOG, 4, 12, 4, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 3),
	  { { AT_BITE, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 250, 0, MS_BARK, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(BROWN) },
	{ "death dog", S_DOG, 2, 12, 7, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 10 }, { AT_BITE, AD_PHYS, 1, 10 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 250, 0, MS_BARK, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(BLACK) },
	{ "rabid wolf", S_DOG, 6, 12, 4, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_DRCO, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 250, 0, MS_BARK, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(BROWN) },
	{ "werewolf", S_DOG, 10, 12, 4, 20, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 250, 0, MS_BARK, MZ_MEDIUM, MR_POISON | MR_HITASTWO, 0,
	  M1_NOHANDS | M1_POIS | M1_REGEN | M1_CARNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE, 0, C(BROWN) },
	{ "warg", S_DOG, 7, 12, 4, 0, -5, (G_NOHELL | G_GENO | G_SGROUP | 3),
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  850, 350, 0, MS_BARK, MZ_MEDIUM, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "hyena", S_DOG, 7, 12, 4, 0, -5, (G_NOHELL | G_GENO | G_LGROUP | 1),
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  850, 350, 0, MS_BARK, MZ_MEDIUM, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(YELLOW) },
	{ "winter wolf", S_DOG, 7, 12, 4, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_BREA, AD_COLD, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  700, 300, 0, MS_BARK, MZ_LARGE, MR_COLD, MR_COLD,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(CYAN) },
	{ "hell hound pup", S_DOG, 7, 12, 4, 20, -5,
	  (G_HELL | G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_BREA, AD_FIRE, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 200, 0, MS_BARK, MZ_SMALL,
	  MR_FIRE | MR_HITASONE, MR_FIRE, M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(RED) },
	{ "wolverine", S_DOG, 9, 15, 4, 0, -8, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 4, 6 }, { AT_CLAW, AD_PHYS, 2, 6 },
	      NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  850, 350, 0, MS_BARK, MZ_MEDIUM, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(GRAY) },
	{ "shadow wolf", S_DOG, 11, 15, 4, 0, -8, (G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_COLD, 4, 6 }, { AT_BITE, AD_PHYS, 2, 6 },
	      NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  850, 350, 0, MS_BARK, MZ_MEDIUM, MR_PLUSONE | MR_HITASTWO, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BLACK) },
	{ "mist wolf", S_DOG, 12, 18, 4, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_COLD, 4, 6 }, { AT_BITE, AD_PHYS, 2, 6 },
	      NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  850, 350, 0, MS_BARK, MZ_MEDIUM, MR_PLUSONE | MR_HITASTWO, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(GREEN) },
	{ "hell hound", S_DOG, 12, 14, 2, 20, 0, (G_HELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 3, 6 }, { AT_BREA, AD_FIRE, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_BARK, MZ_MEDIUM,
	  MR_FIRE | MR_HITASONE, MR_FIRE, M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(RED) },
	{ "Cerberus", S_DOG, 12, 10, 2, 20, -7, (G_HELL | G_UNIQ | 1),
	  { { AT_BITE, AD_PHYS, 3, 6 }, { AT_BITE, AD_PHYS, 3, 6 },
	    { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1000, 350, 0, MS_BARK, MZ_LARGE, MR_FIRE | MR_PLUSTWO | MR_HITASFOUR, MR_FIRE,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_NOPOLY | M2_HOSTILE | M2_STRONG | M2_PNAME | M2_MALE, 0,
	  C(HI_LORD) },
/*      eyes    */
	{ "floating eye", S_EYE, 2, 1, 9, 10, 0, (G_NOHELL | G_GENO | 6),
	  { { AT_NONE, AD_PLYS, 0, 70 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_FLY | M1_AMPHIBIOUS | M1_NOLIMBS | M1_NOHEAD,
	  M2_HOSTILE | M2_NEUTER, 0, C(BLUE) },
	{ "glowing eye", S_EYE, 5, 3, 4, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_GAZE, AD_BLND, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_FLY | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_HOSTILE | M2_NEUTER, 0, C(YELLOW) },
	{ "freezing sphere", S_EYE, 6, 13, 4, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_EXPL, AD_COLD, 4, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_SMALL, MR_COLD | MR_HITASTWO, MR_COLD,
	  M1_FLY | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_HOSTILE | M2_NEUTER, 0, C(WHITE) },
	{ "flaming sphere", S_EYE, 6, 13, 4, 0, 0, (G_GENO | 1),
	  { { AT_EXPL, AD_FIRE, 4, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_SMALL, MR_FIRE, MR_FIRE,
	  M1_FLY | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_HOSTILE | M2_NEUTER, 0, C(RED) },
	{ "shocking sphere", S_EYE, 6, 13, 4, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_EXPL, AD_ELEC, 4, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_SMALL, MR_ELEC, MR_ELEC,
	  M1_FLY | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_HOSTILE | M2_NEUTER, 0, C(HI_ZAP) },
	{ "bloodshot eye", S_EYE, 6, 3, 4, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_GAZE, AD_STUN, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_FLY | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_HOSTILE | M2_NEUTER, 0, C(RED) },
	{ "blinking eye", S_EYE, 8, 12, 4, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_GAZE, AD_TLPT, 0, 0 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_FLY | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS | M1_TPORT,
	  M2_HOSTILE | M2_NEUTER, 0, C(CYAN) },
	{ "beholder", S_EYE, 15, 9, 4, 50, 0, (G_GENO | G_UNIQ | G_NOGEN),
	  { { AT_GAZE, AD_DETH, 1, 4 }, { AT_GAZE, AD_PHYS, 3, 8 },
	    { AT_GAZE, AD_STUN, 1, 3 }, { AT_GAZE, AD_CONF, 1, 3 },
	    { AT_GAZE, AD_SLEE, 1, 4 },
	    NO_ATTK },
	  100, 100, 0, MS_SILENT, MZ_HUMAN, 0, 0,
	  M1_FLY | M1_NOLIMBS | M1_NOHEAD, M2_HOSTILE | M2_NOPOLY | M2_NEUTER | M2_NASTY, 0, C(GRAY) },
	{ "gas spore", S_EYE, 1, 3, 10, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BOOM, AD_PHYS, 4, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_FLY | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_HOSTILE | M2_NEUTER, 0, C(GRAY) },
/*      felines         */
	{ "kitten", S_FELINE, 2, 18, 6, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  150, 150, 0, MS_MEW, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_WANDER | M2_DOMESTIC, 0, C(HI_DOMESTIC) },
	{ "housecat", S_FELINE, 4, 16, 5, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 200, 0, MS_MEW, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_DOMESTIC, 0, C(HI_DOMESTIC) },
	{ "jaguar", S_FELINE, 4, 15, 6, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_GROWL, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "lynx", S_FELINE, 5, 15, 6, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_COLD, 1, 4 }, { AT_CLAW, AD_COLD, 1, 4 },
	    { AT_BITE, AD_PHYS, 1, 10 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_GROWL, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(CYAN) },
	{ "panther", S_FELINE, 5, 15, 6, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_BITE, AD_PHYS, 1, 10 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_GROWL, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BLACK) },
	{ "werepanther", S_FELINE, 5, 15, 6, 20, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 1, 10 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_CLAW, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_GROWL, MZ_LARGE, MR_POISON, 0,
	  M1_NOHANDS | M1_POIS | M1_REGEN | M1_CARNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE, 0, C(BLACK) },
	{ "large cat", S_FELINE, 6, 15, 4, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  250, 250, 0, MS_MEW, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_STRONG | M2_DOMESTIC, 0, C(HI_DOMESTIC) },
	{ "caterwaul", S_FELINE, 4, 24, 4, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 100, 0, MS_GROWL, MZ_HUMAN, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(GRAY) },
	{ "tiger", S_FELINE, 6, 12, 6, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    { AT_BITE, AD_PHYS, 1, 10 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_GROWL, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(YELLOW) },
	{ "weretiger", S_FELINE, 7, 12, 6, 20, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 2, 6 }, { AT_CLAW, AD_PHYS, 2, 5 },
	    { AT_CLAW, AD_PHYS, 2, 5}, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_GROWL, MZ_LARGE, MR_POISON, 0,
	  M1_NOHANDS | M1_POIS | M1_REGEN | M1_CARNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE, 0, C(YELLOW) },
	{ "sabre-toothed cat", S_FELINE, 9, 12, 6, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 4, 4 }, { AT_CLAW, AD_PHYS, 4, 4 },
	    { AT_BITE, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  800, 400, 0, MS_GROWL, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(YELLOW) },
	{ "kamadan", S_FELINE, 4, 12, 4, 0, -3, (G_NOHELL | G_GENO | 1),
	  { { AT_BREA, AD_SLEE, 1, 6 }, { AT_BITE, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 3 }, {AT_BITE, AD_PHYS, 1, 3}, NO_ATTK, NO_ATTK },
	  750, 400, 0, MS_GROWL, MZ_LARGE, MR_SLEEP, MR_SLEEP,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(ORANGE_COLORED) },
	{ "displacer beast", S_FELINE, 12, 12, -10, 0, -3, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 4, 4 }, { AT_CLAW, AD_PHYS, 4, 4 },
	    { AT_BITE, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  750, 400, 0, MS_GROWL, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BLUE) },
	{ "hellcat", S_FELINE, 12, 12, 6, 0, 0, (G_HELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 4, 4 }, { AT_CLAW, AD_PHYS, 4, 4 },
	    { AT_BITE, AD_FIRE, 3, 10 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  800, 400, 0, MS_GROWL, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(RED) },
/*      gremlins        */
	{ "gremlin", S_GREMLIN, 5, 12, 2, 25, -9, (G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_BITE, AD_PHYS, 1, 4 }, { AT_CLAW, AD_CURS, 0, 0 },
	    NO_ATTK, NO_ATTK },
	  100, 20, 0, MS_LAUGH, MZ_SMALL, MR_POISON, 0,
	  M1_SWIM | M1_HUMANOID | M1_POIS, M2_STALK, 0, C(GREEN) },
	{ "galltrit", S_GREMLIN, 3, 18, 2, 25, -9, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_BITE, AD_PHYS, 1, 4 }, { AT_CLAW, AD_CURS, 0, 0 },
	    NO_ATTK, NO_ATTK },
	  100, 20, 0, MS_LAUGH, MZ_SMALL, MR_POISON, 0,
	  M1_SWIM | M1_HUMANOID | M1_POIS, M2_STALK, 0, C(BLACK) },
	{ "jermlaine", S_GREMLIN, 0, 15, 7, 0, -9, (G_NOHELL | G_GENO | G_VLGROUP | 1),
	  { { AT_CLAW, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK },
	  100, 20, 0, MS_LAUGH, MZ_SMALL, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS, M2_STALK, 0, C(GRAY) },
/*      humanoids       */
	{ "hobbit", S_HUMANOID, 1, 9, MARM(10,7), 0, 6, (G_NOHELL | G_GENO | 3),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 200, 0, MS_HUMANOID, MZ_SMALL, 0, 0,
	  M1_HUMANOID, M2_COLLECT, 0, C(GREEN) },
	{ "dwarf", S_HUMANOID,  2, 6, MARM(10,4), 10, 4, (G_NOHELL | G_GENO | 4),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  900, 300, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_TUNNEL | M1_NEEDPICK | M1_HUMANOID,
	  M2_DWARF | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(RED) },
	{ "dwarf thief", S_HUMANOID,  2, 6, MARM(10,4), 10, 4, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, { AT_TUCH, AD_SITM, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  900, 300, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_TUNNEL | M1_NEEDPICK | M1_HUMANOID,
	  M2_DWARF | M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(BLACK) },
	{ "bugbear", S_HUMANOID, 3, 9, 5, 0, -6, (G_NOHELL | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1250, 250, 0, MS_GROWL, MZ_LARGE, 0, 0,
	  M1_HUMANOID, M2_STRONG | M2_COLLECT, 0, C(BROWN) },
	{ "gnoll", S_HUMANOID, 2, 9, 6, 0, -6, (G_NOHELL | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  900, 300, 0, MS_GROWL, MZ_LARGE, 0, 0,
	  M1_HUMANOID, M2_STRONG | M2_COLLECT, 0, C(YELLOW) },
	{ "dwarf lord", S_HUMANOID,  4, 6, MARM(10,4), 10, 5, (G_NOHELL | G_GENO | 3),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  900, 300, 0, MS_HUMANOID, MZ_HUMAN,
	  MR_HITASONE, 0, M1_TUNNEL | M1_NEEDPICK | M1_HUMANOID,
	  M2_DWARF | M2_STRONG | M2_LORD | M2_MALE | M2_GREEDY | M2_JEWELS |
	  M2_COLLECT, 0, C(BLUE) },
	{ "dwarf king", S_HUMANOID,  6, 6, MARM(10,4), 20, 6, (G_NOHELL | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, { AT_WEAP, AD_PHYS, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  900, 300, 0, MS_HUMANOID, MZ_HUMAN,
	  MR_HITASTWO, 0, M1_TUNNEL | M1_NEEDPICK | M1_HUMANOID,
	  M2_DWARF | M2_STRONG | M2_PRINCE | M2_MALE | M2_GREEDY | M2_JEWELS |
	  M2_COLLECT, 0, C(HI_LORD) },
	{ "duergar", S_HUMANOID,  4, 6, MARM(10,2), 10, 5, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  900, 300, 0, MS_HUMANOID, MZ_HUMAN,
	  MR_HITASONE, 0, M1_TUNNEL | M1_NEEDPICK | M1_HUMANOID,
	  M2_DWARF | M2_STRONG | M2_MALE | M2_GREEDY | M2_JEWELS |
	  M2_COLLECT, 0, C(GRAY) },
	{ "mind flayer", S_HUMANOID, 9, 12, 5, 90, -8, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, { AT_TENT, AD_DRIN, 2, 1 },
	    { AT_TENT, AD_DRIN, 2, 1 }, { AT_TENT, AD_DRIN, 2, 1 },
	    { AT_TENT, AD_DRIN, 2, 1 }, NO_ATTK },
	  1450, 400, 0, MS_HISS, MZ_HUMAN,
	  MR_HITASTWO, 0, M1_HUMANOID | M1_FLY | M1_SEE_INVIS | M1_OMNIVORE,
	  M2_HOSTILE | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(MAGENTA) },
	{ "master mind flayer", S_HUMANOID, 13, 12, 0, 90, -8, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, { AT_TENT, AD_DRIN, 2, 1 },
	    { AT_TENT, AD_DRIN, 2, 1 }, { AT_TENT, AD_DRIN, 2, 1 },
	    { AT_TENT, AD_DRIN, 2, 1 }, NO_ATTK },
	  1450, 400, 0, MS_HISS, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_FLY | M1_SEE_INVIS | M1_OMNIVORE,
	  M2_HOSTILE | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(MAGENTA) },
/*      imps & other minor demons/devils */
	{ "manes", S_IMP, 1, 3, 7, 0, -7, (G_GENO | G_LGROUP | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_SILENT, MZ_SMALL,
	  MR_SLEEP | MR_POISON | MR_HITASONE, 0, M1_POIS, M2_HOSTILE | M2_STALK, 0, C(RED) },
	{ "homunculus", S_IMP, 2, 12, 6, 10, -7, (G_GENO | 3),
	  { { AT_BITE, AD_SLEE, 1, 3 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 100, 0, MS_SILENT, MZ_TINY,
	  MR_SLEEP | MR_POISON | MR_HITASONE, MR_SLEEP | MR_POISON,
	  M1_FLY | M1_POIS, M2_STALK, 0, C(GREEN) },
	{ "dretch", S_IMP, 2, 12, 2, 20, -7, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 10, 0, MS_CUSS, MZ_TINY, 0, 0,
	  M1_REGEN, M2_WANDER | M2_STALK, 0, C(YELLOW) },
	{ "imp", S_IMP, 3, 12, 2, 20, -7, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 10, 0, MS_CUSS, MZ_TINY, 0, 0,
	  M1_REGEN, M2_WANDER | M2_STALK, 0, C(RED) },
	{ "lemure", S_IMP, 3, 3, 7, 0, -7,
	  (G_HELL | G_GENO | G_LGROUP | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  150, 100, 0, MS_SILENT, MZ_MEDIUM, MR_SLEEP | MR_POISON
	  | MR_PLUSONE | MR_HITASONE, MR_SLEEP, M1_POIS | M1_REGEN, M2_HOSTILE |
	  M2_WANDER | M2_STALK | M2_NEUTER, 0, C(BROWN) },
	{ "larva", S_IMP, 1, 6, 9, 0, -7,
	  (G_HELL | G_GENO | G_VLGROUP | G_NOCORPSE | 4),
	  { { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  150, 100, 0, MS_SILENT, MZ_MEDIUM, MR_SLEEP | MR_POISON,
	  MR_SLEEP, M1_POIS | M1_REGEN, M2_HOSTILE |
	  M2_WANDER | M2_STALK | M2_NEUTER, 0, C(WHITE) },
	{ "quasit", S_IMP, 3, 15, 2, 20, -7, (G_GENO | 3),
	  { { AT_CLAW, AD_DRDX, 1, 2 }, { AT_CLAW, AD_DRDX, 1, 2 },
	    { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 200, 0, MS_SILENT, MZ_SMALL, MR_POISON | MR_PLUSONE, MR_POISON,
	  M1_REGEN, M2_STALK, 0, C(BLUE) },
	{ "rutterkin", S_IMP, 5, 12, 2, 20, -7, (G_GENO | 1),
	  { { AT_CLAW, AD_DRST, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 10, 0, MS_CUSS, MZ_TINY, 0, 0,
	  M1_REGEN, M2_WANDER | M2_STALK, 0, C(ORANGE_COLORED) },
	{ "tengu", S_IMP, 6, 13, 5, 30, 7, (G_GENO | 4),
	  { { AT_BITE, AD_PHYS, 1, 7 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 200, 0, MS_SQAWK, MZ_SMALL, MR_POISON | MR_HITASONE, MR_POISON,
	  M1_TPORT | M1_TPORT_CNTRL, M2_STALK, 0, C(CYAN) },
	{ "nupperibo", S_IMP, 7, 12, 0, 20, -7, (G_GENO | 1),
	  { { AT_CLAW, AD_DRST, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 10, 0, MS_CUSS, MZ_TINY, 0, 0,
	  M1_REGEN, M2_WANDER | M2_STALK, 0, C(GREEN) },
	{ "blood imp", S_IMP, 9, 12, 0, 60, -7, (G_GENO | 1),
	  { { AT_CLAW, AD_DRST, 3, 4 }, { AT_BITE, AD_PHYS, 3, 4 },
	     NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 10, 0, MS_CUSS, MZ_TINY, 0, 0,
	  M1_REGEN, M2_WANDER | M2_STALK, 0, C(BLACK) },
/*      jellies         */
	{ "blue jelly", S_JELLY, 4, 0, 8, 10, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_NONE, AD_COLD, 0, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 20, 0, MS_SILENT, MZ_MEDIUM,
	  MR_COLD | MR_POISON, MR_COLD | MR_POISON,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_OMNIVORE, M2_HOSTILE | M2_NEUTER, 0, C(BLUE) },
	{ "spotted jelly", S_JELLY, 5, 0, 8, 10, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_NONE, AD_ACID, 0, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 20, 0, MS_SILENT, MZ_MEDIUM, MR_ACID | MR_STONE, 0,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_ACID | M1_OMNIVORE, M2_HOSTILE | M2_NEUTER,
	  0, C(GREEN) },
	{ "clear jelly", S_JELLY, 6, 3, 8, 10, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_TUCH, AD_ACID, 3, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 20, 0, MS_SILENT, MZ_MEDIUM,
	  MR_COLD | MR_POISON, MR_COLD | MR_POISON,
	  M1_BREATHLESS | M1_CLING | M1_HIDE | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_OMNIVORE, M2_HOSTILE | M2_NEUTER, 0, C(CYAN) },
	{ "ochre jelly", S_JELLY, 6, 3, 8, 20, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_ENGL, AD_ACID, 3, 6 }, { AT_NONE, AD_ACID, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 20, 0, MS_SILENT, MZ_MEDIUM, MR_ACID | MR_STONE, 0,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_ACID | M1_OMNIVORE, M2_HOSTILE | M2_NEUTER,
	  0, C(BROWN) },
	{ "red jelly", S_JELLY, 8, 5, 8, 20, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_ENGL, AD_ACID, 3, 6 }, { AT_NONE, AD_STUN, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  250, 220, 0, MS_SILENT, MZ_MEDIUM, MR_ACID | MR_STONE, 0,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_ACID | M1_OMNIVORE, M2_HOSTILE | M2_NEUTER,
	  0, C(RED) },
	{ "orange jelly", S_JELLY, 8, 5, 8, 20, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_ENGL, AD_ACID, 2, 8 }, { AT_NONE, AD_SLEE, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  250, 220, 0, MS_SILENT, MZ_MEDIUM, MR_ACID | MR_STONE, 0,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_ACID | M1_OMNIVORE, M2_HOSTILE | M2_NEUTER,
	  0, C(ORANGE_COLORED) },
	{ "black jelly", S_JELLY, 12, 5, 8, 20, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_ENGL, AD_ACID, 4, 6 }, { AT_NONE, AD_ACID, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  250, 220, 0, MS_SILENT, MZ_MEDIUM, MR_ACID | MR_STONE, 0,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_ACID | M1_OMNIVORE, M2_HOSTILE | M2_NEUTER,
	  0, C(BLACK) },
/*      kobolds         */
	{ "kobold", S_KOBOLD,  0, 6, MARM(10,7), 0, -2, (G_NOHELL | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 100, 0, MS_ORC, MZ_SMALL, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS, M2_HOSTILE | M2_COLLECT, 0, C(BROWN) },
	{ "large kobold", S_KOBOLD,  1, 6, MARM(10,6), 0, -3, (G_NOHELL | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  450, 150, 0, MS_ORC, MZ_SMALL, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS, M2_HOSTILE | M2_COLLECT, 0, C(RED) },
	{ "kobold lord", S_KOBOLD,  2, 6, MARM(10,5), 0, -4, (G_NOHELL | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 200, 0, MS_ORC, MZ_SMALL, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS,
	  M2_HOSTILE | M2_LORD | M2_MALE | M2_COLLECT, 0, C(HI_LORD) },
	{ "kobold shaman", S_KOBOLD, 1, 6, 6, 10, -4, (G_NOHELL | G_GENO | 2),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  450, 150, 0, MS_ORC, MZ_SMALL, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS, M2_HOSTILE | M2_MAGIC, 0, C(HI_ZAP) },
	{ "swamp kobold", S_KOBOLD,  3, 9, MARM(10,5), 0, -3, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  450, 150, 0, MS_ORC, MZ_SMALL, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS, M2_HOSTILE | M2_COLLECT, 0, C(GREEN) },
	{ "rock kobold", S_KOBOLD,  5, 9, MARM(10,5), 0, -3, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  450, 150, 0, MS_ORC, MZ_SMALL, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS, M2_HOSTILE | M2_COLLECT, 0, C(BLACK) },
	{ "kobold wizard", S_KOBOLD, 5, 9, 6, 10, -4, (G_NOHELL | G_GENO | 1),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  450, 150, 0, MS_ORC, MZ_SMALL, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS, M2_HOSTILE | M2_MAGIC, 0, C(HI_ZAP) },
	{ "kobold warrior", S_KOBOLD,  7, 9, MARM(10,4), 0, -3, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  450, 150, 0, MS_ORC, MZ_SMALL, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS, M2_HOSTILE | M2_COLLECT, 0, C(GRAY) },
	{ "Kroo the Kobold King", S_KOBOLD, 13, 9, MARM(10,0), 0, -3, (G_UNIQ | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  450, 150, 0, MS_ORC, MZ_SMALL, MR_POISON | MR_STONE, 0,
	  M1_HUMANOID | M1_POIS,
	  M2_PNAME | M2_PRINCE | M2_MALE | M2_GREEDY | M2_STALK |
	  M2_HOSTILE | M2_NASTY | M2_NOPOLY | M2_JEWELS | M2_COLLECT |
	  M2_MAGIC, 0, C(HI_LORD) },
/*      leprechauns     */
	{ "leprechaun", S_LEPRECHAUN, 5, 15, 8, 20, 0, (G_NOHELL | G_GENO | 5),
	  { { AT_CLAW, AD_SGLD, 1, 2 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 30, 0, MS_LAUGH, MZ_TINY, MR_HITASONE, 0,
	  M1_HUMANOID | M1_TPORT, M2_HOSTILE | M2_GREEDY, 0, C(GREEN) },
	{ "leprechaun wizard", S_LEPRECHAUN, 8, 15, 6, 20, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_SGLD, 1, 2 }, { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 30, 0, MS_LAUGH, MZ_TINY, MR_HITASONE, 0,
	  M1_HUMANOID | M1_TPORT, M2_HOSTILE | M2_GREEDY | M2_MAGIC, 0, C(HI_ZAP) },
	{ "brownie", S_LEPRECHAUN, 8, 15, 3, 20, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 30, 0, MS_LAUGH, MZ_TINY, MR_HITASONE, 0,
	  M1_HUMANOID | M1_TPORT, M2_HOSTILE | M2_GREEDY | M2_MAGIC, 0, C(BROWN) },
	{ "quickling", S_LEPRECHAUN, 3, 96, 1, 20, -10, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 30, 0, MS_LAUGH, MZ_TINY, MR_HITASONE, 0,
	  M1_HUMANOID, M2_HOSTILE | M2_GREEDY | M2_NASTY, 0, C(BLUE) },
	{ "pixie", S_LEPRECHAUN, 3, 15, 3, 20, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_SITM, 1, 2 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 30, 0, MS_LAUGH, MZ_TINY, MR_HITASONE, 0,
	  M1_HUMANOID | M1_SEE_INVIS, M2_HOSTILE | M2_GREEDY, 0, C(CYAN) },
/*      mimics  */
	{ "small mimic", S_MIMIC, 7, 3, 7, 0, 0, (G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 200, 0, MS_SILENT, MZ_MEDIUM, MR_ACID, 0,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_HIDE | M1_ANIMAL |
	  M1_NOEYES | M1_NOHEAD | M1_NOLIMBS | M1_THICK_HIDE | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "large mimic", S_MIMIC, 8, 3, 7, 10, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_STCK, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 400, 0, MS_SILENT, MZ_LARGE, MR_ACID, 0,
	  M1_CLING | M1_BREATHLESS | M1_AMORPHOUS | M1_HIDE | M1_ANIMAL |
	  M1_NOEYES | M1_NOHEAD | M1_NOLIMBS | M1_THICK_HIDE | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(RED) },
	{ "giant mimic", S_MIMIC, 9, 3, 7, 20, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_STCK, 3, 6 }, { AT_CLAW, AD_STCK, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  800, 500, 0, MS_SILENT, MZ_LARGE, MR_ACID, 0,
	  M1_CLING | M1_BREATHLESS | M1_AMORPHOUS | M1_HIDE | M1_ANIMAL |
	  M1_NOEYES | M1_NOHEAD | M1_NOLIMBS | M1_THICK_HIDE | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(HI_LORD) },
/*      nymphs  */
	{ "wood nymph", S_NYMPH, 3, 12, 9, 20, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_SITM, 0, 0 }, { AT_CLAW, AD_SEDU, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_SEDUCE, MZ_HUMAN,
	  MR_HITASONE, 0, M1_HUMANOID | M1_TPORT, M2_HOSTILE | M2_FEMALE | M2_COLLECT,
	  0, C(GREEN) },
	{ "water nymph", S_NYMPH, 3, 12, 9, 20, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_SITM, 0, 0 }, { AT_CLAW, AD_SEDU, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_SEDUCE, MZ_HUMAN,
	  MR_HITASONE, 0, M1_HUMANOID | M1_TPORT | M1_SWIM,
	  M2_HOSTILE | M2_FEMALE | M2_COLLECT, 0, C(BLUE) },
	{ "mountain nymph", S_NYMPH, 3, 12, 9, 20, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_SITM, 0, 0 }, { AT_CLAW, AD_SEDU, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_SEDUCE, MZ_HUMAN,
	  MR_HITASONE, 0, M1_HUMANOID | M1_TPORT, M2_HOSTILE | M2_FEMALE | M2_COLLECT,
	  0, C(BROWN) },
	{ "Aphrodite", S_NYMPH, 10, 15, -5, 20, 0, (G_UNIQ | 1),
	  { { AT_CLAW, AD_SITM, 0, 0 }, { AT_CLAW, AD_SEDU, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_SEDUCE, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_TPORT,
	  M2_PNAME | M2_PRINCE | M2_FEMALE | M2_GREEDY | M2_STALK |
	  M2_HOSTILE | M2_NASTY | M2_NOPOLY | M2_JEWELS | M2_COLLECT |
	  M2_MAGIC, 0, C(HI_LORD) },
/*      orcs    */
	{ "goblin", S_ORC,  0, 6, MARM(10,6), 0, -3, (G_NOHELL | G_GENO | 3),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 100, 0, MS_ORC, MZ_SMALL, 0, 0,
	  M1_HUMANOID, M2_ORC | M2_COLLECT, 0, C(GRAY) },
	{ "hobgoblin", S_ORC,  1, 9, MARM(10,6), 0, -4, (G_NOHELL | G_GENO | 3),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1000, 200, 0, MS_ORC, MZ_HUMAN, 0, 0,
	  M1_HUMANOID, M2_ORC | M2_STRONG | M2_COLLECT, 0, C(BROWN) },
	/* "orc" for zombie corpses only; they don't get created at random */
	/* [Tom] they do now... */
	{ "orc", S_ORC,  1, 9, MARM(10,6), 0, -3, (G_NOHELL | G_GENO | G_LGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  850, 150, 0, MS_ORC, MZ_HUMAN, 0, 0, M1_HUMANOID,
	  M2_ORC | M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(RED) },
	{ "hill orc", S_ORC, 2, 9, MARM(10,6), 0, -4, (G_NOHELL | G_GENO | G_LGROUP | 3),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1000, 200, 0, MS_ORC, MZ_HUMAN, 0, 0, M1_HUMANOID,
	  M2_ORC | M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(YELLOW) },
	{ "Mordor orc", S_ORC, 3, 5, MARM(10,6), 0, -5, (G_NOHELL | G_GENO | G_LGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 200, 0, MS_ORC, MZ_HUMAN, 0, 0, M1_HUMANOID,
	  M2_ORC | M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(BLUE) },
	{ "Uruk-hai", S_ORC, 3, 7, MARM(10,5), 0, -4, (G_NOHELL | G_GENO | G_LGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1300, 300, 0, MS_ORC, MZ_HUMAN, 0, 0, M1_HUMANOID,
	  M2_ORC | M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(BLACK) },
	{ "orc shaman", S_ORC, 3, 9, 5, 10, -5, (G_NOHELL | G_GENO | 2),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1000, 300, 0, MS_ORC, MZ_HUMAN, 0, 0, M1_HUMANOID,
	  M2_ORC | M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(HI_ZAP) },
	{ "orc-captain", S_ORC, 5, 5, MARM(10,4), 0, -5, (G_NOHELL | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1350, 350, 0, MS_ORC, MZ_HUMAN, MR_HITASONE, 0, M1_HUMANOID,
	  M2_ORC | M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(HI_LORD) },
	{ "war orc", S_ORC, 6, 7, MARM(10,3), 0, -4, (G_NOHELL | G_GENO | G_LGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1300, 300, 0, MS_ORC, MZ_HUMAN, 0, 0, M1_HUMANOID,
	  M2_ORC | M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(GREEN) },
	{ "great orc", S_ORC, 9, 7, MARM(10,2), 10, -4, (G_NOHELL | G_GENO | G_LGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1300, 300, 0, MS_ORC, MZ_HUMAN, 0, 0, M1_HUMANOID,
	  M2_ORC | M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(BRIGHT_GREEN) },
	{ "Grund the Orc King", S_ORC, 20, 7, MARM(10,0), 66, -4, (G_UNIQ | 1),
	  { { AT_WEAP, AD_PHYS, 4, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1300, 300, 0, MS_ORC, MZ_HUMAN, MR_POISON, MR_POISON, M1_HUMANOID,
	  M2_ORC | M2_STRONG | M2_PNAME | M2_PRINCE | M2_MALE | M2_GREEDY | M2_STALK |
	  M2_HOSTILE | M2_NASTY | M2_NOPOLY | M2_JEWELS | M2_COLLECT |
	  M2_MAGIC, 0, C(HI_LORD) },
	{ "snow orc", S_ORC, 9, 12, MARM(10,-2), 10, -9, (G_NOHELL | G_GENO | G_LGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1300, 300, 0, MS_ORC, MZ_HUMAN, MR_COLD, MR_COLD, M1_HUMANOID,
	  M2_ORC | M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(CYAN) },
	{ "demon orc", S_ORC, 12, 12, MARM(10,-2), 10, -9, (G_HELL | G_GENO | G_LGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1300, 300, 0, MS_ORC, MZ_HUMAN, MR_FIRE, MR_FIRE, M1_HUMANOID,
	  M2_ORC | M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(ORANGE_COLORED) },
/*       piercers       */
	{ "rock piercer", S_PIERCER, 3, 1, 3, 0, 0, (G_GENO | 5),
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 200, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_CLING | M1_HIDE | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS |
	  M1_CARNIVORE, M2_HOSTILE, 0, C(GRAY) },
	{ "iron piercer", S_PIERCER, 5, 1, 0, 0, 0, (G_GENO | 3),
	  { { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 300, 0, MS_SILENT, MZ_MEDIUM, 0, 0,
	  M1_CLING | M1_HIDE | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS |
	  M1_CARNIVORE, M2_HOSTILE, 0, C(CYAN) },
	{ "glass piercer", S_PIERCER, 7, 1, 0, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 6, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 300, 0, MS_SILENT, MZ_MEDIUM, 0, 0,
	  M1_CLING | M1_HIDE | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS |
	  M1_CARNIVORE, M2_HOSTILE, 0, C(WHITE) },
	{ "roper", S_PIERCER, 10, 1, 0, 0, 0, (G_GENO | 1),
	  { { AT_HUGS, AD_PHYS, 2, 6 }, {AT_TUCH, AD_DRST, 2, 4},
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1400, 300, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOLIMBS |
	  M1_CARNIVORE, M2_HOSTILE, 0, C(BLACK) },
/*      quadrupeds (generic)    */
	{ "rothe", S_QUADRUPED, 2, 9, 7, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 5),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_BITE, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 100, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(GRAY) },
	{ "giant badger", S_QUADRUPED, 2, 12, 6, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 2 }, { AT_CLAW, AD_PHYS, 1, 2 },
	    { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 50, 0, MS_SILENT, MZ_MEDIUM, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(BROWN) },
	{ "scramper", S_QUADRUPED, 3, 9, 7, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_BITE, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 8 }, { AT_STNG, AD_LEGS, 1, 6 },
	    NO_ATTK, NO_ATTK },
	  400, 100, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE | M1_POIS, M2_HOSTILE, 0, C(GREEN) },
	{ "squealer", S_QUADRUPED, 4, 9, 7, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_BITE, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 8 }, { AT_STNG, AD_LEGS, 1, 6 },
	    NO_ATTK, NO_ATTK },
	  400, 100, 0, MS_SHRIEK, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE | M1_POIS, M2_HOSTILE, 0, C(MAGENTA) },
	{ "mumak", S_QUADRUPED, 5, 9, 0, 0, -2, (G_NOHELL | G_GENO | 2),
	  { { AT_BUTT, AD_PHYS, 4, 12 }, { AT_BITE, AD_PHYS, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2500, 500, 0, MS_SILENT, MZ_LARGE, MR_HITASTWO, 0,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(GRAY) },
	{ "leocrotta", S_QUADRUPED, 6, 18, 4, 10, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 2, 6 }, { AT_BITE, AD_PHYS, 2, 6 },
	    { AT_CLAW, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 500, 0, MS_IMITATE, MZ_LARGE, MR_HITASTWO, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(RED) },
	{ "mangler", S_QUADRUPED, 8, 9, 7, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_CLAW, AD_PHYS, 3, 3 }, { AT_CLAW, AD_PHYS, 3, 3 },
	    { AT_BITE, AD_PHYS, 3, 8 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 100, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(ORANGE_COLORED) },
	{ "wumpus", S_QUADRUPED, 8, 3, 2, 10, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2500, 500, 0, MS_SILENT, MZ_LARGE, MR_HITASONE, 0,
	  M1_CLING | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(CYAN) },
	{ "titanothere", S_QUADRUPED, 12, 12, 6, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2650, 650, 0, MS_SILENT, MZ_LARGE, MR_HITASTWO, 0,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(GRAY) },
	{ "baluchitherium", S_QUADRUPED, 14, 12, 5, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 5, 4 }, { AT_CLAW, AD_PHYS, 5, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3800, 800, 0, MS_SILENT, MZ_LARGE, MR_HITASTHREE, 0,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS | M1_HERBIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(GRAY) },
	{ "mastodon", S_QUADRUPED, 20, 12, 5, 0, 0, (G_GENO | 1),
	  { { AT_BUTT, AD_PHYS, 4, 8 }, { AT_BUTT, AD_PHYS, 4, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3800, 800, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS | M1_HERBIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(BROWN) },
	{ "Jumbo the Elephant", S_QUADRUPED, 30, 12, 5, 0, 0, (G_UNIQ | 1),
	  { { AT_BUTT, AD_PHYS, 6, 8 }, { AT_BUTT, AD_PHYS, 6, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3800, 800, 0, MS_SILENT, MZ_LARGE, MR_STONE, MR_STONE,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS | M1_HERBIVORE,
	  M2_STRONG | M2_PNAME | M2_PRINCE | M2_MALE | M2_STALK |
	  M2_HOSTILE | M2_NASTY | M2_NOPOLY, 0, C(HI_LORD) },
	{ "juggernaut", S_QUADRUPED, 30, 9, 7, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 1),
	  { { AT_BUTT, AD_PHYS, 8, 8 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3800, 800, 0, MS_SILENT, MZ_GIGANTIC, 0, 0,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS | M1_HERBIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(YELLOW) },
	{ "catoblepas", S_QUADRUPED, 6, 6, 7, 10, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_GAZE, AD_DETH, 2, 6 }, { AT_BITE, AD_PHYS, 1, 3 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 500, 0, MS_SILENT, MZ_LARGE, MR_HITASTWO, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_HERBIVORE,
	  M2_HOSTILE | M2_NASTY | M2_STRONG, 0, C(BLACK) },
/*      rodents         */
	{ "sewer rat",  S_RODENT, 0, 12, 7, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 12, 0, MS_SQEEK, MZ_TINY, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "rabbit", S_RODENT, 0, 15, 7, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 12, 0, MS_SQEEK, MZ_TINY, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_HERBIVORE,
	  M2_HOSTILE, 0, C(WHITE) },
	{ "black rat",  S_RODENT, 0, 12, 7, 0, 0, (G_NOHELL | G_GENO | G_LGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 12, 0, MS_SQEEK, MZ_TINY, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BLACK) },
	{ "giant rat",  S_RODENT, 1, 10, 7, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 3),
	  { { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_SQEEK, MZ_TINY, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "rabid rat", S_RODENT, 2, 12, 6, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_DRCO, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 5, 0, MS_SQEEK, MZ_TINY, MR_POISON, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_POIS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "rabid rabbit", S_RODENT, 3, 18, 7, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_DRCO, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 12, 0, MS_SQEEK, MZ_TINY, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_HERBIVORE,
	  M2_HOSTILE, 0, C(WHITE) },
	{ "pack rat",  S_RODENT, 0, 12, 7, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 3 }, { AT_TUCH, AD_SITM, 1, 1 },
	      NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 12, 0, MS_SQEEK, MZ_TINY, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BLACK) },
	{ "wererat", S_RODENT, 2, 12, 6, 10, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 30, 0, MS_SQEEK, MZ_TINY, MR_POISON, 0,
	  M1_NOHANDS | M1_POIS | M1_REGEN | M1_CARNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE, 0, C(BROWN) },
	{ "rock mole", S_RODENT, 3, 3, 0, 20, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_TUNNEL | M1_ANIMAL | M1_NOHANDS | M1_METALLIVORE,
	  M2_HOSTILE | M2_GREEDY | M2_JEWELS | M2_COLLECT, 0, C(GRAY) },
	{ "hellrat",  S_RODENT, 5, 15, 7, 0, 0, (G_HELL | G_GENO | G_LGROUP | G_NOCORPSE | 1),
	  { { AT_BITE, AD_FIRE, 3, 3 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 12, 0, MS_SQEEK, MZ_TINY, MR_FIRE, MR_FIRE,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(RED) },
	{ "the Rat King",  S_RODENT, 12, 15, 7, 0, 0, (G_UNIQ | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_BITE, AD_PHYS, 2, 3 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 120, 0, MS_SQEEK, MZ_MEDIUM, MR_STONE, MR_STONE,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_STRONG | M2_PNAME | M2_PRINCE | M2_MALE | M2_GREEDY | M2_STALK |
	  M2_HOSTILE | M2_NASTY | M2_NOPOLY | M2_JEWELS | M2_COLLECT |
	  M2_MAGIC, 0, C(HI_LORD) },
/*      spiders and scorpions   */
	{ "cave spider", S_SPIDER, 1, 12, 3, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 3),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 50, 0, MS_SILENT, MZ_TINY, MR_POISON, MR_POISON,
	  M1_CONCEAL | M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(GRAY) },
	{ "centipede", S_SPIDER, 2, 12, 3, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_DRST, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 50, 0, MS_SILENT, MZ_TINY, MR_POISON, MR_POISON,
	  M1_CONCEAL | M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(YELLOW) },
	{ "recluse spider", S_SPIDER, 3, 12, 3, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_DRST, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 50, 0, MS_SILENT, MZ_TINY, MR_POISON, MR_POISON,
	  M1_CONCEAL | M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "giant spider", S_SPIDER, 5, 15, 4, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_DRST, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_SILENT, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_POIS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(BLACK) },
	{ "barking spider", S_SPIDER, 5, 15, 3, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 2 }, { AT_BITE, AD_PHYS, 1, 2 },
	     NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_BARK, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_POIS |
	  M1_CARNIVORE, M2_HOSTILE, 0, C(ORANGE_COLORED) },
	{ "scorpion", S_SPIDER, 5, 15, 3, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 1, 2 }, { AT_CLAW, AD_PHYS, 1, 2 },
	    { AT_STNG, AD_DRST, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 100, 0, MS_SILENT, MZ_SMALL, MR_POISON, MR_POISON,
	  M1_CONCEAL | M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_POIS |
	  M1_CARNIVORE, M2_HOSTILE, 0, C(RED) },
	{ "carrion crawler", S_SPIDER, 3, 12, 3, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_TUCH, AD_PLYS, 1, 1 }, { AT_TUCH, AD_PLYS, 1, 1 },
	    { AT_TUCH, AD_PLYS, 1, 1 }, { AT_TUCH, AD_PLYS, 1, 1 },
	    { AT_TUCH, AD_PLYS, 1, 1 }, { AT_TUCH, AD_PLYS, 1, 1 }
	  },
	  50, 100, 0, MS_SILENT, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS |
	  M1_CARNIVORE, M2_HOSTILE | M2_NASTY, 0, C(GREEN) },
	{ "nickelpede", S_SPIDER, 8, 12, 3, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_DRST, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  150, 50, 0, MS_SILENT, MZ_MEDIUM, MR_POISON, MR_POISON,
	  M1_CONCEAL | M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(CYAN) },
	{ "giant scorpion", S_SPIDER, 12, 15, 3, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 5, 2 }, { AT_CLAW, AD_PHYS, 5, 2 },
	    { AT_STNG, AD_DRST, 3, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 150, 0, MS_SILENT, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_POIS |
	  M1_CARNIVORE, M2_HOSTILE, 0, C(RED) },
	{ "Girtab", S_SPIDER, 22, 15, 3, 0, 0, (G_UNIQ | 1),
	  { { AT_CLAW, AD_PHYS, 5, 4 }, { AT_CLAW, AD_PHYS, 5, 4 },
	    { AT_STNG, AD_DRST, 3, 8 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 150, 0, MS_SILENT, MZ_LARGE, MR_POISON | MR_STONE, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_POIS |
	  M1_CARNIVORE,
	  M2_STRONG | M2_PNAME | M2_PRINCE | M2_FEMALE | M2_STALK |
	  M2_HOSTILE | M2_NASTY | M2_NOPOLY, 0, C(RED) },
	{ "Shelob", S_SPIDER, 26, 15, 3, 0, 0, (G_UNIQ | 1),
	  { { AT_BITE, AD_PHYS, 8, 4 }, { AT_BITE, AD_DRST, 5, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 150, 0, MS_SILENT, MZ_LARGE, MR_POISON | MR_STONE, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_POIS |
	  M1_CARNIVORE,
	  M2_STRONG | M2_PNAME | M2_PRINCE | M2_FEMALE | M2_STALK |
	  M2_HOSTILE | M2_NASTY | M2_NOPOLY, 0, C(BLACK) },
	{ "phase spider", S_SPIDER, 8, 12, 2, 0, -4, (G_GENO | 1),
	  { { AT_BITE, AD_DRST, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_SILENT, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_POIS | M1_TPORT |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(BLUE) },
	{ "werespider", S_SPIDER, 11, 15, 3, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_WERE, 4, 4 }, NO_ATTK,
	     NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_BARK, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_NOHANDS | M1_OVIPAROUS | M1_POIS |
	  M1_CARNIVORE | M1_REGEN, M2_HOSTILE | M2_WERE, 0, C(BLACK) },
/*      trappers, lurkers, &c.  */
	{ "lurker above", S_TRAPPER, 10, 3, 3, 0, 0, (G_GENO | 3),
	  { { AT_ENGL, AD_DGST, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  800, 350, 0, MS_SILENT, MZ_HUGE, 0, 0,
	  M1_HIDE | M1_FLY | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_CARNIVORE, M2_HOSTILE | M2_STALK | M2_STRONG, 0, C(GRAY) },
	{ "trapper", S_TRAPPER, 12, 3, 3, 0, 0, (G_GENO | 3),
	  { { AT_ENGL, AD_DGST, 1, 10 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  800, 350, 0, MS_SILENT, MZ_HUGE, 0, 0,
	  M1_HIDE | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_CARNIVORE, M2_HOSTILE | M2_STALK | M2_STRONG, 0, C(GREEN) },
/*      unicorns        */
	{ "white unicorn", S_UNICORN, 10, 24, 2, 70, 7, (G_NOHELL | G_GENO | 3),
	  { { AT_BUTT, AD_PHYS, 1, 12 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1300, 300, 0, MS_NEIGH, MZ_LARGE,
	  MR_POISON | MR_HITASTWO, MR_POISON, M1_NOHANDS | M1_HERBIVORE,
	  M2_WANDER | M2_STRONG | M2_JEWELS, 0, C(WHITE) },
	{ "gray unicorn", S_UNICORN, 10, 24, 2, 70, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BUTT, AD_PHYS, 1, 12 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1300, 300, 0, MS_NEIGH, MZ_LARGE,
	  MR_POISON | MR_HITASTWO, MR_POISON, M1_NOHANDS | M1_HERBIVORE,
	  M2_WANDER | M2_STRONG | M2_JEWELS, 0, C(GRAY) },
	{ "black unicorn", S_UNICORN, 10, 24, 2, 70, -7, (G_NOHELL | G_GENO | 2),
	  { { AT_BUTT, AD_PHYS, 1, 12 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1300, 300, 0, MS_NEIGH, MZ_LARGE,
	  MR_POISON | MR_HITASTWO, MR_POISON, M1_NOHANDS | M1_HERBIVORE,
	  M2_WANDER | M2_STRONG | M2_JEWELS, 0, C(BLACK) },
	{ "nightmare", S_UNICORN, 12, 24, 2, 70, -7, (G_HELL | G_GENO | 1),
	  { { AT_BUTT, AD_PHYS, 3, 12 }, { AT_KICK, AD_PHYS, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1300, 300, 0, MS_NEIGH, MZ_LARGE,
	  MR_POISON | MR_FIRE | MR_PLUSTWO | MR_HITASTWO,
	  MR_POISON | MR_FIRE, M1_NOHANDS | M1_HERBIVORE,
	  M2_WANDER | M2_STRONG | M2_JEWELS, 0, C(RED) },
/*      vortices        */
	{ "fog cloud",  S_VORTEX, 3,  1, 0, 0, 0, (G_GENO | G_NOCORPSE | 3),
	  { { AT_ENGL, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_HUGE,
	  MR_DEATH | MR_SLEEP | MR_POISON | MR_STONE, 0,
	  M1_FLY | M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_AMORPHOUS | M1_UNSOLID,
	  M2_HOSTILE | M2_NEUTER, 0, C(GRAY) },
	{ "dust vortex", S_VORTEX, 4, 20, 2, 30, 0, (G_GENO | G_NOCORPSE | 3),
	  { { AT_ENGL, AD_BLND, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_HUGE,
	  MR_DEATH | MR_SLEEP | MR_POISON | MR_STONE, 0,
	  M1_FLY | M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS,
	  M2_HOSTILE | M2_NEUTER, 0, C(BROWN) },
	{ "ice vortex", S_VORTEX, 5, 20, 2, 30, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_ENGL, AD_COLD, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_HUGE,
	  MR_DEATH | MR_COLD | MR_SLEEP | MR_POISON | MR_STONE, 0,
	  M1_FLY | M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS,
	  M2_HOSTILE | M2_NEUTER, 0, C(CYAN) },
	{ "energy vortex", S_VORTEX, 6, 20, 2, 30, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_ENGL, AD_ELEC, 1, 6 }, { AT_ENGL, AD_DREN, 0, 0 },
	    { AT_NONE, AD_ELEC, 0, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_HUGE,
	  MR_DEATH | MR_ELEC | MR_SLEEP | MR_DISINT | MR_POISON | MR_STONE, 0,
	  M1_FLY | M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_UNSOLID, M2_HOSTILE | M2_NEUTER, 0, C(HI_ZAP) },
	{ "steam vortex", S_VORTEX, 7, 22, 2, 30, 0,
	  (G_HELL | G_GENO | G_NOCORPSE | 3),
	  { { AT_ENGL, AD_FIRE, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_HUGE,
	  MR_DEATH | MR_FIRE | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSONE, 0,
	  M1_FLY | M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_UNSOLID, M2_HOSTILE | M2_NEUTER, 0, C(BLUE) },
	{ "fire vortex", S_VORTEX, 8, 22, 2, 30, 0,
	  (G_HELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_ENGL, AD_FIRE, 1, 10 }, { AT_NONE, AD_FIRE, 0, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_HUGE,
	  MR_DEATH | MR_FIRE | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSONE, 0,
	  M1_FLY | M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_UNSOLID, M2_HOSTILE | M2_NEUTER, 0, C(YELLOW) },
/*      worms   */
	{ "maggot", S_WORM, 1, 9, 5, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_CONCEAL | M1_SLITHY | M1_NOLIMBS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(WHITE) },
	{ "dung worm", S_WORM, 2, 9, 5, 0, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_DRST, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_SLITHY | M1_NOLIMBS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BLACK) },
	{ "acid worm", S_WORM, 4, 9, 5, 0, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_SPIT, AD_ACID, 2, 4 }, { AT_BITE, AD_DRST, 1, 4}, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_SILENT, MZ_SMALL, MR_ACID, 0,
	  M1_ANIMAL | M1_SLITHY | M1_NOLIMBS | M1_CARNIVORE | M1_ACID,
	  M2_HOSTILE, 0, C(GREEN) },
	{ "bloodworm", S_WORM, 6, 9, 4, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_DRST, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_SILENT, MZ_SMALL, MR_ACID, 0,
	  M1_ANIMAL | M1_SLITHY | M1_NOLIMBS | M1_CARNIVORE | M1_AMPHIBIOUS,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "tunnel worm", S_WORM, 7, 9, 5, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 200, 0, MS_SILENT, MZ_MEDIUM, MR_ACID, 0,
	  M1_ANIMAL | M1_SLITHY | M1_TUNNEL | M1_NOLIMBS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(RED) },
	{ "baby long worm", S_WORM, 8, 3, 5, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 250, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_SLITHY | M1_NOLIMBS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "baby purple worm", S_WORM, 8, 3, 5, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 250, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_SLITHY | M1_NOLIMBS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(MAGENTA) },
	{ "long worm", S_WORM, 8, 3, 5, 10, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 500, 0, MS_SILENT, MZ_GIGANTIC, 0, 0,
	  M1_ANIMAL | M1_SLITHY | M1_NOLIMBS | M1_OVIPAROUS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY,
	  0, C(BROWN) },
	{ "purple worm", S_WORM, 15, 9, 6, 20, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_BITE, AD_PHYS, 2, 8 }, { AT_ENGL, AD_DGST, 1, 10 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2700, 700, 0, MS_SILENT, MZ_GIGANTIC, MR_HITASONE, 0,
	  M1_ANIMAL | M1_SLITHY | M1_NOLIMBS | M1_OVIPAROUS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY,
	  0, C(MAGENTA) },
	{ "rot worm", S_WORM, 1, 9, 5, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DISE, 1, 2 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 10, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_CONCEAL | M1_SLITHY | M1_NOLIMBS | M1_CARNIVORE,
	  M2_NASTY | M2_HOSTILE, 0, C(GRAY) },
/*      Dummy monster needed for visual interface. */
	{ "long worm tail", S_WORM_TAIL, 0, 0, 0, 0, 0,
	  (G_NOGEN | G_NOCORPSE | G_UNIQ),      /* uniq prevents figurines */
	  { NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, 0, 0, 0, 0, 0, M2_NOPOLY, 0, C(BROWN) },
/*      xan, &c.        */
	{ "grid bug", S_XAN, 0, 12, 9, 0, 0,
	  (G_NOHELL | G_GENO | G_SGROUP | G_NOCORPSE | 4),
	  { { AT_BITE, AD_ELEC, 1, 1 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 10, 0, MS_BUZZ, MZ_TINY, MR_ELEC | MR_POISON | MR_HITASONE, 0,
	  M1_ANIMAL, M2_HOSTILE, 0, C(MAGENTA) },
	{ "arc bug", S_XAN, 2, 12, 9, 0, 0,
	  (G_NOHELL | G_GENO | G_SGROUP | G_NOCORPSE | 1),
	  { { AT_BITE, AD_ELEC, 1, 3 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 10, 0, MS_BUZZ, MZ_TINY, MR_ELEC | MR_POISON | MR_HITASONE, 0,
	  M1_ANIMAL, M2_HOSTILE, 0, C(HI_ZAP) },
	{ "spark bug", S_XAN, 4, 12, 9, 0, 0,
	  (G_NOHELL | G_GENO | G_SGROUP | G_NOCORPSE | 1),
	  { { AT_BITE, AD_ELEC, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 10, 0, MS_BUZZ, MZ_TINY, MR_ELEC | MR_POISON | MR_HITASONE, 0,
	  M1_ANIMAL, M2_HOSTILE, 0, C(ORANGE_COLORED) },
	{ "lightning bug", S_XAN, 6, 12, 9, 0, 0,
	  (G_NOHELL | G_GENO | G_SGROUP | G_NOCORPSE | 1),
	  { { AT_BITE, AD_ELEC, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 10, 0, MS_BUZZ, MZ_TINY, MR_ELEC | MR_POISON | MR_HITASONE, 0,
	  M1_ANIMAL, M2_HOSTILE, 0, C(YELLOW) },
	{ "xan", S_XAN, 7, 18, -4, 0, 0, (G_GENO | 4),
	  { { AT_STNG, AD_LEGS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 300, 0, MS_BUZZ, MZ_TINY, MR_POISON, MR_POISON,
	  M1_FLY | M1_ANIMAL | M1_NOHANDS | M1_POIS, M2_HOSTILE, 0, C(RED) },
/*      lights */
	{ "yellow light", S_LIGHT, 3, 15, 0, 0, 0, (G_NOHELL | G_NOCORPSE| G_GENO | 5),
	  { { AT_EXPL, AD_BLND, 10, 20 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_SMALL,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_ELEC | MR_DISINT | MR_SLEEP | MR_POISON |
	  MR_ACID | MR_STONE, 0,
	  M1_FLY | M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS |
	  M1_NOHEAD | M1_MINDLESS | M1_UNSOLID, M2_HOSTILE | M2_NEUTER,
	  0, C(YELLOW) },
	{ "red light", S_LIGHT, 5, 15, 0, 0, 0, (G_NOHELL | G_NOCORPSE| G_GENO | 1),
	  { { AT_EXPL, AD_FIRE, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_SMALL,
	  MR_FIRE | MR_COLD | MR_ELEC | MR_DISINT | MR_SLEEP | MR_POISON |
	  MR_ACID | MR_STONE, 0,
	  M1_FLY | M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS |
	  M1_NOHEAD | M1_MINDLESS | M1_UNSOLID, M2_HOSTILE | M2_NEUTER,
	  0, C(RED) },
	{ "blue light", S_LIGHT, 5, 15, 0, 0, 0, (G_NOHELL | G_NOCORPSE| G_GENO | 1),
	  { { AT_EXPL, AD_COLD, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_SMALL,
	  MR_FIRE | MR_COLD | MR_ELEC | MR_DISINT | MR_SLEEP | MR_POISON |
	  MR_ACID | MR_STONE, 0,
	  M1_FLY | M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS |
	  M1_NOHEAD | M1_MINDLESS | M1_UNSOLID, M2_HOSTILE | M2_NEUTER,
	  0, C(BLUE) },
/*      zruty   */
	{ "zruty", S_ZRUTY, 9, 8, 3, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 600, 0, MS_SILENT, MZ_LARGE, MR_HITASONE, 0,
	  M1_ANIMAL | M1_HUMANOID | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(BROWN) },
/*      Angels and other lawful minions */
	{ "couatl", S_ANGEL, 8, 10, 2, 30, 7,
	  (G_NOHELL | G_SGROUP | G_NOCORPSE | 2),
	  { { AT_BITE, AD_DRST, 2, 4 }, { AT_BITE, AD_PHYS, 1, 3 },
	    { AT_HUGS, AD_WRAP, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  900, 400, 0, MS_SILENT, MZ_LARGE, MR_POISON | MR_PLUSTWO, 0,
	  M1_FLY | M1_POIS, M2_MINION | M2_STALK | M2_STRONG | M2_NASTY, 0, C(GREEN) },
	{ "Aleax", S_ANGEL, 10, 8, -2, 30, 7, (G_NOHELL | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_WEAP, AD_PHYS, 1, 6 },
	    { AT_KICK, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0,
	  MS_SILENT, MZ_HUMAN, MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON |
	  MR_PLUSTWO, 0, M1_HUMANOID | M1_SEE_INVIS,
	  M2_MINION | M2_STALK | M2_NASTY | M2_COLLECT, 0, C(YELLOW) },
	{ "movanic deva", S_ANGEL, 12, 18, -5, 90, 15, (G_NOHELL | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_PHYS, 3, 4 }, { AT_WEAP, AD_FIRE, 3, 4 },
	    { AT_WEAP, AD_FIRE, 3, 4 }, { AT_MAGC, AD_CLRC, 2, 6 },
	     NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_CUSS, MZ_MEDIUM, MR_DEATH | MR_PLUSONE, 0,
	  M1_FLY | M1_HUMANOID | M1_SEE_INVIS,
	  M2_NOPOLY | M2_MINION | M2_STALK | M2_STRONG | M2_NASTY,
	  0, C(BLUE) },
	{ "monadic deva", S_ANGEL, 15, 18, -4, 90, 15, (G_NOHELL | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_PHYS, 3, 4 }, { AT_WEAP, AD_PHYS, 6, 4 },
	    { AT_MAGC, AD_CLRC, 3, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_CUSS, MZ_MEDIUM, MR_DEATH | MR_PLUSONE, 0,
	  M1_FLY | M1_HUMANOID | M1_SEE_INVIS,
	  M2_NOPOLY | M2_MINION | M2_STALK | M2_STRONG | M2_NASTY,
	  0, C(BRIGHT_CYAN) },
	{ "astral deva", S_ANGEL, 18, 18, -6, 90, 15, (G_NOHELL | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_PHYS, 3, 12 }, { AT_WEAP, AD_STUN, 1, 4 },
	    { AT_MAGC, AD_CLRC, 3, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_CUSS, MZ_MEDIUM, MR_DEATH | MR_PLUSONE, 0,
	  M1_FLY | M1_HUMANOID | M1_SEE_INVIS,
	  M2_NOPOLY | M2_MINION | M2_STALK | M2_STRONG | M2_NASTY,
	  0, C(WHITE) },
	{ "Angel", S_ANGEL, 14, 10, -6, 55, 12, (G_NOHELL | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_MAGM, 2, 6 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, sizeof(struct epri), MS_CUSS, MZ_HUMAN,
	  MR_DEATH | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_PLUSTHREE, 0,
	  M1_HUMANOID | M1_SEE_INVIS,
	  M2_NOPOLY | M2_MINION | M2_STALK | M2_STRONG | M2_NASTY | M2_COLLECT,
	  0, C(WHITE) },
	{ "ki-rin", S_ANGEL, 16, 18, -8, 90, 15, (G_NOHELL | G_NOCORPSE | 2),
	  { { AT_KICK, AD_PHYS, 2, 4 }, { AT_KICK, AD_BLND, 2, 4 },
	    { AT_BUTT, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEIGH, MZ_LARGE, MR_DEATH | MR_PLUSTHREE, 0,
	  M1_FLY | M1_HUMANOID | M1_SEE_INVIS,
	  M2_NOPOLY | M2_MINION | M2_STALK | M2_STRONG | M2_NASTY | M2_LORD,
	  0, C(HI_GOLD) },
	{ "Archon", S_ANGEL, 19, 16, -10, 80, 15, (G_NOHELL | G_NOCORPSE |2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_GAZE, AD_BLND, 2, 6 },
	    { AT_WEAP, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 1, 8 },
	    { AT_MAGC, AD_SPEL, 4, 6 }, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_CUSS, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_PLUSFOUR,
	  0, M1_FLY | M1_HUMANOID | M1_SEE_INVIS | M1_REGEN,
	  M2_NOPOLY | M2_MINION | M2_STALK | M2_STRONG | M2_NASTY | M2_LORD |
	  M2_COLLECT | M2_MAGIC,
	  0, C(HI_LORD) },
	{ "Planetar", S_ANGEL, 29, 16, -10, 80, 15, (G_NOHELL | G_NOCORPSE |1),
	  { { AT_WEAP, AD_PHYS, 4, 4 }, { AT_GAZE, AD_BLND, 3, 6 },
	    { AT_WEAP, AD_PHYS, 4, 4 }, { AT_CLAW, AD_PHYS, 2, 8 },
	    { AT_MAGC, AD_SPEL, 4, 6 }, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_CUSS, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_PLUSFOUR,
	  0, M1_FLY | M1_HUMANOID | M1_SEE_INVIS | M1_REGEN,
	  M2_NOPOLY | M2_MINION | M2_STALK | M2_STRONG | M2_NASTY | M2_LORD |
	  M2_COLLECT | M2_MAGIC,
	  0, C(CYAN) },
	{ "Solar", S_ANGEL, 39, 16, -10, 80, 15, (G_NOHELL | G_NOCORPSE |1),
	  { { AT_WEAP, AD_PHYS, 5, 4 }, { AT_GAZE, AD_BLND, 5, 6 },
	    { AT_WEAP, AD_PHYS, 5, 4 }, { AT_CLAW, AD_PHYS, 5, 8 },
	    { AT_MAGC, AD_SPEL, 5, 6 }, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_CUSS, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_PLUSFOUR,
	  0, M1_FLY | M1_HUMANOID | M1_SEE_INVIS | M1_REGEN,
	  M2_NOPOLY | M2_MINION | M2_STALK | M2_STRONG | M2_NASTY | M2_LORD |
	  M2_COLLECT | M2_MAGIC,
	  0, C(BROWN) },
/*      Bats    */
	{ "bat", S_BAT, 0, 22, 8, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 20, 0, MS_SQEEK, MZ_TINY, 0, 0,
	  M1_FLY | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_WANDER, 0, C(BROWN) },
	{ "giant bat", S_BAT, 2, 22, 7, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_SQEEK, MZ_MEDIUM, 0, 0,
	  M1_FLY | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_WANDER | M2_HOSTILE, 0, C(RED) },
	{ "rhumbat", S_BAT, 3, 22, 7, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 10 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_SQEEK, MZ_MEDIUM, 0, 0,
	  M1_FLY | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_WANDER | M2_HOSTILE, 0, C(YELLOW) },
	{ "athol", S_BAT, 2, 20, 7, 0, 0, (G_NOHELL | G_GENO | G_LGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 5 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_SQEEK, MZ_MEDIUM, 0, 0,
	  M1_FLY | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_WANDER | M2_HOSTILE, 0, C(GRAY) },
	{ "vampire bat", S_BAT, 5, 20, 6, 0, 0, (G_GENO | 3),
	  { { AT_BITE, AD_PHYS, 1, 6 }, { AT_BITE, AD_DRST, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 20, 0, MS_SQEEK, MZ_TINY, MR_SLEEP | MR_POISON, 0,
	  M1_FLY | M1_BREATHLESS | M1_ANIMAL | M1_NOHANDS | M1_POIS | M1_REGEN,
	  M2_UNDEAD | M2_HOSTILE, 0, C(BLACK) },
	{ "hellbat", S_BAT, 7, 22, 7, 0, 0, (G_HELL | G_GENO | G_SGROUP | G_NOCORPSE | 1),
	  { { AT_BITE, AD_FIRE, 1, 12 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_SQEEK, MZ_MEDIUM, MR_FIRE, MR_FIRE,
	  M1_FLY | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_WANDER | M2_HOSTILE, 0, C(RED) },
	{ "mongbat", S_BAT, 7, 22, 7, 0, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 12 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_SQEEK, MZ_MEDIUM, 0, 0,
	  M1_FLY | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_WANDER | M2_HOSTILE, 0, C(ORANGE_COLORED) },
	{ "mobat", S_BAT, 9, 22, 7, 0, 0, (G_NOHELL | G_GENO | G_LGROUP | 1),
	  { { AT_BITE, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_SHRIEK, MZ_MEDIUM, 0, 0,
	  M1_FLY | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_WANDER | M2_HOSTILE, 0, C(BLACK) },
	{ "harpy", S_BAT, 9, 17, 5, 0, -4, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 12 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  130, 130, 0, MS_SQEEK, MZ_MEDIUM, 0, 0,
	  M1_FLY | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_WANDER | M2_HOSTILE, 0, C(GRAY) },
/*      Centaurs        */
	{ "plains centaur", S_CENTAUR, 4, 18, 4, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2500, 500, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_HUMANOID, M2_STRONG | M2_GREEDY | M2_COLLECT, 0, C(BROWN) },
	{ "forest centaur", S_CENTAUR, 5, 18, 3, 10, -1, (G_NOHELL | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2550, 600, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_HUMANOID, M2_STRONG | M2_GREEDY | M2_COLLECT, 0, C(GREEN) },
	{ "mountain centaur", S_CENTAUR, 6, 20, 2, 10, -3, (G_NOHELL | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 10 }, { AT_KICK, AD_PHYS, 1, 6 },
	    { AT_KICK, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  2550, 500, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_HUMANOID, M2_STRONG | M2_GREEDY | M2_COLLECT, 0, C(CYAN) },
/*      Dragons.  The order of the dragons is VERY IMPORTANT.  Quite a few
	pieces of code depend on gray being first and yellow being last.
	The code also depends on the *order* being the same as that for
	dragon scale mail and dragon scales in objects.c                    */
	{ "baby gray dragon", S_DRAGON, 4, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 500, 0, MS_ROAR, MZ_HUGE, MR_HITASONE, 0,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS, 0, C(GRAY) },
	{ "baby silver dragon", S_DRAGON, 4, 9, 2, 40, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 500, 0, MS_ROAR, MZ_HUGE, 0, 0,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS, 0, C(BRIGHT_CYAN) },
	{ "baby shimmering dragon", S_DRAGON, 4, 9, -4, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 500, 0, MS_ROAR, MZ_HUGE, 0, 0,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS, 0, C(CYAN) },
	{ "baby deep dragon", S_DRAGON, 4, 9, 0, 10, 0, G_GENO,
	  { { AT_BITE, AD_DRST, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 500, 0, MS_ROAR, MZ_HUGE, 0, 0,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS, 0, C(MAGENTA) },
	{ "baby red dragon", S_DRAGON, 4, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 500, 0, MS_ROAR, MZ_HUGE, MR_FIRE | MR_HITASONE, MR_FIRE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS, 0, C(RED) },
	{ "baby white dragon", S_DRAGON, 4, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 500, 0, MS_ROAR, MZ_HUGE, MR_COLD | MR_HITASONE, MR_COLD,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS, 0, C(WHITE) },
	{ "baby orange dragon", S_DRAGON, 4, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 500, 0, MS_ROAR, MZ_HUGE, MR_SLEEP | MR_HITASONE, MR_SLEEP,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS, 0, C(ORANGE_COLORED) },
	{ "baby black dragon", S_DRAGON, 4, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 500, 0, MS_ROAR, MZ_HUGE, MR_DISINT | MR_HITASONE, MR_DISINT,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS, 0, C(BLACK) },
	{ "baby blue dragon", S_DRAGON, 4, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 500, 0, MS_ROAR, MZ_HUGE, MR_ELEC | MR_HITASONE, MR_ELEC,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS, 0, C(BLUE) },
	{ "baby green dragon", S_DRAGON, 4, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 500, 0, MS_ROAR, MZ_HUGE, MR_POISON | MR_HITASONE, MR_POISON,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE | M1_POIS,
	  M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS, 0, C(GREEN) },
	{ "baby yellow dragon", S_DRAGON, 4, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 500, 0, MS_ROAR, MZ_HUGE, MR_ACID | MR_STONE | MR_HITASONE, MR_STONE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE | M1_ACID,
	  M2_HOSTILE | M2_STRONG | M2_GREEDY | M2_JEWELS, 0, C(YELLOW) },
	{ "gray dragon", S_DRAGON, 18, 9, -4, 20, 4, (G_GENO | 1),
	  { { AT_BREA, AD_MAGM, 4, 6 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 1500, 0, MS_ROAR, MZ_GIGANTIC, MR_HITASTHREE, 0,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS | M1_OVIPAROUS |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(GRAY) },
	{ "silver dragon", S_DRAGON, 18, 9, -1, 95, 4, (G_GENO | 1),
	  { { AT_BREA, AD_COLD, 4, 6 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 1500, 0, MS_ROAR, MZ_GIGANTIC, MR_COLD | MR_HITASTHREE, MR_COLD,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS | M1_OVIPAROUS |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(BRIGHT_CYAN) },
	{ "shimmering dragon", S_DRAGON, 18, 9, -8, 20, 4, (G_GENO | 1),
	  { { AT_BREA, AD_MAGM, 4, 6 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 1500, 0, MS_ROAR, MZ_GIGANTIC, MR_HITASTHREE, 0,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS | M1_OVIPAROUS |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(CYAN) },
	{ "deep dragon", S_DRAGON, 18, 9, -4, 20, -6, (G_GENO | 1),
	  { { AT_BREA, AD_DISN, 4, 10 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 1500, 0, MS_ROAR, MZ_GIGANTIC, MR_DISINT | MR_HITASTHREE, MR_DISINT,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS | M1_OVIPAROUS |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(MAGENTA) },
	{ "red dragon", S_DRAGON, 18, 9, -4, 20, -4, (G_GENO | 2),
	  { { AT_BREA, AD_FIRE, 6, 6 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 1500, 0, MS_ROAR, MZ_GIGANTIC, MR_FIRE | MR_HITASTHREE, MR_FIRE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS | M1_OVIPAROUS |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(RED) },
	{ "white dragon", S_DRAGON, 18, 9, -4, 20, -5, (G_GENO | 2),
	  { { AT_BREA, AD_COLD, 4, 6 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 1500, 0, MS_ROAR, MZ_GIGANTIC, MR_COLD | MR_HITASTHREE, MR_COLD,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS | M1_OVIPAROUS |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(WHITE) },
	{ "orange dragon", S_DRAGON, 18, 9, -4, 20, 5, (G_GENO | 2),
	  { { AT_BREA, AD_SLEE, 4, 25 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 1500, 0, MS_ROAR, MZ_GIGANTIC, MR_SLEEP | MR_HITASTHREE, MR_SLEEP,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS | M1_OVIPAROUS |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(ORANGE_COLORED) },
	{ "black dragon", S_DRAGON, 18, 9, -4, 20, -6, (G_GENO | 2),
	  { { AT_BREA, AD_DISN, 4, 10 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 1500, 0, MS_ROAR, MZ_GIGANTIC, MR_DISINT | MR_HITASTHREE, MR_DISINT,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS | M1_OVIPAROUS |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(BLACK) },
	{ "blue dragon", S_DRAGON, 18, 9, -4, 20, -7, (G_GENO | 2),
	  { { AT_BREA, AD_ELEC, 4, 6 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 1500, 0, MS_ROAR, MZ_GIGANTIC, MR_ELEC | MR_HITASTHREE, MR_ELEC,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS | M1_OVIPAROUS |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(BLUE) },
	{ "green dragon", S_DRAGON, 18, 9, -4, 20, 6, (G_GENO | 2),
	  { { AT_BREA, AD_DRST, 4, 6 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 1500, 0, MS_ROAR, MZ_GIGANTIC, MR_POISON | MR_HITASTHREE, MR_POISON,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS | M1_OVIPAROUS |
	  M1_CARNIVORE | M1_POIS,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(GREEN) },
	{ "yellow dragon", S_DRAGON, 18, 9, -4, 20, 7, (G_GENO | 2),
	  { { AT_BREA, AD_ACID, 4, 6 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 1500, 0, MS_ROAR, MZ_GIGANTIC,
	  MR_ACID | MR_STONE | MR_HITASTHREE, MR_STONE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS | M1_OVIPAROUS |
	  M1_CARNIVORE | M1_ACID,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(YELLOW) },
	{ "wyvern", S_DRAGON, 18, 9, -4, 20, 7, (G_GENO | 1),
	  { { AT_STNG, AD_DRST, 4, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK },
	  WT_DRAGON, 500, 0, MS_ROAR, MZ_GIGANTIC,
	  MR_POISON | MR_STONE | MR_HITASTWO, MR_POISON,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(BROWN) },
	{ "hydra", S_DRAGON, 26, 9, -4, 20, 7, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 8 }, { AT_BITE, AD_PHYS, 2, 8 },
	    { AT_BITE, AD_PHYS, 2, 8 }, { AT_BITE, AD_PHYS, 2, 8 },
	    { AT_BITE, AD_PHYS, 2, 8 }, { AT_BITE, AD_PHYS, 2, 8 } },
	  WT_DRAGON, 500, 0, MS_ROAR, MZ_GIGANTIC,
	  MR_POISON | MR_STONE | MR_HITASTWO, MR_POISON,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_SEE_INVIS |
	  M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  0, C(BRIGHT_GREEN) },
/*      Elementals      */
	{ "air elemental", S_ELEMENTAL, 8, 36, 2, 30, 0, (G_NOHELL | G_NOCORPSE | 2),
	  { { AT_ENGL, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_HUGE, MR_POISON | MR_STONE, 0,
	  M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS | M1_UNSOLID |
	  M1_FLY,
	  M2_STRONG | M2_NEUTER, 0, C(CYAN) },
	{ "fire elemental", S_ELEMENTAL, 8, 12, 2, 30, 0, (G_NOHELL | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_FIRE, 3, 6 }, { AT_NONE, AD_FIRE, 0, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_HUGE, MR_FIRE | MR_POISON | MR_STONE, 0,
	  M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS | M1_UNSOLID |
	  M1_FLY,
	  M2_STRONG | M2_NEUTER, 0, C(YELLOW) },
	{ "earth elemental", S_ELEMENTAL, 8, 6, 2, 30, 0, (G_NOHELL | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 4, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2500, 0, 0, MS_SILENT, MZ_HUGE,
	  MR_FIRE | MR_COLD | MR_POISON | MR_STONE, 0,
	  M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS | M1_BREATHLESS |
	  M1_WALLWALK | M1_THICK_HIDE, M2_STRONG | M2_NEUTER, 0, C(BROWN) },
	{ "water elemental", S_ELEMENTAL, 8, 6, 2, 30, 0, (G_NOHELL | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 5, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2500, 0, 0, MS_SILENT, MZ_HUGE, MR_POISON | MR_STONE, 0,
	  M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS | M1_AMPHIBIOUS |
	  M1_SWIM,
	  M2_STRONG | M2_NEUTER, 0, C(BLUE) },
/*      Fungi   */
	{ "brown mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_NONE, AD_COLD, 0, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 30, 0, MS_SILENT, MZ_SMALL,
	  MR_DEATH | MR_COLD | MR_POISON, MR_COLD | MR_POISON,
	  M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS |
	  M1_OMNIVORE,
	  M2_HOSTILE | M2_NEUTER, 0, C(BROWN) },
	{ "yellow mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_NONE, AD_STUN, 0, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 30, 0, MS_SILENT, MZ_SMALL, MR_DEATH | MR_POISON, MR_POISON,
	  M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS |
	  M1_OMNIVORE | M1_POIS,
	  M2_HOSTILE | M2_NEUTER, 0, C(YELLOW) },
	{ "green mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_NONE, AD_ACID, 0, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 30, 0, MS_SILENT, MZ_SMALL, MR_DEATH | MR_ACID | MR_STONE, MR_STONE,
	  M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS |
	  M1_OMNIVORE | M1_ACID,
	  M2_HOSTILE | M2_NEUTER, 0, C(GREEN) },
	{ "red mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_NONE, AD_FIRE, 0, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 30, 0, MS_SILENT, MZ_SMALL,
	  MR_DEATH | MR_FIRE | MR_POISON, MR_FIRE | MR_POISON,
	  M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS |
	  M1_OMNIVORE,
	  M2_HOSTILE | M2_NEUTER, 0, C(RED) },
	{ "shrieker", S_FUNGUS, 3, 1, 7, 0, 0, (G_NOHELL | G_GENO | 2),
	  { NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_SHRIEK, MZ_SMALL, MR_DEATH | MR_POISON, MR_POISON,
	  M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS,
	  M2_HOSTILE | M2_NEUTER, 0, C(MAGENTA) },
	{ "violet fungus", S_FUNGUS, 3, 1, 7, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_TUCH, AD_PHYS, 1, 4 }, { AT_TUCH, AD_STCK, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_SILENT, MZ_SMALL, MR_POISON, MR_POISON,
	  M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS |
	  M1_OMNIVORE,
	  M2_HOSTILE | M2_NEUTER, 0, C(MAGENTA) },
	{ "disgusting mold", S_FUNGUS, 5, 0, 7, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_NONE, AD_DRST, 1, 8 }, { AT_NONE, AD_ACID, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_SILENT, MZ_SMALL, MR_POISON, MR_POISON,
	  M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS |
	  M1_OMNIVORE,
	  M2_HOSTILE | M2_NEUTER, 0, C(CYAN) },
	{ "black mold", S_FUNGUS, 6, 2, 7, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_NONE, AD_DRST, 0, 4 }, { AT_NONE, AD_ACID, 1, 8 },
	     { AT_TUCH, AD_ACID, 1, 8 }, { AT_TUCH, AD_DRST, 2, 4 },
	     NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_SILENT, MZ_SMALL, MR_POISON, MR_POISON,
	  M1_BREATHLESS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD | M1_MINDLESS |
	  M1_OMNIVORE,
	  M2_HOSTILE | M2_NEUTER, 0, C(BLACK) },
/*      Gnomes  */
	{ "gnome", S_GNOME, 1, 6, MARM(10,5), 4, 0, (G_NOHELL | G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  650, 100, 0, MS_ORC, MZ_SMALL, 0, 0,
	  M1_HUMANOID, M2_COLLECT, 0, C(BROWN) },
	{ "gnome thief", S_GNOME, 1, 6, MARM(10,5), 4, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_TUCH, AD_SITM, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  650, 100, 0, MS_ORC, MZ_SMALL, 0, 0,
	  M1_HUMANOID, M2_HOSTILE | M2_COLLECT, 0, C(BLACK) },
	{ "gnome lord", S_GNOME, 3, 8, MARM(10,4), 4, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  700, 120, 0, MS_ORC, MZ_SMALL, 0, 0,
	  M1_HUMANOID, M2_LORD | M2_MALE | M2_COLLECT, 0, C(BLUE) },
	{ "gnomish wizard", S_GNOME, 3, 10, 4, 10, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  700, 120, 0, MS_ORC, MZ_SMALL, 0, 0,
	  M1_HUMANOID, M2_MAGIC, 0, C(HI_ZAP) },
	{ "deep gnome", S_GNOME, 5, 10, MARM(10,2), 20, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  750, 150, 0, MS_ORC, MZ_SMALL, MR_HITASONE, 0,
	  M1_HUMANOID | M1_TUNNEL | M1_NEEDPICK, M2_MALE | M2_GREEDY |
	  M2_JEWELS | M2_COLLECT, 0, C(GRAY) },
	{ "gnome warrior", S_GNOME, 5, 10, MARM(10,2), 20, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  750, 150, 0, MS_ORC, MZ_SMALL, MR_HITASONE, 0,
	  M1_HUMANOID, M2_MALE | M2_COLLECT, 0, C(RED) },
	{ "Ruggo the Gnome King", S_GNOME, 16, 10, MARM(10,2), 10, -3, (G_UNIQ | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  750, 150, 0, MS_ORC, MZ_SMALL, MR_POISON | MR_STONE | MR_HITASONE, 0,
	  M1_HUMANOID, M2_PNAME | M2_PRINCE | M2_MALE | M2_COLLECT | M2_GREEDY |
	  M2_STALK | M2_HOSTILE | M2_NASTY | M2_NOPOLY | M2_JEWELS | M2_MAGIC, 0,
	  C(HI_LORD) },
#ifdef SPLITMON_1
};
#endif
#endif /* !SPLITMON_2 */

/* horrible kludge alert:
 * This is a compiler-specific kludge to allow the compilation of monst.o in
 * two pieces, by defining first SPLITMON_1 and then SPLITMON_2. The
 * resulting assembler files (monst1.s and monst2.s) are then run through
 * sed to change local symbols, concatenated together, and assembled to
 * produce monst.o. THIS ONLY WORKS WITH THE ATARI GCC, and should only
 * be done if you don't have enough memory to compile monst.o the "normal"
 * way.  --ERS
 */

#ifndef SPLITMON_1
#ifdef SPLITMON_2
struct permonst _mons2[] = {
#endif
/*      giant Humanoids */
	{ "giant", S_GIANT, 6, 6, 0, 0, 2, (G_NOHELL | G_GENO | G_NOGEN | 1),
	  { { AT_WEAP, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2250, 750, 0, MS_SILENT, MZ_HUGE, MR_HITASONE, 0,
	  M1_HUMANOID,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY | M2_COLLECT |
	  M2_JEWELS, 0, C(RED) },
	{ "stone giant", S_GIANT, 6, 6, 0, 0, 2, (G_NOHELL | G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2250, 750, 0, MS_SILENT, MZ_HUGE, MR_HITASTWO, 0,
	  M1_HUMANOID,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY | M2_COLLECT |
	  M2_JEWELS, 0, C(GRAY) },
	{ "hill giant", S_GIANT, 8, 10, 6, 0, -2, (G_NOHELL | G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2200, 700, 0, MS_SILENT, MZ_HUGE, MR_HITASTWO, 0,
	  M1_HUMANOID,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY | M2_COLLECT |
	  M2_JEWELS, 0, C(CYAN) },
	{ "fire giant", S_GIANT, 9, 12, 4, 5, 2, (G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2250, 750, 0, MS_SILENT, MZ_HUGE, MR_FIRE | MR_HITASTWO, MR_FIRE,
	  M1_HUMANOID,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY | M2_COLLECT |
	  M2_JEWELS, 0, C(YELLOW) },
	{ "frost giant", S_GIANT, 10, 12, 3, 10, -3, (G_NOHELL | G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 12 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2250, 750, 0, MS_SILENT, MZ_HUGE, MR_COLD | MR_HITASTWO, MR_COLD,
	  M1_HUMANOID,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY | M2_COLLECT |
	  M2_JEWELS, 0, C(WHITE) },
	{ "ettin", S_GIANT, 10, 12, 3, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1700, 500, 0, MS_GRUNT, MZ_HUGE, MR_HITASTWO, 0,
	  M1_ANIMAL | M1_HUMANOID | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_COLLECT, 0, C(BROWN) },
	{ "titan", S_GIANT, 16, 18, -5, 70, 9, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2300, 900, 0, MS_SILENT, MZ_HUGE, MR_DEATH, 0,
	  M1_FLY | M1_HUMANOID, M2_STRONG | M2_ROCKTHROW | M2_NASTY |
	  M2_COLLECT | M2_MAGIC, 0, C(MAGENTA) },
	{ "storm giant", S_GIANT, 16, 12, 3, 10, -3, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 12 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2250, 750, 0, MS_SILENT, MZ_HUGE, MR_ELEC, MR_ELEC,
	  M1_HUMANOID,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY | M2_COLLECT |
	  M2_JEWELS, 0, C(YELLOW) },
	{ "minotaur", S_GIANT, 15, 15, 0, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_CLAW, AD_PHYS, 3, 10 }, { AT_CLAW, AD_PHYS, 3, 10 },
	    { AT_BUTT, AD_PHYS, 2, 8}, NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 700, 0, MS_SILENT, MZ_LARGE, MR_DEATH | MR_HITASTWO, 0,
	  M1_ANIMAL | M1_HUMANOID | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY, 0, C(BROWN) },
	{ "the Largest Giant", S_GIANT, 26, 12, 0, 15, -3, (G_UNIQ | 1),
	  { { AT_WEAP, AD_PHYS, 3, 10 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2250, 750, 0, MS_SILENT, MZ_HUGE, MR_FIRE | MR_HITASTHREE | MR_POISON | MR_STONE,
	  MR_FIRE, M1_HUMANOID,
	  M2_PNAME | M2_PRINCE | M2_MALE | M2_STALK | M2_HOSTILE |
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY | M2_COLLECT |
	  M2_NOPOLY | M2_MAGIC |
	  M2_JEWELS, 0, C(HI_LORD) },
/*      Invisible stalker       */
	{ "sneaker", S_STALKER, 4, 12, 3, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  90, 30, 0, MS_SILENT, MZ_TINY, 0, 0,
	  M1_ANIMAL | M1_FLY | M1_SEE_INVIS,
	  M2_WANDER | M2_STALK | M2_HOSTILE | M2_STRONG, 0, C(CYAN) },
	{ "squeaker", S_STALKER, 6, 9, 3, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  90, 30, 0, MS_SHRIEK, MZ_TINY, 0, 0,
	  M1_ANIMAL | M1_FLY | M1_SEE_INVIS,
	  M2_WANDER | M2_STALK | M2_HOSTILE | M2_STRONG, 0, C(BRIGHT_MAGENTA) },
	{ "stalker", S_STALKER, 8, 12, 3, 0, 0, (G_NOHELL | G_GENO | 4),
	  { { AT_CLAW, AD_PHYS, 4, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  900, 400, 0, MS_SILENT, MZ_LARGE, MR_PLUSONE, 0,
	  M1_ANIMAL | M1_FLY | M1_SEE_INVIS,
	  M2_WANDER | M2_STALK | M2_HOSTILE | M2_STRONG, 0, C(WHITE) },
/*      Jabberwock */
	{ "jabberwock", S_JABBERWOCK, 15, 12, -2, 50, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 2, 10 }, { AT_BITE, AD_PHYS, 2, 10 },
	    { AT_CLAW, AD_PHYS, 2, 10 }, { AT_CLAW, AD_PHYS, 2, 10 },
	    NO_ATTK, NO_ATTK },
	  1300, 600, 0, MS_BURBLE, MZ_LARGE, MR_HITASONE, 0,
	  M1_ANIMAL | M1_FLY | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_COLLECT,
	  0, C(ORANGE_COLORED) },
	{ "vorpal jabberwock", S_JABBERWOCK, 20, 12, -2, 50, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 3, 10 }, { AT_BITE, AD_PHYS, 3, 10 },
	    { AT_CLAW, AD_PHYS, 3, 10 }, { AT_CLAW, AD_PHYS, 3, 10 },
	    NO_ATTK, NO_ATTK },
	  1300, 600, 0, MS_BURBLE, MZ_LARGE, MR_HITASTHREE, 0,
	  M1_ANIMAL | M1_FLY | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_COLLECT,
	  0, C(HI_LORD) },
/*      Kops    */
#ifdef KOPS
	{ "Keystone Kop", S_KOP, 1, 6, MARM(10,7), 10, 9,
	  (G_GENO | G_LGROUP | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 200, 0, MS_ARREST, MZ_HUMAN, 0, 0, M1_HUMANOID,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE | M2_MALE | M2_COLLECT,
	  0, C(BLUE) },
	{ "Kop Sergeant", S_KOP, 2, 8, MARM(10,6), 10, 10,
	  (G_GENO | G_SGROUP | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 200, 0, MS_ARREST, MZ_HUMAN, 0, 0, M1_HUMANOID,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE | M2_STRONG | M2_MALE | M2_COLLECT,
	  0, C(BLUE) },
	{ "Kop Lieutenant", S_KOP, 3, 10, MARM(10,5), 20, 11,
	  (G_GENO | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 200, 0, MS_ARREST, MZ_HUMAN, 0, 0, M1_HUMANOID,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE | M2_STRONG | M2_MALE | M2_COLLECT,
	  0, C(CYAN) },
	{ "Kop Kaptain", S_KOP, 4, 12, MARM(10,4), 20, 12, (G_GENO | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 200, 0, MS_ARREST, MZ_HUMAN, 0, 0, M1_HUMANOID,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE | M2_STRONG | M2_MALE | M2_COLLECT,
	  0, C(HI_LORD) },
#endif
/*      Liches   */
	{ "lich", S_LICH, 11, 6, -2, 30, -9, (G_GENO | 2),
	  { { AT_TUCH, AD_COLD, 1, 10 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 100, 0, MS_MUMBLE, MZ_HUMAN,
	  MR_COLD | MR_SLEEP | MR_POISON | MR_PLUSTWO, MR_COLD,
	  M1_BREATHLESS | M1_HUMANOID | M1_POIS | M1_REGEN,
	  M2_UNDEAD | M2_HOSTILE | M2_MAGIC, 0, C(BROWN) },
	{ "demilich", S_LICH, 14, 9, -4, 60, -12, (G_GENO | 2),
	  { { AT_TUCH, AD_COLD, 3, 4 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 100, 0, MS_MUMBLE, MZ_HUMAN,
	  MR_COLD | MR_SLEEP | MR_POISON | MR_PLUSTHREE,
	  MR_COLD, M1_BREATHLESS | M1_HUMANOID | M1_POIS | M1_REGEN,
	  M2_UNDEAD | M2_HOSTILE | M2_MAGIC, 0, C(RED) },
	{ "master lich", S_LICH, 17, 9, -8, 90, -15, (G_HELL | G_GENO | 2),
	  { { AT_TUCH, AD_COLD, 3, 6 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 100, 0, MS_MUMBLE, MZ_HUMAN,
	  MR_FIRE | MR_COLD | MR_SLEEP | MR_POISON | MR_PLUSTHREE,
	  MR_FIRE | MR_COLD, M1_BREATHLESS | M1_HUMANOID | M1_POIS | M1_REGEN,
	  M2_UNDEAD | M2_HOSTILE | M2_MAGIC, M3_WANTSBOOK, C(HI_LORD) },
	{ "arch-lich", S_LICH, 25, 9, -6, 90, -15, (G_HELL | G_GENO | 1),
	  { { AT_TUCH, AD_COLD, 5, 6 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 100, 0, MS_MUMBLE, MZ_HUMAN,
	  MR_FIRE | MR_COLD | MR_SLEEP | MR_POISON | MR_PLUSFOUR, MR_FIRE | MR_COLD,
	  M1_BREATHLESS | M1_HUMANOID | M1_POIS | M1_REGEN,
	  M2_UNDEAD | M2_HOSTILE | M2_MAGIC, M3_WANTSBOOK, C(HI_LORD) },
	{ "Vecna", S_LICH, 49, 9, -8, 90, -15, (G_UNIQ | 1),
	  { { AT_TUCH, AD_COLD, 9, 6 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 100, 0, MS_MUMBLE, MZ_HUMAN,
	  MR_FIRE | MR_COLD | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSFOUR,
	  MR_FIRE | MR_COLD,
	  M1_BREATHLESS | M1_HUMANOID | M1_POIS | M1_REGEN,
	  M2_UNDEAD | M2_STRONG | M2_PNAME | M2_PRINCE | M2_MALE | M2_GREEDY | M2_STALK |
	  M2_HOSTILE | M2_NASTY | M2_NOPOLY | M2_JEWELS | M2_COLLECT |
	  M2_MAGIC, M3_WANTSBOOK, C(HI_LORD) },
/*      Mummies         */
	{ "kobold mummy", S_MUMMY, 3, 8, 6, 20, -2, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 50, 0, MS_SILENT, MZ_SMALL,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_HOSTILE, 0, C(BROWN) },
	{ "gnome mummy", S_MUMMY, 4, 10, 6, 20, -3, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  650, 50, 0, MS_SILENT, MZ_SMALL,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_HOSTILE, 0, C(RED) },
	{ "orc mummy", S_MUMMY, 5, 10, 5, 20, -4, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  850, 75, 0, MS_SILENT, MZ_HUMAN,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_HOSTILE | M2_ORC | M2_GREEDY | M2_JEWELS, 0, C(GRAY) },
	{ "elf mummy", S_MUMMY, 6, 12, 4, 30, -5, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 175, 0, MS_SILENT, MZ_HUMAN,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_HOSTILE | M2_ELF, 0, C(GREEN) },
	{ "human mummy", S_MUMMY, 6, 12, 4, 30, -5, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 200, 0, MS_SILENT, MZ_HUMAN,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_HOSTILE, 0, C(GRAY) },
	{ "ettin mummy", S_MUMMY, 7, 12, 4, 30, -6, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 2, 6 }, { AT_CLAW, AD_PHYS, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1700, 250, 0, MS_SILENT, MZ_HUGE,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_HOSTILE | M2_STRONG, 0, C(BLUE) },
	{ "giant mummy", S_MUMMY, 8, 14, 3, 30, -7, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2050, 375, 0, MS_SILENT, MZ_HUGE,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_HOSTILE | M2_GIANT | M2_STRONG | M2_JEWELS,
	  0, C(CYAN) },
	{ "troll mummy", S_MUMMY, 9, 14, 3, 30, -8, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 375, 0, MS_SILENT, MZ_HUGE,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_HOSTILE | M2_GIANT | M2_STRONG | M2_JEWELS,
	  0, C(BROWN) },
/*      Nagas   */
	{ "red naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 100, 0, MS_MUMBLE, MZ_LARGE,
	  MR_FIRE | MR_POISON, MR_FIRE | MR_POISON,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE, M2_STRONG, 0, C(RED) },
	{ "black naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 100, 0, MS_MUMBLE, MZ_LARGE,
	  MR_POISON | MR_ACID | MR_STONE, MR_POISON | MR_STONE,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE, M2_STRONG, 0, C(BLACK) },
	{ "golden naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 100, 0, MS_MUMBLE, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE, M2_STRONG, 0, C(HI_GOLD) },
	{ "guardian naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 100, 0, MS_MUMBLE, MZ_LARGE, MR_POISON, MR_POISON,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE, M2_STRONG, 0, C(GREEN) },
	{ "red naga", S_NAGA, 6, 12, 4, 0, -4, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 4 }, { AT_BREA, AD_FIRE, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2600, 400, 0, MS_MUMBLE, MZ_HUGE,
	  MR_FIRE | MR_POISON, MR_FIRE | MR_POISON,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_OVIPAROUS,
	  M2_STRONG, 0, C(RED) },
	{ "black naga", S_NAGA, 8, 14, 2, 10, 4, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_SPIT, AD_ACID, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2600, 400, 0, MS_MUMBLE, MZ_HUGE,
	  MR_POISON | MR_ACID | MR_STONE, MR_POISON | MR_STONE,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_OVIPAROUS | M1_ACID,
	  M2_STRONG, 0, C(BLACK) },
	{ "golden naga", S_NAGA, 10, 14, 2, 70, 5, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_MAGC, AD_SPEL, 4, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2600, 400, 0, MS_MUMBLE, MZ_HUGE, MR_POISON | MR_HITASONE, MR_POISON,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_OVIPAROUS,
	  M2_STRONG, 0, C(HI_GOLD) },
	{ "guardian naga", S_NAGA, 12, 16, 0, 50, 7, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PLYS, 1, 6 }, { AT_SPIT, AD_DRST, 1, 6 },
	    { AT_HUGS, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  2600, 400, 0, MS_MUMBLE, MZ_HUGE, MR_POISON | MR_HITASONE, MR_POISON,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_OVIPAROUS | M1_POIS,
	  M2_STRONG, 0, C(GREEN) },
/*      Ogres   */
	{ "ogre", S_OGRE, 5, 10, 5, 0, -3, (G_NOHELL | G_SGROUP | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 5 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1600, 500, 0, MS_GRUNT, MZ_LARGE, 0, 0,
	  M1_HUMANOID, M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(BROWN) },
	{ "ogre lord", S_OGRE, 7, 12, 3, 30, -5, (G_NOHELL | G_GENO | 3),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1700, 700, 0, MS_GRUNT, MZ_LARGE, 0, 0, M1_HUMANOID,
	  M2_STRONG | M2_LORD | M2_MALE | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(RED) },
	{ "ogre mage", S_OGRE, 7, 12, 3, 30, -5, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, { AT_MAGC, AD_SPEL, 0, 0},
	     NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1700, 700, 0, MS_GRUNT, MZ_LARGE, 0, 0, M1_HUMANOID,
	  M2_STRONG | M2_LORD | M2_MALE | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(HI_ZAP) },
	{ "ogre king", S_OGRE, 7, 14, 4, 60, -7, (G_NOHELL | G_GENO | 3),
	  { { AT_WEAP, AD_PHYS, 3, 5 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1700, 750, 0, MS_GRUNT, MZ_LARGE, MR_HITASONE, 0, M1_HUMANOID,
	  M2_STRONG | M2_PRINCE | M2_MALE | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(HI_LORD) },
	{ "shadow ogre", S_OGRE, 10, 14, 0, 60, -7, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 3, 5 }, { AT_TUCH, AD_DRLI, 3, 5 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1700, 750, 0, MS_GRUNT, MZ_LARGE, MR_PLUSONE, 0, M1_HUMANOID,
	  M2_STRONG | M2_PRINCE | M2_MALE | M2_GREEDY | M2_JEWELS | M2_COLLECT,
	  0, C(BLACK) },
/*      Puddings */
	{ "gray ooze", S_PUDDING, 3, 1, 8, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_BITE, AD_RUST, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 250, 0, MS_SILENT, MZ_MEDIUM,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_POISON | MR_ACID | MR_STONE,
	  MR_FIRE | MR_COLD | MR_POISON,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_OMNIVORE | M1_ACID,
	  M2_HOSTILE | M2_NEUTER, 0, C(GRAY) },
	{ "brown pudding", S_PUDDING, 5, 3, 8, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_DCAY, 0, 0 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 250, 0, MS_SILENT, MZ_MEDIUM,
	  MR_DEATH | MR_COLD | MR_ELEC | MR_POISON | MR_ACID | MR_STONE | MR_HITASONE,
	  MR_COLD | MR_ELEC | MR_POISON,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_OMNIVORE | M1_ACID,
	  M2_HOSTILE | M2_NEUTER, 0, C(BROWN) },
	{ "moldy pudding", S_PUDDING, 8, 3, 8, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_ENGL, AD_ACID, 4, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 250, 0, MS_SILENT, MZ_MEDIUM,
	  MR_DEATH | MR_COLD | MR_ELEC | MR_POISON | MR_ACID | MR_STONE | MR_HITASONE,
	  MR_COLD | MR_ELEC | MR_POISON,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_OMNIVORE | M1_ACID,
	  M2_HOSTILE | M2_NEUTER, 0, C(GREEN) },
	{ "black pudding", S_PUDDING, 10, 6, 6, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_RUST, 3, 8 }, { AT_NONE, AD_RUST, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  900, 250, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_COLD | MR_ELEC | MR_POISON | MR_ACID | MR_STONE | MR_HITASTWO,
	  MR_COLD | MR_ELEC | MR_POISON,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_OMNIVORE | M1_ACID,
	  M2_HOSTILE | M2_NEUTER, 0, C(BLACK) },
	{ "green slime", S_PUDDING, 6, 6, 6, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_TUCH, AD_SLIM, 1, 4 }, { AT_NONE, AD_SLIM, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 150, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_COLD | MR_ELEC | MR_POISON | MR_ACID | MR_STONE | MR_HITASTWO,
	  MR_COLD | MR_ELEC | MR_POISON,
	  M1_BREATHLESS | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_NOHEAD |
	  M1_MINDLESS | M1_OMNIVORE | M1_ACID | M1_POIS,
	  M2_HOSTILE | M2_NEUTER, 0, C(GREEN) },
/*      Quantum Mechanics       */
	{ "quantum mechanic", S_QUANTMECH, 7, 12, 3, 10, 0, (G_NOHELL | G_GENO | 4),
	  { { AT_CLAW, AD_TLPT, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 20, 0, MS_HUMANOID, MZ_HUMAN, MR_POISON | MR_HITASONE, 0,
	  M1_HUMANOID | M1_POIS | M1_TPORT, M2_HOSTILE, 0, C(CYAN) },
/*      Rust Monster    */
	{ "rust monster", S_RUSTMONST, 5, 18, 2, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_TUCH, AD_RUST, 0, 0 }, { AT_TUCH, AD_RUST, 0, 0 },
	    { AT_NONE, AD_RUST, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1000, 250, 0, MS_SILENT, MZ_MEDIUM, MR_HITASONE, 0,
	  M1_SWIM | M1_ANIMAL | M1_NOHANDS | M1_METALLIVORE, M2_HOSTILE,
	  0, C(BROWN) },
/*      Snakes  */
	{ "garter snake", S_SNAKE, 1, 8, 8, 0, 0, (G_NOHELL | G_LGROUP | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 60, 0, MS_HISS, MZ_TINY, 0, 0,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY |
	  M1_OVIPAROUS | M1_CARNIVORE, 0, 0, C(GREEN) },
	{ "snake", S_SNAKE, 4, 15, 3, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_BITE, AD_DRST, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 80, 0, MS_HISS, MZ_SMALL, MR_POISON, MR_POISON,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY | M1_POIS |
	  M1_OVIPAROUS | M1_CARNIVORE, M2_HOSTILE, 0, C(BROWN) },
	{ "water moccasin", S_SNAKE, 4, 15, 3, 0, 0,
	  (G_GENO | G_NOGEN | G_LGROUP),
	  { { AT_BITE, AD_DRST, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  150, 80, 0, MS_HISS, MZ_SMALL, MR_POISON, MR_POISON,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY | M1_POIS |
	  M1_CARNIVORE | M1_OVIPAROUS, M2_HOSTILE, 0, C(RED) },
	{ "pit viper", S_SNAKE, 6, 15, 2, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_DRST, 1, 4 }, { AT_BITE, AD_DRST, 1, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 60, 0, MS_HISS, MZ_MEDIUM,
	  MR_POISON, MR_POISON,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY | M1_POIS |
	  M1_CARNIVORE | M1_OVIPAROUS, M2_HOSTILE, 0, C(BLUE) },
	{ "python", S_SNAKE, 6, 3, 5, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_DRST, 1, 4 }, {AT_BITE, AD_PHYS, 1, 4},
	    { AT_HUGS, AD_WRAP, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  250, 100, 0, MS_HISS, MZ_LARGE, MR_POISON | MR_HITASONE, MR_POISON,
	  M1_SWIM | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY | M1_POIS |
	  M1_CARNIVORE | M1_OVIPAROUS, M2_HOSTILE | M2_STRONG, 0, C(MAGENTA) },
	{ "cobra", S_SNAKE, 6, 18, 2, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_DRST, 2, 4 }, { AT_SPIT, AD_BLND, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  250, 100, 0, MS_HISS, MZ_MEDIUM,
	  MR_POISON, MR_POISON,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY | M1_POIS |
	  M1_CARNIVORE | M1_OVIPAROUS, M2_HOSTILE, 0, C(BLUE) },
	{ "king cobra", S_SNAKE, 9, 15, 2, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_DRST, 3, 4 }, { AT_BITE, AD_DRST, 3, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 120, 0, MS_HISS, MZ_MEDIUM,
	  MR_POISON, MR_POISON,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY | M1_POIS |
	  M1_CARNIVORE | M1_OVIPAROUS, M2_HOSTILE, 0, C(GRAY) },
	{ "weresnake", S_SNAKE, 9, 12, 2, 20, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 3, 6 }, { AT_BITE, AD_DRST, 2, 6 },
	      NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 120, 0, MS_HISS, MZ_MEDIUM, MR_POISON, 0,
	  M1_NOLIMBS | M1_SWIM | M1_SLITHY | M1_POIS | M1_REGEN | M1_CARNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE, 0, C(BROWN) },
	{ "asphynx", S_SNAKE, 8, 15, 3, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_STON, 1, 6 }, { AT_NONE, AD_STON, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 80, 0, MS_HISS, MZ_SMALL, MR_POISON | MR_STONE, MR_POISON | MR_STONE,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY | M1_POIS |
	  M1_OVIPAROUS | M1_CARNIVORE, M2_HOSTILE, 0, C(BLACK) },
/*      Trolls  */
	{ "troll", S_TROLL, 7, 12, 4, 0, -3, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 4, 2 }, { AT_CLAW, AD_PHYS, 4, 2 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  800, 350, 0, MS_GRUNT, MZ_LARGE, MR_HITASONE, 0,
	  M1_HUMANOID | M1_REGEN | M1_CARNIVORE,
	  M2_STRONG | M2_STALK | M2_HOSTILE, 0, C(BROWN) },
	{ "ice troll", S_TROLL, 9, 10, 2, 20, -3, (G_NOHELL | G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 2, 6 }, { AT_CLAW, AD_COLD, 2, 6 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1000, 300, 0, MS_GRUNT, MZ_LARGE, MR_COLD | MR_HITASONE, MR_COLD,
	  M1_HUMANOID | M1_REGEN | M1_CARNIVORE,
	  M2_STRONG | M2_STALK | M2_HOSTILE, 0, C(WHITE) },
	{ "rock troll", S_TROLL, 9, 12, 0, 0, -3, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 300, 0, MS_GRUNT, MZ_LARGE, MR_HITASTWO, 0,
	  M1_HUMANOID | M1_REGEN | M1_CARNIVORE,
	  M2_STRONG | M2_STALK | M2_HOSTILE | M2_COLLECT, 0, C(CYAN) },
	{ "two-headed troll", S_TROLL, 10, 12, 8, 0, -3, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_BITE, AD_PHYS, 1, 10 }, { AT_BITE, AD_PHYS, 1, 10 },
	     NO_ATTK, NO_ATTK },
	  1200, 300, 0, MS_GRUNT, MZ_LARGE, MR_HITASTWO, 0,
	  M1_HUMANOID | M1_REGEN | M1_CARNIVORE,
	  M2_STRONG | M2_STALK | M2_HOSTILE | M2_COLLECT, 0, C(GREEN) },
	{ "water troll", S_TROLL, 11, 14, 4, 40, -3, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_CLAW, AD_PHYS, 2, 8 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 350, 0, MS_GRUNT, MZ_LARGE, MR_HITASTWO, 0,
	  M1_HUMANOID | M1_REGEN | M1_CARNIVORE | M1_SWIM,
	  M2_STRONG | M2_STALK | M2_HOSTILE, 0, C(BLUE) },
	{ "Olog-hai", S_TROLL, 13, 12, -4, 0, -7, (G_NOHELL | G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 400, 0, MS_GRUNT, MZ_LARGE, MR_HITASTWO, 0,
	  M1_HUMANOID | M1_REGEN | M1_CARNIVORE,
	  M2_STRONG | M2_STALK | M2_HOSTILE | M2_COLLECT, 0, C(HI_LORD) },
	{ "black troll", S_TROLL, 17, 12, -4, 0, -7, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 3, 8 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 400, 0, MS_GRUNT, MZ_LARGE, MR_HITASTHREE, 0,
	  M1_HUMANOID | M1_REGEN | M1_CARNIVORE,
	  M2_STRONG | M2_STALK | M2_HOSTILE | M2_COLLECT, 0, C(BLACK) },
/*      Umber Hulk      */
	{ "umber hulk", S_UMBER, 9, 6, 2, 25, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    { AT_BITE, AD_PHYS, 2, 5 }, { AT_GAZE, AD_CONF, 0, 0 },
	    NO_ATTK, NO_ATTK },
	  1200, 500, 0, MS_SILENT, MZ_LARGE, MR_HITASONE, 0,
	  M1_TUNNEL | M1_CARNIVORE, M2_STRONG, 0, C(BROWN) },
	{ "water hulk", S_UMBER, 11, 6, 2, 25, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    { AT_BITE, AD_PHYS, 2, 5 }, { AT_GAZE, AD_CONF, 0, 0 },
	    NO_ATTK, NO_ATTK },
	  1200, 500, 0, MS_SILENT, MZ_LARGE, MR_HITASONE, 0,
	  M1_SWIM | M1_TUNNEL | M1_CARNIVORE, M2_STRONG, 0, C(GREEN) },
/*      Vampires        */
	{ "vampire", S_VAMPIRE, 10, 12, -1, 25, -8, (G_GENO | 2),
	  { { AT_CLAW, AD_DRLI, 2, 4 }, { AT_BITE, AD_DRLI, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_VAMPIRE, MZ_HUMAN, MR_SLEEP | MR_POISON |
	  MR_PLUSTWO, 0, M1_FLY | M1_BREATHLESS | M1_HUMANOID |
	  M1_POIS | M1_REGEN, M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_STRONG |
	  M2_NASTY, 0, C(RED) },
	{ "vampire lord", S_VAMPIRE, 12, 14, -4, 50, -9, (G_GENO | 2),
	  { { AT_CLAW, AD_DRLI, 2, 8 }, { AT_BITE, AD_DRLI, 1, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_VAMPIRE, MZ_HUMAN, MR_SLEEP | MR_POISON |
	  MR_PLUSTHREE, 0, M1_FLY | M1_BREATHLESS |
	  M1_HUMANOID | M1_POIS | M1_REGEN, M2_UNDEAD | M2_STALK |
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_LORD | M2_MALE, 0, C(BLUE) },
	{ "vampire mage", S_VAMPIRE, 20, 14, -4, 50, -9, (G_GENO | 1),
	  { { AT_CLAW, AD_DRLI, 2, 8 }, { AT_BITE, AD_DRLI, 1, 8 },
	    { AT_MAGC, AD_SPEL, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_VAMPIRE, MZ_HUMAN, MR_SLEEP | MR_POISON |
	  MR_PLUSTHREE, 0, M1_FLY | M1_BREATHLESS |
	  M1_HUMANOID | M1_POIS | M1_REGEN, M2_UNDEAD | M2_STALK |
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_LORD | M2_MALE | M2_MAGIC, 0, C(HI_ZAP) },
	{ "Vlad the Impaler", S_VAMPIRE, 40, 18, -8, 80, -10,
	  (G_NOGEN | G_NOCORPSE | G_UNIQ),
	  { { AT_WEAP, AD_DRLI, 2, 12 }, { AT_BITE, AD_DRLI, 2, 12 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_VAMPIRE, MZ_HUMAN, MR_SLEEP | MR_POISON |
	  MR_PLUSTHREE, 0, M1_FLY | M1_BREATHLESS | M1_HUMANOID |
	  M1_POIS | M1_REGEN, M2_NOPOLY | M2_UNDEAD | M2_STALK | M2_HOSTILE |
	  M2_PNAME | M2_STRONG | M2_NASTY | M2_PRINCE | M2_MALE, M3_WAITFORU |
	  M3_WANTSBOOK, C(HI_LORD) },
/*      Wraiths         */
	{ "barrow wight", S_WRAITH, 3, 12, 5, 5, -3, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    { AT_WEAP, AD_DRLI, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 0, 0, MS_SILENT, MZ_HUMAN, MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_HUMANOID,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_COLLECT, 0, C(GREEN) },
	{ "wight", S_WRAITH, 5, 12, 5, 5, -3, (G_GENO | 1),
	  { { AT_CLAW, AD_DRLI, 1, 4 }, { AT_BITE, AD_PHYS, 2, 3 },
	    { AT_CLAW, AD_DRLI, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1200, 0, 0, MS_SILENT, MZ_HUMAN, MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_HUMANOID,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_COLLECT, 0, C(GRAY) },
	{ "wraith", S_WRAITH, 6, 12, 4, 15, -6, (G_GENO | G_NOCORPSE | 3),
	  { { AT_TUCH, AD_DRLI, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_HUMAN,
	  MR_COLD | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSONE | MR_HITASTWO, 0,
	  M1_BREATHLESS | M1_FLY | M1_HUMANOID | M1_UNSOLID,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE, 0, C(BLACK) },
	{ "Nazgul", S_WRAITH, 13, 12, 0, 25, -17, (G_GENO | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_DRLI, 1, 4 }, { AT_BREA, AD_SLEE, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 0, 0, MS_SILENT, MZ_HUMAN,
	  MR_COLD | MR_SLEEP | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0,
	  M1_BREATHLESS | M1_HUMANOID, M2_UNDEAD | M2_STALK | M2_STRONG |
	  M2_HOSTILE | M2_MALE | M2_COLLECT, 0, C(HI_LORD) },
/*      Xorn    */
	{ "xorn", S_XORN, 8, 9,-2, 20, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_CLAW, AD_PHYS, 1, 3 }, { AT_BITE, AD_PHYS, 4, 6 },
	    NO_ATTK, NO_ATTK }, 1200, 700, 0, MS_SILENT, MZ_MEDIUM,
	  MR_FIRE | MR_COLD | MR_STONE | MR_HITASONE, MR_FIRE | MR_COLD |
	  MR_STONE, M1_BREATHLESS | M1_WALLWALK | M1_THICK_HIDE |
	  M1_METALLIVORE, M2_HOSTILE | M2_STRONG, 0, C(BROWN) },
/*      Yeti, Apes and other large beasts */
	{ "monkey", S_YETI, 2, 12, 6, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 50, 0, MS_GROWL, MZ_SMALL, 0, 0,
	  M1_ANIMAL | M1_HUMANOID | M1_CARNIVORE,
	  0, 0, C(GRAY) },
	{ "ape", S_YETI, 4, 12, 6, 0, 0, (G_NOHELL | G_GENO | G_SGROUP | 3),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1100, 500, 0, MS_GROWL, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_HUMANOID | M1_CARNIVORE,
	  M2_STRONG, 0, C(BROWN) },
	{ "owlbear", S_YETI, 5, 12, 5, 0, 0, (G_NOHELL | G_GENO | 4),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_HUGS, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1700, 700, 0, MS_SILENT, MZ_LARGE, MR_HITASONE, 0,
	  M1_ANIMAL | M1_HUMANOID | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG | M2_NASTY, 0, C(BROWN) },
	{ "yeti", S_YETI, 5, 15, 6, 0, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1600, 700, 0, MS_GROWL, MZ_LARGE, MR_COLD | MR_HITASONE, MR_COLD,
	  M1_ANIMAL | M1_HUMANOID | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(WHITE) },
	{ "carnivorous ape", S_YETI, 6, 12, 6, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_HUGS, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1250, 550, 0, MS_GROWL, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_HUMANOID | M1_CARNIVORE,
	  M2_HOSTILE | M2_STRONG, 0, C(BLACK) },
	{ "sasquatch", S_YETI, 7, 15, 6, 0, 2, (G_NOHELL | G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_KICK, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1550, 750, 0, MS_GROWL, MZ_LARGE, MR_HITASONE, 0,
	  M1_ANIMAL | M1_HUMANOID | M1_SEE_INVIS | M1_OMNIVORE,
	  M2_STRONG, 0, C(GRAY) },
/*      Zombies         */
	{ "kobold zombie", S_ZOMBIE, 0, 6, 10, 0, -2, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 50, 0, MS_SILENT, MZ_SMALL,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE, 0, C(BROWN) },
	{ "gnome zombie", S_ZOMBIE, 1, 6, 10, 0, -2, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 5 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  650, 50, 0, MS_SILENT, MZ_SMALL,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE, 0, C(BROWN) },
	{ "orc zombie", S_ZOMBIE, 2, 6, 9, 0, -3,
	  (G_GENO | G_SGROUP | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  850, 75, 0, MS_SILENT, MZ_HUMAN,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_ORC, 0, C(GRAY) },
	{ "elf zombie", S_ZOMBIE, 3, 6, 9, 0, -3,
	  (G_GENO | G_SGROUP | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 7 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 175, 0, MS_SILENT, MZ_HUMAN,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_ELF, 0, C(GREEN) },
	{ "human zombie", S_ZOMBIE, 4, 6, 8, 0, -3,
	  (G_GENO | G_SGROUP | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 200, 0, MS_SILENT, MZ_HUMAN,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE, 0, C(HI_DOMESTIC) },
	{ "ghoul", S_ZOMBIE, 3, 6, 10, 0, -2, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PLYS, 1, 2 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 4}, NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 50, 0, MS_SILENT, MZ_SMALL,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE, 0, C(BLACK) },
	{ "ettin zombie", S_ZOMBIE, 6, 8, 6, 0, -4, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 10 }, { AT_CLAW, AD_PHYS, 1, 10 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1700, 250, 0, MS_SILENT, MZ_HUGE,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_STRONG, 0, C(BLUE) },
	{ "ghast", S_ZOMBIE, 4, 6, 10, 0, -2, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PLYS, 1, 2 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 50, 0, MS_SILENT, MZ_SMALL,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE, 0, C(MAGENTA) },
	{ "giant zombie", S_ZOMBIE, 8, 8, 6, 0, -4, (G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_CLAW, AD_PHYS, 2, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2050, 375, 0, MS_SILENT, MZ_HUGE,
	  MR_COLD | MR_SLEEP | MR_POISON, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_GIANT | M2_STRONG,
	  0, C(CYAN) },
	{ "skeleton", S_ZOMBIE, 12, 8, 4, 0, 0, (G_NOCORPSE | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, { AT_TUCH, AD_SLOW, 1, 6},
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  300, 5, 0, MS_BONES, MZ_HUMAN,
	  MR_COLD | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSTWO, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_THICK_HIDE,
	  M2_UNDEAD | M2_WANDER | M2_HOSTILE | M2_STRONG | M2_COLLECT,
	  0, C(WHITE) },
/*      Golems  */
	{ "straw golem", S_GOLEM, 3, 12, 10, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 2 }, { AT_CLAW, AD_PHYS, 1, 2 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  400, 0, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_SLEEP | MR_POISON | MR_HITASONE, 0, M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID,
	  M2_HOSTILE | M2_NEUTER, 0, C(YELLOW) },
	{ "rope golem", S_GOLEM, 4, 9, 8, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_HUGS, AD_PHYS, 6, 1 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  450, 0, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_SLEEP | MR_POISON | MR_HITASONE, 0, M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID,
	  M2_HOSTILE | M2_NEUTER, 0, C(BROWN) },
	{ "leather golem", S_GOLEM, 6, 6, 6, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  800, 0, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_SLEEP | MR_POISON | MR_HITASONE, 0, M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID,
	  M2_HOSTILE | M2_NEUTER, 0, C(HI_LEATHER) },
	{ "wood golem", S_GOLEM, 7, 3, 4, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  900, 0, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_SLEEP | MR_POISON | MR_HITASONE, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_THICK_HIDE,
	  M2_HOSTILE | M2_NEUTER, 0, C(HI_WOOD) },
	{ "gargoyle", S_GOLEM, 4, 9, 5, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3},
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  900, 0, 0, MS_SILENT, MZ_HUMAN,
	  MR_DEATH | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSONE, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_THICK_HIDE,
	  M2_HOSTILE, 0, C(GRAY) },
	{ "flesh golem", S_GOLEM, 9, 8, 9, 30, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_CLAW, AD_PHYS, 2, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1400, 600, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_PLUSONE |
	  MR_HITASTWO, MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID,
	  M2_HOSTILE | M2_STRONG, 0, C(RED) },
	{ "clay golem", S_GOLEM, 11, 7, 4, 40, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 3, 10 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1550, 0, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_SLEEP | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_THICK_HIDE,
	  M2_HOSTILE | M2_STRONG, 0, C(BROWN) },
	{ "stone golem", S_GOLEM, 14, 6, 2, 50, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 3, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1900, 0, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSTWO, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_THICK_HIDE,
	  M2_HOSTILE | M2_STRONG, 0, C(GRAY) },
	{ "iron golem", S_GOLEM, 18, 6, 0, 60, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_PHYS, 4, 10 }, { AT_BREA, AD_DRST, 4, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2000, 0, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_PLUSTWO, 0,
	  M1_BREATHLESS | M1_MINDLESS | M1_HUMANOID | M1_THICK_HIDE | M1_POIS,
	  M2_HOSTILE | M2_STRONG | M2_COLLECT, 0, C(HI_METAL) },
/*      Humans          */
	{ "human", S_HUMAN, 0, 12, 10, 0, 0, G_NOGEN, /* for corpses */
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(HI_DOMESTIC) },
	{ "wererat", S_HUMAN, 2, 12, MARM(10,7), 10, -7, 1,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_HUMAN, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS | M1_REGEN | M1_OMNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE | M2_HUMAN | M2_COLLECT, 0, C(BROWN) },
	{ "werejackal", S_HUMAN, 2, 12, MARM(10,7), 10, -7, 1,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_BARK, MZ_HUMAN, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS | M1_REGEN | M1_OMNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE | M2_HUMAN | M2_COLLECT, 0, C(RED) },
	{ "werewolf", S_HUMAN, 10, 12, MARM(10,6), 20, -7, 1,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_BARK, MZ_HUMAN, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS | M1_REGEN | M1_OMNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE | M2_HUMAN | M2_COLLECT,
	  0, C(ORANGE_COLORED) },
	{ "jackalwere", S_HUMAN, 3, 12, 4, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 2 }, { AT_GAZE, AD_SLEE, 1, 2},
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 250, 0, MS_BARK, MZ_HUMAN, 0, 0,
	  M1_ANIMAL | M1_CARNIVORE, M2_HOSTILE | M2_NASTY, 0,
	  C(BROWN) },
	{ "gibberling", S_HUMAN, 1, 12, 10, 0, -2, (G_NOHELL | G_GENO | G_VLGROUP  | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_WAIL, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_COLLECT, 0, C(GRAY) },
	{ "grimlock", S_HUMAN, 2, 12, 5, 0, -2, (G_NOHELL | G_GENO | G_VLGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GRUNT, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE | M1_NOEYES,
	  M2_NOPOLY | M2_HUMAN | M2_COLLECT, 0, C(BLACK) },
	{ "Woodland-elf", S_HUMAN, 4, 12, MARM(8,5), 10, 5,
	  (G_NOHELL | G_GENO | G_SGROUP | 3),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_HUMANOID, MZ_HUMAN, MR_SLEEP, MR_SLEEP,
	  M1_HUMANOID | M1_OMNIVORE, M2_ELF | M2_COLLECT, 0, C(GREEN) },
	{ "Green-elf", S_HUMAN, 5, 12, MARM(7,4), 10, 6,
	  (G_NOHELL | G_GENO | G_SGROUP | 3),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_HUMANOID, MZ_HUMAN, MR_SLEEP, MR_SLEEP,
	  M1_HUMANOID | M1_OMNIVORE, M2_ELF | M2_COLLECT, 0, C(BRIGHT_GREEN) },
	{ "Grey-elf", S_HUMAN, 6, 12, MARM(7,4), 10, 7,
	  (G_NOHELL | G_GENO | G_SGROUP | 3),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_HUMANOID, MZ_HUMAN, MR_SLEEP, MR_SLEEP,
	  M1_HUMANOID | M1_OMNIVORE, M2_ELF | M2_COLLECT, 0, C(GRAY) },
	{ "elf-lord", S_HUMAN, 8, 12, MARM(6,3), 20, 9,
	  (G_NOHELL | G_GENO | G_SGROUP | 3),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_HUMANOID, MZ_HUMAN, MR_SLEEP, MR_SLEEP,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_ELF | M2_STRONG | M2_LORD | M2_MALE | M2_COLLECT,
	  0, C(BRIGHT_BLUE) },
	{ "drow", S_HUMAN, 6, 12, MARM(4,0), 60, -9,
	  (G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_SLEE, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_HUMANOID, MZ_HUMAN, MR_SLEEP, MR_SLEEP,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_ELF | M2_STRONG | M2_LORD | M2_MALE | M2_COLLECT | M2_HOSTILE,
	  0, C(BLACK) },
	{ "Elvenking", S_HUMAN, 9, 12, MARM(6,3), 25, 10, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4},
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_HUMANOID, MZ_HUMAN,
	  MR_SLEEP | MR_HITASONE, MR_SLEEP, M1_HUMANOID | M1_OMNIVORE,
	  M2_ELF | M2_STRONG | M2_PRINCE | M2_MALE | M2_COLLECT, 0,
	  C(HI_LORD) },
	{ "mugger", S_HUMAN, 2, 12, MARM(10,7), 0, -8, (G_GENO | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, NO_ATTK,
		NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_HOSTILE | M2_COLLECT, 0, C(BLACK) },
	{ "thief", S_HUMAN, 4, 12, MARM(10,7), 0, -8, (G_NOHELL | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_TUCH, AD_SITM, 0, 0 },
		NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_HOSTILE | M2_COLLECT, 0, C(BLACK) },
	{ "werepanther", S_HUMAN, 5, 15, MARM(10,6), 20, -7, 1,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GROWL, MZ_HUMAN, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS | M1_REGEN | M1_OMNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE | M2_HUMAN | M2_COLLECT,
	  0, C(BLACK) },
	{ "weretiger", S_HUMAN, 7, 12, MARM(10,5), 20, -7, 1,
	  { { AT_WEAP, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GROWL, MZ_HUMAN, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS | M1_REGEN | M1_OMNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE | M2_HUMAN | M2_COLLECT,
	  0, C(YELLOW) },
	{ "weresnake", S_HUMAN, 9, 12, MARM(10,3), 20, -7, 1,
	  { { AT_WEAP, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HISS, MZ_HUMAN, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS | M1_REGEN | M1_OMNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE | M2_HUMAN | M2_COLLECT,
	  0, C(BROWN) },
	{ "werespider", S_HUMAN, 9, 12, MARM(10,3), 20, -7, 1,
	  { { AT_WEAP, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HISS, MZ_HUMAN, MR_POISON, 0,
	  M1_HUMANOID | M1_POIS | M1_REGEN | M1_OMNIVORE,
	  M2_NOPOLY | M2_WERE | M2_HOSTILE | M2_HUMAN | M2_COLLECT,
	  0, C(BLACK) },
	{ "nurse", S_HUMAN, 11, 6, 0, 0, 0, (G_NOHELL | G_GENO | 4),
	  { { AT_CLAW, AD_HEAL, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NURSE, MZ_HUMAN, MR_POISON, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE, M2_NOPOLY | M2_HUMAN | M2_HOSTILE,
	  0, C(HI_DOMESTIC) },
	{ "shopkeeper", S_HUMAN, 20, 18, 0, 50, 0, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 3, 10 }, { AT_WEAP, AD_PHYS, 3, 10 },
	    { AT_WEAP, AD_PHYS, 3, 10 }, { AT_WEAP, AD_PHYS, 3, 10 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, sizeof(struct eshk), MS_SELL, MZ_HUMAN,
	  MR_SLEEP | MR_DEATH | MR_HITASFOUR | MR_POISON, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG |
	  M2_COLLECT | M2_MAGIC,
	  0, C(HI_DOMESTIC) },
#ifdef BLACKMARKET
/* the black marketeer's speed (24) matches the speed boots he's wearing */
	{ "black marketeer", S_HUMAN, 25, 24, -6, 50, -2, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 4, 10 }, NO_ATTK, NO_ATTK,
	      NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, sizeof(struct eshk), MS_SELL, MZ_HUMAN,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_SLEEP | MR_ELEC | MR_STONE | MR_HITASFOUR,
	  MR_SLEEP, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG |
	  M2_COLLECT | M2_MAGIC | M2_MALE,
	  0, C(BLACK) },
#endif /* BLACKMARKET */
	{ "guard", S_HUMAN, 12, 12, MARM(10,-1), 40, 10, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 4, 10 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, sizeof(struct egd), MS_GUARD, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_MERC | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(BLUE) },
	{ "oracle", S_HUMAN, 12, 0, 0, 50, 0, G_NOGEN | G_UNIQ,
	  { { AT_NONE, AD_MAGM, 0, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_ORACLE, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_FEMALE, 0, C(HI_ZAP) },
	{ "aligned priest", S_HUMAN, 12, 12, MARM(10,0), 50, 0, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 4, 10 }, { AT_KICK, AD_PHYS, 1, 4 },
	    { AT_MAGC, AD_CLRC, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, sizeof(struct epri), MS_PRIEST, MZ_HUMAN,
	  MR_DEATH | MR_ELEC | MR_HITASFOUR, MR_ELEC, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_LORD | M2_PEACEFUL | M2_COLLECT,
	  0, C(WHITE) },
	{ "high priest", S_HUMAN, 35, 15, MARM(7,-8), 70, 0,
	   (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 4, 10 }, { AT_KICK, AD_PHYS, 2, 8 },
	    { AT_MAGC, AD_CLRC, 2, 8 }, { AT_MAGC, AD_CLRC, 2, 8 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, sizeof(struct epri), MS_PRIEST, MZ_HUMAN,
	  MR_DEATH | MR_FIRE | MR_ELEC | MR_SLEEP | MR_POISON | MR_HITASFOUR,
	  MR_FIRE | MR_ELEC | MR_SLEEP | MR_POISON,
	  M1_HUMANOID | M1_SEE_INVIS | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_MINION | M2_PRINCE | M2_NASTY |
	  M2_COLLECT | M2_MAGIC, 0, C(WHITE) },
#ifndef MUSE
	{ "unarmored watchman", S_HUMAN, 6, 4, 10, 0, -2, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_MERC | M2_STALK | M2_PEACEFUL | M2_STRONG |
	  M2_COLLECT, 0, C(BROWN) },
#endif
#ifdef ARMY
# ifndef MUSE
	{ "unarmored soldier", S_HUMAN, 6, 4, 10, 0, -2, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_MERC | M2_STALK | M2_HOSTILE | M2_STRONG |
	  M2_COLLECT, 0, C(BROWN) },
# endif
	{ "soldier", S_HUMAN, 6, 4, MARM(10,3), 0, -2, (G_SGROUP | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_MERC | M2_STALK | M2_HOSTILE | M2_STRONG |
	  M2_COLLECT, 0, C(GRAY) },
	{ "sergeant", S_HUMAN, 8, 4, MARM(10,0), 5, -3, (G_SGROUP | G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_MERC | M2_STALK | M2_HOSTILE | M2_STRONG |
	  M2_COLLECT, 0, C(RED) },
	{ "lieutenant", S_HUMAN, 10, 4, MARM(10,-2), 15, -4, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 3, 4 }, { AT_WEAP, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_MERC | M2_STALK | M2_HOSTILE | M2_STRONG |
	  M2_COLLECT, 0, C(GREEN) },
	{ "captain", S_HUMAN, 12, 4, MARM(10,-3), 15, -5, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 4, 4 }, { AT_WEAP, AD_PHYS, 4, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_MERC | M2_STALK | M2_HOSTILE | M2_STRONG |
	  M2_COLLECT, 0, C(BLUE) },
#endif
/*
 *      Keep these separate - some of the mkroom code assumes that all
 *      the soldiers are contiguous.
 */
	{ "watchman", S_HUMAN, 6, 4, MARM(10,3), 0, -2, (G_SGROUP | G_NOGEN | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_MERC | M2_STALK | M2_PEACEFUL | M2_STRONG |
	  M2_COLLECT, 0, C(GRAY) },
	{ "watch captain", S_HUMAN, 10, 4, MARM(10,-2), 15, -4, (G_NOGEN | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 3, 4 }, { AT_WEAP, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  0, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_MERC | M2_STALK | M2_PEACEFUL | M2_STRONG |
	  M2_COLLECT, 0, C(GREEN) },
	{ "Medusa", S_HUMAN, 20, 12, -5, 50, -15, G_NOGEN | G_UNIQ,
	  { { AT_CLAW, AD_PHYS, 1, 8 }, { AT_GAZE, AD_STON, 0, 0 },
	    { AT_BITE, AD_DRST, 1, 6 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HISS, MZ_LARGE,
	  MR_DEATH | MR_POISON | MR_STONE | MR_HITASFOUR, MR_POISON | MR_STONE, M1_FLY | M1_SWIM |
	  M1_AMPHIBIOUS | M1_HUMANOID | M1_POIS | M1_OMNIVORE,
	  M2_NOPOLY | M2_HOSTILE | M2_STRONG | M2_PNAME | M2_FEMALE,
	  M3_WAITFORU, C(BRIGHT_GREEN) },
	{ "Wizard of Yendor", S_HUMAN, 30, 12, -15, 100, A_NONE, G_NOGEN,
	  { { AT_CLAW, AD_SAMU, 2, 12 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_CUSS, MZ_HUMAN,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_HITASFOUR, MR_FIRE | MR_POISON,
	  M1_FLY | M1_BREATHLESS | M1_HUMANOID | M1_REGEN | M1_SEE_INVIS |
	  M1_TPORT | M1_TPORT_CNTRL | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_HOSTILE | M2_STRONG | M2_NASTY |
	  M2_PRINCE | M2_MALE | M2_MAGIC,
	  M3_COVETOUS | M3_WAITFORU, C(HI_LORD) },
#ifdef MULDGN
	{ "Croesus", S_HUMAN, 20, 15, -5, 40, 15, (G_UNIQ | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 4, 10 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARD, MZ_HUMAN,
	  MR_STONE | MR_HITASFOUR, MR_STONE, M1_HUMANOID | M1_SEE_INVIS | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STALK | M2_HOSTILE | M2_STRONG | M2_NASTY |
	  M2_PNAME | M2_PRINCE | M2_MALE | M2_GREEDY | M2_JEWELS | M2_COLLECT |
	  M2_MAGIC, 0, C(HI_LORD) },
#endif
#ifdef CHARON
	{ "Charon", S_HUMAN, 76, 18, -5, 120, 0,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, { AT_TUCH, AD_PLYS, 1, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_FERRY, MZ_HUMAN,
	  MR_FIRE | MR_COLD | MR_POISON | MR_STONE | MR_PLUSTHREE | MR_HITASFOUR, 0,
	  M1_BREATHLESS | M1_SEE_INVIS | M1_HUMANOID,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_PNAME | M2_MALE | M2_GREEDY |
	  M2_COLLECT,
	  0, C(WHITE) },
#endif
/*      Ghosts          */
	{ "shadow", S_GHOST, 4, 9, 4, 0, 0, (G_NOCORPSE | 1),
	  { { AT_TUCH, AD_DRST, 1, 4 }, { AT_TUCH, AD_COLD, 1, 4},
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 0, 0, MS_WAIL, MZ_HUMAN,
	  MR_COLD | MR_DISINT | MR_SLEEP | MR_POISON | MR_STONE, 0,
	  M1_FLY | M1_BREATHLESS | M1_WALLWALK | M1_HUMANOID | M1_SEE_INVIS,
	  M2_NOPOLY | M2_UNDEAD | M2_WANDER | M2_HOSTILE | M2_NASTY,
	  0, C(BLACK) },
	{ "ghost", S_GHOST, 10, 3, -5, 50, -5, (G_NOCORPSE | G_NOGEN),
	  { { AT_TUCH, AD_PHYS, 1, 1 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 0, PL_NSIZ, MS_SILENT, MZ_HUMAN,
	  MR_COLD | MR_DISINT | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSONE |
	  MR_HITASTWO, 0, M1_FLY | M1_BREATHLESS | M1_WALLWALK | M1_HUMANOID |
	  M1_UNSOLID, M2_NOPOLY | M2_UNDEAD | M2_STALK | M2_HOSTILE, 0, C(GRAY) },
	{ "shade", S_GHOST, 12, 10, 10, 0, 0, (G_NOCORPSE | G_NOGEN),
	  { { AT_TUCH, AD_PLYS, 2, 6 }, { AT_TUCH, AD_SLOW, 1, 6},
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 0, 0, MS_WAIL, MZ_HUMAN,
	  MR_COLD | MR_DISINT | MR_SLEEP | MR_POISON | MR_STONE | MR_HITASFOUR, 0,
	  M1_FLY | M1_BREATHLESS | M1_WALLWALK | M1_HUMANOID |
	  M1_UNSOLID | M1_SEE_INVIS, M2_NOPOLY | M2_UNDEAD | M2_WANDER | M2_STALK |
	  M2_HOSTILE, 0, C(BLACK) },
/*      (major) Demons  */
	{ "water demon", S_DEMON, 8, 12, -4, 30, -7, (G_NOCORPSE | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_HUMAN,
	  MR_DEATH | MR_FIRE | MR_POISON, 0, M1_HUMANOID | M1_POIS | M1_SWIM,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY | M2_COLLECT,
	  0, C(BLUE) },
	/* standard demons & devils */
	{ "horned devil", S_DEMON, 6, 9, -6, 50, 11, (G_HELL | G_NOCORPSE | 3),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 2, 3 }, { AT_STNG, AD_PHYS, 1, 3 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_HUMAN,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_POIS | M1_THICK_HIDE,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(BROWN) },
	{ "spined devil", S_DEMON, 5, 18, 1, 45, 7, (G_HELL | G_LGROUP | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_HUMAN,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSONE, 0, M1_FLY | M1_POIS | M1_THICK_HIDE,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(GREEN) },
	{ "bearded devil", S_DEMON, 8, 15, 1, 45, 7, (G_HELL | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_PHYS, 1, 10 }, { AT_WEAP, AD_PHYS, 1, 10 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_HUMAN,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_POIS | M1_THICK_HIDE,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(BLACK) },
#ifdef SEDUCE
	{ "succubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 2),
	  { { AT_BITE, AD_SSEX, 0, 0 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_CLAW, AD_PHYS, 1, 3 }, NO_ATTK,
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SEDUCE, MZ_HUMAN,
	  MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_HUMANOID | M1_FLY | M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY | M2_FEMALE, 0, C(GRAY) },
	{ "incubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 2),
	  { { AT_BITE, AD_SSEX, 0, 0 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_CLAW, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SEDUCE, MZ_HUMAN,
	  MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_HUMANOID | M1_FLY | M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY | M2_MALE, 0, C(GRAY) },
#else
	{ "succubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_DRLI, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SEDUCE, MZ_HUMAN,
	  MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_HUMANOID | M1_FLY,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY | M2_FEMALE, 0, C(GRAY) },
	{ "incubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_DRLI, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SEDUCE, MZ_HUMAN,
	  MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_HUMANOID | M1_FLY | M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY | M2_MALE, 0, C(GRAY) },
#endif
	{ "erinyes", S_DEMON, 7, 12, 2, 30, 10,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 3),
	  { { AT_WEAP, AD_DRST, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_HUMAN,
	  MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_HUMANOID | M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_STRONG | M2_NASTY | M2_FEMALE |
	  M2_COLLECT, 0, C(RED) },
	{ "barbed devil", S_DEMON, 8, 12, -2, 35, 8,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 3),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    { AT_STNG, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_HUMAN,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_POIS | M1_THICK_HIDE,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(RED) },
	{ "marilith", S_DEMON, 7, 12, -8, 80, -12, (G_HELL | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 } },
	  WT_HUMAN, 400, 0, MS_CUSS, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSTWO | MR_HITASTHREE, 0,
	  M1_HUMANOID | M1_SLITHY | M1_SEE_INVIS | M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY | M2_FEMALE | M2_COLLECT,
	  0, C(RED) },
	{ "bar-lgura", S_DEMON, 7, 15, -3, 45, -9,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_BITE, AD_PHYS, 2, 12 }, NO_ATTK,
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(ORANGE_COLORED) },
	{ "chasme", S_DEMON, 8, 21, -1, 40, -9,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 1),
	  { { AT_CLAW, AD_PHYS, 2, 6 }, { AT_CLAW, AD_PHYS, 2, 6 },
	    { AT_BITE, AD_PHYS, 2, 4 }, { AT_GAZE, AD_SLEE, 1, 6 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_MEDIUM,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_POIS | M1_FLY,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(CYAN) },
	{ "vrock", S_DEMON, 8, 12, -2, 50, -9,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 3),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_CLAW, AD_PHYS, 1, 8 }, { AT_CLAW, AD_PHYS, 1, 8 },
	    { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(RED) },
	{ "babau", S_DEMON, 9, 15, -3, 50, -9,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_GAZE, AD_DRST, 1, 8 }, { AT_BITE, AD_PHYS, 1, 8 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTWO, 0, M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(BLACK) },
	{ "hezrou", S_DEMON, 9, 6, -4, 55, -10,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 3),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 4, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSTWO, 0, M1_HUMANOID | M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(RED) },
	{ "bone devil", S_DEMON, 9, 15, -3, 40, -9,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 3),
	  { { AT_WEAP, AD_PHYS, 3, 4 }, { AT_STNG, AD_DRST, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSTWO | MR_HITASTHREE, 0, M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY | M2_COLLECT,
	  0, C(GRAY) },
	{ "ice devil", S_DEMON, 11, 6, -6, 55, -12, (G_HELL | G_NOCORPSE | 3),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 2, 4 }, { AT_STNG, AD_COLD, 3, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_POISON | MR_PLUSTWO | MR_HITASTHREE, 0, M1_SEE_INVIS | M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(WHITE) },
	{ "nalfeshnee", S_DEMON, 11, 9, -3, 65, -11, (G_HELL | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 2, 4 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSTWO | MR_HITASTHREE, 0, M1_HUMANOID | M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(RED) },
	{ "nabassu", S_DEMON, 9, 15, -5, 50, -11, (G_HELL | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    { AT_BITE, AD_DRLI, 3, 4 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSONE | MR_HITASTHREE, 0, M1_HUMANOID | M1_POIS | M1_FLY,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, 0, C(BLACK) },
	{ "pit fiend", S_DEMON, 13, 6, -6, 65, -13, (G_HELL | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_PHYS, 4, 2 }, { AT_WEAP, AD_PHYS, 4, 2 },
	    { AT_HUGS, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GROWL, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSTHREE | MR_HITASFOUR, 0, M1_SEE_INVIS | M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY | M2_COLLECT, 0, C(RED) },
	{ "balrog", S_DEMON, 16, 5, -8, 75, -14, (G_HELL | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_PHYS, 8, 4 }, { AT_WEAP, AD_PHYS, 4, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSTHREE | MR_HITASFOUR, 0, M1_FLY | M1_SEE_INVIS | M1_POIS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_STRONG | M2_NASTY | M2_COLLECT,
	  0, C(RED) },
	/* Named demon lords & princes plus Arch-Devils */
	{ "Juiblex", S_DEMON, 50, 3, -7, 65, -15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_ENGL, AD_DISE, 4, 10 }, { AT_SPIT, AD_ACID, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 0, 0, MS_GURGLE, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_ACID | MR_STONE | MR_PLUSFOUR, 0,
	  M1_AMPHIBIOUS | M1_AMORPHOUS | M1_NOHEAD | M1_FLY | M1_SEE_INVIS |
	  M1_ACID | M1_POIS,
	  M2_NOPOLY | M2_DEMON | M2_STALK | M2_HOSTILE | M2_PNAME | M2_NASTY |
	  M2_LORD | M2_MALE,
	  M3_WAITFORU | M3_WANTSAMUL, C(BRIGHT_GREEN) },
	{ "Yeenoghu", S_DEMON, 56, 18, -8, 80, -15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 3, 6 }, { AT_WEAP, AD_CONF, 2, 8 },
	    { AT_WEAP, AD_PLYS, 1, 6 }, { AT_MAGC, AD_MAGM, 2, 6 },
	    NO_ATTK, NO_ATTK },
	  900, 500, 0, MS_ORC, MZ_LARGE, MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSFOUR, 0,
	  M1_FLY | M1_SEE_INVIS | M1_POIS, M2_NOPOLY | M2_DEMON | M2_STALK |
	  M2_HOSTILE | M2_PNAME | M2_NASTY | M2_LORD | M2_MALE | M2_COLLECT,
	  M3_WANTSAMUL, C(HI_LORD) },
	{ "Orcus", S_DEMON, 66, 9, -8, 85, -20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_MAGC, AD_SPEL, 8, 6 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    { AT_STNG, AD_DRST, 2, 4 }, NO_ATTK },
	  1500, 500, 0, MS_ORC, MZ_HUGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSFOUR, 0,
	  M1_FLY | M1_SEE_INVIS | M1_POIS, M2_NOPOLY | M2_DEMON | M2_STALK |
	  M2_HOSTILE | M2_PNAME | M2_NASTY | M2_PRINCE | M2_MALE | M2_COLLECT,
	  M3_WAITFORU | M3_WANTSBOOK | M3_WANTSAMUL, C(HI_LORD) },
	{ "Geryon", S_DEMON, 72, 3, -8, 75, 15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_CLAW, AD_PHYS, 3, 6 }, { AT_CLAW, AD_PHYS, 3, 6 },
	    { AT_STNG, AD_DRST, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 500, 0, MS_BRIBE, MZ_HUGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSFOUR, 0,
	  M1_FLY | M1_SEE_INVIS | M1_POIS | M1_SLITHY, M2_NOPOLY | M2_DEMON |
	  M2_STALK | M2_HOSTILE | M2_PNAME | M2_NASTY | M2_PRINCE | M2_MALE,
	  M3_WANTSAMUL, C(HI_LORD) },
	{ "Dispater", S_DEMON, 78, 15, -8, 80, 15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 4, 6 }, { AT_MAGC, AD_SPEL, 6, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 500, 0, MS_BRIBE, MZ_HUMAN,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSFOUR, 0, M1_FLY | M1_SEE_INVIS | M1_POIS |
	  M1_HUMANOID, M2_NOPOLY | M2_DEMON | M2_STALK | M2_HOSTILE |
	  M2_PNAME | M2_NASTY | M2_PRINCE | M2_MALE | M2_COLLECT,
	  M3_WANTSAMUL, C(HI_LORD) },
	{ "Baalzebub", S_DEMON, 89, 9, -8, 85, 20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_BITE, AD_DRST, 2, 6 }, { AT_GAZE, AD_STUN, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 500, 0, MS_BRIBE, MZ_LARGE,
	  MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSFOUR, 0, M1_FLY | M1_SEE_INVIS | M1_POIS,
	  M2_NOPOLY | M2_DEMON | M2_STALK | M2_HOSTILE | M2_PNAME | M2_NASTY |
	  M2_PRINCE | M2_MALE, M3_WANTSAMUL | M3_WAITFORU, C(HI_LORD) },
	{ "Asmodeus", S_DEMON, 105, 12, -8, 90, 20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_CLAW, AD_PHYS, 4, 4 }, { AT_MAGC, AD_COLD, 6, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 500, 0, MS_BRIBE, MZ_HUGE,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_POISON | MR_PLUSFOUR, 0,
	  M1_FLY | M1_SEE_INVIS | M1_HUMANOID | M1_POIS,
	  M2_NOPOLY | M2_DEMON | M2_STALK | M2_HOSTILE | M2_PNAME | M2_STRONG |
	  M2_NASTY | M2_PRINCE | M2_MALE, M3_WANTSAMUL | M3_WAITFORU,
	  C(HI_LORD) },
	{ "Demogorgon", S_DEMON, 106, 15, -8, 95, -20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_MAGC, AD_SPEL, 8, 6 }, { AT_STNG, AD_DRLI, 1, 4 },
	    { AT_CLAW, AD_DISE, 1, 6 }, { AT_CLAW, AD_DISE, 1, 6 },
	    NO_ATTK, NO_ATTK },
	  1500, 500, 0, MS_GROWL, MZ_HUGE, MR_DEATH | MR_FIRE | MR_POISON | MR_PLUSFOUR, 0,
	  M1_FLY | M1_SEE_INVIS | M1_NOHANDS | M1_POIS, M2_NOPOLY | M2_DEMON |
	  M2_STALK | M2_HOSTILE | M2_PNAME | M2_NASTY | M2_PRINCE | M2_MALE,
	  M3_WANTSAMUL, C(HI_LORD) },
	{ "Death", S_DEMON, 20, 3, 4, 95, 0, (G_UNIQ | G_NOGEN),
	  { { AT_TUCH, AD_DETH, 8, 8 }, { AT_TUCH, AD_DETH, 8, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 0, 0, MS_RIDER, MZ_HUMAN,
	  MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSFOUR,
	  MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_STONE,
	  M1_FLY | M1_SEE_INVIS | M1_HUMANOID | M1_REGEN,
	  M2_NOPOLY | M2_STALK | M2_HOSTILE | M2_PNAME | M2_STRONG | M2_NASTY,
	  0, C(HI_LORD) },
	{ "Pestilence", S_DEMON, 20, 3, 4, 95, 0, (G_UNIQ | G_NOGEN),
	  { { AT_TUCH, AD_PEST, 8, 8 }, { AT_TUCH, AD_PEST, 8, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 0, 0, MS_RIDER, MZ_HUMAN,
	  MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSFOUR,
	  MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_STONE,
	  M1_FLY | M1_SEE_INVIS | M1_HUMANOID | M1_REGEN,
	  M2_NOPOLY | M2_STALK | M2_HOSTILE | M2_PNAME | M2_STRONG | M2_NASTY,
	  0, C(HI_LORD) },
	{ "Famine", S_DEMON, 20, 3, 4, 95, 0, (G_UNIQ | G_NOGEN),
	  { { AT_TUCH, AD_FAMN, 8, 8 }, { AT_TUCH, AD_FAMN, 8, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 0, 0, MS_RIDER, MZ_HUMAN,
	  MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSFOUR,
	  MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_STONE,
	  M1_FLY | M1_SEE_INVIS | M1_HUMANOID | M1_REGEN,
	  M2_NOPOLY | M2_STALK | M2_HOSTILE | M2_PNAME | M2_STRONG | M2_NASTY,
	  0, C(HI_LORD) },
#ifdef MAIL
	{ "mail daemon", S_DEMON, 56, 24, 10, 127, 0, (G_NOGEN | G_NOCORPSE),
	  { NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  600, 300, 0, MS_SILENT, MZ_HUMAN,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_ELEC | MR_SLEEP | MR_POISON | MR_STONE | MR_PLUSFOUR, 0,
	  M1_FLY | M1_SWIM | M1_BREATHLESS | M1_SEE_INVIS | M1_HUMANOID |
	  M1_POIS, M2_NOPOLY | M2_STALK | M2_PEACEFUL, 0, C(BRIGHT_BLUE) },
/* Neither rain nor sleet nor gloom of night shall stay this courier... */
#endif
	{ "djinni", S_DEMON, 7, 12, 4, 30, 0, (G_NOGEN | G_NOCORPSE),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 400, 0, MS_DJINNI, MZ_HUMAN, MR_POISON | MR_STONE, 0,
	  M1_HUMANOID | M1_FLY | M1_POIS,
	  M2_NOPOLY | M2_STALK | M2_COLLECT, 0, C(YELLOW) },
	{ "efreeti", S_DEMON, 7, 12, 4, 30, 0, (G_NOGEN | G_NOCORPSE),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 400, 0, MS_DJINNI, MZ_HUMAN, MR_POISON | MR_STONE |
	  MR_FIRE | MR_ELEC, 0,
	  M1_HUMANOID | M1_FLY | M1_POIS,
	  M2_NOPOLY | M2_STALK | M2_COLLECT, 0, C(RED) },
	{ "dao", S_DEMON, 7, 12, 4, 30, 0, (G_NOGEN | G_NOCORPSE),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 400, 0, MS_DJINNI, MZ_HUMAN, MR_POISON | MR_STONE, 0,
	  M1_HUMANOID | M1_FLY | M1_POIS,
	  M2_NOPOLY | M2_STALK | M2_COLLECT, 0, C(BROWN) },
	{ "marid", S_DEMON, 7, 12, 4, 30, 0, (G_NOGEN | G_NOCORPSE),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  1500, 400, 0, MS_DJINNI, MZ_HUMAN, MR_COLD | MR_POISON | MR_STONE, 0,
	  M1_HUMANOID | M1_FLY | M1_POIS,
	  M2_NOPOLY | M2_STALK | M2_COLLECT, 0, C(BLUE) },
/*      sea monsters            */
	{ "giant eel", S_EEL, 5, 9, -1, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_BITE, AD_PHYS, 3, 6 }, { AT_TUCH, AD_WRAP, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 250, 0, MS_SILENT, MZ_HUGE,
	  0, 0, M1_SWIM | M1_AMPHIBIOUS | M1_ANIMAL | M1_SLITHY |
	  M1_NOLIMBS | M1_CARNIVORE | M1_OVIPAROUS, M2_HOSTILE, 0, C(CYAN) },
	{ "shark", S_EEL, 7, 12, 0, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_BITE, AD_PHYS, 5, 6 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 350, 0, MS_SILENT, MZ_HUGE,
	  0, 0, M1_SWIM | M1_AMPHIBIOUS | M1_ANIMAL | M1_SLITHY |
	  M1_NOLIMBS | M1_CARNIVORE, M2_HOSTILE, 0, C(BROWN) },
	{ "giant crab", S_EEL, 7, 12, 0, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_CLAW, AD_PHYS, 3, 6 }, { AT_CLAW, AD_PHYS, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  500, 350, 0, MS_SILENT, MZ_HUGE,
	  0, 0, M1_SWIM | M1_AMPHIBIOUS | M1_ANIMAL | M1_OVIPAROUS,
	  M2_HOSTILE, 0, C(GREEN) },
	{ "electric eel", S_EEL, 7, 10, -3, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_BITE, AD_ELEC, 4, 6 }, { AT_TUCH, AD_WRAP, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 250, 0, MS_SILENT, MZ_HUGE, MR_ELEC, MR_ELEC,
	  M1_SWIM | M1_AMPHIBIOUS | M1_ANIMAL | M1_SLITHY | M1_NOLIMBS |
	  M1_CARNIVORE | M1_OVIPAROUS, M2_HOSTILE, 0, C(BLUE) },
	{ "kraken", S_EEL, 20, 3, 6, 0, -3, (G_GENO | G_NOGEN),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    { AT_HUGS, AD_WRAP, 2, 6 }, { AT_BITE, AD_PHYS, 5, 4 },
	    NO_ATTK, NO_ATTK },
	  1800, 1000, 0, MS_SILENT, MZ_HUGE, 0, 0,
	  M1_SWIM | M1_AMPHIBIOUS | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_NOPOLY | M2_HOSTILE | M2_STRONG, 0, C(RED) },
/*      lizards         */
	{ "newt", S_LIZARD, 0, 6, 8, 0, 0, (G_NOHELL | G_GENO | 6),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 20, 0, MS_SILENT, MZ_TINY, 0, 0,
	  M1_SWIM | M1_AMPHIBIOUS | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(YELLOW) },
	{ "gecko", S_LIZARD, 1, 6, 8, 0, 0, (G_NOHELL | G_GENO | 6),
	  { { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 20, 0, MS_SQEEK, MZ_TINY, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(GREEN) },
	{ "iguana", S_LIZARD, 2, 6, 7, 0, 0, (G_NOHELL | G_GENO | 6),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 30, 0, MS_SILENT, MZ_TINY, 0, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(BROWN) },
	{ "baby crocodile", S_LIZARD, 3, 6, 7, 0, 0, (G_NOHELL | G_GENO),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  200, 200, 0, MS_SILENT, MZ_MEDIUM, 0, 0,
	  M1_SWIM | M1_AMPHIBIOUS | M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "lizard", S_LIZARD, 5, 6, 6, 10, 0, (G_NOHELL | G_GENO | 6),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 40, 0, MS_SILENT, MZ_TINY, MR_STONE, MR_STONE,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(GREEN) },
	{ "gila monster", S_LIZARD, 6, 6, 6, 10, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_DRST, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 40, 0, MS_SILENT, MZ_TINY, MR_POISON, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(ORANGE_COLORED) },
	{ "chameleon", S_LIZARD, 6, 5, 6, 10, 0, (G_NOHELL | G_GENO | 3),
	  { { AT_BITE, AD_PHYS, 4, 2 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 100, 0, MS_SILENT, MZ_TINY,
	  MR_HITASONE, 0, M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE,
	  M2_NOPOLY | M2_HOSTILE, 0, C(BROWN) },
	{ "crocodile", S_LIZARD, 6, 9, 5, 0, 0, (G_NOHELL | G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 4, 2 }, { AT_CLAW, AD_PHYS, 1, 12 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_SWIM | M1_AMPHIBIOUS | M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS |
	  M1_OVIPAROUS | M1_CARNIVORE, M2_STRONG | M2_HOSTILE, 0, C(BROWN) },
	{ "salamander", S_LIZARD, 7, 6, 6, 10, 0, (G_GENO | 1),
	  { { AT_BITE, AD_FIRE, 3, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 40, 0, MS_SILENT, MZ_TINY, MR_POISON, 0,
	  M1_ANIMAL | M1_NOHANDS | M1_CARNIVORE, M2_HOSTILE, 0, C(RED) },
	{ "rhaumbusun", S_LIZARD, 2, 9, 5, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_GAZE, AD_PLYS, 1, 2 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 40, 0, MS_SILENT, MZ_TINY, MR_POISON, MR_POISON,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS |
	  M1_OVIPAROUS | M1_CARNIVORE,  M2_NASTY | M2_HOSTILE, 0, C(MAGENTA) },
	{ "basilisk", S_LIZARD, 8, 9, 5, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_STON, 4, 2 }, { AT_NONE, AD_STON, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE, MR_POISON | MR_STONE, MR_POISON | MR_STONE,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS |
	  M1_OVIPAROUS | M1_CARNIVORE, M2_STRONG | M2_HOSTILE, 0, C(BLACK) },
	{ "komodo dragon", S_LIZARD, 9, 9, 5, 0, 0, (G_NOHELL | G_GENO | 1),
	  { { AT_BITE, AD_DRCO, 2, 6 }, { AT_CLAW, AD_PHYS, 1, 12 },
	    { AT_CLAW, AD_PHYS, 1, 12}, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_SILENT, MZ_LARGE, 0, 0,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS |
	  M1_OVIPAROUS | M1_CARNIVORE, M2_STRONG | M2_HOSTILE, 0, C(GREEN) },

/*      character classes */
	{ "archeologist", S_HUMAN, 1, 10, 10, 1, 3, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_TUNNEL | M1_NEEDPICK | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_COLLECT | M2_HOSTILE, 0, C(HI_DOMESTIC) },
	{ "barbarian", S_HUMAN, 1, 10, 10, 1, -3, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, MR_POISON, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_COLLECT | M2_HOSTILE, 0, C(HI_DOMESTIC) },
	{ "caveman", S_HUMAN, 1, 10, 10, 0, 1, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_MALE | M2_COLLECT | M2_HOSTILE, 0,
	  C(RED) },
	{ "cavewoman", S_HUMAN, 1, 10, 10, 0, 1, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_FEMALE | M2_COLLECT | M2_HOSTILE,
	  0, C(RED) },
	{ "doppelganger", S_HUMAN, 1, 10, 10, 0, 1, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_COLLECT | M2_HOSTILE,
	  0, C(GRAY) },
	/* Note: players who are elves still get normal carrying capacity,
	 * even though this is strictly speaking inconsistent.
	 */
	{ "elf", S_HUMAN, 1, 12, 10, 2, 3, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_HUMANOID, MZ_HUMAN, MR_SLEEP, MR_SLEEP,
	  M1_HUMANOID | M1_OMNIVORE | M1_SEE_INVIS,
	  M2_NOPOLY | M2_ELF | M2_STRONG | M2_COLLECT | M2_HOSTILE, 0, C(GREEN) },
	{ "flame mage", S_HUMAN, 1, 10, 10, 3, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_COLLECT | M2_MAGIC | M2_HOSTILE,
	  0, C(RED) },
	{ "healer", S_HUMAN, 1, 10, 10, 1, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_CLRC, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, MR_POISON, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_COLLECT | M2_HOSTILE, 0, C(HI_DOMESTIC) },
	{ "ice mage", S_HUMAN, 1, 10, 10, 3, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_COLLECT | M2_MAGIC | M2_HOSTILE,
	  0, C(WHITE) },
	{ "knight", S_HUMAN, 1, 10, 10, 1, 3, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_COLLECT | M2_HOSTILE, 0, C(HI_DOMESTIC) },
	{ "monk", S_HUMAN, 1, 10, 10, 2, 0, (G_GENO | 1),
	  { { AT_KICK, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_MALE | M2_COLLECT | M2_HOSTILE,
	  0, C(HI_DOMESTIC) },
	{ "necromancer", S_HUMAN, 1, 10, 10, 3, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_COLLECT | M2_MAGIC | M2_HOSTILE,
	  0, C(BLACK) },
	{ "priest", S_HUMAN, 1, 10, 10, 2, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_CLRC, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_MALE | M2_COLLECT | M2_HOSTILE,
	  0, C(HI_DOMESTIC) },
	{ "priestess", S_HUMAN, 1, 10, 10, 2, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_CLRC, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_FEMALE | M2_COLLECT | M2_HOSTILE,
	  0, C(HI_DOMESTIC) },
	{ "rogue", S_HUMAN, 1, 10, 10, 1, -3, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_TUCH, AD_SGLD, 1, 2 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_GREEDY | M2_JEWELS | M2_COLLECT | M2_HOSTILE,
	  0, C(BLACK) },
	{ "samurai", S_HUMAN, 1, 10, 10, 1, 3, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_COLLECT | M2_HOSTILE, 0, C(HI_DOMESTIC) },
#ifdef TOURIST
	{ "tourist", S_HUMAN, 1, 10, 10, 1, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_COLLECT | M2_HOSTILE, 0, C(MAGENTA) },
#endif
	{ "undead slayer", S_HUMAN, 1, 10, 10, 1, -1, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, MR_DRAIN, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_FEMALE | M2_COLLECT | M2_HOSTILE,
	  0, C(BLACK) },
	{ "valkyrie", S_HUMAN, 1, 10, 10, 1, -1, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, MR_COLD, MR_COLD,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_FEMALE | M2_COLLECT | M2_HOSTILE,
	  0, C(HI_DOMESTIC) },
	{ "wizard", S_HUMAN, 1, 10, 10, 3, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, 0, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_COLLECT | M2_MAGIC | M2_HOSTILE,
	  0, C(HI_ZAP) },
#ifdef MULDGN
	{ "Lord Carnarvon", S_HUMAN, 20, 12, 0, 30, 20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_HITASFOUR, 0,
	  M1_TUNNEL | M1_NEEDPICK | M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_COLLECT | M2_MAGIC,
	  M3_CLOSE, C(HI_LORD) },
	{ "Pelias", S_HUMAN, 20, 12, 0, 30, -20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_POISON | MR_HITASFOUR, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG |
	  M2_COLLECT | M2_MAGIC,
	  M3_CLOSE, C(HI_LORD) },
	{ "Shaman Karnov", S_HUMAN, 20, 12, 0, 30, 20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_COLLECT | M2_MAGIC,
	  M3_CLOSE, C(HI_LORD) },
	{ "Master Shifter", S_HUMAN, 20, 12, 0, 30, 0, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_COLLECT | M2_MAGIC,
	  M3_CLOSE, C(HI_LORD) },
	/* Two for elves - one of each sex. */
	{ "Earendil", S_HUMAN, 25, 15, 0, 50, 20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 3, 8 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_LEADER, MZ_HUMAN, MR_SLEEP | MR_DEATH | MR_HITASFOUR, MR_SLEEP,
	  M1_HUMANOID | M1_SEE_INVIS | M1_OMNIVORE,
	  M2_NOPOLY | M2_ELF | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG |
	  M2_MALE | M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
	{ "Elwing", S_HUMAN, 20, 15, 0, 50, -20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_LEADER, MZ_HUMAN, MR_SLEEP | MR_HITASFOUR, MR_SLEEP,
	  M1_HUMANOID | M1_SEE_INVIS | M1_OMNIVORE,
	  M2_NOPOLY | M2_ELF | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG |
	  M2_FEMALE | M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
	{ "High Flame Mage", S_HUMAN, 20, 12, 0, 40, 0, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_POISON | MR_HITASFOUR, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
	{ "Hippocrates", S_HUMAN, 20, 12, 0, 40, 0, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_POISON | MR_HITASFOUR, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
	{ "High Ice Mage", S_HUMAN, 20, 12, 0, 40, 0, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_POISON | MR_HITASFOUR, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
	{ "King Arthur", S_HUMAN, 20, 12, 0, 40, 20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
	{ "High Lycanthrope", S_HUMAN, 20, 12, 0, 40, -20, (G_NOGEN | G_UNIQ),
	  { { AT_BITE, AD_PHYS, 3, 6 }, { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_POISON | MR_HITASFOUR, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
	
	{ "Grand Master", S_HUMAN, 25, 15, MARM(7,-3), 70, 0,
	   (G_NOGEN | G_UNIQ),
	  { { AT_CLAW, AD_PHYS, 4, 10 }, { AT_KICK, AD_PHYS, 2, 8 },
	    { AT_MAGC, AD_CLRC, 2, 8 }, { AT_MAGC, AD_CLRC, 2, 8 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN,
	  MR_FIRE | MR_ELEC | MR_SLEEP | MR_POISON | MR_HITASFOUR,
	  MR_FIRE | MR_ELEC | MR_SLEEP | MR_POISON,
	  M1_HUMANOID | M1_SEE_INVIS | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_NASTY |
	  M2_MAGIC, M3_CLOSE, C(WHITE) },
	{ "the Dark Lord", S_HUMAN, 20, 12, 0, 60, -20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
	{ "Arch Priest", S_HUMAN, 25, 15, MARM(7,-3), 70, 0,
	   (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 4, 10 }, { AT_KICK, AD_PHYS, 2, 8 },
	    { AT_MAGC, AD_CLRC, 2, 8 }, { AT_MAGC, AD_CLRC, 2, 8 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN,
	  MR_FIRE | MR_ELEC | MR_SLEEP | MR_POISON | MR_HITASFOUR,
	  MR_FIRE | MR_ELEC | MR_SLEEP | MR_POISON,
	  M1_HUMANOID | M1_SEE_INVIS | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_NASTY |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(WHITE) },
	{ "Master of Thieves", S_HUMAN, 20, 15, 0, 30, -20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, { AT_WEAP, AD_PHYS, 2, 6 },
	    { AT_CLAW, AD_SAMU, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_GREEDY | M2_JEWELS | M2_COLLECT | M2_MAGIC,
	  M3_CLOSE, C(HI_LORD) },
	{ "Lord Sato", S_HUMAN, 20, 0, 0, 30, 20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
#ifdef TOURIST
	{ "Twoflower", S_HUMAN, 20, 10, 10, 20, 0, (G_NOGEN | G_UNIQ),
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_DOMESTIC) },
#endif
	{ "Van Helsing", S_HUMAN, 20, 12, 0, 40, 20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG | M2_MALE |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
	{ "Norn", S_HUMAN, 20, 15, 0, 80, 0, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_COLD | MR_HITASFOUR, MR_COLD,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_FEMALE |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
	{ "Wizard of Balance", S_HUMAN, 20, 12, 0, 60, 0, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_LEADER, MZ_HUMAN, MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG |
	  M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },
	{ "Lolth", S_SPIDER, 20, 15, 0, 50, -20, (G_NOGEN | G_UNIQ),
	  { { AT_BITE, AD_DRST, 5, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_LEADER, MZ_HUMAN, MR_SLEEP | MR_HITASFOUR, MR_SLEEP,
	  M1_HUMANOID | M1_SEE_INVIS | M1_OMNIVORE,
	  M2_NOPOLY | M2_ELF | M2_HUMAN | M2_PNAME | M2_PEACEFUL | M2_STRONG |
	  M2_FEMALE | M2_COLLECT | M2_MAGIC, M3_CLOSE, C(HI_LORD) },

	/* The nemesis monsters */

	{ "Minion of Huhetol", S_DEMON, 25, 10, -10, 75, -20,
	  (G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 8, 4 }, { AT_WEAP, AD_PHYS, 4, 6 },
	    { AT_MAGC, AD_SPEL, 0, 0 }, { AT_CLAW, AD_SAMU, 2, 6 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_LARGE, MR_DEATH | MR_FIRE | MR_POISON | MR_HITASFOUR, 0,
	  M1_FLY | M1_SEE_INVIS | M1_POIS,
	  M2_NOPOLY | M2_DEMON | M2_STALK | M2_HOSTILE | M2_STRONG | M2_NASTY |
	  M2_COLLECT, M3_WANTSARTI | M3_WAITFORU, C(RED) },
	{ "Thoth Amon", S_HUMAN, 25, 10, -10, 10, 20, (G_NOGEN | G_UNIQ),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    { AT_WEAP, AD_PHYS, 1, 6 }, { AT_CLAW, AD_SAMU, 1, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_HUMAN, MR_DEATH | MR_POISON | MR_HITASFOUR, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_STALK | M2_HOSTILE | M2_NASTY |
	  M2_COLLECT | M2_MAGIC, M3_WANTSARTI | M3_WAITFORU, C(HI_LORD) },
	{ "Chromatic Dragon", S_DRAGON, 25, 10, -10, 30, -20, (G_NOGEN | G_UNIQ),
	  { { AT_BREA, AD_RBRE, 6, 8 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    { AT_CLAW, AD_SAMU, 2, 8 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_BITE, AD_PHYS, 4, 8 }, { AT_STNG, AD_PHYS, 1, 6 } },
	  WT_DRAGON, 1700, 0, MS_NEMESIS, MZ_GIGANTIC,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_ELEC | MR_DISINT | MR_POISON | MR_HITASFOUR,
	  MR_FIRE | MR_COLD | MR_ELEC | MR_DISINT | MR_POISON,
	  M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE | M1_SEE_INVIS | M1_POIS,
	  M2_NOPOLY | M2_HOSTILE | M2_FEMALE | M2_PNAME | M2_STALK |
	  M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  M3_WANTSARTI | M3_WAITFORU, C(HI_LORD) },
	{ "Transmuter", S_HUMAN, 25, 10, -10, 30, -20, (G_NOGEN | G_UNIQ),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    { AT_CLAW, AD_SAMU, 2, 8 }, { AT_CLAW, AD_SAMU, 2, 8 },
	    { AT_CLAW, AD_SAMU, 2, 8 }, { AT_CLAW, AD_SAMU, 2, 8 } },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_HUMAN,
	  MR_DEATH | MR_FIRE | MR_COLD | MR_ELEC | MR_POISON | MR_HITASFOUR,
	  MR_FIRE | MR_COLD | MR_ELEC | MR_POISON,
	  M1_CARNIVORE | M1_SEE_INVIS,
	  M2_NOPOLY | M2_HOSTILE | M2_PNAME | M2_STALK |
	  M2_STRONG | M2_NASTY | M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  M3_WANTSARTI | M3_WAITFORU, C(HI_LORD) },
	{ "Goblin King", S_ORC, 25, 10, MARM(0,-10), 0, -20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, { AT_WEAP, AD_PHYS, 2, 6 },
	    { AT_CLAW, AD_SAMU, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  750, 350, 0, MS_NEMESIS, MZ_HUMAN, MR_DEATH | MR_HITASFOUR, 0, M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_ORC | M2_HOSTILE | M2_STRONG | M2_STALK | M2_NASTY |
	  M2_MALE | M2_GREEDY | M2_JEWELS | M2_COLLECT | M2_MAGIC,
	  M3_WANTSARTI | M3_WAITFORU, C(HI_LORD) },
	{ "Water Mage", S_HUMAN, 25, 10, -10, 10, 20, (G_NOGEN | G_UNIQ),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    { AT_WEAP, AD_PHYS, 1, 6 }, { AT_CLAW, AD_SAMU, 1, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_HUMAN, MR_DEATH | MR_POISON | MR_HITASFOUR, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_STALK | M2_HOSTILE | M2_NASTY |
	  M2_COLLECT | M2_MAGIC, M3_WANTSARTI | M3_WAITFORU, C(HI_LORD) },
	{ "Lareth", S_HUMAN, 25, 15, 0, 50, 20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 4, 8 }, { AT_WEAP, AD_SLEE, 2, 5 },
	    { AT_MAGC, AD_SPEL, 0, 0 }, { AT_MAGC, AD_SPEL, 0, 0 },
	     NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_NEMESIS, MZ_HUMAN, MR_SLEEP | MR_HITASFOUR | MR_DEATH, MR_SLEEP,
	  M1_HUMANOID | M1_SEE_INVIS | M1_OMNIVORE,
	  M2_NOPOLY | M2_ELF | M2_HUMAN | M2_STRONG | M2_PNAME | M2_HOSTILE | M2_NASTY |
	  M2_MALE | M2_COLLECT | M2_JEWELS | M2_MAGIC | M2_STALK,
	  M3_WANTSARTI | M3_WAITFORU,
	  C(BLACK) },
	{ "Cyclops", S_GIANT, 25, 10, -10, 0, -20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 4, 8 }, { AT_WEAP, AD_PHYS, 4, 8 },
	    { AT_CLAW, AD_SAMU, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  1900, 700, 0, MS_NEMESIS, MZ_HUGE, MR_DEATH | MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_STALK |
	  M2_HOSTILE | M2_NASTY | M2_MALE | M2_JEWELS | M2_COLLECT,
	  M3_WANTSARTI | M3_WAITFORU, C(GRAY) },
	{ "Earth Mage", S_HUMAN, 25, 10, -10, 10, 20, (G_NOGEN | G_UNIQ),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    { AT_WEAP, AD_PHYS, 1, 6 }, { AT_CLAW, AD_SAMU, 1, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_HUMAN, MR_DEATH | MR_POISON | MR_HITASFOUR, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_STALK | M2_HOSTILE | M2_NASTY |
	  M2_COLLECT | M2_MAGIC, M3_WANTSARTI | M3_WAITFORU, C(HI_LORD) },
	{ "Ixoth", S_DRAGON, 25, 9, -10, 20, -20, (G_NOGEN | G_UNIQ),
	  { { AT_BREA, AD_FIRE, 8, 6 }, { AT_BITE, AD_PHYS, 4, 8 },
	    { AT_MAGC, AD_SPEL, 0, 0 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    { AT_CLAW, AD_SAMU, 2, 4 }, NO_ATTK  },
	  WT_DRAGON, 1600, 0, MS_NEMESIS, MZ_GIGANTIC, MR_DEATH | MR_FIRE | MR_HITASFOUR, MR_FIRE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_CARNIVORE | M1_SEE_INVIS,
	  M2_NOPOLY | M2_HOSTILE | M2_PNAME | M2_STRONG | M2_NASTY | M2_STALK |
	  M2_GREEDY | M2_JEWELS | M2_MAGIC,
	  M3_WANTSARTI | M3_WAITFORU, C(RED) },
	{ "Sir Lorimar", S_HUMAN, 25, 15, -10, 40, -20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, { AT_WEAP, AD_PHYS, 2, 6 },
	    { AT_CLAW, AD_SAMU, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_HUMAN, MR_DEATH | MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_PNAME | M2_HOSTILE | M2_STALK |
	  M2_NASTY | M2_MALE | M2_COLLECT | M2_MAGIC,
	  M3_WANTSARTI | M3_WAITFORU, C(HI_LORD) },
	{ "Master Kaen", S_HUMAN, 25, 10, -10, 10, -20, (G_NOGEN | G_UNIQ),
	  { { AT_CLAW, AD_PHYS, 16, 2 }, { AT_CLAW, AD_PHYS, 16, 2 },
	    { AT_MAGC, AD_SPEL, 0, 0 }, { AT_CLAW, AD_SAMU, 1, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_HUMAN, MR_DEATH | MR_POISON | MR_HITASFOUR, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_STALK | M2_HOSTILE | M2_NASTY |
	  M2_COLLECT | M2_PNAME | M2_MAGIC, M3_WANTSARTI | M3_WAITFORU, C(HI_LORD) },
	{ "Maugneshaagar", S_DEMON, 16, 10, -10, 85, -20,
	  (G_NOGEN | G_UNIQ | G_NOCORPSE),
	  { { AT_WEAP, AD_PHYS, 8, 4 }, { AT_WEAP, AD_PHYS, 4, 6 },
	    { AT_MAGC, AD_SPEL, 0, 0 }, { AT_CLAW, AD_SAMU, 2, 6 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_LARGE, MR_DEATH | MR_FIRE | MR_POISON | MR_HITASFOUR, 0,
	  M1_FLY | M1_SEE_INVIS | M1_POIS,
	  M2_NOPOLY | M2_DEMON | M2_PNAME | M2_HOSTILE | M2_STRONG | M2_STALK |
	  M2_NASTY | M2_COLLECT, M3_WANTSARTI | M3_WAITFORU, C(BLACK) },
	{ "Nalzok", S_DEMON, 16, 10, -10, 85, -20,
	  (G_NOGEN | G_UNIQ | G_NOCORPSE),
	  { { AT_WEAP, AD_PHYS, 8, 4 }, { AT_WEAP, AD_PHYS, 4, 6 },
	    { AT_MAGC, AD_SPEL, 0, 0 }, { AT_CLAW, AD_SAMU, 2, 6 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_LARGE, MR_DEATH | MR_FIRE | MR_POISON | MR_HITASFOUR, 0,
	  M1_FLY | M1_SEE_INVIS | M1_POIS,
	  M2_NOPOLY | M2_DEMON | M2_PNAME | M2_HOSTILE | M2_STRONG | M2_STALK |
	  M2_NASTY | M2_COLLECT, M3_WANTSARTI | M3_WAITFORU, C(RED) },
	{ "Master Assassin", S_HUMAN, 25, 15, -10, 30, 18, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_DRST, 2, 6 }, { AT_WEAP, AD_PHYS, 2, 8 },
	    { AT_CLAW, AD_SAMU, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_HUMAN, MR_DEATH | MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_HOSTILE | M2_STALK | M2_NASTY |
	  M2_COLLECT | M2_MAGIC,
	  M3_WANTSARTI | M3_WAITFORU, C(HI_LORD) },
	/* A renegade daimyo who led a 13 year civil war against the shogun */
	/* of his time. */
	{ "Ashikaga Takauji", S_HUMAN, 25, 15, -10, 40, -20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, { AT_WEAP, AD_PHYS, 2, 6 },
	    { AT_CLAW, AD_SAMU, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_HUMAN, MR_DEATH | MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_PNAME | M2_HOSTILE | M2_STALK |
	  M2_NASTY | M2_MALE | M2_COLLECT | M2_MAGIC,
	  M3_WANTSARTI | M3_WAITFORU, C(HI_LORD) },

/*      NOTE: the Master of Thieves was defined above. */
	{ "Lord Vlad the Impaler", S_HUMAN, 25, 18, -8, 80, -10,
	  (G_NOGEN | G_NOCORPSE | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, { AT_WEAP, AD_PHYS, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_HUMAN, MR_SLEEP | MR_POISON |
	  MR_HITASFOUR, 0, M1_FLY | M1_BREATHLESS | M1_HUMANOID |
	  M1_POIS | M1_REGEN, M2_NOPOLY | M2_HUMAN | M2_STALK | M2_HOSTILE |
	  M2_PNAME | M2_STRONG | M2_NASTY | M2_PRINCE | M2_MALE, M3_WAITFORU |
	  M3_WANTSARTI, C(HI_LORD) },

	{ "Lord Surtur", S_GIANT, 25, 12, -10, 50, -20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 2, 10 }, { AT_WEAP, AD_PHYS, 2, 10 },
	    { AT_CLAW, AD_SAMU, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK },
	  2250, 850, 0, MS_NEMESIS, MZ_HUGE, MR_DEATH | MR_FIRE | MR_HITASFOUR, MR_FIRE,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_STALK |
	  M2_HOSTILE | M2_NASTY | M2_MALE | M2_PNAME | M2_COLLECT | M2_JEWELS,
	  M3_WANTSARTI | M3_WAITFORU, C(HI_LORD) },
	{ "Dark One", S_HUMAN, 25, 10, -10, 80, -20, (G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    { AT_WEAP, AD_PHYS, 1, 6 }, { AT_CLAW, AD_SAMU, 1, 4 },
	    NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_NEMESIS, MZ_HUMAN, MR_DEATH | MR_HITASFOUR, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_STRONG | M2_HOSTILE | M2_STALK | M2_NASTY |
	  M2_COLLECT | M2_MAGIC,
	  M3_WANTSARTI | M3_WAITFORU, C(BLACK) },

/*      The "guards" */
	{ "student", S_HUMAN, 5, 10, 10, 10, 3, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_TUNNEL | M1_NEEDPICK | M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(HI_DOMESTIC) },
	{ "chieftain", S_HUMAN, 5, 10, 10, 10, 0, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_POISON | MR_HITASONE, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(HI_DOMESTIC) },
	{ "neanderthal", S_HUMAN, 5, 10, 10, 10, 1, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(RED) },
	{ "shifter", S_HUMAN, 5, 12, 0, 10, 0, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_COLLECT, 0, C(GRAY) },
	{ "High-elf", S_HUMAN, 5, 12, MARM(10,5), 10, -7, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_MAGC, AD_CLRC, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_ELF, 350, 0, MS_GUARDIAN, MZ_HUMAN, MR_SLEEP | MR_HITASONE, MR_SLEEP,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_ELF | M2_PEACEFUL | M2_COLLECT, 0, C(GREEN) },
	{ "igniter", S_HUMAN, 5, 10, 10, 10, 3, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_POISON | MR_HITASONE, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(RED) },
	{ "froster", S_HUMAN, 5, 10, 10, 10, 3, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_POISON | MR_HITASONE, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(WHITE) },
	{ "fiend", S_HUMAN, 5, 10, 10, 10, 3, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_POISON | MR_HITASONE, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(ORANGE_COLORED) },
	{ "attendant", S_HUMAN, 5, 10, 10, 10, 3, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_POISON | MR_HITASONE, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(HI_DOMESTIC) },
	{ "intern", S_HUMAN, 5, 10, 10, 10, 3, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_POISON | MR_HITASONE, MR_POISON,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(HI_DOMESTIC) },
	{ "page", S_HUMAN, 5, 10, 10, 10, 3, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(HI_DOMESTIC) },
	{ "abbot", S_HUMAN, 5, 10, 10, 20, 0, G_NOGEN,
	  { { AT_CLAW, AD_PHYS, 8, 2 }, { AT_KICK, AD_STUN, 3, 2 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(HI_DOMESTIC) },
	{ "embalmer", S_HUMAN, 5, 10, 10, 30, 0, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG |
	  M2_COLLECT | M2_MAGIC, 0, C(BLACK) },
	{ "acolyte", S_HUMAN, 5, 10, 10, 20, 0, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_CLRC, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(HI_DOMESTIC) },
	{ "thug", S_HUMAN, 5, 10, 10, 10, -3, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG |
	  M2_GREEDY | M2_COLLECT,
	  0, C(BLACK) },
	{ "ninja", S_HUMAN, 5, 10, 10, 10, 3, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(BLACK) },
	{ "ronin", S_HUMAN, 5, 10, 10, 10, 3, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_HUMANOID, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_HOSTILE | M2_STRONG | M2_COLLECT,
	  0, C(HI_DOMESTIC) },
#ifdef TOURIST
	{ "guide", S_HUMAN, 5, 10, 10, 20, 0, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG |
	  M2_COLLECT | M2_MAGIC, 0, C(HI_DOMESTIC) },
#endif
	{ "exterminator", S_HUMAN, 8, 10, 10, 10, 10, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(BLACK) },
	{ "warrior", S_HUMAN, 5, 10, 10, 10, -1, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG | M2_COLLECT,
	  0, C(HI_DOMESTIC) },
	{ "apprentice", S_HUMAN, 5, 10, 10, 30, 0, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  WT_HUMAN, 400, 0, MS_GUARDIAN, MZ_HUMAN, MR_HITASONE, 0,
	  M1_HUMANOID | M1_OMNIVORE,
	  M2_NOPOLY | M2_HUMAN | M2_PEACEFUL | M2_STRONG |
	  M2_COLLECT | M2_MAGIC, 0, C(HI_ZAP) },
/*      evil food         */
	{ "bad egg", S_BAD_FOOD, 4, 9, 7, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 1),
	  { { AT_BITE, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_BREATHLESS | M1_ANIMAL | M1_NOEYES | M1_NOHEAD | M1_MINDLESS |
	  M1_NOLIMBS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(WHITE) },
	{ "killer tripe ration", S_BAD_FOOD, 7, 9, 7, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 1),
	  { { AT_BITE, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_BREATHLESS | M1_ANIMAL | M1_NOEYES | M1_NOHEAD | M1_MINDLESS |
	  M1_NOLIMBS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
	{ "killer food ration", S_BAD_FOOD, 9, 9, 7, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 1),
	  { { AT_BITE, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_BREATHLESS | M1_ANIMAL | M1_NOEYES | M1_NOHEAD | M1_MINDLESS |
	  M1_NOLIMBS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(BROWN) },
/*      evil coins        */
	{ "pile of killer coins", S_BAD_COINS, 6, 9, 7, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 1),
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_BREATHLESS | M1_ANIMAL | M1_NOEYES | M1_NOHEAD | M1_MINDLESS |
	  M1_NOLIMBS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(YELLOW) },
	{ "large pile of killer coins", S_BAD_COINS, 9, 12, 7, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 1),
	  { { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_BREATHLESS | M1_ANIMAL | M1_NOEYES | M1_NOHEAD | M1_MINDLESS |
	  M1_NOLIMBS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(YELLOW) },
	{ "huge pile of killer coins", S_BAD_COINS, 11, 12, 7, 0, 0, (G_NOHELL | G_GENO | G_NOCORPSE | 1),
	  { { AT_BITE, AD_PHYS, 4, 6 }, NO_ATTK, NO_ATTK,
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, MS_SILENT, MZ_SMALL, 0, 0,
	  M1_BREATHLESS | M1_ANIMAL | M1_NOEYES | M1_NOHEAD | M1_MINDLESS |
	  M1_NOLIMBS | M1_CARNIVORE,
	  M2_HOSTILE, 0, C(YELLOW) },

#endif /* MULDGN /* */
/*      ARRAY TERMINATOR        */
	{ "", 0, 0, 0, 0, 0, 0, 0,
	  { NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, C(0) }
};
#endif /* !SPLITMON_1 */

#ifndef SPLITMON_1
/* dummy routine used to force linkage */
void
monst_init()
{
    return;
}
#endif

/*monst.c*/
