// -[KeepHeading]-


// -[Copyright]-

/**
 * (c) Step Ahead Software Pty Ltd 1996. All rights reserved. Registered
 * of JAVelin may use this applet in their web pages.
 */
import java.lang.*;


// -[KeepBeforeClass]-
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Font;
import java.awt.Event;
import java.applet.Applet;


// -[Class]-

/**
 * @jTitle           BounceApplet
 * @jAuthor          Chris Colman
 * @jOverridability  can be overridden
 * @jDescription
 * BounceApplication is a JAVA applet that manages and displays a set
 * of BounceAnimations.
 * 
 * @see              Runnable, Applet
 */
public 
class BounceApplet extends Applet implements Runnable
{
// -[KeepWithinClass]-


// -[Fields]-



/**
 * A constant that stores the number of objects in the BounceAnimations
 * array.
 */
protected static int NUMOBJS= 4;



/**
 * An array of BounceAnimations. This is initially unallocated but the
 * constructor allocates space for the array.
 */
protected BounceAnimation bounceAnimations[];



/**
 * Thread of execution that cycles through the BounceAnimations advancing
 * them to their next state.
 */
protected Thread bouncer= null;



/**
 * Font used for message at the bottom.
 */
protected Font messageFont= new Font("Helvetica", Font.PLAIN, 12);



/**
 * Font used for moving objects.
 */
protected Font movingFont= new Font("TimesRoman",Font.BOLD,24);



/**
 * State of thread's execution.
 */
protected boolean threadSuspended= false;



// -[Methods]-

/**
 * Describe here
 */
public void destroy()
{
	if ( bouncer != null )
	{
		bouncer.stop();
		// wake up so can die
		bouncer.resume();
	}
}

/**
 * Initialises the applet.
 */
public void init()
{
	// Allocate space for the array of BounceAnimations
	bounceAnimations = new BounceAnimation[NUMOBJS];

	// Resize the applet window ot 400x120 pixels
	resize(400,120);

	// Set the current font to the message font field
	setFont(messageFont);

	// Create the animations and add them to the array
	bounceAnimations[0] = new BounceAnimation("Javelin: Slick, cool and very, very HOT!", 1, Color.red, 50, 20, 3);
	bounceAnimations[1] = new BounceAnimation("Visual Classworks", -1, Color.blue, 100, 80, 1);
	bounceAnimations[2] = new BounceAnimation("C++", 1, Color.green, 150, 60, 5);
	bounceAnimations[3] = new BounceAnimation("Visual Object Oriented Development", -1, Color.yellow, 175, 40, 4);
}

/**
 * Starts the applet.
 */
public void start()
{
	System.out.println("Starting");

	if (bouncer == null) {
		bouncer = new Thread(this);
		bouncer.start();
	}
	else
		if (bouncer.isAlive())
			bouncer.resume();
}

/**
 * Called to stop the execution.
 */
public void stop()
{
	System.out.println("Stopping");

	if (bouncer != null) {
		bouncer.suspend();
	}
}

/**
 * Calls when a new thread is created. The thread dies when this function
 * returned.
 */
public void run()
{
	while ( true ) {
		try {
			Thread.sleep(100);
		} 
		catch (InterruptedException e) {
		}

		repaint();
	}
}

/**
 * Called whenever a window needs updating.
 */
public void paint(Graphics g)
{
	Rectangle r = bounds();


	Font oldF = g.getFont();
	g.setFont(movingFont);

	for(int i = 0; i < NUMOBJS; i++)
	{
		bounceAnimations[i].advance(r.width);
		bounceAnimations[i].paint(g);
	}
	g.setFont(oldF);

	g.drawString("Click to toggle the animation on/off", 10, 100);
}




/**
 * Called when the mouse goes down on this object.
 */
public boolean mouseDown(Event evt, int x, int y)
{
	if (threadSuspended) {
		bouncer.resume();
	}
	else {
		bouncer.suspend();
	}
	
	threadSuspended = !threadSuspended;

	return true;
}
}
