@ECHO OFF
CLS
ECHO ************************************************************************
ECHO *   NEWL95.BAT - Updates to the latest versions of L4W95 'Client' and  *
ECHO *   L4W95 'File and printer sharing'.                                  *
ECHO *                                                                      *
ECHO *   This batch file installs a new version of both the 'Client' and    *
ECHO *   'File and printer sharing' portions of LANtastic for Windows 95    *
ECHO *   that fix the problems listed in NOSL95.TXT.                        *
ECHO *                                                                     *
ECHO *   This batch file should be run from the temporary directory where   *
ECHO *   you copied NOSL95.EXE.  Be sure that you have restarted the        *
ECHO *   computer in MS-DOS mode.                                           *
ECHO *                                                                      *
ECHO *   The destination directories for the files in this update           *
ECHO *   are C:\LANTASTI\WIN95, C:\LANTASTI\WIN95\INSTALL, and your         *
ECHO *   Windows 95 \SYSTEM directory.                                      *
ECHO *                                                                      *  
ECHO *   Your present copies of the files to be updated will be backed up   *
ECHO *   in a .\NOSL95.OLD directory below this temporary directory.        *
ECHO *                                                                      *
ECHO *                                                                      *
ECHO *   Press CTRL-C now to abort running this patch.                      *
ECHO ************************************************************************
PAUSE

:FILESEXIST
IF NOT EXIST AFSD.VPE GOTO ERR1DIR
IF NOT EXIST ASNBPSD.VPE GOTO ERR1DIR
IF NOT EXIST LCAEXEC.EXE GOTO ERR1DIR
IF NOT EXIST LTSHEX.DLL GOTO ERR1DIR
IF NOT EXIST SERVER.LCA GOTO ERR1DIR
IF NOT EXIST VLTSERV.VPE GOTO ERR1DIR
IF NOT EXIST VLTSERV.MSG GOTO ERR1DIR
IF NOT EXIST VSVRSNB.VPE GOTO ERR1DIR
IF NOT EXIST VSVRSNB.MSG GOTO ERR1DIR

:DIRSEXIST
IF NOT EXIST %WINBOOTDIR%\SYSTEM\ATILA.VPE GOTO ERRWSYS
IF NOT EXIST C:\LANTASTI\WIN95\NUL GOTO ERRLW95
IF NOT EXIST C:\LANTASTI\WIN95\INSTALL\ATILA.VPE GOTO ERRLW95I

:BATEXIST
IF EXIST %WINBOOTDIR%\SYSTEM\NEWL95.BAT GOTO ERR2DIR
IF EXIST C:\LANTASTI\WIN95\NEWL95.BAT GOTO ERR2DIR
IF EXIST C:\LANTASTI\WIN95\INSTALL\NEWL95.BAT GOTO ERR2DIR

:BACKUPOLD
ECHO.
ECHO Ready to backup the L4W95 files that are to be updated to a directory 
ECHO named NOSL95.OLD below this directory:
TRUENAME
ECHO.
PAUSE

:MAKEDIR
IF EXIST .\NOSL95.OLD\NUL GOTO :NOMAKEDIR
ECHO.
ECHO Creating directory NOSL95.OLD ...
ECHO.
MD NOSL95.OLD

:NOMAKEDIR
ECHO.
ECHO Backing up files from the Windows 95 \SYSTEM directory ...
ECHO.
COPY/-Y %WINBOOTDIR%\SYSTEM\AFSD.VPE .\NOSL95.OLD\AFSD.VPE 
COPY/-Y %WINBOOTDIR%\SYSTEM\ASNBPSD.VPE .\NOSL95.OLD\ASNBPSD.VPE 
COPY/-Y %WINBOOTDIR%\SYSTEM\LTSHEX.DLL .\NOSL95.OLD\LTSHEX.DLL 
COPY/-Y %WINBOOTDIR%\SYSTEM\VLTSERV.VPE .\NOSL95.OLD\VLTSERV.VPE 
COPY/-Y %WINBOOTDIR%\SYSTEM\VLTSERV.MSG .\NOSL95.OLD\VLTSERV.MSG 
COPY/-Y %WINBOOTDIR%\SYSTEM\VSVRSNB.VPE .\NOSL95.OLD\VSVRSNB.VPE 
COPY/-Y %WINBOOTDIR%\SYSTEM\VSVRSNB.MSG .\NOSL95.OLD\VSVRSNB.MSG 
ECHO.
ECHO.
ECHO Backing up files from the C:\LANTASTI\WIN95 directory ...
ECHO.
COPY/-Y C:\LANTASTI\WIN95\LCAEXEC.EXE .\NOSL95.OLD\LCAEXEC.EXE
COPY/-Y C:\LANTASTI\WIN95\SERVER.LCA .\NOSL95.OLD\SERVER.LCA
ECHO.

ECHO.
ECHO Ready to update LANtastic for Windows 95 ...
ECHO.
PAUSE

:INSTALL
ECHO.
ECHO Updating files in the C:\LANTASTI\WIN95\INSTALL directory ...
ECHO.
COPY/Y AFSD.VPE C:\LANTASTI\WIN95\INSTALL\AFSD.VPE
COPY/Y ASNBPSD.VPE C:\LANTASTI\WIN95\INSTALL\ASNBPSD.VPE
COPY/Y LCAEXEC.EXE C:\LANTASTI\WIN95\INSTALL\LCAEXEC.EXE
COPY/Y LTSHEX.DLL C:\LANTASTI\WIN95\INSTALL\LTSHEX.DLL
COPY/Y SERVER.LCA C:\LANTASTI\WIN95\INSTALL\SERVER.LCA
COPY/Y VLTSERV.VPE C:\LANTASTI\WIN95\INSTALL\VLTSERV.VPE
COPY/Y VLTSERV.MSG C:\LANTASTI\WIN95\INSTALL\VLTSERV.MSG
COPY/Y VSVRSNB.VPE C:\LANTASTI\WIN95\INSTALL\VSVRSNB.VPE
COPY/Y VSVRSNB.MSG C:\LANTASTI\WIN95\INSTALL\VSVRSNB.VPE

:WINSYS
ECHO.
ECHO Updating files in the Windows 95 \SYSTEM directory ...
ECHO.

:FILE1
COPY/Y AFSD.VPE %WINBOOTDIR%\SYSTEM\AFSD.VPE
IF NOT ERRORLEVEL 1 GOTO :FILE2
ECHO ERROR DETECTED -- Copy AFSD.VPE manually to Windows 95 \SYSTEM ...
ECHO.
PAUSE

:FILE2
COPY/Y ASNBPSD.VPE %WINBOOTDIR%\SYSTEM\ASNBPSD.VPE
IF NOT ERRORLEVEL 1 GOTO :FILE3
ECHO ERROR DETECTED -- Copy ASNBPSD.VPE manually to Windows 95 \SYSTEM ...
ECHO.
PAUSE

:FILE3
COPY/Y LTSHEX.DLL %WINBOOTDIR%\SYSTEM\LTSHEX.DLL
IF NOT ERRORLEVEL 1 GOTO :FILE4
ECHO ERROR DETECTED -- Copy LTSHEX.DLL manually to Windows 95 \SYSTEM ...
ECHO.
PAUSE

:FILE4
COPY/Y VLTSERV.VPE %WINBOOTDIR%\SYSTEM\VLTSERV.VPE
IF NOT ERRORLEVEL 1 GOTO :FILE5
ECHO ERROR DETECTED -- Copy VLTSERV.VPE manually to Windows 95 \SYSTEM ...
ECHO.
PAUSE

:FILE5
COPY/Y VLTSERV.MSG %WINBOOTDIR%\SYSTEM\VLTSERV.MSG
IF NOT ERRORLEVEL 1 GOTO :FILE6
ECHO ERROR DETECTED -- Copy VLTSERV.MSG manually to Windows 95 \SYSTEM ...
ECHO.
PAUSE

:FILE6
COPY/Y VSVRSNB.VPE %WINBOOTDIR%\SYSTEM\VSVRSNB.VPE
IF NOT ERRORLEVEL 1 GOTO :FILE7
ECHO ERROR DETECTED -- Copy VSVRSNB.VPE manually to Windows 95 \SYSTEM ...
ECHO.
PAUSE

:FILE7
COPY/Y VSVRSNB.MSG %WINBOOTDIR%\SYSTEM\VSVRSNB.MSG
IF NOT ERRORLEVEL 1 GOTO :FILE8
ECHO ERROR DETECTED -- Copy VSVRSNB.MSG manually to Windows 95 \SYSTEM ...
ECHO.
PAUSE

:FILE8
ECHO.
ECHO Updating files in the C:\LANTASTI\WIN95 directory ...
ECHO.
COPY/Y LCAEXEC.EXE C:\LANTASTI\WIN95\LCAEXEC.EXE
IF NOT ERRORLEVEL 1 GOTO :FILE9
ECHO ERROR DETECTED -- Copy LCAEXEC.EXE manually to C:\LANTASTI\WIN95 ...
ECHO.
PAUSE

:FILE9
COPY/Y SERVER.LCA C:\LANTASTI\WIN95\SERVER.LCA
IF NOT ERRORLEVEL 1 GOTO :DONE
ECHO ERROR DETECTED -- Copy SERVER.LCA manually to C:\LANTASTI\WIN95 ...
ECHO.
PAUSE
GOTO :DONE

:ERR1DIR
ECHO.
ECHO                           * ERROR *
ECHO.
ECHO A file needed for this update was not not found in this directory.
ECHO Please change to the directory where you self-extracted NOSL95.EXE 
ECHO and rerun this batch file.  
ECHO.
ECHO.
GOTO EXIT

:ERR2DIR
ECHO.
ECHO                           * ERROR *
ECHO.
ECHO This batch file was found to exist in a destination directory needed
ECHO for this update.  Please place and self-extract NOSL95.EXE in a separate 
ECHO temporary directory and rerun this batch file.  The update should then
ECHO proceed correctly.  
ECHO.
ECHO Note that some of your original files may have now been overwritten, 
ECHO and that you may need to reinstall from your original disks to return
ECHO to your original configuration.  
ECHO.
ECHO.
GOTO EXIT

:ERRWSYS
ECHO.
ECHO                           * ERROR *
ECHO.
ECHO A file from a licensed copy of LANtastic for Windows 95 does not appear 
ECHO to exist in your Windows 95 \SYSTEM directory.  Be sure that LANtastic
ECHO for Windows 95 has been correctly installed.  
ECHO.
ECHO.
GOTO EXIT

:ERRLW95
ECHO 
ECHO                           * ERROR *
ECHO 
ECHO The C:\LANTASTI\WIN95 directory does not appear to exist.  Be sure that
ECHO LANtastic for Windows 95 has been correctly installed.
ECHO.
ECHO.
GOTO EXIT

:ERRLW95I
ECHO 
ECHO                           * ERROR *
ECHO 
ECHO A file from a licensed copy of LANtastic for Windows 95 does not appear
ECHO to exist in the C:\LANTASTI\WIN95\INSTALL directory.  Be sure that
ECHO LANtastic for Windows 95 has been correctly installed.
ECHO.
ECHO.
GOTO EXIT

:DONE
ECHO.
ECHO.
ECHO.
ECHO          * LANtastic for Windows 95 has been updated. *
ECHO.
ECHO.
ECHO   * Be sure to manually copy any files that were not updated. *
ECHO.
ECHO.

:EXIT
