Option Explicit

Global Const A4WidthInTwips = 11905 '21cm in twips
Global Const A4LengthInTwips = 15307 '27cm in twips
Global Const TWIPS_IN_MM = 56.7
Global Const TWIPS_IN_CM = 567

Type FormState
    Deleted As Integer
    Dirty As Integer
    Ignore As Integer
End Type
Global FState()  As FormState
Global Document() As New frmMDIChild
Global gFindString, gFindCase As Integer, gFindDirection As Integer
Global gCurPos As Integer, gFirstTime As Integer
Global ArrayNum As Integer

'-------------------------------------------------------------------------
' AnyPadsLeft
'
' Look for a free entry in the document array
'-------------------------------------------------------------------------
Function AnyPadsLeft () As Integer
    Dim i As Integer

    ' Cycle throught the document array.
    ' Return True if there is at least one
    ' open document remaining.
    For i = 1 To UBound(Document)
        If Not FState(i).Deleted Then
            AnyPadsLeft = True
            Exit Function
        End If
    Next

End Function

'-------------------------------------------------------------------------
' EditCopyProc
'
' Copy selected text to the clipboard
'-------------------------------------------------------------------------
Sub EditCopyProc ()
    frmMDIParent.ActiveForm.TextControl1.Clip = CLIP_COPY
End Sub

'-------------------------------------------------------------------------
' EditCutProc
'
' Cuts selected text and copy it to clipboard
'-------------------------------------------------------------------------
Sub EditCutProc ()
    frmMDIParent.ActiveForm.TextControl1.Clip = CLIP_CUT
End Sub

'-------------------------------------------------------------------------
' EditDeleteProc
'
' Deletes selected text (or next character)
'-------------------------------------------------------------------------
Sub EditDeleteProc ()
    frmMDIParent.ActiveForm.TextControl1.Clip = CLIP_CLEAR
End Sub

'-------------------------------------------------------------------------
' EditFindReplaceProc
'
' Call find or replace dialog
'
' Parameters: 1 find dialog
'             2 replace dialog
'-------------------------------------------------------------------------
Sub EditFindReplaceProc (Flag As Integer)
    frmMDIParent.ActiveForm.TextControl1.FindReplace = Flag
End Sub

'-------------------------------------------------------------------------
' EditPasteProc
'
' Paste clipboard data
'-------------------------------------------------------------------------
Sub EditPasteProc ()
    frmMDIParent.ActiveForm.TextControl1.Clip = CLIP_PASTE
End Sub

'-------------------------------------------------------------------------
' EditSelectAll
'
' Select whole text
'-------------------------------------------------------------------------
Sub EditSelectAll ()
    Dim nPointer As Integer     'MousePointer proterty value

    nPointer = frmMDIParent.ActiveForm.TextControl1.MousePointer
    frmMDIParent.ActiveForm.TextControl1.MousePointer = 11
    frmMDIParent.ActiveForm.TextControl1.SelStart = 0
    frmMDIParent.ActiveForm.TextControl1.SelLength = -1
    frmMDIParent.ActiveForm.TextControl1.MousePointer = nPointer
End Sub

Sub EditSpellCheckProc ()

frmMDIParent.ActiveForm.TextControl1.VTSpellCheck = True
MsgBox "Spell Checking is Complete."

End Sub

'-------------------------------------------------------------------------
' EnableToolbarButtons
'
'-------------------------------------------------------------------------
Sub EnableToolbarButtons ()
    If AnyPadsLeft() Then
        frmMDIParent!imgFileSaveButton.Picture = frmMDIParent!imgFileSaveButtonUp.Picture
        frmMDIParent!imgFileSaveButton.Enabled = True
        frmMDIParent!imgCutButton.Picture = frmMDIParent!imgCutButtonUp.Picture
        frmMDIParent!imgCutButton.Enabled = True
        frmMDIParent!imgCopyButton.Picture = frmMDIParent!imgCopyButtonUp.Picture
        frmMDIParent!imgCopyButton.Enabled = True
        frmMDIParent!imgPasteButton.Picture = frmMDIParent!imgPasteButtonUp.Picture
        frmMDIParent!imgPasteButton.Enabled = True
    Else
        frmMDIParent!imgFileSaveButton.Picture = frmMDIParent!imgFileSaveButtonDis.Picture
        frmMDIParent!imgFileSaveButton.Enabled = False
        frmMDIParent!imgCutButton.Picture = frmMDIParent!imgCutButtonDis.Picture
        frmMDIParent!imgCutButton.Enabled = False
        frmMDIParent!imgCopyButton.Picture = frmMDIParent!imgCopyButtonDis.Picture
        frmMDIParent!imgCopyButton.Enabled = False
        frmMDIParent!imgPasteButton.Picture = frmMDIParent!imgPasteButtonDis.Picture
        frmMDIParent!imgPasteButton.Enabled = False
    End If
End Sub

'-------------------------------------------------------------------------
' FileNewProc
'
' Initialize a new window
'-------------------------------------------------------------------------
Sub FileNewProc ()
    Dim fIndex As Integer

    fIndex = FindFreeIndex()
    If fIndex <> 0 Then
        Document(fIndex).Tag = fIndex
        Document(fIndex).Caption = "Untitled:" & fIndex
        Document(fIndex).TXRuler1.ScaleUnits = SCALE_MM
        Document(fIndex).Show

        ' Make sure toolbar edit buttons are visible
        frmMDIParent!imgCutButton.Visible = True
        frmMDIParent!imgCopyButton.Visible = True
        frmMDIParent!imgPasteButton.Visible = True
    End If
    
End Sub

'-------------------------------------------------------------------------
' FindFreeIndex
'
'-------------------------------------------------------------------------
Function FindFreeIndex () As Integer
    Dim i As Integer
    Dim ArrayCount As Integer

    ArrayCount = UBound(Document)

    ' Cycle throught the document array. If one of the
    ' documents has been deleted, then return that
    ' index.
    For i = 1 To ArrayCount
        If FState(i).Deleted Then
            FindFreeIndex = i
            FState(i).Deleted = False
            FState(i).Ignore = False
            Exit Function
        End If
    Next

    ' If none of the elements in the document array have
    ' been deleted, then increment the document and the
    ' state arrays by one and return the index to the
    ' new element.

    ReDim Preserve Document(ArrayCount + 1)
    ReDim Preserve FState(ArrayCount + 1)
    FindFreeIndex = UBound(Document)
End Function

'-------------------------------------------------------------------------
' FormatColorProc
'
' Set text or background color
'-------------------------------------------------------------------------
Sub FormatColorProc (Index As Integer)
    Dim lOldColor As Long

    On Error Resume Next

    If Index = COLOR_TEXT Then
        lOldColor = frmMDIParent.ActiveForm.TextControl1.TextColor
    Else
        lOldColor = frmMDIParent.ActiveForm.TextControl1.BackColor
    End If

    If lOldColor = -1 Then
        frmMDIParent.CMDialog1.Color = 0  'use black if different colors
    Else
        frmMDIParent.CMDialog1.Color = lOldColor
    End If

    frmMDIParent.CMDialog1.Flags = CC_RGBINIT Or CC_PREVENTFULLOPEN
    frmMDIParent.CMDialog1.CancelError = True
    frmMDIParent.CMDialog1.Action = DLG_COLOR
    If Err Then Exit Sub

    'set new color

    If lOldColor = -1 Or frmMDIParent.CMDialog1.Color <> lOldColor Then
        If Index = COLOR_TEXT Then
            frmMDIParent.ActiveForm.TextControl1.TextColor = frmMDIParent.CMDialog1.Color
        Else
            frmMDIParent.ActiveForm.TextControl1.BackColor = frmMDIParent.CMDialog1.Color
        End If
    End If
End Sub

'-------------------------------------------------------------------------
' FormatDocProc
'
' Call the document formatting dialog
'-------------------------------------------------------------------------
Sub FormatDocProc ()
    frmDocDlg.Show 1
End Sub

'-------------------------------------------------------------------------
' FormatFramesProc
'
' Call the paragraph frames dialog
'-------------------------------------------------------------------------
Sub FormatFramesProc ()
    frmFramesDlg.Show 1
End Sub

'-------------------------------------------------------------------------
' ResizeChild
'
' Resize a text window
'-------------------------------------------------------------------------
Sub ResizeChild (frmCurrent As Form)
    
    'Switch background color to gray if child window gets
    'bigger than maximum TX width (30% zoom on large screens)
    If frmCurrent.Width > frmCurrent!TextControl1.Width Then
        frmCurrent.BackColor = &HC0C0C0
    Else
        frmCurrent.BackColor = &HFFFFFF
    End If
    
    'Resize TX window when MDI child is resized. Do not resize
    'if window is too small.
    If frmCurrent.WindowState <> 1 And frmCurrent.ScaleHeight - frmCurrent!TXRuler1.Height > 0 Then
        frmCurrent!TextControl1.Height = frmCurrent.ScaleHeight
        If (frmCurrent!TXRuler1.Visible) Then
            frmCurrent!TextControl1.Height = frmCurrent!TextControl1.Height - frmCurrent!TXRuler1.Height
        End If
    End If
End Sub

'-------------------------------------------------------------------------
' ViewParagraphBarProc
'
' Switch button bar visible state
'-------------------------------------------------------------------------
Sub ViewParagraphBarProc (frmCurrent As Form)
    frmMDIParent!TXButtonBar1.Visible = Not frmMDIParent!TXButtonBar1.Visible
    frmCurrent!mnuView_ParagraphBar.Checked = frmMDIParent!TXButtonBar1.Visible
    frmMDIParent!picToolbar.Top = 0
End Sub

'-------------------------------------------------------------------------
' ViewRulerProc
'
' Switch the ruler visible state
'-------------------------------------------------------------------------
Sub ViewRulerProc (frmCurrent As Form)
    frmCurrent!TXRuler1.Visible = Not frmCurrent!TXRuler1.Visible
    frmCurrent!mnuView_Ruler.Checked = frmCurrent!TXRuler1.Visible
    ResizeChild frmCurrent
End Sub

'-------------------------------------------------------------------------
' ViewStatusBarProc
'
' Switch the status bar visible state
'-------------------------------------------------------------------------
Sub ViewStatusBarProc (frmCurrent As Form)
    frmMDIParent!TXStatusBar1.Visible = Not frmMDIParent!TXStatusBar1.Visible
    frmCurrent!mnuView_StatusBar.Checked = frmMDIParent!TXStatusBar1.Visible
End Sub

'-------------------------------------------------------------------------
' ViewToolBarProc
'
' Switch the toolbar visible state
'-------------------------------------------------------------------------
Sub ViewToolBarProc (frmCurrent As Form)
    frmMDIParent!picToolbar.Visible = Not frmMDIParent!picToolbar.Visible
    frmCurrent!mnuView_Toolbar.Checked = frmMDIParent!picToolbar.Visible
    frmMDIParent!picToolbar.Top = 0
End Sub

