/*------------------------------------------------------------
 * 
 *  calcpopyx.c
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 * 
 *  calculate where to put a popup box relative to the
 *  current cursor position / input field location
 * 
 *  returns ERR if you can't pop up without covering the cursor
 *  otherwise it returns OK
 * 
 *----------------------------------------------------------*/

#include "curses.h"

#define MAX_DISTANCE 10
#define MIN_DISTANCE 1

int
calcpopyx(rows, cols, cury, minx, maxx, yp, xp)
int rows, cols, minx, maxx, *yp, *xp;
{
    int y0, y1, x0, x1, dist;

    for (dist = MAX_DISTANCE; dist >= MIN_DISTANCE; dist--) {
        /* look right */
        x0 = maxx + dist;
        x1 = x0 + cols - 1;
        y0 = (LINES - rows) / 2;
        y1 = y0 + rows - 1;
        if (x1 <= COLS)
            break;
        /* look left */
        x1 = minx - dist;
        x0 = x1 - cols + 1;
        if (x0 >= 0)
            break;
        /* look above */
        x0 = (COLS - cols) / 2;
        x1 = x0 + cols - 1;
        y1 = cury - dist;
        y0 = y1 - rows + 1;
        if (y0 >= 0)
            break;
        /* look below */
        y0 = cury + dist;
        y1 = y0 + rows - 1;
        if (y1 <= LINES)
            break;
    }
    if (dist < MIN_DISTANCE) {
        /* center of screen */
        *xp = (COLS - cols) / 2;
        *yp = (LINES - rows) / 2;
        return ERR;
    } else {
        *xp = x0;
        *yp = y0;
        return OK;
    }
}


