/*------------------------------------------------------------
 * 
 *  newwin.c
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  create new windows and subwindows
 * 
 *  NOTE: SUB-WINDOWS MUST BE WHOLLY CONTAINED WITHIN THEIR
 *  PARENT WINDOWS OR ALLOCATION FAILS!
 * 
 *----------------------------------------------------------*/

#include "curses.h"

WINDOW *
newwin(r,c,y,x)
{
    WINDOW *win;
    void *ptrs[4];
    int row;
    VIDCHR fillch;
	
    if (r == 0)
        r = LINES - y;
    if (c == 0)
        c = COLS - x;
                
    ptrs[0] = calloc(1, sizeof(WINDOW));
    ptrs[1] = calloc(r, sizeof(VIDCHR *));
    ptrs[2] = calloc(r, sizeof(int));
    ptrs[3] = calloc(r, sizeof(int));
    
    if (!ptrs[0] || !ptrs[1] || !ptrs[2] || !ptrs[3]) {
        int n;

        for (n = 0; n < 4; n++)
            if (ptrs[n])
                free(ptrs[n]);

        return NULL;
    }            

    win = ptrs[0];
    win->buf = ptrs[1];
    win->firstx = ptrs[2];
    win->lastx = ptrs[3];

    for (row = 0; row < r; row++) {
        win->buf[row] = calloc(c, sizeof(VIDCHR));
        if (!win->buf[row])
            break;
    }
                
    if (row < r) {
        int n;
        
        /* almost made it */
        while (--row >= 0)
            free(win->buf[row]);
        for (n = 0; n < 4; n++)
            free(ptrs[n]);
        return NULL;
    }
                
    fillch.chr = ' ';
    fillch.att = __DEFNORM;
                
    for (row = 0; row < r; row++)
        memsetw(win->buf[row], &fillch, c);
                
    win->orgy = y;
    win->orgx = x;
    win->maxy = r - 1;
    win->maxx = c - 1;
    win->n_attr = win->attrib = __DEFNORM;
    win->s_attr = __DEFSTAND;
    win->b_attr = __DEFBRIGHT;
    win->flags |= (_WWRAP | _WSCROLL);
    if (r >= LINES && c >= COLS)
        win->flags |= _WFULLWIN;
    touchwin(win);

    return win;
}

/*
        r, c are scaled to fit if they are 0
        y, x are relative to the screen, NOT the parent window
*/

WINDOW *
subwin(win, r, c, y, x)
WINDOW *win;
{
    WINDOW *sub;
    int yoffs, xoffs, row, col;
    void *ptrs[4];
                
    yoffs = y - win->orgy;
    xoffs = x - win->orgx;          

    if (yoffs < 0 || xoffs < 0) /* out of bounds */
        return 0;
    
    row = win->maxy - yoffs + 1;
    col = win->maxx - xoffs + 1;
        
    if (row < 1 || col < 1) /* out of bounds */
        return 0;

    if (r == 0) /* set max rows */
        r = row;
    else if (r > row) /* too tall */
        return 0;
    if (c == 0) /* set max cols */
        c = col;
    else if (c > col) /* too wide */
        return 0;

    ptrs[0] = calloc(1, sizeof(WINDOW));
    ptrs[1] = calloc(r, sizeof(VIDCHR *));
    ptrs[2] = calloc(r, sizeof(int));
    ptrs[3] = calloc(r, sizeof(int));

    if (!ptrs[0] || !ptrs[1] || !ptrs[2] || !ptrs[3]) {
        int n;
            
        for (n = 0; n < 4; n++)
            if (ptrs[n])
                free(ptrs[n]);

        return  NULL;                    
    }

    sub = ptrs[0];
    sub->buf = ptrs[1];
    sub->firstx = ptrs[2];
    sub->lastx = ptrs[3];
    
    for (row = 0; row < r; row++)
        sub->buf[row] = win->buf[row + yoffs] + xoffs;
                
    sub->orgy = y;
    sub->orgx = x;
    sub->maxy = r - 1;
    sub->maxx = c - 1;
    sub->attrib = win->attrib;
    sub->n_attr = win->n_attr;
    sub->s_attr = win->s_attr;
    sub->b_attr = win->b_attr;
    sub->flags = win->flags | _WSUBWIN;
    if (r < LINES || c < COLS)
        sub->flags &= ~_WFULLWIN;
    touchwin(sub);
    
    return sub;
}
