/**********************************************************************
 *  
 *  NAME:           keybdtsk.cpp
 *  
 *  DESCRIPTION:    example task to handle keyboard input (polling)
 *  
 *  copyright (c) 1991 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  05/09/91    J. Alan Eldridge    created
 *  
 *********************************************************************/

#include    "aedef.h"
#include    "task.h"
#include    "keybdtsk.h"

#define QSize       128 //  # chars in keyboard queue

#define SendDelay   50  //  # milliseconds to wait to send
#define SleepTime   50  //  # milliseconds between polling 

KeybdTask           KbdTask;
BPipe               KbdPipe(QSize);

void
KeybdTask::TaskMain()
{
    for (;;) {
        if (kbhit()) {
            uchar   ch = getch();
            
            KbdPipe.send(ch, SendDelay);
            if (ch == 0xE0 || ch == 0x00) {
                ch = getch();
                KbdPipe.send(ch, SendDelay);
            }
        }
        sleep(SleepTime);
    }
}
