#include "C:\tc\mysource\ansi2.h"
#include <stdio.h>

// member functions for the AnsiCurosr class

AnsiCursor::AnsiCursor(int Initrows=0 , int Initcols=0)
{
cols = Initcols;
rows = Initrows;
}

void AnsiCursor::Goup(int nrows) {
printf("\x1B[%dA", nrows);
rows -= nrows;
}

void AnsiCursor::Godown(int nrows) {
printf("\x1B[%dB", nrows);
rows += nrows;
}

void AnsiCursor::Forward(int ncols) {
printf("\x1B[%dC",  ncols);
cols += ncols;
}

void AnsiCursor::Backward(int ncols) {
printf("\x1B[%dD", ncols);
cols -= ncols;
}

void AnsiCursor::Save(void) {
printf("\x1B[s");
}

void AnsiCursor::Restore(void) {
printf("\x1B[u");
}

void AnsiCursor::Home(void) {
printf("\x1B[H");
cols = 0;
rows=0;
}

void AnsiCursor::Clrline(void) {
printf("\x1B[K");
}

void AnsiCursor::Cls(void) {
printf("\x1B[2J");
cols=0;
rows=0;
}

void AnsiCursor::Clratt(void) {
printf("\x1B[0m");
}

void AnsiCursor::Bold(void) {
printf("\x1b[1m");
}

void AnsiCursor::Blink(void) {
printf("\x1b[5m");
}

void AnsiCursor::Reverse(void) {
printf("\x1b[7m");
}

void AnsiCursor::Hide(void) {
printf("\x1b[8m");
}

void AnsiCursor::Go(int nrows, int ncols) {
printf("\x1B[%d;%df", nrows, ncols);
cols=ncols;
rows=nrows;
}

