/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 */

#include "bccgrx00.h"

/* ATTENTION : Check this definition against LIBGRX/src/interrup.h !! */
# include <sys/registers.h>
extern  void  int10(REGISTERS *regs);

struct palettetype __gr_EGAdef =
  { size:16, colors:{EGA_BLACK, EGA_BLUE, EGA_GREEN, EGA_CYAN, EGA_RED,
		     EGA_MAGENTA, EGA_BROWN, EGA_LIGHTGRAY, EGA_DARKGRAY,
		     EGA_LIGHTBLUE, EGA_LIGHTGREEN, EGA_LIGHTCYAN,
		     EGA_LIGHTRED, EGA_LIGHTMAGENTA, EGA_YELLOW, EGA_WHITE}};

static struct palettetype *AktPal = &__gr_EGAdef;
static struct palettetype UsrPal;

/* ----------------------------------------------------------------- */
void getpalette(struct palettetype  *palette)
{
  _DO_INIT_CHECK;
  memcpy( palette, AktPal, sizeof(struct palettetype));
}

/* ----------------------------------------------------------------- */
void setallpalette(struct palettetype *palette)
{
  int i;

  _DO_INIT_CHECK;
  for (i=0; i < palette->size; ++i)
    setpalette( i, palette->colors[i]);
}

/* ----------------------------------------------------------------- */
void setpalette(int colornum, int color)
{
  REGISTERS regs;

  colornum &= 0x0f;
  color    &= 0x3f;
  regs.ax = 0x1000;
  regs.bx = colornum | (color << 8);
  int10(&regs);

  _DO_INIT_CHECK;
  if (AktPal == &__gr_EGAdef) {
    AktPal = &UsrPal;
    memcpy( &UsrPal, &__gr_EGAdef, sizeof(UsrPal));
  }
  UsrPal.colors[colornum] = color;
}

