
          ****************
          ** C Compiler **
          ****************

    Put full path of file name into debugging information so
    that the debugger can find the source file without having
    to use 'set source'.
===========================================================

    /bt=netware turns on /fpr switch
===========================================================

    The floating point constant 0129.5 was not properly
    parsed (compiler thought that it was an octal constant
    and complained when it saw the '9' digit).
===========================================================

          ********************
          ** Code Generator **
          ********************

    recognizes more numeric operations as dangerous for purposes of hoisting
    (POW, MOD etc).
===========================================================

    bug in handling of large, overlapped moves was fixed
===========================================================

    would GP-fault when running low on memory and trying to optimize
===========================================================

    The compiler no longer GPFaults when fixing up certain types
    of one iteration loops (loops which will go around exactly one time).
===========================================================

    Do not generate needless runtime calls to compare code pointers
    against NULL.
===========================================================

    A loop which was going to execute exactly one time followed by
    another loop (without intervening code) would cause incorrect code
    to be generated.
===========================================================

    Fixed a bug which caused data to be ejected into the wrong spot
    in a code segment when compiling with debugging optimization.
===========================================================

    When unrolling a loop we would not assign locations to temps on
    occassion which would result in an internal compiler error #30.
===========================================================

    Debugging information would cause problems with instruction scheduling.
===========================================================

    Fixed access of virtual function tables in large-code programs
    which were compiled with /zc.
===========================================================

    Under circumstances too complex to explain, bad code would be
    generated causing all sorts of stuff to happen.
===========================================================

    A loop which had an induction variable whose initial and final
    values were known and in which the induction variable was not
    updated on every time through the loop would sometimes get thrown
    out.
===========================================================

    Arithmetic operations on signed 16-bit integers would not be
    properly folded, resulting in bogus values.
===========================================================

    Constant folding of operations which use the EDX:EAX forms
    of mulitply would generate an ICE #28.
===========================================================

    The code generator would propagate the result of a conversion
    from a temp to another temp into another convert on the same
    operand even though the conversions were being carried out in
    different manners.
===========================================================

    Assignments of incompatible types to bit-fields would not
    get converted properly.
===========================================================

    Floating point compares would not be handled correctly if
    they were not used as part of an if statement (possible
    if fortran).
===========================================================

          ***************
          ** C Library **
          ***************

    added _fileno() to <stdio.h>
===========================================================

    added POSIX errors to <errno.h>
===========================================================

    Corrected OS/2 1.x library to remove extraneous
    reference to ___FPE_int.

    Fixed Floating point exception support in 16-bit DOS library.
===========================================================

    Fixed fseek() function to report an error condition when
    attempting to flush buffers before seeking yields an error.
===========================================================

    Fixed signal handling of SIGINT and SIGBREAK under
    extended DOS for Rational and Pharlap extenders.
===========================================================

    fixed abort() for 386 -3s model for DOS4G and NT environments
===========================================================

    The bsearch function could segment violate if it was
    given an array which contained only one element and
    the element size was very large.
===========================================================

    The mktime() function did not properly handle some
    unrepresentable values.
===========================================================

    The atanh function returned the negative of the correct value.
===========================================================

    printf() with the 'G' format for floating point output
    did not correctly determine when to use the 'E' format
    if the exponent was negative.
===========================================================

    fread() of TEXT mode files did not properly handle
    reads going past the end of the file's buffer.
===========================================================

    Optimize fseek() for SEEK_CUR with negative offsets.
===========================================================

    Fixed a problem where floating point exceptions under
    Pharlap would not be properly caught if the exception
    handler offset was > 64K.
===========================================================

    Fixed freopen() for standard streams under default
    windowing applications.
===========================================================

    Fixed WILDARGV.C so that it can be compiled as a C++
    source file.
===========================================================

    Fix scanf() family of functions to not modify the user
    variable if no match for the format string is found in
    the input stream.
===========================================================

    Fix fread() to always attempt to fill user buffer.
===========================================================

    The memory allocator has been improved for DOS/4GW.  DPMI memory
    blocks will now be given back to the DPMI host when possible.
    'realloc' will try to expand a DPMI memory block if possible
    rather than allocating a new DPMI memory block and copying the
    old memory block to the new memory block.
===========================================================

    Startup code for Rational DOS extender no longer zeros the
    entire BSS, since the DOS extender will zero the pages when
    they are first created. This will speed up loading of applications
    that have large uninitialized arrays.
===========================================================

          *************
          ** DOS4/GW **
          *************

  All of the DOS/4GW error messages have been reorganized and renumbered.
  There is currently no document that describes all the conditions under
  which the errors can occur.
  
  The familiar "unexpected interrupt" message has been revised for clarity.
  It now gives both the exception number and a brief description of the
  exception.
  
  On a transfer stack overflow, the error message now includes the number of
  the interrupt that provoked the overflow and the address at which the
  interrupt occurred.
  
  Setting DOS4G=NULLP now catches attempts to read from the null pointer as
  well as attempts to write to it.
  
  The virtual memory manager will now silently accept bad configuration
  options.
  
  An incompatibility with cheap clone IDE disk controllers has been fixed.
  Some of these controllers, when installed in machines with clock speeds
  relatively fast for their processors, and with other cards on the bus,
  randomly generate interrupt 0Fh even if configured to use a different IRQ.
  On a computer with one of these hardware configurations, DOS/4GW would
  crash at random points while loading or running; the problem would never
  occur in a Windows DOS box.
  
  We have worked around a bug in the EMM386 distributed with DOS 6.0, which
  cropped up only without the NOEMS and NOVCPI options. If another
  application that allocated expanded (EMS) memory ran beforehand, DOS/4GW
  would hang on startup.
  
  DOS/4GW on Fujitsu FMR series computers no longer causes the system to
  crash on an interrupt F3h.
  
  The SS and ESP are no longer reported as zero on a recoverable stack fault.
  
  DOS/4GW is less susceptible to recursive faults while reporting an
  exception. It will detect most recursive fault conditions and terminate
  immediately.
  
  The trap flag is now properly preserved if a hardware interrupt or
  processor exception occurs while single-stepping in a debugger. This bug
  caused debuggers to occasionally "run away" during stepping for no obvious
  reason.
  
  A bug in handling exceptions when ESP was slightly greater than an even
  multiple of 10000h has been corrected.
  
  A bug that caused the system to reboot on INT 31/0001 (Free Descriptor)
  when DS and ES contained the segment register being cancelled is fixed.
  
  An obscure bug in INT 31/0002 (Segment to Descriptor) has been fixed.
  
  INT 31/0100 (Allocate DOS Memory Block) and INT 31/0102 (Resize DOS Memory
  Block) will now properly return the number of available paragraphs in BX
  when more memory is requested than is actually available.
  
  Several bugs in INT 31h/601h (Unlock Linear Region) have been corrected.
  
  Two bugs in INT 31h/800h (Physical Address Mapping), one with mapping more
  than 64K at a time and one with multiple mappings, have been corrected.
  
  INT 2 (the non-maskable interrupt) is once again passed down.
  
  DOS/4GW will now return carry clear on any attempt to unlock memory that
  isn't managed by the virtual memory manager (for example, low memory).
  
  An off-by-one-page bug in calculating the maximum address managed by VMM
  has been fixed.
  
  A bug that reduced application performance on 80486 machines, even when all
  code and data fit into physical memory, has been corrected.
  
  DOS/4GW is now more careful about recognizing the names of programs which
  require special treatment, for example DOS4GW.EXE. It is now possible to
  name your program something like XXDOS4GW.EXE.
  
  DOS/4GW once again opens programs using DOS "compatibility mode". This
  change allows multiple users to read the executable simultaneously. For
  example, WVIDEO can read the debugging information even if the .EXE file
  has been kept open for demand loading. Ironically, we switched away from
  compatibility mode to support an earlier version of WVIDEO.
  
  A bug in handling 16-bit relocations in 32-bit code that prevented programs
  from loading has been corrected.
  
  Freeing a descriptor that happens to be in the FS or GS registers now works
  properly. The value in FS or GS will be zeroed.
  
  Chaining to a previously installed interrupt handler will now correctly
  return the zero and carry flags.
  
  A bug where the EAX register was corrupted on a switch from real mode to
  protected mode has been fixed. This bug was only a problem in the absence
  of a VCPI or DPMI memory manager, when VMM was running, and when DOS STACKS
  was not set to 0,0.
===========================================================

          **********************
          ** Graphics Library **
          **********************

    Made _remappalette go faster in 16 and 256 colour modes.
===========================================================

    Added support for VESA devices in 386 protected mode.
===========================================================

    Improved the speed of the palette initialization in _setvideomode
    by making use of the faster _remappalette code.
===========================================================

          ***************
          ** Librarian **
          ***************

    The last two elements of the ++ operator description
    on the help screen were reversed.
===========================================================

    The librarian now places COMDEF and COMDAT symbols into
    the library dictionary. This allows C++ template functions
    to be properly found and extracted from a library by
    the linker.
===========================================================

    Fixed check for overflowing library files under NT.
===========================================================

          ************
          ** Linker **
          ************

    The file specified by "option resource" for QNX executables
    was being opened for read/write access rather than just read.
===========================================================

    The OPTION INTERNALRELOCS directive did not work properly.
===========================================================

    There was a bug in option eliminate that occured when a PUBDEF
    record redefined a COMDAT record that was a virtual function in a
    base class, and the inheriting class was instantiated the virtual
    function was referenced _after_ the comdat was redefined. (phew)
    This could be made to happen with lots of templates.
===========================================================

    For files that only contain templated code, the debugging
    information was slightly out of whack
===========================================================

    The linker will not search library dictionary for uninitialized
    communal variables now.  (Needed so we can put communal variable
    definitions into the library dictionaries)
===========================================================

    In some cases it was possible for OS/2 1.x and Windows NT DLLs to
    lose a bit of uninitialized data.
===========================================================

    Added "format windows nt pharlap" and "runtime dosstyle"
    for the PharLap TNT dos extender.
===========================================================

    changed the message "DLL COMENT record invalid when not in OS2"  to
    "export and import records not valid for %f" since the old message
    is rather archaic.  (more than just OS2 supports DLLs now!)
    As well, disabled this warning message for the win386 extender.
===========================================================

    made the libfile command work with the LIB environment variable.
===========================================================

    put out linear addresses in qnx flat map files
===========================================================

    option rwr would not work if you compiled with /d2 but did not use
    debug all in the link file
===========================================================

          **********
          ** Make **
          **********

    always build targets if any of their dependents are
    updated with commands
===========================================================

    execute .error command list for .symbolic and .precious
    targets if an error occurs during the command list
===========================================================

          ************
          ** WVIDEO **
          ************

    If you were in a function that had 2 or more local variables
    which only differed in case and the debugger was set to
    perform case insensitive lookups (the default) then an
    attempt to reference one of the local variables would cause
    the debugger to fault. E.g.:

        foo()
	{
	    int c, C;
	}

     And attempt to print the value of 'c' or 'C'.
===========================================================

    The QNX pmd.trp file did not properly access memory
    through the data selector when processing a dump
    file from a 32-bit flat model program.
===========================================================

    Make debug registers work when debugging a DOS4G application.
===========================================================

    The debugger would sometimes attempt to access a C++
    member before a routine's prologue had completed execution.
    An error message is now issued in this case.
===========================================================

    If an error occurred parsing the command line options
    right at the end of the command line (e.g. "wvideo /" )
    then a strange character would be displayed in the error
    message on some systems.
===========================================================

    Fixed a bug in WVPMHELP that could hang PM when
    a break point was hit in a dialog callback.
===========================================================

    The variable display window could not properly follow
    more than one level of pointer fields.
===========================================================

    Fixed the OS/2 hosted version of the debugger so that
    it works properly under PharLap's 286|DOS-Extender.
    In an OS/2 2.x DOS box you have to specify the

    	/TRAP=STD16

    option to force the use of the OS/2 1.x debugging
    interface code.
===========================================================

    Pressing the right mouse button did not work properly
    under OS/2.
===========================================================

    Comments in multi-line command lists (from invoke files)
    did not terminate properly at the end of line.
===========================================================

    Fixed some problems with asynchronous interruption
    of programs under DOS4G/W.
===========================================================

    Support use of ALT-<number> under OS/2 to allow entering
    any keyboard code.
===========================================================

    The default profile was using a colour scheme which
    did not look good on monochrome display adaptors.
===========================================================
