/**
 ** P8PIXBLK.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p8.h"
#include "memfill.h"

void _GrP8SetPixBlock(long addr,int color,int w,int h)
{
	int oper = C_OPER(color);
	int skip,w2;
	pixptr p;

	if((w <= 0) || (h <= 0)) return;
	if((_GrP8DrawTable[oper] ^ (color &= C_SIGNIF)) == 0) return;
	_ClrDir();
	if(CURC->gc_onscreen && _GrP8UsePlanarMode) {
	    if((oper == C_SET) && (w >= 12)) {
		int rmask = ((int)addr + w) & 3;
		int lmask = (int)addr & 3;
		int offs = CURC->gc_lineoffset >> 2;

		PLANAR_MODE_ON();
		p = P_XADDRESS(CURC,addr);
		if(lmask) {
		    _SetVGAPlaneMask(_GrP8LmaskTable[lmask]);
		    _ColSetB(FASTLEFT,p,offs,color,h);
		    w -= (4 - lmask);
		    p++;
		}
		skip = offs - (w >>= 2);
		_SetVGAPlaneMask(0xff);
		if((offs & 1) || (w <= 4)) {
		    _BlkSetB(FASTBLKB,p,skip,color,w,h);
		    p += w;
		}
		else {
		    color |= (color << 8);
		    if((int)p & 1) {
			_ColSetB(FASTBLKL,p,offs,color,h);
			p++;
			w--;
		    }
		    w2 = w >> 1;
		    skip = offs - (w2 << 1);
		    _BlkSetW(FASTBLKW,p,skip,color,w2,h);
		    p += (w2 << 1);
		    if(w & 1) {
			_ColSetB(FASTBLKR,p,offs,color,h);
			p++;
		    }
		}
		if(rmask) {
		    _SetVGAPlaneMask(_GrP8RmaskTable[rmask]);
		    _ColSetB(FASTRIGHT,p,offs,color,h);
		}
		return;
	    }
	    PLANAR_MODE_OFF();
	}
	p = P_ADDRESS(CURC,addr);
	skip = CURC->gc_lineoffset - w;
	if(((int)addr | skip | w) & 1) switch(oper) {
	    case C_XOR: _BlkSetXorB(XB,p,skip,color,w,h); return;
	    case C_OR:  _BlkSetOrB(OB,p,skip,color,w,h);  return;
	    case C_AND: _BlkSetAndB(AB,p,skip,color,w,h); return;
	    default:	_BlkSetB(WB,p,skip,color,w,h);	  return;
	}
	w >>= 1;
	color |= (color << 8);
	switch(oper) {
	    case C_XOR: _BlkSetXorW(XW,p,skip,color,w,h); return;
	    case C_OR:  _BlkSetOrW(OW,p,skip,color,w,h);  return;
	    case C_AND: _BlkSetAndW(AW,p,skip,color,w,h); return;
	    default:	_BlkSetW(WW,p,skip,color,w,h);	  return;
	}
}

