/**
 ** PICHAR.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p8514a.h"

static int bg_mixtable[] = {
    BSS_BKGDCOL | MIX_SRC,	      /* C_SET */
    BSS_BKGDCOL | MIX_XOR,	      /* C_XOR */
    BSS_BKGDCOL | MIX_OR,	      /* C_OR  */
    BSS_BKGDCOL | MIX_AND	      /* C_AND */
};

void _GrPIDrawChar(long a,int w,int h,char far *bpt,int fg,int bg)
{
	if((w <= 0) || (h <= 0)) return;
	if(CURC->gc_onscreen) {
	    int fgop = C_OPER(fg);
	    int bgop = C_OPER(bg);
	    int xpos = COORD_X(a);
	    int ypos = COORD_Y(a);
	    int bytes = ((xpos + w + 7) >> 3) - (xpos >> 3);
	    int shift = (xpos & 7);
	    int fontw = (w + 7) >> 3;

	    if(((_GrPIDrawTable[fgop] ^ (fg &= C_SIGNIF)) |
		(_GrPIDrawTable[bgop] ^ (bg &= C_SIGNIF))) == 0) return;
	    WaitQueue(7);
	    outpw(MULTIFUNC_CNTL,SCISSORS_L | xpos);
	    outpw(MULTIFUNC_CNTL,SCISSORS_R | (xpos + w - 1));
	    outpw(MAJ_AXIS_PCNT,((bytes << 3) - 1));
	    outpw(MULTIFUNC_CNTL,(MIN_AXIS_PCNT | (h - 1)));
	    outpw(MULTIFUNC_CNTL,(PIX_CNTL | MIXSEL_EXPPC));
	    outpw(FRGD_MIX,_GrPIMixTable[fgop]);
	    outpw(BKGD_MIX,bg_mixtable[bgop]);
	    WaitQueue(5);
	    outpw(FRGD_COLOR,fg);
	    outpw(BKGD_COLOR,bg);
	    outpw(CUR_X,(xpos & ~7));
	    outpw(CUR_Y,ypos);
	    outpw(CMD,(CMD_RECT | INC_X | INC_Y | PCDATA | _16BIT | BYTSEQ | DRAW | PLANAR | WRTDATA));
	    WaitQueue(8);
#ifdef __TURBOC__
#define _HAVE_INLINE_
	    asm .286
	    asm cld;
	    asm push	ds;
	    asm lds	si,DWORD PTR bpt;
	    asm mov	cx,WORD PTR shift;
	    asm mov	dx,PIX_TRANS;
	  VertLoop:
	    asm push	si;
	    asm mov	bx,WORD PTR bytes;
	    asm xor	ch,ch;
	  HorLoop:
	    asm lodsb
	    asm xor	ah,ah;
	    asm ror	ax,cl;
	    asm or	al,ch;
	    asm mov	ch,ah;
	    asm mov	ah,al;
	    asm add	ah,ah;
	    asm shr	al,3;
	    asm out	dx,ax;
	    asm dec	bx;
	    asm jne	HorLoop;
	    asm pop	si;
	    asm add	si,WORD PTR fontw;
	    asm dec	WORD PTR h;
	    asm jne	VertLoop;
	    asm pop	ds;
#endif
#ifdef __GNUC__
#define _HAVE_INLINE_
	    asm volatile("                                            \n\
		cld						      \n\
		movl	%1,%%esi				      \n\
		movl	%2,%%ecx				      \n\
		movl	%3,%%edx				      \n\
	      L_VertLoop:					      \n\
		movl	%%esi,%%edi				      \n\
		movl	%4,%%ebx				      \n\
		xorb	%%ch,%%ch				      \n\
	      L_HorLoop:					      \n\
		lodsb						      \n\
		xorb	%%ah,%%ah				      \n\
		rorw	%%cl,%%ax				      \n\
		orb	%%ch,%%al				      \n\
		movb	%%ah,%%ch				      \n\
		movb	%%al,%%ah				      \n\
		addb	%%ah,%%ah				      \n\
		shrb	$3,%%al					      \n\
		outw	%%ax,%%dx				      \n\
		decl	%%ebx					      \n\
		jne	L_HorLoop				      \n\
		movl	%5,%%esi				      \n\
		leal	(%%edi,%%esi),%%esi			      \n\
		decl	%0					      \n\
		jne	L_VertLoop					"
		: "=g" (h)
		: "g" (bpt),   "g" (shift), "g" (PIX_TRANS),
		  "g" (bytes), "g" (fontw)
		: "di", "si", "dx", "cx", "bx", "ax"
	    );
#endif
#ifndef _HAVE_INLINE_
	    while(--h >= 0) {
		unsigned char far *fbits;
		int count,carry,bits;
		fbits = (unsigned char far *)bpt;
		count = bytes;
		carry = 0;
		while(--count >= 0) {
		    bits  = *fbits++ | carry;
		    carry = bits << 8;
		    bits  = (bits >> shift) & 0xff;
		    outpw(PIX_TRANS,((bits << 9) | (bits >> 3)));
		}
		bpt += fontw;
	    }
#endif
	    WaitQueue(3);
	    outpw(MULTIFUNC_CNTL,(PIX_CNTL | 0));
	    outpw(MULTIFUNC_CNTL,(SCISSORS_L | 0));
	    outpw(MULTIFUNC_CNTL,(SCISSORS_R | 1023));
	    return;
	}
	_GrP8DrawChar(a,w,h,bpt,fg,bg);
}

