#include <math.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "genlib.h"

#define MAXINPLINELEN 200

typedef enum {VALUE=1,CONSTANT,X,FUNCTION,OPERATOR,UNDEF_ETYPE} etype;
typedef enum {PLUS=1,MINUS,TIMES,DIVIDE,UMINUS,POWER,BRACKET,UNDEF_OP} operators;
typedef enum {SIN=1,COS,EXP,LN,TAN,SEC,COSEC,COT,SINH,COSH,TANH,SECH,
		  COSECH,COTH,ARCSINH,ARCSIN,ARCCOSH,ARCCOS,ARCTANH,ARCTAN,
		  UNDEF_FUNC} functions;
typedef char constants;

struct expression
{ etype exptype;
  union
  { operators op;
    functions fn;
    constants co;
  } expval;
  float cval;
  struct expression *rval;
  struct expression *lval;
};

struct expression *differentiate(struct expression *expr);
struct expression *parser(char *buff);
struct expression *simplify(struct expression *expr);
void printout(struct expression *expr);
void freetree(struct expression *expr);
struct expression *newtree(void);
struct expression *copytree(struct expression *expr);
