/* This is file BLIT.CC */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <string.h>
#include "graphics.h"
#include <pc.h>

extern "C" int _GrCanBcopyInBlit;

void Blit(GrRegion *src,
          GrRegion *dest, int dx, int dy,
          GrBlitFunc function)
{
  Blit(src, 0, 0, src->width, src->height, dest, dx, dy, function);
}

void Blit(GrRegion *src, int sx, int sy, int sw, int sh,
          GrRegion *dest, int dx, int dy,
          GrBlitFunc function)
{
  GrRegion *s = src->SubRegion(sx, sy, sw, sh);
  if (!s)
    return;
  if (!(s->data))
  {
    delete s;
    return;
  }
  GrRegion *d = dest->SubRegion(dx, dy, sw, sh);
  if (!d)
  {
    delete s;
    return;
  }
  if (!(d->data))
  {
    delete s;
    delete d;
    return;
  }
  if (s->width < d->width)
    d->width = s->width;
  else
    s->width = d->width;
  if (s->height < d->height)
    d->height = s->height;
  else
    s->height = d->height;

  sw = s->width;
  sh = s->height;

  int reverse=0;
  if (s->data < d->data)
    reverse = 1;
  register int x,y;
  char *temp_data = (char *)malloc(sw);
  switch (function)
  {
    case BlitSrc:
      if (reverse)
      {
        if (_GrCanBcopyInBlit)
          for (y=sh-1; y>=0; y--)
            bcopy(s->rdata+y*s->row_scale, d->wdata+y*d->row_scale, sw);
        else
          for (y=sh-1; y>=0; y--)
          {
            bcopy(s->rdata+y*s->row_scale, temp_data, sw);
            bcopy(temp_data, d->wdata+y*d->row_scale, sw);
          }
      }
      else
      {
        if (_GrCanBcopyInBlit)
          for (y=0; y<sh; y++)
            bcopy(s->rdata+y*s->row_scale, d->wdata+y*d->row_scale, sw);
        else
          for (y=0; y<sh; y++)
          {
            bcopy(s->rdata+y*s->row_scale, temp_data, sw);
            bcopy(temp_data, d->wdata+y*d->row_scale, sw);
          }
      }
      break;
    case BlitDest:
      break;
    case BlitXor:
      if (reverse)
        for (y=sh-1; y>=0; y--)
          for (x=sw-1; x>=0; x--)
            d->data[x+y*d->row_scale] ^= s->data[x+y*s->row_scale];
      else
        for (y=0; y<sh; y++)
          for (x=0; x<sw; x++)
            d->data[x+y*d->row_scale] ^= s->data[x+y*s->row_scale];
      break;
  }
  free(temp_data);
  delete s;
  delete d;
}
