/*--------------------------------------------------------
  MYID.C - Windows Application
  Displays Novell User ID in client screen area.
  Made with:
  BC++ 3.1					DOS 6.22
  Novell Netware 4.1    Windows 3.1
  Novell Client Client API for C Vers. 1.0e

  C program.  Using standard method for windows programs.
  (Petzold style.)

  Program developed for testing NET_ID.DLL, which was made to
  retreive the user ID from the system.

  NOTE: Use the Makefile to compile and link the program:
   "make -f myid.mak"   
  --------------------------------------------------------*/

#include <windows.h>
#include <string.h>

/* net_id.h Contains the function for getting the user ID
	from the NETID.DLL. */
#include "net_id.h"


long FAR PASCAL _export WndProc (HWND, UINT, UINT, LONG) ;

static char szAppName[] = "MYID" ;	// Application Name	
char far 	szMyID[40];             // String to hold UserID
char far		*pszUserID ;            // Pointer to szMyID


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
	/* Standard creation and start up for a Windows application */
	  HWND        hwnd ;
     MSG         msg ;
	  WNDCLASS    wndclass ;

     pszUserID = szMyID ;

     if (!hPrevInstance)
     {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
			 wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
	  }

     hwnd = CreateWindow (szAppName,    // window class name
					"Is This Your ID?",      // window caption
               WS_OVERLAPPEDWINDOW,     // window style
               CW_USEDEFAULT,           // initial x position
               CW_USEDEFAULT,           // initial y position
               CW_USEDEFAULT,           // initial x size
               CW_USEDEFAULT,           // initial y size
               NULL,                    // parent window handle
               NULL,                    // window menu handle
     				hInstance,               // program instance handle
	  				NULL) ;		     			 // creation parameters

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
     {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
     }
     return msg.wParam ;
}


long FAR PASCAL _export WndProc (HWND hwnd, UINT message, UINT wParam, LONG lParam)
{

	  HDC         hdc ;
     PAINTSTRUCT ps ;
	  RECT	 	  rect ;
     int			  i;

	  switch (message)
     {
			 case WM_CREATE:

					i = NetUserID(pszUserID);	// Call the NetUserID function from the net_id.dll.
														// It returns the current user's ID.
//					ReleaseDC (hwnd, hdc) ;

               return 0 ;

			 case WM_PAINT:
					hdc = BeginPaint (hwnd, &ps) ;

               GetClientRect (hwnd, &rect) ;
					DrawText (hdc, pszUserID, -1, &rect,		// Draw a text box in the window.
					DT_SINGLELINE | DT_CENTER | DT_VCENTER) ; // Fill the text box with text 
					EndPaint (hwnd, &ps) ;                    // returned from the NetUserID Call.
               return 0 ;

          case WM_DESTROY:
               PostQuitMessage (0) ;
               return 0 ;
     }

     return DefWindowProc (hwnd, message, wParam, lParam) ;
}

