/*------------------------------------------------
	NET_ID.C -- Library module for calling the novell
	NWCALLS.DLL to get the user ID.  This is a stripped
	down DLL, and should by no reason be considered an
	example for standard DLLs. It's purpose is to be an
	interface between Visual Basic and the Novell
	Windows DLLs.

	The Novell Netware libraries and DLLs use and return
	unsigned integer, unsigned short, and unsigned long
	numeric formats to the programs that call them.
	Visual Basic doesn't seem able to deal with the
	unsigned format (I could be wrong).

	This DLL was written to deal with the Netware unsigned
	numbers for Visual Basic programs.

	Personal Note : This type of incident is the reason I
	didn't want our company to standardize on Visual Basic.
		 
	T.H. Smith, 1996
  ------------------------------------------------*/

#include <windows.h>
#include <stdlib.h>
#include <string.h>

#include <nwcalls.h>

#include "net_id.h"

extern "C" {
int FAR PASCAL _export WEP (int) ;
}

unsigned int far				uiConnHandle;			// connection Handle
unsigned int far				uiConnNumber;        // connection Number
static char far				szObjectName[40] ;   // Object Name - User ID
																//  (or printer name, etc).
static unsigned short far	siObjectType;			// Type of object
static unsigned long far	liObjectID;				// Numeric object ID
																//  ( User ID used by system )
static char far				szLoginTime[7] ;		// Time user logged in.


int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize,
                        LPSTR lpszCmdLine)
     {
     if (wHeapSize > 0)
          UnlockData (0) ;

     return 1 ;
	  }

int FAR PASCAL _export WEP (int nParam)
     {
	  return 1 ;
     }

int FAR PASCAL _export NetUserID ( char far * lpString )
{
	/*
	NWGetDefaultConnectionID gets the connection handle.
	NWGetConnectionNumber gets the Connection Handle.  These two
	numbers are needed as input parameters when making the
	NWGetConnectionInformation call, which returns the User ID and
	other things.
   */

	char				*npPath;
	unsigned long	*lLong;
	unsigned int	ccode;

   /* Initialize  */
	ccode = NWCallsInit(NULL, NULL);
	if(ccode)
   	return(ccode);

	/* Get Connection Handle */
	ccode = NWGetDefaultConnectionID( &uiConnHandle );
	if(ccode)
   	return(ccode);

	/* Get Connection Number */
	ccode = NWGetConnectionNumber( uiConnHandle, &uiConnNumber );
	if(ccode)
   	return(ccode);

	/* Get Connection Info */
	ccode = NWGetConnectionInformation( uiConnHandle,
									uiConnNumber, szObjectName,
									&siObjectType, &liObjectID,
									szLoginTime);
	if(ccode)
   	return(ccode);

	/* Copy szObjectName to the function parameter */
	lstrcpy( lpString, (char far *)szObjectName );

	return( 0 );

}
