//	catfish.h  -  main application sample code  -  1.1
//
//	This is a part of the MetaKit library.
//	Copyright (c) 1996 Meta Four Software.
//	All rights reserved.
/////////////////////////////////////////////////////////////////////////////

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

#define FILE_TYPE	".cf4"

/////////////////////////////////////////////////////////////////////////////

	extern CString GetCatalogDate(CString& catName);
	
/////////////////////////////////////////////////////////////////////////////
// The main application class

class CTheApp : public CWinApp
{
public:
	CTheApp ();
	
	virtual BOOL InitInstance();
};

/////////////////////////////////////////////////////////////////////////////
// The main dialog window class

class CMainDlgWindow : public CDialog
{
private:
		// a small font used for several dialog box items
    CFont m_font;
      
      	// these are set during listbox owner-draw
    DRAWITEMSTRUCT* m_item;
    CDC* m_dc;
    
    	// set to the current catalog
    c4_Storage* m_storage;
    c4_View m_currCat;
    
    	// the directory currently shown in the tree list
	int m_treeDir;
	
    	// the directory currently shown in the file list
    int m_fileDir;
    c4_View m_fileView;

		// cumulative totals, one entry for each directory in the catalog
    CWordArray m_dirCounts;
    CWordArray m_fileCounts;
    CWordArray m_lastDates;
    CDWordArray m_kiloTotals;
    
	void ConstructTitle(const char* catName);

	void SetCatalog(const char* catName);
	void SetTreeDir(int dirNum);           
	void SetFileDir(int dirNum);           
	
	void DrawItemText(const CString& text, int off =0);
	void OnDrawCatItem(int n);
	void OnDrawDirItem(int n);
	void OnDrawFileItem(int n);

public:
	CMainDlgWindow ();
	~CMainDlgWindow ();

	//{{AFX_DATA(CMainDlgWindow)
	enum { IDD = IDD_MAIN_DIALOG };
	CStatic	m_pathFrame;
	CListBox	m_treeList;
	CListBox	m_fileList;
	CListBox	m_catList;
	CStatic	m_msgText;
	CStatic	m_infoText;
	CStatic	m_treePath;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CMainDlgWindow)
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

	virtual void OnCancel();

protected:
	//{{AFX_MSG(CMainDlgWindow)
	virtual BOOL OnInitDialog();
	afx_msg void OnClose();
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	afx_msg void OnSelchangeCatList();
	afx_msg void OnSelchangeTreeList();
	afx_msg void OnDblclkTreeList();
	afx_msg void OnSelchangeFileList();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnFindBtn();
	afx_msg void OnSetupBtn();
	afx_msg void OnDblclkFileList();
	//}}AFX_MSG
	afx_msg void OnHelp();
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

