//	mydlg.cpp  -  display server sample code  -  1.0
//
//	This is a part of the MetaKit library.
//	Copyright (c) 1996 Meta Four Software.
//	All rights reserved.
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "catrecv.h"
#include "MyDlg.h"
#include "TreeDlg.h"

#ifdef _DEBUG
//#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyDlg dialog

CMyDlg::CMyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMyDlg::IDD, pParent), _timer (0), _server (0)
{
	//{{AFX_DATA_INIT(CMyDlg)
	//}}AFX_DATA_INIT
}

CMyDlg::~CMyDlg ()
{
	delete _server;						// shutdown the server
}

void CMyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyDlg)
	DDX_Control(pDX, IDC_PORT, m_port);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMyDlg, CDialog)
	//{{AFX_MSG_MAP(CMyDlg)
	ON_EN_CHANGE(IDC_PORT, OnChangePort)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// [JCW]  This code added for MetaKit CATRECV

BOOL CMyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_port.SetWindowText("12345");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// called at start and whenever the m_port edit control has changed
void CMyDlg::OnChangePort() 
{
	delete _server;
	_server = 0;

	KillTimer(_timer);					// forget pending timeouts
	_timer = SetTimer(1, 1000, 0);		// timeout 1 second from now
}

	// this will be called by the CServer object to set up a new connection 
	static void StartNewConnection(CFile& file_)
	{
		DEBUG_NEW CTreeDialog (file_);	// creates a modeless dialog box
	}

// use a delay to wait for a good port number before (re-)creating a server
void CMyDlg::OnTimer(UINT nIDEvent) 
{
	KillTimer(_timer);					// avoid further timeouts
	_timer = 0;

		// called one second after the last change to the m_port edit control
	CString s;
	m_port.GetWindowText(s);
	int port = atoi(s);

	if (port > 0)
	{
			// set up a new server listening on the specified port
		ASSERT(!_server);
		_server = DEBUG_NEW CServer (port, StartNewConnection);
	}
	else
		MessageBeep(MB_OK);

	CDialog::OnTimer(nIDEvent);
}

/////////////////////////////////////////////////////////////////////////////
// CServer socket, this sample code does no error checking

CServer::CServer (int port_, ConnectHandler handler_)
	: _port (port_), _handler (handler_)
{
	OnClose(0);	// simulate a lost connection to start things up
}

CServer::~CServer ()
{
	Close();
}

void CServer::OnAccept(int /* error_ */)
{
	CSocket session;
	VERIFY(Accept(session));

	CSocketFile data (&session);

	ASSERT(_handler);
	_handler(data);
}

void CServer::OnClose(int /* error_ */)
{
    Close();

	VERIFY(Create(_port));
	VERIFY(Listen());
}

/////////////////////////////////////////////////////////////////////////////
