/*
 *	File drawa.c
 *	Demonstrates the use of the DRAWAREA Object
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "mgui.h"

/*
 *	Callback for closing and destroying a generic dialog
 */
extern void CloseDialogCB(MOBJECT p, void *s, void *v);
extern int LowRes;

extern MTColor black, white, darkblue, cadetblue, seagreen;

/*****************************************************
 *	This Callback draws lines and circles in the
 *	DRAWAREA Object using its current dimensions.
 *****************************************************/
void DrawAreaExposeCB(MOBJECT obj, MEvent *pe, void *a_data)
{
	int hsize, wsize;

	wsize = MObjectWidth(obj);
	hsize = MObjectHeight(obj);
	MDrawLine(obj, 0, 0, wsize, hsize, black);
	MDrawLine(obj, 0, hsize, wsize, 0, white);
	MDrawFilledCircle(obj, wsize/2, hsize/2, wsize/4, cadetblue);
	MDrawCircle(obj, wsize/2, hsize/2, wsize/4, black);

}

/*****************************************************
 *	This Callback handles the resize of the
 *	DRAWAREA, setting a LABEL text to the
 *	new dimensions.
 *****************************************************/
void DrawAreaResizeCB(MOBJECT obj, DRAWAREA_PREF *pref, void *label)
{
	char str[128];

	sprintf(str, "Dimensions: %dx%d", pref->new_w, pref->new_h);
        MObjectSetText((MOBJECT )label, str);
}

/*****************************************************
 *	This Callback handles the mouse input events
 *	in the Object drawing lines
 *****************************************************/
void DrawAreaInputCB(MOBJECT obj, MEvent *pe, void *a_data)
{
	static int x1, y1, x2, y2;

	if (pe->type == E_BUTTON_PRESS) {
/*
 * Set the initial coordinates at the mouse
 * button press event
 */
		x1 = x2 = pe->mouse.x;
		y1 = y2 = pe->mouse.y;
	}
	else if (pe->type == E_MOTION) {
/*
 * Erase the old line and draw the new one
 * while dragging the mouse (draw in Xor mode)
 */
		MDrawXorLine(obj, x1, y1, x2, y2);
		x2 = pe->mouse.x;
		y2 = pe->mouse.y;
		MDrawXorLine(obj, x1, y1, x2, y2);
	}
	else if (pe->type == E_BUTTON_RELEASE) {
/*
 * Erase the old line and draw the definitive one
 */
		MDrawXorLine(obj, x1, y1, x2, y2);
		x2 = pe->mouse.x;
		y2 = pe->mouse.y;
		MDrawLine(obj, x1, y1, x2, y2, seagreen);
	}
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void DrawAreaCB(MOBJECT obj, void *a, void *b)
{
	MOBJECT pbutton, shell, cform, rform, label, drawa, sfile;

	shell = MCreateShell("Draw Area", SF_MODAL);

        cform = MCreateColForm(shell);
        rform = MCreateRowForm(cform);
/*
 * This LABEL is used to show the current
 * DRAWAREA dimensions
 */
	label = MCreateLabel(rform, "", HELV_L_FONT);

/*
 * Create the DRAWAREA Object of 256x256 pixels wide
 */
	drawa = MCreateDrawArea(rform, 256, 256);
/*
 * Allow the DRAWAREA to resize in Horizontal and Vertical
 * directions
 */
	MObjectSetResize(drawa, True, True);
/*
 * Set the callbacks to handle the Object events
 */
	MDrawAreaSetExposeCallback(drawa, DrawAreaExposeCB, 0L);
	MDrawAreaSetInputCallback(drawa, DrawAreaInputCB, 0L);
	MDrawAreaSetResizeCallback(drawa, DrawAreaResizeCB, label);
/*
 * Create a SFILE Object to show this source file in the dialog
 */
	sfile = MCreateSFile(cform, __FILE__,
			(LowRes ? SMALL_FONT : DEFAULT_FONT),
			10, 48);
	MObjectSetColor(sfile, darkblue, white);
/*
 * This PUSH BUTTON closes the dialog
 */
	pbutton = MCreatePButton(shell, "Close", TIMES_L_FONT);
	MPButtonSetCallback(pbutton, CloseDialogCB, 0L);

	MShellRealize(shell);
}

