/*
 *      File mguimain.c
 *      Creates the main shell of the application
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mgui.h"

/*
 *     Menu Callbacks.
 */
void STextCB(MOBJECT o, void *id, void *a_data);
void SListCB(MOBJECT o, void *id, void *a_data);
void BlockListCB(MOBJECT o, void *id, void *a_data);
void EditListCB(MOBJECT o, void *id, void *a_data);
void SkipListCB(MOBJECT o, void *id, void *a_data);
void MSelListCB(MOBJECT o, void *id, void *a_data);
void SFileCB(MOBJECT o, void *id, void *a_data);
void ScrolledFormCB(MOBJECT o, void *id, void *a_data);
void PagedFormCB(MOBJECT o, void *id, void *a_data);
void ClippedFormCB(MOBJECT o, void *id, void *a_data);
void FontViewCB(MOBJECT o, void *id, void *a_data);
void ColPickCB(MOBJECT o, void *id, void *a_data);
void ObjectManageCB(MOBJECT o, void *id, void *a_data);
void TRButtonCB(MOBJECT obj, void *id, void *a_data);
void EditCB(MOBJECT obj, void *id, void *a_data);
void MLEditCB(MOBJECT obj, void *id, void *a_data);
void DrawAreaCB(MOBJECT obj, void *id, void *a_data);
void StatusBarCB(MOBJECT obj, void *id, void *a_data);
void RS232CB(MOBJECT obj, void *id, void *a_data);

void ExitCB(MOBJECT p, void *id, void *a_data);
void InfoCB(MOBJECT o, void *id, void *a_data);
void ChangeTitleCB(MOBJECT o, void *id, void *a_data);

/*
 *      Main Object
 */
MOBJECT mainshell;
/*
 *      Identificatori colori
 */
MTColor black, white, darkblue, cadetblue, seagreen;

int	PaletteMode; /* True if the system allows color animation */
long	NColors;
int	LowRes;

#ifdef BORLANDC
/*
 *      memory is limited only in DOS 16 bit environment
 */
#include "malloc.h"     /* for coreleft() prototype */

void MemCB(MOBJECT o, void *item, void *a_data)
{
	MLog(1, "Free memory: %ld", coreleft());
}

#endif

/**************************************************
 *      Callback that destroys the shell containing
 *      the Object 'p' (the caller).
 **************************************************/
void CloseDialogCB(MOBJECT p, void *s, void *v)
{
	MShellDestroy(p);
}

/**************************************************
 *      Callback called when an accelarator key
 *      associated to a FORM is pressed
 **************************************************/
void FormKeyCB(MOBJECT obj, MVALUE key, void *udata)
{
	char str[128];

	sprintf(str, "Form Key Callback\nkey code: %lx\nuser data: %ld", key, (long)udata);
	MMessageDialog("", str, "OK", NULL);
}

/**************************************************
 *      This callback shows the check status of
 *	a menu item
 **************************************************/
void ItemCheckCB(MOBJECT obj, void *item, void *udata)
{
	int status;
	char str[128];

	status = MToggleItemCheckStatus(obj, item);
	sprintf(str, "The selected menu item\nhas been %s",
		(status ? "Activated" : "Deactivated"));
	MMessageDialog("", str, "Ok", NULL);
}

/**************************************************
 *      This callback changes a menu item text
 **************************************************/
void ChangeItemTextCB(MOBJECT obj, void *item, void *udata)
{
	char text[32];

        strcpy(text, MPullDownGetItemText(obj, item));
	if (MInputPrompt("Item Text", "Type in the new text", text, 31, "Exec", "Cancel"))
		MPullDownSetItemText(obj, item, text);
}

/**************************************************
 *      This callback changes a menu title text
 **************************************************/
void ChangeTitleTextCB(MOBJECT obj, void *item, void *udata)
{
	char text[32];
	const char *oldtext = MPullDownGetTitleText(obj);

	strcpy(text, (oldtext != NULL ? oldtext : "NULL"));
	if (MInputPrompt("Title Text", "Type in the new text", text, 31, "Exec", "Cancel"))
		MPullDownSetTitleText(obj, text);
}

/**************************************************
 *      This callback is called when the user
 *	selects destroy a pulldown
 **************************************************/
void DestroyPullDownCB(MOBJECT obj, void *item, void *udata)
{
	if (udata != NULL)
		MDestroyPullDown((MOBJECT )udata);
	else
		MDestroyPullDown(obj);
}

/**************************************************
 *      This callback is called when the user
 *	selects a menu item
 **************************************************/
void ItemSelectCB(MOBJECT obj, void *item, void *udata)
{
	char str[128];

	sprintf(str, "Selected the menu item <%ld>", (long)item);
	MMessageDialog("", str, "Ok", NULL);
}

/**************************************************
 *      This callback handles the Window Manager
 *	request to close the main shell (the program)
 **************************************************/
void WMCloseCB(MOBJECT obj, void *o_data, void *a_data)
{
	if (MMessageDialog("Closing",
	    "Do you want to Quit ?", "Yes", "No", NULL) == 0) {
		MGUITerm();
		exit(0);
	}
}

/**************************************************
 *      Access point to the MGUI application
 **************************************************/
void MGUIMain(int argc, char **argv)
{
	MOBJECT menu, pdown, subpd, sfile, label, form;
	PULLDOWN_ITEM pd_item_id;
/*
 *  Log parameter initialization:
 *
 *	log level:		3
 *	n. of stored lines:	10
 *	n. of visble lines:	5
 *	row len:		80
 *	visible row len:	60
 *	log file:		"mguitest.log" (NULL if not needed)
 *
 * To show/hide log window press	<Ctrl + Shift + F1>
 * To change run time log level press	<Ctrl + Shift + F2>
 */
	MLogInit(3, 10, 5, 80, 60, "mguitest.log");
 
	PaletteMode = MPaletteMode();
	NColors = MGetNColors();
	LowRes = MGetScreenWidth() < 800;
/*
 *  Colors allocation
 */
	black = MBlackColor();
	white = MWhiteColor();
	cadetblue = MAllocColor(0x60, 0x85, 0x95);
	seagreen = MAllocColor(0x70, 0xa5, 0xa0);
	darkblue = (NColors > 16 ? MAllocShiftColor(cadetblue, 70) : cadetblue);

	MSetMessageDialogRGB(120, 140, 130);
	MSetInputPromptRGB(150, 120, 120);

	mainshell = MCreateShell("MGUI Library Test", SF_IGNORE_WM_CLOSE);

	MShellSetWMCloseCallback(mainshell, WMCloseCB, 0L);
	menu = MCreateMenuBar(mainshell, HELV_L_FONT);
	MObjectSetColor(menu, seagreen, white);
	MMenuSetAcc(menu, F10);
	pdown = MCreatePullDown(menu, "File");
#if !defined BC_MGUI || defined LIBGRX
/* Font loading not supported in BORLANDC BGI */
	MPullDownAddItem(pdown, "Font Browser", FontViewCB, 0L);
#endif
	MPullDownAddItem(pdown, "Color Browser", ColPickCB, 0L);
	MPullDownAddItem(pdown, "Shell title...", ChangeTitleCB, 0L);
#if defined WIN_MGUI && !defined __WIN32__
/* Serial communication currently available only in Windows */
	MPullDownAddItem(pdown, "Test RS-232", RS232CB, 0L);
#endif
	pd_item_id = MPullDownAddItem(pdown, "Quit", ExitCB, 0L);
	MPullDownSetItemAccel(pdown, pd_item_id, C_Q, "Ctrl+Q");

	pdown = MCreatePullDown(menu, "Objects");

	pd_item_id = MPullDownAddItem(pdown, "Form", NULL, 0L);
	subpd = MCreateSubPullDown(pdown, pd_item_id);
	MPullDownAddItem(subpd, "Scrolled Form", ScrolledFormCB, 0L);
	MPullDownAddItem(subpd, "Paged Form", PagedFormCB, 0L);
	MPullDownAddItem(subpd, "Clipped Form", ClippedFormCB, 0L);
	MPullDownAddItem(subpd, "Object Manage", ObjectManageCB, 0L);

	pd_item_id = MPullDownAddItem(pdown, "List", NULL, 0L);
	subpd = MCreateSubPullDown(pdown, pd_item_id);
	MPullDownAddItem(subpd, "Scrolled List", SListCB, 0L);
	MPullDownAddItem(subpd, "Block List", BlockListCB, 0L);
	MPullDownAddItem(subpd, "Edit List", EditListCB, 0L);
	MPullDownAddItem(subpd, "Skip List", SkipListCB, 0L);
	MPullDownAddItem(subpd, "Multi Sel List", MSelListCB, 0L);
	MPullDownAddItem(subpd, "Scrolled Text", STextCB, 0L);
	MPullDownAddItem(subpd, "Scrolled File", SFileCB, 0L);

	MPullDownAddItem(pdown, "Radio & Toggle", TRButtonCB, 0L);
	MPullDownAddItem(pdown, "Edit", EditCB, 0L);
	MPullDownAddItem(pdown, "Multi Line Edit", MLEditCB, 0L);
	MPullDownAddItem(pdown, "DrawArea", DrawAreaCB, 0L);
	MPullDownAddItem(pdown, "Status Bar", StatusBarCB, 0L);

	pdown = MCreatePullDown(menu, "Pulldown");
	MPullDownAddItem(pdown, "Item 1", ItemCheckCB, 0L);
	pd_item_id = MPullDownAddItem(pdown, "Subpulldown", NULL, 0L);
	MPullDownAddItem(pdown, "Change me", ChangeItemTextCB, 0L);
	MPullDownAddItem(pdown, "Change title", ChangeTitleTextCB, 0L);

	subpd = MCreateSubPullDown(pdown, pd_item_id);
	MPullDownAddItem(subpd, "subItem 2-1", ItemCheckCB, 0L);
	MPullDownAddItem(subpd, "subItem 2-2", ItemCheckCB, 0L);
	pd_item_id = MPullDownAddItem(subpd, "Subpulldown", NULL, 0L);

	subpd = MCreateSubPullDown(subpd, pd_item_id);
	MPullDownAddItem(subpd, "subItem 3-1", ItemSelectCB, 0L);
	MPullDownAddItem(subpd, "subItem 3-2", ItemSelectCB, 0L);
	MPullDownAddItem(subpd, "subItem 3-3", ItemSelectCB, 0L);
	MPullDownAddItem(subpd, "Change me", ChangeItemTextCB, 0L);
	MPullDownAddItem(subpd, "Change title", ChangeTitleTextCB, 0L);
	MPullDownAddItem(subpd, "Destroy SubPullDown", DestroyPullDownCB, 0L);
	MPullDownAddItem(subpd, "Destroy PullDown", DestroyPullDownCB, pdown);

	MFormAddKeyCallback(mainshell, F1, FormKeyCB, 0L);
	MFormAddKeyCallback(mainshell, C_F1, FormKeyCB, (void *)1);
	MFormAddKeyCallback(mainshell, C_A, FormKeyCB, (void *)2);

	form = MCreateColForm(mainshell);

	label = MCreateLabel(form, "Left\naligned\nLabel", DEFAULT_FONT);
	MLabelSetAlignment(label, LEFT_ALIGN);
	MObjectSetColor(label, darkblue, white);

	label = MCreateLabel(form, "Center\naligned\nLabel", DEFAULT_FONT);
	MObjectSetColor(label, darkblue, white);

	label = MCreateLabel(form, "Right\naligned\nLabel", DEFAULT_FONT);
	MLabelSetAlignment(label, RIGHT_ALIGN);
	MObjectSetColor(label, darkblue, white);

	sfile = MCreateSFile(mainshell, __FILE__, DEFAULT_FONT, 16, 74);
	MObjectSetColor(sfile, darkblue, white);

	MShellRealize(mainshell);
/*
 * Now the program passes control to MGUI library
 * and gains control only through callbacks
 */
	MMainLoop();
}

/************************************************
 *      Program termination callback.
 ************************************************/
void ExitCB(MOBJECT p, void *item, void *a_data)
{
	MShellUnrealize(mainshell);
	MShellDestroy(mainshell);

	MFreeColor(seagreen);
	MFreeColor(cadetblue);
	MFreeColor(darkblue);

	MGUITerm();
	exit(0);
}

/***********************************************
 *      This callback changes the mainshell title
 *      using the utility function MInputPrompt()
 ************************************************/
void ChangeTitleCB(MOBJECT o, void *item, void *a_data)
{
	char title[64];

	title[0] = '\0';
	if (MInputPrompt("INPUT", "New title:", title, 40, "Exec", "Cancel"))
		MShellSetTitle(mainshell, title);
}
