/*
 * 	File pageform.c
 */
#include <stdio.h>

#include "mgui.h"

void CloseDialogCB(MOBJECT p, void *s, void *v);

extern MTColor black, white, darkblue, cadetblue, seagreen;
extern int LowRes;

static MOBJECT lab1, lab2, lab3, lab4;

/****************************************************
*	Closes the dialog freeing the allocated PIXMAP
****************************************************/
void ClosePagedFormCB(MOBJECT p, void *s, void *adata)
{
	MPIXMAP mpm = (MPIXMAP)adata;

	MFreePixmap(mpm);
	CloseDialogCB(p, s, 0L);
}

/****************************************************
*	Changes the active page in the Paged Form
****************************************************/
void SetFormPageCB(MOBJECT o, MVALUE o_data, void *a_data)
{
	MOBJECT form = (MOBJECT)MObjectGetUserData(o);
	static int n=0;
	char str[128];

	if (o_data) {

		MPagedFormSetActivePage(form, (int)a_data);
/*
 * Set new text in the labels belonging to each page
 */
		sprintf(str, "Page 1 - %d", n);
		MObjectSetText(lab1, str);
		sprintf(str, "Page 2 - %d", n);
		MObjectSetText(lab2, str);
		sprintf(str, "Page 3 - %d", n);
		MObjectSetText(lab3, str);
		sprintf(str, "Page 4 - %d", n);
		MObjectSetText(lab4, str);
		n++;
	}
}

/**********************************************************
*	Selects an Object in a given page of the Paged Form
***********************************************************/
void SelectPageObjCB(MOBJECT o, MVALUE o_data, void *a_data)
{
	if (o_data) {
		MSelectObject((MOBJECT )a_data);
	}
}

/**********************************************************
*	Install the PIXMAP and redraw it
***********************************************************/
void InstallPixmapCB(MOBJECT o, MVALUE o_data, void *a_data)
{
	MOBJECT pixm = (MOBJECT)a_data;

	if (o_data) {
		MInstallPixmap((MPIXMAP)MObjectGetUserData(pixm));
		MObjectRedraw(pixm);
	}
}

/**********************************************************
*	Uninstalls the PIXMAP leaving it drawn
***********************************************************/
void UninstallPixmapCB(MOBJECT o, MVALUE o_data, void *a_data)
{
	MOBJECT pixm = (MOBJECT)a_data;

	if (o_data) {
		MUninstallPixmap((MPIXMAP)MObjectGetUserData(pixm));
		MObjectRedraw(pixm);
	}
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void PagedFormCB(MOBJECT o, void *o_data, void *a_data)
{
	MOBJECT shell, form, rb1form, rb2form, pform;
	MOBJECT form0, form1;
	MOBJECT pbutton, rb, edit, sfile, pixm;
	MPIXMAP mpm;
	int npages;

	shell = MCreateShell("Paged Form", 0);

	form1 = MCreateColForm(shell);

	sfile = MCreateSFile(form1, __FILE__,
			(LowRes ? SMALL_FONT : DEFAULT_FONT),
			15, 48);
	MObjectSetColor(sfile, darkblue, white);
						
	form0 = MCreateRowForm(form1);
	npages = 4;
	pform = MCreatePagedFormExt(form0, npages);

	form = MCreateColForm(form0);
	MFormSetSpacing(form, 0);
	MObjectSetShadow(form, WS_NONE, 0, 0);
	rb1form = MCreateRowForm(form);
	MFormSetSpacing(rb1form, 0);
	MCreateLabel(rb1form, "Selection", DEFAULT_FONT);
	rb2form = MCreateRowForm(form);
	MFormSetSpacing(rb2form, 0);
	MCreateLabel(rb2form, "Selection", DEFAULT_FONT);
/*
 * Add Objects in the first page
 */
	MPagedFormSetActivePage(pform, 0);
	lab1 = MCreateLabel(pform, "Page 1", HELV_N_FONT);
	edit = MCreateEdit(pform, "", 12, DEFAULT_FONT);
	mpm = MReadPixmapFile("paulina.bmp");
	if (mpm) {
		pixm = MCreatePixmapFromData(pform, mpm);
		MObjectSetUserData(pixm, mpm);
		form = MCreateColForm(pform);
		MFormSetSpacing(form, 0);
		MObjectSetShadow(form, WS_NONE, 0, 0);
		rb = MCreateRButton(form, "Install", TIMES_N_FONT);
		MRButtonSetCallback(rb, InstallPixmapCB, pixm);
		rb = MCreateRButton(form, "Uninstall", TIMES_N_FONT);
		MRButtonSetCallback(rb, UninstallPixmapCB, pixm);
	}

	rb = MCreateRButton(rb1form, "Page 1", TIMES_N_FONT);
	MObjectSetUserData(rb, (void *)pform);
	MRButtonSetCallback(rb, SetFormPageCB, 0L);
	rb = MCreateRButton(rb2form, "Object 1", TIMES_N_FONT);
	MRButtonSetCallback(rb, SelectPageObjCB, edit);
/*
 * Add Objects in the second page
 */
	MPagedFormSetActivePage(pform, 1);
	edit = MCreateEdit(pform, "", 12, DEFAULT_FONT);
	lab2 = MCreateLabel(pform, "Page 2", HELV_N_FONT);
	edit = MCreateEdit(pform, "", 12, DEFAULT_FONT);

	rb = MCreateRButton(rb1form, "Page 2", TIMES_N_FONT);
	MObjectSetUserData(rb, (void *)pform);
	MRButtonSetCallback(rb, SetFormPageCB, (void *)1);
	rb = MCreateRButton(rb2form, "Object 2", TIMES_N_FONT);
	MRButtonSetCallback(rb, SelectPageObjCB, edit);
/*
 * Add Objects in the third page
 */
	MPagedFormSetActivePage(pform, 2);
	edit = MCreateEdit(pform, "", 12, DEFAULT_FONT);
	edit = MCreateEdit(pform, "", 12, DEFAULT_FONT);
	lab3 = MCreateLabel(pform, "Page 3", TIMES_L_FONT);
	MBottomAttach(lab3, F_ATT_NONE, 0, NULL);

	rb = MCreateRButton(rb1form, "Page 3", TIMES_N_FONT);
	MObjectSetUserData(rb, (void *)pform);
	MRButtonSetCallback(rb, SetFormPageCB, (void *)2);
	rb = MCreateRButton(rb2form, "Object 3", TIMES_N_FONT);
	MRButtonSetCallback(rb, SelectPageObjCB, edit);
/*
 * Add Objects in the fourth page
 */
	MPagedFormSetActivePage(pform, 3);
	lab4 = MCreateLabel(pform, "Page 4", HELV_N_FONT);
	MCreateEdit(pform, "", 12, DEFAULT_FONT);
	MCreateEdit(pform, "", 12, DEFAULT_FONT);

	rb = MCreateRButton(rb1form, "Page 4", TIMES_N_FONT);
	MObjectSetUserData(rb, (void *)pform);
	MRButtonSetCallback(rb, SetFormPageCB, (void *)3);
	MRButtonActivate(rb);
	rb = MCreateRButton(rb2form, "Object 4", TIMES_N_FONT);
	MRButtonSetCallback(rb, SelectPageObjCB, edit);

	pbutton = MCreatePButton(shell, "Close", TIMES_L_FONT);
	MObjectSetResize(pbutton, False, False);
/*
 * The Pixmap 'mpm' must be freed on any close event...
 */
	MPButtonSetCallback(pbutton, ClosePagedFormCB, mpm);
	MShellSetWMCloseCallback(shell, ClosePagedFormCB, mpm);

	MShellRealize(shell);
}
