/*
 * 	File rs232.c
 *	Serial communication via RS-232 ports (experimental)
 */

#include <stdio.h>
#include <string.h>

#include "mgui.h"

extern MTColor black, white, darkblue, cadetblue, seagreen;

void CloseRS232CB(MOBJECT p, void *s, void *a)
{
	int com;

	p = MObjectShell(p);
	com = (int)MObjectGetUserData(p);
	if (com >= 0)
		MCloseRS232(com);
	MShellUnrealize(p);
	MShellDestroy(p);
}

/*********************************************
 *      This callback reads from a RS-232 port
 *********************************************/
void RS232ReadCB(int id, void *data)
{
	MOBJECT list = (MOBJECT )data;
	char buff[32];
        int len;

	while ((len=MReadRS232(id, buff, 31)) > 0) {
		buff[len] = '\0';
		MLog(1, buff);
		MSListAddItem(list, buff, 0L);
	}
	if (len < 0)
		MLog(1, "read error # %d", len);
}

/*********************************************
 *      This callback writes to a RS-232 port
 *********************************************/
void WriteRS232CB(MOBJECT p, void *a, void *data)
{
	char buff[32];
        int len, com;

	p = MObjectShell(p);
	com = (int)MObjectGetUserData(p);
	strcpy(buff, "This text is sent by me!!");
	MLog(1, "Try to send <%s> on the port: %d (shell: %lx)", buff, com, p);
	if (com >= 0 && (len=MWriteRS232(com, buff, strlen(buff))) < 0)
		MLog(1, "write error # %d", len);
}

void OpenCommCB(MOBJECT p, MVALUE a, void *b)
{
	int com;
	char msg[128];
	MOBJECT list = (MOBJECT )MObjectGetUserData(p);

	if (a == 0L)
		return;
	p = MObjectShell(p);
	com = (int)MObjectGetUserData(p);
	if (com >= 0)
		MCloseRS232(com);
	com = -1;
	if (b >= 0) {
	    if ((com = MOpenRS232((int)b, 9600, RS232_PARITY_NONE, 7, 1, 50, 50)) >= 0) {
		MRS232SetDataReadyCallback(com, RS232ReadCB, list);
	    }
	    else {
		sprintf(msg, "Error # %d opening the port: COM%d", com, (int)b+1);
		MMessageDialog("ERROR", msg, "Ok", NULL);
	    }
	}
	MLog(1, "port open: %d (shell: %lx)", com, p);
	MObjectSetUserData(p, (void *)com);
}

/**************************************************
 *      This callback handles the Window Manager
 *	request to close the dialog
 **************************************************/
static void WMCloseCB(MOBJECT obj, void *a, void *udata)
{
	CloseRS232CB(obj, 0L, 0L);
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void RS232CB(MOBJECT o, void *o_data, void *a_data)
{
	MOBJECT pbutton, shell, form0, form1, form2;
	MOBJECT slist, sfile, rb;

	shell = MCreateShell("Test RS-232", 0);
	MObjectSetUserData(shell, (void *)-1);
	MShellSetWMCloseCallback(shell, WMCloseCB, 0L);

	form0 = MCreateColForm(shell);

	form1 = MCreateRowForm(form0);
	form2 = MCreateRowForm(form1);
	slist = MCreateSList(form1, DEFAULT_FONT, 16, 10, 12);

	rb = MCreateRButton(form2, "None", DEFAULT_FONT);
	MRButtonSetCallback(rb, OpenCommCB, (void *)(-1));
	MObjectSetUserData(rb, (void *)slist);

	rb = MCreateRButton(form2, "COM1", DEFAULT_FONT);
	MRButtonSetCallback(rb, OpenCommCB, (void *)0);
	MObjectSetUserData(rb, (void *)slist);

	rb = MCreateRButton(form2, "COM2", DEFAULT_FONT);
	MRButtonSetCallback(rb, OpenCommCB, (void *)1);
	MObjectSetUserData(rb, (void *)slist);

	rb = MCreateRButton(form2, "COM3", DEFAULT_FONT);
	MRButtonSetCallback(rb, OpenCommCB, (void *)2);
	MObjectSetUserData(rb, (void *)slist);

	rb = MCreateRButton(form2, "COM4", DEFAULT_FONT);
	MRButtonSetCallback(rb, OpenCommCB, (void *)3);
	MObjectSetUserData(rb, (void *)slist);

	sfile = MCreateSFile(form0, __FILE__, DEFAULT_FONT, 15, 60);
	MObjectSetColor(sfile, darkblue, white);
	MObjectSetUserData(rb, (void *)slist);

	pbutton = MCreatePButton(form1, "Send", TIMES_L_FONT);
	MPButtonSetCallback(pbutton, WriteRS232CB, (void *)0);

	pbutton = MCreatePButton(shell, "Close", TIMES_L_FONT);
	MPButtonSetCallback(pbutton, CloseRS232CB, (void *)0);
	MObjectSetResize(pbutton, False, False);

	MShellRealize(shell);
}
