/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% MOUSE.H %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*                                                                        */
/* This file declares the MOUSELIB graphics library functions and global  */
/* parameters used throughout the graphics routines.                      */
/*                                                                        */
/*                                                                        */
/*               Copyright 1995 HATAMY.  All Rights Reserved              */
/*                                                                        */
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/





/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*                              Definitions                               */
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#define _VISIBLE        1
#define _NOTVISIBLE     0
#define ON              1
#define OFF             0

/***** MOUSE TYPES *****/
#define NONE            0
#define BUS             1
#define SERIAL          2
#define INPORT          3
#define IBM             4
#define HEWLETT-PACKARD 5 
   

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*                    External Parameter Declarations                    */
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/



extern int  MAXX;         //  current horisontal screen resolution

extern int  MAXY;         //  current vertical screen resolution


extern int  MOUSE_X;      //  Mouse X position


extern int  MOUSE_Y;      //  Mouse Y position


extern int  MOUSE_L;      //  Return: (1) if left mouse button pressed
                          //  Return: (0) if left mouse button released

extern int  MOUSE_R;      //  Return: (2) if right mouse button pressed
                          //  Return: (0) if right mouse button pressed

extern char MOUSE_STATUS; //  _VISIBLE    (1) if mouse is on  
                          //  _NOTVISIBLE (0) if mouse is off

                          
/*%%%%%%%%%%%%%%%%%%%%%%%  Available Mouse shapes  %%%%%%%%%%%%%%%%%%%%%%%*/


extern char *R_ARROW;
extern char *L_ARROW;
extern char *SAND_GLASS;

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*                      External Function Prototypes                      */
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/


extern char StartMouse(char *shape);             // Load mouse shape
                                                 // On success return: 1
                                                 // If failed return : 0    

extern void FiniMouse();                         //remove mouse from memory

extern void ShowMouse();                         //Show mouse

extern void HideMouse();                         //Hide mouse

extern char SetMouseShape(char * NewShape);      //Change the mouse shape
                                                 //On success return :1
                                                 //If faield return  :0

extern char SetPosition(int x,int y);            //Set the initial mouse
                                                 //position  
                                                 //On success return :1
                                                 //If faield return  :0
                                                 
extern void GetMouse();                          //Updates: MOUSE_X
                                                 //         MOUSE_Y 
                                                 //         MOUSE_L 
                                                 //         MOUSE_R
                                                 
extern char SetMouseRange
            ( int x1, int y1, int x2, int y2 );  //Set the area within mouse
                                                 //is active
                                                 //On success return :1
                                                 //If faield return  :0
                                                 
extern char InstallMouseWatch(char INTER);       //Install the mouse watch
                                                 //onto interrupt 0x1c
                                                 
                                                 //On success return :1
                                                 //If mouse watch was already 
                                                 //installed  return :0

extern char RemoveMouseWatch();                  //Remove the mouse watch
                                                 //On success return :1
                                                 //If mouse watch was not
                                                 //installed  return :0
                                                

extern char  SetHotSpot(int X_Spot,int Y_Spot);  //Set the mouse hotspot
                                                 //On success return :1
                                                 //If faield return  :0
                                                 
extern int   GetXSpot();                         //Return the horizontal
                                                 //hotspot.                                                 
                                                 //If faield return the
                                                 //X screen size.
                                                  
extern int   GetYSpot();                         //Return the vertical
                                                 //hotspot.                                                 
                                                 //If faield return the
                                                 //Y screen size.


extern char MouseInfo();                         //Return one of the following
                                                 //mouse information:
                                                 
                                                 // 1: NONE
                                                 // 2: BUS
                                                 // 3: SERIAL
                                                 // 4: INPORT
                                                 // 5: IBM
                                                 // 6: HEWLETT-PACKARD  


extern char TuneMouse(char status);              //Set the anti mouse flicker
                                                 //Default status is ON
                                                 //
                                                 //Return : 0 if OFF
                                                 //         1 if ON 

                                                 
extern float GetVersion();                       //Returns the version number
                                                 //of this library                                                 
