/*%%%%%%%%%%%%%%%%%%%%%%%%%       MOUSE LIB       %%%%%%%%%%%%%%%%%%%%%%%%%*/
/*                                                                         */
/*     'MOUSELIB' EGA/VGA/SVGA 16/32 bit mouse Library for WATCOM C/C++    */
/*                                                                         */
/*                                                                         */
/*                       Copyright (C) 1995 by HATAMY                      */
/*                                                                         */
/*                                                                         */
/*                                                                         */
/*%%%%%%%%%%%%%%%%%%   UNREGISTERD SHAREWARE VERSION   %%%%%%%%%%%%%%%%%%%%*/
/*                                                                         */
/*   FOR EVUALATION ONLY. NOT FOR RESALE IN ANY FORM. SOFTWARE WRITTEN     */
/*   USING THIS UNREGISTERED SHAREWARE GRAPHICS LIBRARY MAY NOT BE SOLD    */
/*   OR USED FOR ANY PURPOSE OTHER THAN THE EVALUATION OF THIS LIBRARY.    */
/*                                                                         */
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/*%%%%%%%%%%%%%%%%%%% NO WARRANTIES AND NO LIABILITY %%%%%%%%%%%%%%%%%%%%%%*/
/*                                                                         */
/*   HATAMY provide no warranties, either expressed or implied, of         */
/*   merchantability, or fitness, for a particular use or purpose of this  */
/*   SOFTWARE and documentation. In no event shall HATAMY be held liable   */
/*   for any damages resulting from the use or misuse of the SOFTWARE and  */
/*   documentation.                                                        */
/*                                                                         */
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/



/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*                                                                         */
/*   By using this SOFTWARE or documentation, you agree to the above       */
/*   terms and conditions.                                                 */
/*                                                                         */
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/




#include <graph.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>

#include "mouse.h"    //The mouselib header file



                        
int NextMode(int mode);                                                             
void demo(int mode);
void mainscreen();
void DrawScreen();


int X1,X2,Y1[5],Y2[5];
int items;


//Conditions//
//////////////

//DS MUST be set to DGROUP
//                          in :
//                          Options /
//                          C Compiler switches... /
//                          Register UsageSwitches /
//                          DS Register /
//                          "DS pegged to DGROUP" must be marked


/**********************************************************************/
//                                                                    // 
//                               Main                                 // 
//                                                                    //
/**********************************************************************/

void main(void)
{
 
   mainscreen();
   
   
   do
   {
    if(MOUSE_L||MOUSE_R)
    {
     switch(MOUSE_Y)
     {
      case(3) :
                // End work with mouse //
                //*********************//
                FiniMouse();
                
                _setvideomode(_DEFAULTMODE);
                
                exit(EXIT_SUCCESS);
                
                break;

      
      case(4) : demo(1); break;
      case(5) : demo(2); break;
      case(6) : demo(3); break;
      case(7) : demo(4); break;
      case(8) : demo(5); break;
      case(9) : demo(6); break;
      case(10): demo(7); break;
      case(11): demo(8); break;
      case(12): demo(9); break;
      case(13): demo(10);break;
      case(14): demo(11);break;
      case(15): demo(12);break;
      case(16): demo(13);break;
      case(17): demo(14);break;
      case(18): demo(15);break;      
      case(19): demo(16);break;
      case(20): demo(17);break;
      case(21): demo(18);break;
     }
    } 
   }
    while(!kbhit());
   
   
    _setvideomode(_DEFAULTMODE);
    _clearscreen(_GVIEWPORT);

    // End work with mouse //
    //*********************//
    FiniMouse();

}//End Main


/*************************************************************************/
/*************************************************************************/

void demo(int mode)
{
int SelectedMode;
int MouseStarted;
int j=-1;
int i;
char key;
struct videoconfig vc;


 // End work with mouse //
 //*********************//
    FiniMouse();
    
            
 // Select a video mode (1 -> 18)
 
    SelectedMode=_setvideomode(NextMode(mode));

 
    _getvideoconfig(&vc);
    
 // Start the mouse and load a cursor shape. The cursor can be displayed  //
 // in a number of shapes. In this evaluation library the following forms //
 // are available :                                                       //
 //                                                                       //
 //             1. L_ARROW                                                //  
 //             2. R_ARROW                                                // 
 //             3. SAND_GLASS                                             //
 //                                                                       // 
 // or an user defined shape from disk.                                   //
 //                                                                       //
 // Example:                                                              //
 //                                                                       //  
 // StartMouse("FACE.IMG");                                               //
 //                                                                       //
 /*************************************************************************/        
  
 MouseStarted=StartMouse(NULL);            


                                            
 if(SelectedMode && MouseStarted)
 {

  // Draw buttons
  
  DrawScreen();                           

  // Put the text on
  
  _settextposition(5,vc.numtextcols/2-1);
  _outtext("Back\n");

  _settextposition(vc.numtextrows-1,1);
  _outtext("Back=[Esc]   Show/Hide Mouse=[Space]\n");
 
  if(vc.mode>_TEXTC80)
  { 
  _settextposition(7,vc.numtextcols/2-3);
  _setbkcolor(1);
  _outtext("L_ARROW\n");
  _settextposition(9,vc.numtextcols/2-3);
  _setbkcolor(3);
  _outtext("R_ARROW\n");
  _settextposition(11,vc.numtextcols/2-4);
  _setbkcolor(5);
  _outtext("SAND_GLASS\n");
  _settextposition(13,vc.numtextcols/2-7);
  if(vc.mode>_MRES256COLOR)
  {
  _setbkcolor(7);
  _outtext("LOAD MOUSE IMAGE\n");
  }
  }
  

  //Turn mouse on//
  /***************/
  ShowMouse();                          
  
 do{
     
  do{
     _settextposition(1,1);
     printf("MOUSE_X=%-3d MOUSE_Y=%-3d  LEFT=%-d  RIGHT=%-d\n",
             MOUSE_X,MOUSE_Y,MOUSE_L,MOUSE_R);

     //Catch mouse
     
       if(MOUSE_L||MOUSE_R)
       {          
        if(MOUSE_X>X1&&MOUSE_X<X2)
        {
         for(i=0;i<items;i++)
         {
          if(MOUSE_Y>Y1[i]&&MOUSE_Y<Y2[i])
          {
           switch(i)
           {
            case 0:  //Wait untill mouse buttons are released
                     while((MOUSE_L+MOUSE_R)!=0)delay(1);
                     
                     //Draw back the main screen
                     mainscreen();
                     
                     return;

                                                    
            case 1:  //Hide mouse//
                     /************/
                     HideMouse();
                     
                     //Set an other cursor shape//
                     //*************************//                     
                     SetMouseShape(L_ARROW);

                     //Show mouse//
                     /************/
                     ShowMouse();
                     
                     break;
            
            case 2:
                     HideMouse();
                     SetMouseShape(R_ARROW     );
                     ShowMouse();
                     break;
            
            case 3:  HideMouse();
                     SetMouseShape(SAND_GLASS  );
                     ShowMouse();
                     break;
            
            case 4:  HideMouse();
                     SetMouseShape("face.img");
                     ShowMouse();
                     break;
                     
           }
           
           //Wait untill mouse buttons are released           
            while((MOUSE_L+MOUSE_R)!=0)delay(1); 
          }
         }    
        }
       }
         
    }
    while(!kbhit());
       
       key=getch();
       
 
       //HideMouse and ShowMouse
       if(key==' ')
       {
       j*=-1;       
       if(j>0)
         HideMouse();
            else
              ShowMouse();
       }
                       
  }
  while(key!=27); //[Esc] will end

  
 }
   else
     {
      if(!SelectedMode)
      printf("\n\n\n\n\nVideo mode not supported.\n");
      if(!MouseStarted)  
      printf("\n\n\n\n\nNo mouse support for this mode.\n");
      printf("hit any key to continue...\n");

      getch();
     }
     
mainscreen();     
} //End demo


/*************************************************************************/
/*************************************************************************/


void DrawScreen()
{
 struct videoconfig vc;
 int factor,i;

    //Reset variables
    for(i=0;i<5;i++)Y1[i]=Y2[i]=0;
    
    //Get the video configuration 
    _getvideoconfig(&vc);

    //If text mode :   
    if(!vc.numxpixels||!vc.numypixels) 
    {
     items=1;
     
     // X,Y button coordinates
     
     X1=vc.numtextcols/3;
     X2=X1*2;
     Y1[0]=3;
     Y2[0]=5;
     
     return;
    }

    //If we got to here then it's a graphic mode
    
    factor=vc.numypixels/vc.numtextrows;

    // X coordinates
    X1=vc.numxpixels/3;
    X2=X1*2;

    items=0;

    for(i=1;i<=10;i+=2)
    {
     //Y coordinates
     Y1[items]=(3+i)*factor;
      Y2[items]=(4+i)*factor;
      
      //Draw buttons
      _setcolor(i);
       _rectangle(_GFILLINTERIOR,X1,Y1[items],X2,Y2[items]);
       
        // keep the count of buttons  
        items++;
         }

}//End DrawScreen


/**************************************************************************/
/**************************************************************************/


int NextMode(int mode)
{
int select;

// Enumerated modes are here
switch(mode)
{
   
   case  1: select= _TEXTBW40;     break;// M,T    40 x 25    16   MDPA,HGC,VGA,SVGA
   case  2: select= _TEXTC40;      break;// C,T    40 x 25    16   CGA,EGA,MCGA,VGA,SVGA
   case  3: select= _TEXTBW80;     break;// M,T    80 x 25    16   MDPA,HGC,VGA,SVGA
   case  4: select= _TEXTC80;      break;// C,T    80 x 25    16   CGA,EGA,MCGA,VGA,SVGA
   case  5: select= _MRES4COLOR;   break;// C,G   320 x 200    4   CGA,EGA,MCGA,VGA,SVGA
   case  6: select= _MRESNOCOLOR;  break;// C,G   320 x 200    4   CGA,EGA,MCGA,VGA,SVGA   
   case  7: select= _HRESBW;       break;// C,G   640 x 200    2   CGA,EGA,MCGA,VGA,SVGA   
   case  8: select= _MRES16COLOR;  break;// C,G   320 x 200   16   EGA,VGA,SVGA
   case  9: select= _HRES16COLOR;  break;// C,G   640 x 200   16   EGA,VGA,SVGA   
   case 10: select= _ERESNOCOLOR;  break;// M,G   640 x 350    4   EGA,VGA,SVGA   
   case 11: select= _ERESCOLOR;    break;// C,G   640 x 350  4/16  EGA,VGA,SVGA   
   case 12: select= _VRES2COLOR;   break;// C,G   640 x 480    2   MCGA,VGA,SVGA   
   case 13: select= _VRES16COLOR;  break;// C,G   640 x 480   16   VGA,SVGA   
   case 14: select= _MRES256COLOR; break;// C,G   320 x 200  256   MCGA,VGA,SVGA   
   case 15: select= _URES256COLOR; break;// C,G   640 x 400  256   SVGA   
   case 16: select= _VRES256COLOR; break;// C,G   640 x 480  256   SVGA      
   case 17: select= _SVRES256COLOR;break;// C,G   800 x 600  256   SVGA      
   case 18: select= _XRES256COLOR; break;// C,G  1024 x 768  256   SVGA

   default: select=1000;  
}

return(select);
}//end NextMode


/*************************************************************************/
/*************************************************************************/


void mainscreen()
{

  // End work with mouse //
 //*********************//
  FiniMouse();

  //Back to default video mode
  
  _setvideomode(_DEFAULTMODE);

  
  _clearscreen(_GVIEWPORT);

  
  _settextposition(1,1);


  //Start text mouse//
  /******************/
  StartMouse(NULL);


  //Show mouse//
  /************/
  
  ShowMouse();

  
//Draw the main screen

printf("******* 'MOUSELIB' EGA/VGA/SVGA 16/32 bit mouse Library for WATCOM C/C++ ******\n");
printf("************************ Copyright (C) 1995 by HATAMY *************************\n\n");


   printf("      EXIT (Esc)\n");
   printf("     _TEXTBW40         M,T    40 x 25    16   MDPA,HGC,VGA,SVGA\n");
   printf("     _TEXTC40          C,T    40 x 25    16   CGA,EGA,MCGA,VGA,SVGA\n");
   printf("     _TEXTBW80         M,T    80 x 25    16   MDPA,HGC,VGA,SVGA\n");
   printf("     _TEXTC80          C,T    80 x 25    16   CGA,EGA,MCGA,VGA,SVGA\n");
   printf("     _MRES4COLOR       C,G   320 x 200    4   CGA,EGA,MCGA,VGA,SVGA\n");
   printf("     _MRESNOCOLOR      C,G   320 x 200    4   CGA,EGA,MCGA,VGA,SVGA\n");
   printf("     _HRESBW           C,G   640 x 200    2   CGA,EGA,MCGA,VGA,SVGA\n");
   printf("     _MRES16COLOR      C,G   320 x 200   16   EGA,VGA,SVGA\n");
   printf("     _HRES16COLOR      C,G   640 x 200   16   EGA,VGA,SVGA\n");
   printf("     _ERESNOCOLOR      M,G   640 x 350    4   EGA,VGA,SVGA\n");
   printf("     _ERESCOLOR        C,G   640 x 350  4/16  EGA,VGA,SVGA\n");
   printf("     _VRES2COLOR       C,G   640 x 480    2   MCGA,VGA,SVGA\n");
   printf("     _VRES16COLOR      C,G   640 x 480   16   VGA,SVGA\n");
   printf("     _MRES256COLOR     C,G   320 x 200  256   MCGA,VGA,SVGA\n");
   printf("     _URES256COLOR     C,G   640 x 400  256   SVGA\n");
   printf("     _VRES256COLOR     C,G   640 x 480  256   SVGA\n");
   printf("     _SVRES256COLOR    C,G   800 x 600  256   SVGA\n");
   printf("     _XRES256COLOR     C,G  1024 x 768  256   SVGA\n");
   
}//End main screen



