#! @SHELL@
# =============================================================================
#
# = DESCRIPTION
#     Converts a C++ class header file into a classinfo description file.
#
# = AUTHOR(S)
#     Graham Dumpleton
# 
# = COPYRIGHT
#     Copyright 1991 OTC LIMITED
#     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
#
# =============================================================================

OSE_HOST=@OSE_HOST@

OSE_RELEASE_NAME=@OSE_RELEASE_NAME@
export OSE_RELEASE_NAME

OSE_ROOT=${OSE_ROOT-@OSE_ROOT@}
export OSE_ROOT

OSE_VERSION_ROOT=$OSE_ROOT/$OSE_RELEASE_NAME
export OSE_VERSION_ROOT

BINDIR="$OSE_VERSION_ROOT/$OSE_HOST/bin"
LIBDIR=${CLASSINFOLIBDIR-"$OSE_VERSION_ROOT/lib"}

INFO2INFO="$BINDIR/info2info@CMDEXT@"

AWK="@AWK@"

if test "$AWK" = "gawk"
then
  VARG="-v"
fi


FILES=
V2=

TMPFILE=.ci.$$

if test -d "/tmp"
then
  TMPFILE=/tmp/ci.$$
else
  if test -d "/temp"
  then
    TMPFILE=/temp/ci.$$
  fi
fi

trap 'rm -f $TMPFILE; exit' 1 2 3 13 15

#
# Error.
#
ERROR()
{
  echo "`basename $0`: $1" >&2
  shift
  while test $# != "0"
  do
    echo $1 >&2
    shift
  done
  exit 1
}

#
# Usage message.
#
USAGE()
{
  ERROR "Usage: `basename $0` file.h ..."
}

#
# Check usage.
#
if test $# = 0
then
  USAGE
fi

#
# Parse command line.
#
while test $# != 0
do
  case $1 in
#    -v2)
#      V2=YES
#      shift
#      ;;
    *.h|*.hh|*.H|*.hxx|*.hpp|*.h++)
      FILES="$FILES $1"
      shift
      ;;
    *)
      USAGE
      ;;
    esac
done

#
# Check usage again.
#
if test -z "$FILES"
then
  USAGE
fi

#
# Check for awk file.
#
CLASS2INFO=$LIBDIR/class2info.awk

if ( test ! -f $CLASS2INFO )
then
  ERROR "Can't find $CLASS2INFO"
fi

#
# Parse each file.
#
for i in $FILES
do
  if test ! -f $i
  then
    ERROR "$i doesn't exist."
  fi
  FILENAME=`basename $i`
  INFOFILE=`echo $FILENAME | sed -e 's/\..*$//'`.ci
  rm -f $INFOFILE
  if test "$?" != 0
  then
    ERROR "Couldn't remove info file $INFOFILE."
  fi
  expand $i >$TMPFILE 
  $AWK -f $CLASS2INFO $VARG filename=$i $TMPFILE > $INFOFILE
  rm -f /tmp/ci.$$
#  if test ! -z "$V2"
#  then
#    $INFO2INFO $INFOFILE
#  fi
done
